/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.ScalarIniField;
import com.rusefi.config.FieldType;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Optional;

public enum STFTFieldMigrator implements TuneMigrator
{
    INSTANCE;

    private static final String stftMaxAddTemplate = "stft_cellCfgs%_maxAdd";
    private static final String stftMaxRemoveTemplate = "stft_cellCfgs%_maxRemove";
    private static final int stftCellCount = 4;

    @Override
    public void migrateTune(TuneMigrationContext context) {
        for (int stftCurrentCell = 1; stftCurrentCell <= 4; ++stftCurrentCell) {
            Boolean ifValidMigration;
            String stftMaxAddField = stftMaxAddTemplate.replace("%", Integer.toString(stftCurrentCell));
            Optional<IniField> prevMaxAddIniField = context.getPrevIniFile().findIniField(stftMaxAddField);
            Optional<IniField> updatedMaxAddIniField = context.getUpdatedIniFile().findIniField(stftMaxAddField);
            if (prevMaxAddIniField.isPresent() && updatedMaxAddIniField.isPresent() && (ifValidMigration = Boolean.valueOf(((ScalarIniField)prevMaxAddIniField.get()).getType() == FieldType.INT8)).booleanValue()) {
                Constant prevMaxAddConst = context.getPrevTune().getConstantsAsMap().get(stftMaxAddField);
                Constant updatedMaxAddConst = context.getUpdatedTune().getConstantsAsMap().get(stftMaxAddField);
                String prevMaxAddValue = prevMaxAddConst.getValue();
                if (prevMaxAddConst != null && updatedMaxAddConst != null) {
                    Constant migratedMaxAddConst = updatedMaxAddConst.cloneWithValue(String.valueOf(prevMaxAddValue));
                    context.addMigration(stftMaxAddField, migratedMaxAddConst);
                }
            }
            String stftMaxRemoveField = stftMaxRemoveTemplate.replace("%", Integer.toString(stftCurrentCell));
            Optional<IniField> prevMaxRemoveIniField = context.getPrevIniFile().findIniField(stftMaxRemoveField);
            Optional<IniField> updatedMaxRemoveIniField = context.getUpdatedIniFile().findIniField(stftMaxRemoveField);
            if (!prevMaxRemoveIniField.isPresent() || !updatedMaxRemoveIniField.isPresent() || !(ifValidMigration = Boolean.valueOf(((ScalarIniField)prevMaxRemoveIniField.get()).getType() == FieldType.INT8)).booleanValue()) continue;
            Constant prevMaxRemoveConst = context.getPrevTune().getConstantsAsMap().get(stftMaxRemoveField);
            Constant updatedMaxRemoveConst = context.getUpdatedTune().getConstantsAsMap().get(stftMaxRemoveField);
            Double prevMaxRemoveValue = Double.parseDouble(prevMaxRemoveConst.getValue());
            if (prevMaxRemoveConst == null || updatedMaxRemoveConst == null) continue;
            Constant migratedStftMaxRemoveConst = updatedMaxRemoveConst.cloneWithValue(String.valueOf(Math.abs(prevMaxRemoveValue)));
            context.addMigration(stftMaxRemoveField, migratedStftMaxRemoveConst);
        }
    }
}

