/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging;

import com.devexperts.logging.DefaultLogging;
import com.devexperts.logging.ThreadNameFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LogFormatter
extends Formatter {
    public static final String CONFIG_FILE_PROPERTY = "logformatter.properties";
    public static final String DEFAULT_CONFIG_FILE = "/META-INF/logformatter.properties";
    private static final String LINE_SEP = DefaultLogging.getProperty("line.separator", "\n");
    private static final BiConsumer<Object, StringBuilder> STRING_FORMAT_CONSUMER = (s, sb) -> sb.append(s);
    private final ThreadLocal<LocalFormatter> formatter = ThreadLocal.withInitial(() -> new LocalFormatter(zone));

    public LogFormatter() {
        this(TimeZone.getDefault());
    }

    public LogFormatter(TimeZone zone) {
    }

    @Override
    public String format(LogRecord record) {
        String s = this.format(LogFormatter.getLevelChar(record.getLevel()), record.getMillis(), Thread.currentThread().getName(), record.getLoggerName(), this.formatMessage(record));
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            sw.write(s);
            record.getThrown().printStackTrace(new PrintWriter(sw));
            s = sw.toString();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(char levelChar, long time, String threadName, String loggerName, String msg) {
        boolean trim;
        String string;
        StringBuilder out = this.formatter.get().appendTo;
        out.setLength(0);
        try {
            this.format(levelChar, time, threadName, loggerName, STRING_FORMAT_CONSUMER, msg, out);
            string = out.toString();
            trim = out.length() > 1000;
        }
        catch (Throwable throwable) {
            boolean trim2 = out.length() > 1000;
            out.setLength(0);
            if (trim2) {
                out.trimToSize();
            }
            throw throwable;
        }
        out.setLength(0);
        if (trim) {
            out.trimToSize();
        }
        return string;
    }

    void format(char levelChar, long time, String threadName, String loggerName, BiConsumer<Object, StringBuilder> msgConsumer, Object msg, StringBuilder out) {
        out.append(levelChar).append(" ");
        this.formatter.get().appendTime(time, out);
        out.append(" ");
        int threadPosition = out.length();
        out.append("[");
        out.append(ThreadNameFormatter.formatThreadName(time, threadName));
        out.append("] ");
        out.append(loggerName, loggerName.lastIndexOf(46) + 1, loggerName.length());
        out.append(" - ");
        int messagePosition = out.length();
        msgConsumer.accept(msg, out);
        out.append(LINE_SEP);
        if (out.length() > messagePosition && out.charAt(messagePosition) == '\b') {
            out.delete(threadPosition, messagePosition + 1);
        }
    }

    static char getLevelChar(Level level) {
        int levelInt = level.intValue();
        if (levelInt <= Level.FINEST.intValue()) {
            return 'T';
        }
        if (levelInt <= Level.FINE.intValue()) {
            return 'D';
        }
        if (levelInt <= Level.INFO.intValue()) {
            return 'I';
        }
        if (levelInt <= Level.WARNING.intValue()) {
            return 'W';
        }
        return 'E';
    }

    private static class LocalFormatter {
        private final Calendar calendar;
        private final char[] timeBuffer = new char[17];
        private final StringBuilder appendTo = new StringBuilder();
        private long translatedMinute;

        private LocalFormatter(TimeZone zone) {
            this.calendar = Calendar.getInstance(zone);
            Arrays.fill(this.timeBuffer, 0, 17, ' ');
            this.timeBuffer[13] = 46;
        }

        private void appendTime(long time, StringBuilder out) {
            if (time < this.translatedMinute || time >= this.translatedMinute + 60000L) {
                this.calendar.setTimeInMillis(time);
                this.translatedMinute = this.calendar.getTime().getTime() - (long)(this.calendar.get(13) * 1000) - (long)this.calendar.get(14);
                this.print2(0, this.calendar.get(1));
                this.print2(2, this.calendar.get(2) + 1);
                this.print2(4, this.calendar.get(5));
                this.print2(7, this.calendar.get(11));
                this.print2(9, this.calendar.get(12));
            }
            int millis = (int)(time - this.translatedMinute);
            this.print2(11, millis / 1000);
            this.print2(14, millis / 10);
            this.timeBuffer[16] = (char)(48 + millis % 10);
            out.append(this.timeBuffer);
        }

        private void print2(int offset, int value) {
            this.timeBuffer[offset] = (char)(48 + value / 10 % 10);
            this.timeBuffer[offset + 1] = (char)(48 + value % 10);
        }
    }
}

