/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.Lcd;
import eu.hansolo.steelseries.tools.GlowImageFactory;
import eu.hansolo.steelseries.tools.GradientWrapper;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Section;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Linear;
import org.pushingpixels.trident.ease.TimelineEase;

public final class DisplaySingle
extends JComponent
implements Lcd,
ActionListener {
    private final Util UTIL = Util.INSTANCE;
    private LcdColor lcdColor = LcdColor.WHITE_LCD;
    private Paint customLcdBackground = Color.BLACK;
    private Color customLcdForeground = Color.WHITE;
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 128, 48);
    private double lcdValue = 0.0;
    private double lcdMinValue = 0.0;
    private double lcdMaxValue = 100.0;
    private double lcdThreshold = 0.0;
    private boolean lcdThresholdVisible = false;
    private boolean lcdThresholdBehaviourInverted = false;
    private boolean lcdBackgroundVisible = true;
    private boolean lcdTextVisible = true;
    private boolean lcdBlinking = false;
    private final Timer LCD_BLINKING_TIMER;
    private BufferedImage lcdThresholdImage;
    private static final String LCD_VALUE_PROPERTY = "lcdValue";
    private static final String LCD_TEXT_PROPERTY = "lcdText";
    private int lcdDecimals = 1;
    private String lcdUnitString = "unit";
    private boolean lcdUnitStringVisible = true;
    private boolean lcdScientificFormat = false;
    private boolean digitalFont = false;
    private boolean useCustomLcdUnitFont = false;
    private Font customLcdUnitFont;
    private Font lcdValueFont;
    private Font lcdUnitFont;
    private String lcdInfoString = "";
    private final Font LCD_STANDARD_FONT;
    private final Font LCD_DIGITAL_FONT;
    private BufferedImage bgImage;
    private Color fgColor;
    private BufferedImage lcdImage;
    private NumberSystem numberSystem;
    private Shape disabledShape;
    private final Color DISABLED_COLOR;
    private Timeline timeline;
    private final transient TimelineEase EASING;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private Font lcdInfoFont;
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();
    private boolean sectionsVisible = false;
    private ArrayList<Section> sections;
    private ArrayList<BufferedImage> sectionsBackground;
    private ArrayList<Color> sectionsForeground;
    private boolean qualityOverlayVisible = false;
    private double overlayCornerRadius = 0.0;
    private float overlayFactor = 0.0f;
    private Insets overlayInsets;
    private float factor = 0.0f;
    private Color[] overlayColors;
    private float[] qualityOverlayFractions;
    private Color[] qualityOverlayColors;
    private GradientWrapper qualityOverlayLookup;
    private LinearGradientPaint qualityOverlayGradient;
    private RoundRectangle2D qualityOverlay;
    private boolean glowVisible;
    private Color glowColor;
    private boolean glowing;
    private BufferedImage glowImageOn;
    private boolean lcdNnumericValues;
    private boolean bargraphVisible;
    private List<Shape> bargraph;
    private double bargraphSegmentFactor;
    private boolean plainBargraphSegments;
    private String lcdText;
    private float lcdTextX;
    private Timer TEXT_SCROLLER;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            Container parent = DisplaySingle.this.getParent();
            if (DisplaySingle.this.getWidth() < DisplaySingle.this.getMinimumSize().width && DisplaySingle.this.getHeight() < DisplaySingle.this.getMinimumSize().height) {
                if (parent != null && DisplaySingle.this.getParent().getLayout() == null) {
                    DisplaySingle.this.setSize(DisplaySingle.this.getMinimumSize());
                } else {
                    DisplaySingle.this.setPreferredSize(DisplaySingle.this.getMinimumSize());
                }
            }
            if (parent != null && DisplaySingle.this.getParent().getLayout() == null) {
                DisplaySingle.this.setSize(DisplaySingle.this.getWidth(), DisplaySingle.this.getHeight());
            } else {
                DisplaySingle.this.setPreferredSize(new Dimension(DisplaySingle.this.getWidth(), DisplaySingle.this.getHeight()));
            }
            DisplaySingle.this.calcInnerBounds();
            DisplaySingle.this.init(((DisplaySingle)DisplaySingle.this).getInnerBounds().width, ((DisplaySingle)DisplaySingle.this).getInnerBounds().height);
        }
    };

    public DisplaySingle() {
        this.LCD_BLINKING_TIMER = new Timer(500, this);
        this.customLcdUnitFont = new Font("Verdana", 0, 24);
        this.LCD_STANDARD_FONT = new Font("Verdana", 0, 24);
        this.LCD_DIGITAL_FONT = Util.INSTANCE.getDigitalFont().deriveFont(24).deriveFont(0);
        this.lcdInfoFont = new Font("Verdana", 0, 24);
        this.numberSystem = NumberSystem.DEC;
        this.DISABLED_COLOR = new Color(102, 102, 102, 178);
        this.timeline = new Timeline(this);
        this.EASING = new Linear();
        this.sections = new ArrayList(3);
        this.sectionsBackground = new ArrayList(3);
        this.sectionsForeground = new ArrayList(3);
        this.overlayInsets = new Insets(6, 6, 6, 6);
        this.overlayColors = new Color[]{Color.RED, Color.RED.darker(), Color.RED};
        this.qualityOverlayFractions = new float[]{0.0f, 0.2f, 0.5f, 0.75f, 0.9f, 1.0f};
        this.qualityOverlayColors = new Color[]{Color.RED, Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.GREEN};
        this.qualityOverlayLookup = new GradientWrapper(new Point2D.Double(this.INNER_BOUNDS.getBounds2D().getMinX(), 0.0), new Point2D.Double(this.INNER_BOUNDS.getMaxX(), 0.0), this.qualityOverlayFractions, this.qualityOverlayColors);
        this.qualityOverlayGradient = new LinearGradientPaint(new Point2D.Double(0.0, 2.0), new Point2D.Double(0.0, this.INNER_BOUNDS.height - 2), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{Color.RED, Color.RED.darker(), Color.RED});
        this.qualityOverlay = new RoundRectangle2D.Double();
        this.glowVisible = false;
        this.glowColor = new Color(51, 255, 255);
        this.glowing = false;
        this.bargraphVisible = false;
        this.bargraph = new ArrayList<Shape>(20);
        this.bargraphSegmentFactor = 0.2;
        this.plainBargraphSegments = true;
        this.lcdNnumericValues = true;
        this.lcdText = "";
        this.lcdTextX = 0.0f;
        this.TEXT_SCROLLER = new Timer(60, this);
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.addComponentListener(this.COMPONENT_LISTENER);
    }

    public final void init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return;
        }
        if (this.bgImage != null) {
            this.bgImage.flush();
        }
        if (this.lcdImage != null) {
            this.lcdImage.flush();
        }
        if (this.glowImageOn != null) {
            this.glowImageOn.flush();
        }
        this.glowImageOn = GlowImageFactory.INSTANCE.createLcdGlow(WIDTH, HEIGHT, this.glowColor, true);
        this.lcdImage = this.create_LCD_Image(WIDTH, HEIGHT, null);
        double CORNER_RADIUS = WIDTH > HEIGHT ? (double)HEIGHT * 0.095 : (double)WIDTH * 0.095;
        this.disabledShape = new RoundRectangle2D.Double(0.0, 0.0, WIDTH, HEIGHT, CORNER_RADIUS, CORNER_RADIUS);
        if (this.isDigitalFont()) {
            this.lcdValueFont = this.LCD_DIGITAL_FONT.deriveFont(0.7f * (float)this.getInnerBounds().height).deriveFont(0);
            this.lcdUnitFont = this.useCustomLcdUnitFont ? this.customLcdUnitFont.deriveFont(0.2f * (float)this.getInnerBounds().height) : this.LCD_STANDARD_FONT.deriveFont(0.2f * (float)this.getInnerBounds().height);
        } else {
            this.lcdValueFont = this.LCD_STANDARD_FONT.deriveFont(0.625f * (float)this.getInnerBounds().height);
            this.lcdUnitFont = this.useCustomLcdUnitFont ? this.customLcdUnitFont.deriveFont(0.2f * (float)this.getInnerBounds().height) : this.LCD_STANDARD_FONT.deriveFont(0.2f * (float)this.getInnerBounds().height);
        }
        this.lcdInfoFont = this.LCD_STANDARD_FONT.deriveFont(1, 0.18f * (float)this.getInnerBounds().height);
        if (this.lcdThresholdImage != null) {
            this.lcdThresholdImage.flush();
        }
        this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)((double)HEIGHT * 0.2045454545), (int)((double)HEIGHT * 0.2045454545), this.lcdColor.TEXT_COLOR);
        if (!this.sections.isEmpty()) {
            this.sectionsBackground.clear();
            this.sectionsForeground.clear();
            float[] HSB_START = Color.RGBtoHSB(this.lcdColor.GRADIENT_START_COLOR.getRed(), this.lcdColor.GRADIENT_START_COLOR.getGreen(), this.lcdColor.GRADIENT_START_COLOR.getBlue(), null);
            float[] HSB_FRACTION1 = Color.RGBtoHSB(this.lcdColor.GRADIENT_FRACTION1_COLOR.getRed(), this.lcdColor.GRADIENT_FRACTION1_COLOR.getGreen(), this.lcdColor.GRADIENT_FRACTION1_COLOR.getBlue(), null);
            float[] HSB_FRACTION2 = Color.RGBtoHSB(this.lcdColor.GRADIENT_FRACTION2_COLOR.getRed(), this.lcdColor.GRADIENT_FRACTION2_COLOR.getGreen(), this.lcdColor.GRADIENT_FRACTION2_COLOR.getBlue(), null);
            float[] HSB_FRACTION3 = Color.RGBtoHSB(this.lcdColor.GRADIENT_FRACTION3_COLOR.getRed(), this.lcdColor.GRADIENT_FRACTION3_COLOR.getGreen(), this.lcdColor.GRADIENT_FRACTION3_COLOR.getBlue(), null);
            float[] HSB_STOP = Color.RGBtoHSB(this.lcdColor.GRADIENT_STOP_COLOR.getRed(), this.lcdColor.GRADIENT_STOP_COLOR.getGreen(), this.lcdColor.GRADIENT_STOP_COLOR.getBlue(), null);
            float HUE_START = HSB_START[0];
            float HUE_FRACTION1 = HSB_FRACTION1[0];
            float HUE_FRACTION2 = HSB_FRACTION2[0];
            float HUE_FRACTION3 = HSB_FRACTION3[0];
            float HUE_STOP = HSB_STOP[0];
            float BRIGHTNESS_START = HSB_START[2];
            float BRIGHTNESS_FRACTION1 = HSB_FRACTION1[2];
            float BRIGHTNESS_FRACTION2 = HSB_FRACTION2[2];
            float BRIGHTNESS_FRACTION3 = HSB_FRACTION3[2];
            float BRIGHTNESS_STOP = HSB_STOP[2];
            for (Section section : this.sections) {
                Color FOREGROUND_COLOR;
                Color[] BACKGROUND_COLORS;
                float[] HSB_SECTION = Color.RGBtoHSB(section.getColor().getRed(), section.getColor().getGreen(), section.getColor().getBlue(), null);
                float HUE_SECTION = HSB_SECTION[0];
                float SATURATION_SECTION = HSB_SECTION[1];
                float BRIGHTNESS_SECTION = HSB_SECTION[2];
                if (!this.UTIL.isMonochrome(section.getColor())) {
                    if (this.lcdColor == LcdColor.SECTIONS_LCD) {
                        BACKGROUND_COLORS = new Color[]{new Color(Color.HSBtoRGB(HUE_SECTION, SATURATION_SECTION, BRIGHTNESS_START - 0.31f)), new Color(Color.HSBtoRGB(HUE_SECTION, SATURATION_SECTION, BRIGHTNESS_FRACTION1 - 0.31f)), new Color(Color.HSBtoRGB(HUE_SECTION, SATURATION_SECTION, BRIGHTNESS_FRACTION2 - 0.31f)), new Color(Color.HSBtoRGB(HUE_SECTION, SATURATION_SECTION, BRIGHTNESS_FRACTION3 - 0.31f)), new Color(Color.HSBtoRGB(HUE_SECTION, SATURATION_SECTION, BRIGHTNESS_STOP - 0.31f))};
                    } else {
                        float HUE_DIFF = HUE_SECTION - HUE_FRACTION3;
                        BACKGROUND_COLORS = new Color[]{this.UTIL.setHue(this.lcdColor.GRADIENT_START_COLOR, (HUE_START + HUE_DIFF) % 360.0f), this.UTIL.setHue(this.lcdColor.GRADIENT_FRACTION1_COLOR, (HUE_FRACTION1 + HUE_DIFF) % 360.0f), this.UTIL.setHue(this.lcdColor.GRADIENT_FRACTION2_COLOR, (HUE_FRACTION2 + HUE_DIFF) % 360.0f), this.UTIL.setHue(this.lcdColor.GRADIENT_FRACTION3_COLOR, (HUE_FRACTION3 + HUE_DIFF) % 360.0f), this.UTIL.setHue(this.lcdColor.GRADIENT_STOP_COLOR, (HUE_STOP + HUE_DIFF) % 360.0f)};
                    }
                    FOREGROUND_COLOR = this.UTIL.setSaturationBrightness(section.getColor(), 0.57f, 0.83f);
                } else {
                    float BRIGHTNESS_DIFF = BRIGHTNESS_SECTION - BRIGHTNESS_FRACTION1;
                    BACKGROUND_COLORS = new Color[]{this.UTIL.setSaturationBrightness(this.lcdColor.GRADIENT_START_COLOR, 0.0f, BRIGHTNESS_START + BRIGHTNESS_DIFF), this.UTIL.setSaturationBrightness(this.lcdColor.GRADIENT_FRACTION1_COLOR, 0.0f, BRIGHTNESS_FRACTION1 + BRIGHTNESS_DIFF), this.UTIL.setSaturationBrightness(this.lcdColor.GRADIENT_FRACTION2_COLOR, 0.0f, BRIGHTNESS_FRACTION2 + BRIGHTNESS_DIFF), this.UTIL.setSaturationBrightness(this.lcdColor.GRADIENT_FRACTION3_COLOR, 0.0f, BRIGHTNESS_FRACTION3 + BRIGHTNESS_DIFF), this.UTIL.setSaturationBrightness(this.lcdColor.GRADIENT_STOP_COLOR, 0.0f, BRIGHTNESS_STOP + BRIGHTNESS_DIFF)};
                    FOREGROUND_COLOR = this.UTIL.isDark(section.getColor()) ? Color.WHITE : Color.BLACK;
                }
                this.sectionsBackground.add(this.create_LCD_Image(WIDTH, HEIGHT, BACKGROUND_COLORS));
                this.sectionsForeground.add(FOREGROUND_COLOR);
            }
        }
        this.overlayCornerRadius = WIDTH > HEIGHT ? (double)HEIGHT * 0.095 - 1.0 : (double)WIDTH * 0.095 - 1.0;
        this.overlayFactor = (float)(this.lcdValue / (this.lcdMaxValue - this.lcdMinValue));
        this.factor = Double.compare(this.overlayFactor, 1.0) > 0 ? 1.0f : (Double.compare(this.overlayFactor, 0.0) < 0 ? 0.0f : this.overlayFactor);
        this.overlayColors = new Color[]{this.UTIL.setAlpha(this.qualityOverlayLookup.getColorAt(this.factor), 0.5f), this.UTIL.setAlpha(this.qualityOverlayLookup.getColorAt(this.factor).darker(), 0.5f), this.UTIL.setAlpha(this.qualityOverlayLookup.getColorAt(this.factor), 0.5f)};
        int INSET = (int)(this.qualityOverlay.getHeight() * 0.0909090909);
        this.overlayInsets.set(INSET, INSET, INSET, INSET);
        this.qualityOverlayLookup = new GradientWrapper(new Point2D.Double(this.overlayInsets.left, 0.0), new Point2D.Double(this.lcdImage.getMinX() + this.lcdImage.getWidth() - this.overlayInsets.right, 0.0), this.qualityOverlayFractions, this.qualityOverlayColors);
        this.qualityOverlayGradient = new LinearGradientPaint(new Point2D.Double(0.0, this.overlayInsets.top), new Point2D.Double(0.0, HEIGHT - this.overlayInsets.bottom), new float[]{0.0f, 0.5f, 1.0f}, this.overlayColors);
        this.qualityOverlay.setRoundRect(this.overlayInsets.left, this.overlayInsets.top, (float)this.INNER_BOUNDS.width * this.overlayFactor - (float)this.overlayInsets.left - (float)this.overlayInsets.right, this.INNER_BOUNDS.height - this.overlayInsets.top - this.overlayInsets.bottom, this.overlayCornerRadius, this.overlayCornerRadius);
        this.bargraphSegmentFactor = 20.0 / (this.lcdMaxValue - this.lcdMinValue);
        this.prepareBargraph(WIDTH, HEIGHT);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        if (this.sectionsVisible && !this.sections.isEmpty()) {
            for (int i = 0; i < this.sections.size(); ++i) {
                if (Double.compare(this.lcdValue, this.sections.get(i).getStart()) >= 0 && Double.compare(this.lcdValue, this.sections.get(i).getStop()) <= 0) {
                    this.bgImage = this.sectionsBackground.get(i);
                    this.fgColor = this.sectionsForeground.get(i);
                    break;
                }
                this.bgImage = this.lcdImage;
                this.fgColor = this.lcdColor.TEXT_COLOR;
            }
            if (this.bgImage == null) {
                this.bgImage = this.lcdImage;
                this.fgColor = null;
            }
        } else {
            this.bgImage = this.lcdImage;
            this.fgColor = null;
        }
        if (this.lcdBackgroundVisible) {
            G2.drawImage((Image)this.bgImage, 0, 0, null);
        }
        if (this.bargraphVisible) {
            int activeSegments = (int)(this.lcdValue * this.bargraphSegmentFactor);
            for (int i = 0; i < 20; ++i) {
                if (i >= activeSegments) continue;
                if (!this.sections.isEmpty()) {
                    for (int j = 0; j < this.sections.size(); ++j) {
                        if (Double.compare(this.lcdValue, this.sections.get(j).getStart()) >= 0 && Double.compare(this.lcdValue, this.sections.get(j).getStop()) <= 0) {
                            Paint fill = this.plainBargraphSegments ? this.sections.get(j).getColor() : new RadialGradientPaint((float)this.bargraph.get(i).getBounds2D().getCenterX(), (float)this.bargraph.get(i).getBounds2D().getCenterY(), (float)this.bargraph.get(i).getBounds2D().getWidth() / 2.0f, new float[]{0.0f, 1.0f}, new Color[]{this.sections.get(j).getColor().brighter(), this.sections.get(j).getColor().darker()});
                            G2.setPaint(fill);
                            break;
                        }
                        G2.setPaint(this.lcdColor.TEXT_COLOR);
                    }
                } else {
                    G2.setPaint(this.lcdColor.TEXT_COLOR);
                }
                G2.fill(this.bargraph.get(i));
            }
        }
        if (this.qualityOverlayVisible && this.lcdValue > this.lcdMinValue) {
            G2.setPaint(this.qualityOverlayGradient);
            G2.fill(this.qualityOverlay);
        }
        if (this.fgColor == null) {
            if (this.lcdColor == LcdColor.CUSTOM) {
                G2.setColor(this.customLcdForeground);
            } else {
                G2.setColor(this.lcdColor.TEXT_COLOR);
            }
        } else {
            G2.setColor(this.fgColor);
        }
        if (this.lcdNnumericValues) {
            double UNIT_STRING_WIDTH;
            double digitalFontOffset;
            G2.setFont(this.lcdUnitFont);
            double d = digitalFontOffset = this.digitalFont ? (double)this.lcdImage.getWidth() * 0.0625 : 0.0;
            if (this.lcdUnitStringVisible && !this.lcdUnitString.isEmpty()) {
                this.unitLayout = new TextLayout(this.lcdUnitString, G2.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                if (this.lcdTextVisible) {
                    G2.drawString(this.lcdUnitString, (int)((double)this.lcdImage.getWidth() - this.UNIT_BOUNDARY.getWidth() - (double)((float)this.lcdImage.getHeight() * 0.15f)), (int)((float)this.lcdImage.getHeight() * 0.76f));
                }
                UNIT_STRING_WIDTH = this.UNIT_BOUNDARY.getWidth();
            } else {
                UNIT_STRING_WIDTH = 0.0;
            }
            G2.setFont(this.lcdValueFont);
            switch (this.numberSystem) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.lcdValue).toUpperCase(), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    if (!this.lcdTextVisible) break;
                    G2.drawString(Integer.toHexString((int)this.lcdValue).toUpperCase(), (float)((double)this.lcdImage.getMinX() + ((double)this.lcdImage.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth() - digitalFontOffset) - (double)this.lcdImage.getHeight() * 0.3), (float)this.lcdImage.getHeight() * 0.76f);
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.lcdValue), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    if (!this.lcdTextVisible) break;
                    G2.drawString(Integer.toOctalString((int)this.lcdValue), (float)((double)this.lcdImage.getMinX() + ((double)this.lcdImage.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth() - digitalFontOffset) - (double)this.lcdImage.getHeight() * 0.3), (float)this.lcdImage.getHeight() * 0.76f);
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.lcdValue), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    if (!this.lcdTextVisible) break;
                    G2.drawString(this.formatLcdValue(this.lcdValue), (float)((double)this.lcdImage.getMinX() + ((double)this.lcdImage.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth() - digitalFontOffset) - (double)this.lcdImage.getHeight() * 0.3), (float)this.lcdImage.getHeight() * 0.76f);
                }
            }
            if (!this.lcdInfoString.isEmpty()) {
                G2.setFont(this.lcdInfoFont);
                this.infoLayout = new TextLayout(this.lcdInfoString, G2.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                G2.drawString(this.lcdInfoString, 5.0f, (float)this.INFO_BOUNDARY.getHeight() + 2.0f);
            }
        } else {
            G2.setFont(this.lcdValueFont);
            if (!this.lcdText.isEmpty()) {
                this.valueLayout = new TextLayout(this.lcdText, G2.getFont(), this.RENDER_CONTEXT);
                this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                if (!this.TEXT_SCROLLER.isRunning()) {
                    this.lcdTextX = (float)this.VALUE_BOUNDARY.getWidth();
                }
                G2.drawString(this.lcdText, (float)this.lcdImage.getWidth() - this.lcdTextX - (float)this.lcdImage.getHeight() * 0.15f, (float)this.lcdImage.getHeight() * 0.76f);
            }
        }
        if (this.numberSystem == NumberSystem.DEC && this.lcdThresholdVisible) {
            if (!this.lcdThresholdBehaviourInverted) {
                if (this.lcdValue >= this.lcdThreshold) {
                    G2.drawImage((Image)this.lcdThresholdImage, 5, this.getHeight() - this.lcdThresholdImage.getHeight() - 5, null);
                }
            } else if (this.lcdValue <= this.lcdThreshold) {
                G2.drawImage((Image)this.lcdThresholdImage, 5, this.getHeight() - this.lcdThresholdImage.getHeight() - 5, null);
            }
        }
        if (this.glowVisible && this.glowing) {
            G2.drawImage((Image)this.glowImageOn, 0, 0, null);
        }
        if (!this.isEnabled()) {
            G2.setColor(this.DISABLED_COLOR);
            G2.fill(this.disabledShape);
        }
        G2.dispose();
    }

    public BufferedImage getAsImage() {
        BufferedImage IMAGE = this.UTIL.createImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        this.paintAll(G2);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public double getLcdValue() {
        return this.lcdValue;
    }

    @Override
    public void setLcdValue(double LCD_VALUE) {
        double OLD_VALUE = this.lcdValue;
        this.lcdValue = LCD_VALUE;
        if (this.numberSystem != NumberSystem.DEC && this.lcdValue < 0.0) {
            this.setLcdNumberSystem(NumberSystem.DEC);
        }
        if (this.qualityOverlayVisible) {
            this.overlayCornerRadius = this.INNER_BOUNDS.width > this.INNER_BOUNDS.height ? (double)this.INNER_BOUNDS.height * 0.095 - 1.0 : (double)this.INNER_BOUNDS.width * 0.095 - 1.0;
            this.overlayFactor = (float)(this.lcdValue / (this.lcdMaxValue - this.lcdMinValue));
            this.factor = Double.compare(this.overlayFactor, 1.0) > 0 ? 1.0f : (Double.compare(this.overlayFactor, 0.0) < 0 ? 0.0f : this.overlayFactor);
            this.overlayColors = new Color[]{this.UTIL.setAlpha(this.qualityOverlayLookup.getColorAt(this.factor), 0.5f), this.UTIL.setAlpha(this.qualityOverlayLookup.getColorAt(this.factor).darker(), 0.5f), this.UTIL.setAlpha(this.qualityOverlayLookup.getColorAt(this.factor), 0.5f)};
            this.qualityOverlayLookup = new GradientWrapper(new Point2D.Double(this.lcdImage.getMinX() + this.overlayInsets.left, 0.0), new Point2D.Double(this.lcdImage.getMinX() + this.lcdImage.getWidth() - this.overlayInsets.right, 0.0), this.qualityOverlayFractions, this.qualityOverlayColors);
            this.qualityOverlayGradient = new LinearGradientPaint(new Point2D.Double(0.0, this.overlayInsets.top), new Point2D.Double(0.0, this.INNER_BOUNDS.height - this.overlayInsets.bottom), new float[]{0.0f, 0.5f, 1.0f}, this.overlayColors);
            this.qualityOverlay.setRoundRect(this.overlayInsets.left, this.overlayInsets.top, (float)this.INNER_BOUNDS.width * this.overlayFactor - (float)this.overlayInsets.left - (float)this.overlayInsets.right, this.INNER_BOUNDS.height - this.overlayInsets.top - this.overlayInsets.bottom, this.overlayCornerRadius, this.overlayCornerRadius);
        }
        this.firePropertyChange(LCD_VALUE_PROPERTY, OLD_VALUE, LCD_VALUE);
        this.repaint(this.getInnerBounds());
    }

    public double getLcdMinValue() {
        return this.lcdMinValue;
    }

    public void setLcdMinValue(double LCD_MIN_VALUE) {
        if (Double.compare(LCD_MIN_VALUE, this.lcdMaxValue) == 0) {
            throw new IllegalArgumentException("Min value cannot be equal to max value");
        }
        if (Double.compare(LCD_MIN_VALUE, this.lcdMaxValue) > 0) {
            this.lcdMinValue = this.lcdMaxValue;
            this.lcdMaxValue = LCD_MIN_VALUE;
        } else {
            this.lcdMinValue = LCD_MIN_VALUE;
        }
        this.init(this.getWidth(), this.getHeight());
        this.repaint(this.getInnerBounds());
    }

    public double getLcdMaxValue() {
        return this.lcdMaxValue;
    }

    public void setLcdMaxValue(double LCD_MAX_VALUE) {
        if (Double.compare(LCD_MAX_VALUE, this.lcdMinValue) == 0) {
            throw new IllegalArgumentException("Max value cannot be equal to min value");
        }
        if (Double.compare(LCD_MAX_VALUE, this.lcdMinValue) < 0) {
            this.lcdMaxValue = this.lcdMinValue;
            this.lcdMinValue = LCD_MAX_VALUE;
        } else {
            this.lcdMaxValue = LCD_MAX_VALUE;
        }
        this.init(this.getWidth(), this.getHeight());
        this.repaint(this.getInnerBounds());
    }

    public boolean isLcdNumericValues() {
        return this.lcdNnumericValues;
    }

    public void setLcdNumericValues(boolean LCD_NUMERIC_VALUES) {
        if (LCD_NUMERIC_VALUES) {
            this.TEXT_SCROLLER.stop();
        }
        this.lcdNnumericValues = LCD_NUMERIC_VALUES;
        this.repaint(this.getInnerBounds());
    }

    public String getLcdText() {
        return this.lcdText;
    }

    public void setLcdText(String LCD_TEXT) {
        String OLD_TEXT = this.lcdText;
        this.lcdText = LCD_TEXT;
        this.firePropertyChange(LCD_TEXT_PROPERTY, OLD_TEXT, LCD_TEXT);
        this.repaint(this.getInnerBounds());
    }

    public boolean isLcdTextScrolling() {
        return this.TEXT_SCROLLER.isRunning();
    }

    public void setLcdTextScrolling(boolean ANIMATE) {
        if (!this.isLcdNumericValues()) {
            if (ANIMATE) {
                this.TEXT_SCROLLER.start();
            } else {
                this.TEXT_SCROLLER.stop();
            }
        }
    }

    @Override
    public void setLcdValueAnimated(double LCD_VALUE) {
        if (this.isEnabled()) {
            if (this.timeline.getState() != Timeline.TimelineState.IDLE) {
                this.timeline.abort();
            }
            this.timeline = new Timeline(this);
            this.timeline.addPropertyToInterpolate(LCD_VALUE_PROPERTY, this.lcdValue, LCD_VALUE);
            this.timeline.setEase(this.EASING);
            this.timeline.setDuration(2000L);
            this.timeline.play();
        }
    }

    @Override
    public double getLcdThreshold() {
        return this.lcdThreshold;
    }

    @Override
    public void setLcdThreshold(double LCD_THRESHOLD) {
        this.lcdThreshold = LCD_THRESHOLD;
        if (this.lcdThresholdVisible) {
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public boolean isLcdThresholdVisible() {
        return this.lcdThresholdVisible;
    }

    @Override
    public void setLcdThresholdVisible(boolean LCD_THRESHOLD_VISIBLE) {
        this.lcdThresholdVisible = LCD_THRESHOLD_VISIBLE;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdThresholdBehaviourInverted() {
        return this.lcdThresholdBehaviourInverted;
    }

    @Override
    public void setLcdThresholdBehaviourInverted(boolean LCD_THRESHOLD_BEHAVIOUR_INVERTED) {
        this.lcdThresholdBehaviourInverted = LCD_THRESHOLD_BEHAVIOUR_INVERTED;
    }

    @Override
    public boolean isLcdBlinking() {
        return this.lcdBlinking;
    }

    @Override
    public void setLcdBlinking(boolean LCD_BLINKING) {
        this.lcdBlinking = LCD_BLINKING;
        if (LCD_BLINKING) {
            this.LCD_BLINKING_TIMER.start();
        } else {
            this.LCD_BLINKING_TIMER.stop();
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public int getLcdDecimals() {
        return this.lcdDecimals;
    }

    @Override
    public void setLcdDecimals(int DECIMALS) {
        this.lcdDecimals = DECIMALS;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdUnitString() {
        return this.lcdUnitString;
    }

    @Override
    public void setLcdUnitString(String LCD_UNIT_STRING) {
        this.lcdUnitString = LCD_UNIT_STRING;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdUnitStringVisible() {
        return this.lcdUnitStringVisible;
    }

    @Override
    public void setLcdUnitStringVisible(boolean LCD_UNIT_STRING_VISIBLE) {
        this.lcdUnitStringVisible = LCD_UNIT_STRING_VISIBLE;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isCustomLcdUnitFontEnabled() {
        return this.useCustomLcdUnitFont;
    }

    @Override
    public void setCustomLcdUnitFontEnabled(boolean USE_CUSTOM_LCD_UNIT_FONT) {
        this.useCustomLcdUnitFont = USE_CUSTOM_LCD_UNIT_FONT;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getCustomLcdUnitFont() {
        return this.customLcdUnitFont;
    }

    @Override
    public void setCustomLcdUnitFont(Font CUSTOM_LCD_UNIT_FONT) {
        this.customLcdUnitFont = CUSTOM_LCD_UNIT_FONT;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setLcdScientificFormat(boolean LCD_SCIENTIFIC_FORMAT) {
        this.lcdScientificFormat = LCD_SCIENTIFIC_FORMAT;
    }

    @Override
    public boolean isLcdScientificFormat() {
        return this.lcdScientificFormat;
    }

    @Override
    public boolean isDigitalFont() {
        return this.digitalFont;
    }

    @Override
    public void setDigitalFont(boolean DIGITAL_FONT) {
        this.digitalFont = DIGITAL_FONT;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public LcdColor getLcdColor() {
        return this.lcdColor;
    }

    @Override
    public void setLcdColor(LcdColor COLOR) {
        this.lcdColor = COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint getCustomLcdBackground() {
        return this.customLcdBackground;
    }

    @Override
    public void setCustomLcdBackground(Paint CUSTOM_LCD_BACKGROUND) {
        this.customLcdBackground = CUSTOM_LCD_BACKGROUND;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] LCD_COLORS) {
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, 1.0);
        Point2D.Double FOREGROUND_STOP = new Point2D.Double(0.0, this.getHeight() - 1);
        if (FOREGROUND_START.equals(FOREGROUND_STOP)) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{LCD_COLORS[0], LCD_COLORS[1], LCD_COLORS[2], LCD_COLORS[3], LCD_COLORS[4]};
        return new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
    }

    @Override
    public boolean isLcdBackgroundVisible() {
        return this.lcdBackgroundVisible;
    }

    @Override
    public void setLcdBackgroundVisible(boolean LCD_BACKGROUND_VISIBLE) {
        this.lcdBackgroundVisible = LCD_BACKGROUND_VISIBLE;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Color getCustomLcdForeground() {
        return this.customLcdForeground;
    }

    @Override
    public void setCustomLcdForeground(Color CUSTOM_LCD_FOREGROUND) {
        this.customLcdForeground = CUSTOM_LCD_FOREGROUND;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String formatLcdValue(double VALUE) {
        StringBuilder DEC_BUFFER = new StringBuilder(16);
        DEC_BUFFER.append("0");
        if (this.lcdDecimals > 0) {
            DEC_BUFFER.append(".");
        }
        for (int i = 0; i < this.lcdDecimals; ++i) {
            DEC_BUFFER.append("0");
        }
        if (this.lcdScientificFormat) {
            DEC_BUFFER.append("E0");
        }
        DecimalFormat DEC_FORMAT = new DecimalFormat(DEC_BUFFER.toString(), new DecimalFormatSymbols(Locale.US));
        return DEC_FORMAT.format(VALUE);
    }

    @Override
    public boolean isValueCoupled() {
        return false;
    }

    @Override
    public void setValueCoupled(boolean VALUE_COUPLED) {
    }

    @Override
    public Font getLcdValueFont() {
        return this.lcdValueFont;
    }

    @Override
    public void setLcdValueFont(Font LCD_VALUE_FONT) {
        this.lcdValueFont = LCD_VALUE_FONT;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdUnitFont() {
        return this.lcdUnitFont;
    }

    @Override
    public void setLcdUnitFont(Font LCD_UNIT_FONT) {
        this.lcdUnitFont = LCD_UNIT_FONT;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdInfoString() {
        return this.lcdInfoString;
    }

    @Override
    public void setLcdInfoString(String LCD_INFO_STRING) {
        this.lcdInfoString = LCD_INFO_STRING;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdInfoFont() {
        return this.lcdInfoFont;
    }

    @Override
    public void setLcdInfoFont(Font LCD_INFO_FONT) {
        this.lcdInfoFont = LCD_INFO_FONT;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public NumberSystem getLcdNumberSystem() {
        return this.numberSystem;
    }

    @Override
    public void setLcdNumberSystem(NumberSystem NUMBER_SYSTEM) {
        this.numberSystem = NUMBER_SYSTEM;
        switch (NUMBER_SYSTEM) {
            case HEX: {
                this.lcdInfoString = "hex";
                break;
            }
            case OCT: {
                this.lcdInfoString = "oct";
                break;
            }
            default: {
                this.lcdInfoString = "";
            }
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.getInnerBounds();
    }

    public boolean isQualityOverlayVisible() {
        return this.qualityOverlayVisible;
    }

    public void setQualityOverlayVisible(boolean QUALITIY_OVERLAY_VISIBLE) {
        this.qualityOverlayVisible = QUALITIY_OVERLAY_VISIBLE;
        this.repaint(this.getInnerBounds());
    }

    public float[] getQualityOverlayFractions() {
        return (float[])this.qualityOverlayFractions.clone();
    }

    public Color[] getQualityOverlayColors() {
        return (Color[])this.qualityOverlayColors.clone();
    }

    public void setQualityOverlayFractionsAndColors(float[] QUALITY_OVERLAY_FRACTIONS, Color[] QUALITY_OVERLAY_COLORS) {
        if (QUALITY_OVERLAY_FRACTIONS.length != QUALITY_OVERLAY_COLORS.length) {
            return;
        }
        this.qualityOverlayFractions = (float[])QUALITY_OVERLAY_FRACTIONS.clone();
        this.qualityOverlayColors = (Color[])QUALITY_OVERLAY_COLORS.clone();
        this.init(this.getWidth(), this.getHeight());
        this.repaint(this.getInnerBounds());
    }

    public boolean isGlowVisible() {
        return this.glowVisible;
    }

    public void setGlowVisible(boolean GLOW_VISIBLE) {
        this.glowVisible = GLOW_VISIBLE;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public Color getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(Color GLOW_COLOR) {
        this.glowColor = GLOW_COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean GLOWING) {
        this.glowing = GLOWING;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public boolean isBargraphVisible() {
        return this.bargraphVisible;
    }

    public void setBargraphVisible(boolean BARGRAPH_VISIBLE) {
        this.bargraphVisible = BARGRAPH_VISIBLE;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public boolean isPlainBargraphSegments() {
        return this.plainBargraphSegments;
    }

    public void setPlainBargraphSegments(boolean PLAIN_BARGRAPH_SEGMENTS) {
        this.plainBargraphSegments = PLAIN_BARGRAPH_SEGMENTS;
    }

    public boolean isSectionsVisible() {
        return this.sectionsVisible;
    }

    public void setSectionsVisible(boolean SECTIONS_VISIBLE) {
        this.sectionsVisible = SECTIONS_VISIBLE;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public List<Section> getSections() {
        ArrayList<Section> sectionsCopy = new ArrayList<Section>(this.sections.size());
        sectionsCopy.addAll(this.sections);
        return sectionsCopy;
    }

    public void setSections(Section ... SECTIONS_ARRAY) {
        this.sections.clear();
        for (Section section : SECTIONS_ARRAY) {
            this.sections.add(new Section(section.getStart(), section.getStop(), section.getColor()));
        }
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public void addSection(Section SECTION) {
        this.sections.add(SECTION);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public void resetSections() {
        this.sections.clear();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    private BufferedImage create_LCD_Image(int WIDTH, int HEIGHT, Color[] lcdMainColors) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        BufferedImage IMAGE = this.UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Point2D.Double LCD_FRAME_START = new Point2D.Double(0.0, 0.0);
        Point2D.Double LCD_FRAME_STOP = new Point2D.Double(0.0, IMAGE_HEIGHT);
        if (LCD_FRAME_START.equals(LCD_FRAME_STOP)) {
            ((Point2D)LCD_FRAME_STOP).setLocation(0.0, ((Point2D)LCD_FRAME_START).getY() + 1.0);
        }
        float[] LCD_FRAME_FRACTIONS = new float[]{0.0f, 0.08f, 0.92f, 1.0f};
        Color[] LCD_FRAME_COLORS = new Color[]{new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 1.0f)};
        LinearGradientPaint LCD_FRAME_GRADIENT = new LinearGradientPaint(LCD_FRAME_START, LCD_FRAME_STOP, LCD_FRAME_FRACTIONS, LCD_FRAME_COLORS);
        double LCD_FRAME_CORNER_RADIUS = WIDTH > HEIGHT ? (double)HEIGHT * 0.095 : (double)WIDTH * 0.095;
        RoundRectangle2D.Double LCD_FRAME = new RoundRectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT, LCD_FRAME_CORNER_RADIUS, LCD_FRAME_CORNER_RADIUS);
        G2.setPaint(LCD_FRAME_GRADIENT);
        G2.fill(LCD_FRAME);
        Point2D.Double LCD_MAIN_START = new Point2D.Double(0.0, 1.0);
        Point2D.Double LCD_MAIN_STOP = new Point2D.Double(0.0, IMAGE_HEIGHT - 1);
        if (LCD_MAIN_START.equals(LCD_MAIN_STOP)) {
            ((Point2D)LCD_MAIN_STOP).setLocation(0.0, ((Point2D)LCD_MAIN_START).getY() + 1.0);
        }
        float[] LCD_MAIN_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        if (lcdMainColors == null) {
            lcdMainColors = new Color[]{this.lcdColor.GRADIENT_START_COLOR, this.lcdColor.GRADIENT_FRACTION1_COLOR, this.lcdColor.GRADIENT_FRACTION2_COLOR, this.lcdColor.GRADIENT_FRACTION3_COLOR, this.lcdColor.GRADIENT_STOP_COLOR};
        }
        if (this.lcdColor == LcdColor.CUSTOM) {
            G2.setPaint(this.customLcdBackground);
        } else {
            LinearGradientPaint LCD_MAIN_GRADIENT = new LinearGradientPaint(LCD_MAIN_START, LCD_MAIN_STOP, LCD_MAIN_FRACTIONS, lcdMainColors);
            G2.setPaint(LCD_MAIN_GRADIENT);
        }
        double LCD_MAIN_CORNER_RADIUS = ((RoundRectangle2D)LCD_FRAME).getArcWidth() - 1.0;
        RoundRectangle2D.Double LCD_MAIN = new RoundRectangle2D.Double(1.0, 1.0, IMAGE_WIDTH - 2, IMAGE_HEIGHT - 2, LCD_MAIN_CORNER_RADIUS, LCD_MAIN_CORNER_RADIUS);
        G2.fill(LCD_MAIN);
        if (this.bargraphVisible) {
            GeneralPath BARGRAPH_OFF = new GeneralPath();
            BARGRAPH_OFF.setWindingRule(0);
            BARGRAPH_OFF.moveTo(0.859375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.859375 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.8828125 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.8828125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.859375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.8203125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.8203125 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.84375 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.84375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.8203125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.78125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.78125 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.8046875 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.8046875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.78125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.7421875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.7421875 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.765625 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.765625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.7421875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.703125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.703125 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.7265625 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.7265625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.703125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.6640625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.6640625 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.6875 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.6875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.6640625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.625 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.6484375 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.6484375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.5859375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.5859375 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.609375 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.609375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.5859375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.546875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.546875 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.5703125 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.5703125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.546875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.5078125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.5078125 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.53125 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.53125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.5078125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.46875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.46875 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.4921875 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.4921875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.46875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.4296875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.4296875 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.453125 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.453125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.4296875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.390625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.390625 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.4140625 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.4140625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.390625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.3515625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.3515625 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.375 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.3515625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.3125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.3125 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.3359375 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.3359375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.3125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.2734375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.2734375 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.296875 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.296875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.2734375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.234375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.234375 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.2578125 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.2578125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.234375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.1953125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.1953125 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.21875 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.21875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.1953125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.15625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.15625 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.1796875 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.1796875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.15625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            BARGRAPH_OFF.moveTo(0.1171875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.1171875 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.140625 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.140625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.lineTo(0.1171875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
            BARGRAPH_OFF.closePath();
            G2.setPaint(new Color(this.lcdColor.TEXT_COLOR.getRed(), this.lcdColor.TEXT_COLOR.getGreen(), this.lcdColor.TEXT_COLOR.getBlue(), 25));
            G2.fill(BARGRAPH_OFF);
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_LCD_THRESHOLD_Image(int WIDTH, int HEIGHT, Color COLOR) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        BufferedImage IMAGE = this.UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath LCD_THRESHOLD = new GeneralPath();
        LCD_THRESHOLD.setWindingRule(0);
        LCD_THRESHOLD.moveTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.7777777777777778);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5555555555555556, (double)IMAGE_HEIGHT * 0.7777777777777778);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5555555555555556, (double)IMAGE_HEIGHT * 0.8888888888888888);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.8888888888888888);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.7777777777777778);
        LCD_THRESHOLD.closePath();
        LCD_THRESHOLD.moveTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.3333333333333333);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5555555555555556, (double)IMAGE_HEIGHT * 0.3333333333333333);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5555555555555556, (double)IMAGE_HEIGHT * 0.7222222222222222);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.7222222222222222);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.3333333333333333);
        LCD_THRESHOLD.closePath();
        LCD_THRESHOLD.moveTo(0.0, (double)IMAGE_HEIGHT);
        LCD_THRESHOLD.lineTo(IMAGE_WIDTH, IMAGE_HEIGHT);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5, 0.0);
        LCD_THRESHOLD.lineTo(0.0, (double)IMAGE_HEIGHT);
        LCD_THRESHOLD.closePath();
        G2.setColor(COLOR);
        G2.fill(LCD_THRESHOLD);
        G2.dispose();
        return IMAGE;
    }

    private void prepareBargraph(int WIDTH, int HEIGHT) {
        int IMAGE_WIDTH = WIDTH;
        int IMAGE_HEIGHT = HEIGHT;
        Rectangle2D.Double SEG1 = new Rectangle2D.Double(0.1171875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG2 = new Rectangle2D.Double(0.15625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG3 = new Rectangle2D.Double(0.1953125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG4 = new Rectangle2D.Double(0.234375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG5 = new Rectangle2D.Double(0.2734375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG6 = new Rectangle2D.Double(0.3125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG7 = new Rectangle2D.Double(0.3515625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG8 = new Rectangle2D.Double(0.390625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG9 = new Rectangle2D.Double(0.4296875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG10 = new Rectangle2D.Double(0.46875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG11 = new Rectangle2D.Double(0.5078125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG12 = new Rectangle2D.Double(0.546875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG13 = new Rectangle2D.Double(0.5859375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG14 = new Rectangle2D.Double(0.625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG15 = new Rectangle2D.Double(0.6640625 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG16 = new Rectangle2D.Double(0.703125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG17 = new Rectangle2D.Double(0.7421875 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG18 = new Rectangle2D.Double(0.78125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG19 = new Rectangle2D.Double(0.8203125 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        Rectangle2D.Double SEG20 = new Rectangle2D.Double(0.859375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.0234375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
        this.bargraph.clear();
        this.bargraph.add(SEG1);
        this.bargraph.add(SEG2);
        this.bargraph.add(SEG3);
        this.bargraph.add(SEG4);
        this.bargraph.add(SEG5);
        this.bargraph.add(SEG6);
        this.bargraph.add(SEG7);
        this.bargraph.add(SEG8);
        this.bargraph.add(SEG9);
        this.bargraph.add(SEG10);
        this.bargraph.add(SEG11);
        this.bargraph.add(SEG12);
        this.bargraph.add(SEG13);
        this.bargraph.add(SEG14);
        this.bargraph.add(SEG15);
        this.bargraph.add(SEG16);
        this.bargraph.add(SEG17);
        this.bargraph.add(SEG18);
        this.bargraph.add(SEG19);
        this.bargraph.add(SEG20);
    }

    private void calcInnerBounds() {
        Insets INSETS = this.getInsets();
        this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, this.getWidth() - INSETS.left - INSETS.right, this.getHeight() - INSETS.top - INSETS.bottom);
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (dim.width < 64 || dim.height < 24) {
            dim = new Dimension(64, 24);
        }
        return dim;
    }

    @Override
    public void setMinimumSize(Dimension DIM) {
        int width = DIM.width < 64 ? 64 : DIM.width;
        int height = DIM.height < 24 ? 24 : DIM.height;
        super.setMinimumSize(new Dimension(width, height));
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        if (dim.width > 1920 || dim.height > 720) {
            dim = new Dimension(1920, 720);
        }
        return dim;
    }

    @Override
    public void setMaximumSize(Dimension DIM) {
        int width = DIM.width > 1920 ? 1920 : DIM.width;
        int height = DIM.height > 720 ? 720 : DIM.height;
        super.setMaximumSize(new Dimension(width, height));
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        super.setPreferredSize(DIM);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        super.setSize(WIDTH, HEIGHT);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(Dimension DIM) {
        super.setSize(DIM);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        super.setBounds(BOUNDS);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        super.setBounds(X, Y, WIDTH, HEIGHT);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBorder(Border BORDER) {
        super.setBorder(BORDER);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void actionPerformed(ActionEvent EVENT) {
        if ((double)this.lcdTextX > (double)this.lcdImage.getWidth() + this.VALUE_BOUNDARY.getWidth()) {
            this.lcdTextX = -this.VALUE_BOUNDARY.getBounds().width;
        }
        this.lcdTextX += 1.0f;
        if (EVENT.getSource().equals(this.LCD_BLINKING_TIMER)) {
            this.lcdTextVisible ^= true;
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String toString() {
        return "DisplaySingle";
    }
}

