/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.opensr5.ConfigurationImageMeta;
import com.opensr5.ini.field.IniField;
import com.rusefi.SerialPortType;
import com.rusefi.core.RusEfiSignature;
import com.rusefi.core.SignatureHelper;
import com.rusefi.maintenance.CalibrationsInfo;
import java.util.Optional;

public class PortResult {
    private static final String HASH3_FIELD_NAME = "hash3";
    public final String port;
    public final SerialPortType type;
    private final CalibrationsInfo calibrations;
    private final RusEfiSignature signature;

    public PortResult(String port, SerialPortType type, CalibrationsInfo calibrations) {
        ConfigurationImageMeta meta;
        this.port = port;
        this.type = type;
        this.calibrations = calibrations;
        this.signature = calibrations == null ? null : ((meta = calibrations.getImage().getMeta()) == null ? null : SignatureHelper.parse(meta.getEcuSignature()));
    }

    public PortResult(String port, SerialPortType type) {
        this(port, type, null);
    }

    protected PortResult(PortResult origin) {
        this.port = origin.port;
        this.type = origin.type;
        this.calibrations = origin.calibrations;
        this.signature = origin.signature;
    }

    public String toString() {
        if (this.type.friendlyString == null) {
            return this.port;
        }
        return this.port + " (" + this.type.friendlyString + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PortResult other = (PortResult)o;
        return this.port.equals(other.port) && this.type.equals((Object)other.type);
    }

    public boolean isEcu() {
        return this.type == SerialPortType.Ecu || this.type == SerialPortType.EcuWithOpenblt;
    }

    public Optional<String> getFirmwareHash() {
        Optional<IniField> hash3IniField = this.calibrations.getIniFile().findIniField(HASH3_FIELD_NAME);
        return hash3IniField.map(field -> field.getValue(this.calibrations.getImage().getConfigurationImage()));
    }

    public CalibrationsInfo getCalibrations() {
        return this.calibrations;
    }
}

