/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ldmp;

import com.rusefi.ToolUtil;
import com.rusefi.VariableRegistry;
import java.util.Date;

public class StateDictionaryGenerator {
    public final StringBuilder content = new StringBuilder();
    private final String yamlFileName;

    public StateDictionaryGenerator(String yamlFileName) {
        this.yamlFileName = yamlFileName;
    }

    public void onEntry(String name, String javaName, String[] outputNames, String cppFileName) {
        if (outputNames.length < 2) {
            this.append(name, javaName, cppFileName, "");
        } else {
            for (int i = 0; i < outputNames.length; ++i) {
                this.append(name, javaName, cppFileName, Integer.toString(i));
            }
        }
    }

    private void append(String name, String javaName, String cppFileName, String suffix) {
        this.content.append("        stateDictionary.register(live_data_e.LDS_");
        this.content.append(name).append(suffix).append(", ");
        this.content.append(VariableRegistry.quote(cppFileName));
        this.content.append(");\n");
    }

    public String getCompleteClass() {
        ToolUtil.TOOL = this.getClass().getSimpleName();
        return "package com.rusefi.enums;\n//" + ToolUtil.getGeneratedAutomaticallyTag() + this.yamlFileName + " on " + new Date() + "n\nimport com.rusefi.config.generated.*;\nimport com.rusefi.ldmp.StateDictionary;\n\npublic class StateDictionaryFactory {\n    public static void initialize(StateDictionary stateDictionary) {\n" + this.content + "    }\n}";
    }
}

