/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.Shadow;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Random;

public enum BackgroundImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private int radWidth = 0;
    private BackgroundColor radBackgroundColor = BackgroundColor.DARK_GRAY;
    private Paint radCustomBackground = null;
    private BufferedImage radBackgroundImage = this.UTIL.createImage(1, 1, 3);
    private Color radTextureColor = new Color(0x686868);
    private int linWidth = 0;
    private int linHeight = 0;
    private BackgroundColor linBackgroundColor = BackgroundColor.DARK_GRAY;
    private Paint linCustomBackground = null;
    private BufferedImage linBackgroundImage = this.UTIL.createImage(1, 1, 3);
    private Color linTextureColor = new Color(0x686868);
    private final Color DARK_NOISE = new Color(0.2f, 0.2f, 0.2f);
    private final Color BRIGHT_NOISE = new Color(0.8f, 0.8f, 0.8f);
    public final BufferedImage STAINLESS_GRINDED_TEXTURE = this.UTIL.create_STAINLESS_STEEL_PLATE_Texture(100);
    public final BufferedImage CARBON_FIBRE_TEXTURE = this.UTIL.create_CARBON_Texture(12);
    private BufferedImage punchedSheetTexture = this.UTIL.create_PUNCHED_SHEET_Image(12, new Color(1909027));

    public BufferedImage createRadialBackground(int WIDTH, BackgroundColor BACKGROUND_COLOR) {
        return this.createRadialBackground(WIDTH, BACKGROUND_COLOR, null);
    }

    public BufferedImage createRadialBackground(int WIDTH, BackgroundColor BACKGROUND_COLOR, Paint CUSTOM_BACKGROUND) {
        return this.createRadialBackground(WIDTH, BACKGROUND_COLOR, CUSTOM_BACKGROUND, null, null);
    }

    public BufferedImage createRadialBackground(int WIDTH, BackgroundColor BACKGROUND_COLOR, Paint CUSTOM_BACKGROUND, Color TEXTURE_COLOR, BufferedImage BACKGROUND_IMAGE) {
        if (WIDTH <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.radWidth == WIDTH && this.radBackgroundColor == BACKGROUND_COLOR && this.radCustomBackground.equals(CUSTOM_BACKGROUND) && this.radTextureColor.equals(TEXTURE_COLOR)) {
            if (BACKGROUND_IMAGE != null) {
                Graphics2D G2 = BACKGROUND_IMAGE.createGraphics();
                G2.drawImage((Image)this.radBackgroundImage, 0, 0, null);
                G2.dispose();
            }
            return this.radBackgroundImage;
        }
        this.radBackgroundImage.flush();
        this.radBackgroundImage = this.UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = this.radBackgroundImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = WIDTH;
        int IMAGE_HEIGHT = WIDTH;
        boolean fadeInOut = false;
        Ellipse2D.Double GAUGE_BACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.08411215245723724, (double)IMAGE_HEIGHT * 0.08411215245723724, (double)IMAGE_WIDTH * 0.8317756652832031, (double)IMAGE_HEIGHT * 0.8317756652832031);
        Point2D.Double GAUGE_BACKGROUND_START = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMinY());
        Point2D.Double GAUGE_BACKGROUND_STOP = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMaxY());
        if (GAUGE_BACKGROUND_START.equals(GAUGE_BACKGROUND_STOP)) {
            ((Point2D)GAUGE_BACKGROUND_STOP).setLocation(0.0, ((Point2D)GAUGE_BACKGROUND_START).getY() + 1.0);
        }
        float[] GAUGE_BACKGROUND_FRACTIONS = new float[]{0.0f, 0.4f, 1.0f};
        if (CUSTOM_BACKGROUND != null && BACKGROUND_COLOR == BackgroundColor.CUSTOM) {
            G2.setPaint(CUSTOM_BACKGROUND);
        } else {
            Paint GAUGE_BACKGROUND_GRADIENT;
            Color[] GAUGE_BACKGROUND_COLORS = new Color[]{BACKGROUND_COLOR.GRADIENT_START_COLOR, BACKGROUND_COLOR.GRADIENT_FRACTION_COLOR, BACKGROUND_COLOR.GRADIENT_STOP_COLOR};
            if (BACKGROUND_COLOR == BackgroundColor.BRUSHED_METAL) {
                GAUGE_BACKGROUND_GRADIENT = new TexturePaint(this.UTIL.createBrushMetalTexture(TEXTURE_COLOR, GAUGE_BACKGROUND.getBounds().width, GAUGE_BACKGROUND.getBounds().height), GAUGE_BACKGROUND.getBounds());
            } else if (BACKGROUND_COLOR == BackgroundColor.STAINLESS) {
                Point2D.Double CENTER = new Point2D.Double(GAUGE_BACKGROUND.getCenterX(), GAUGE_BACKGROUND.getCenterY());
                float[] STAINLESS_FRACTIONS = new float[]{0.0f, 0.03f, 0.1f, 0.14f, 0.24f, 0.33f, 0.38f, 0.5f, 0.62f, 0.67f, 0.76f, 0.81f, 0.85f, 0.97f, 1.0f};
                Color[] STAINLESS_COLORS = new Color[]{new Color(0xFDFDFD), new Color(0xFDFDFD), new Color(0xB2B2B4), new Color(0xACACAE), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(7237232), new Color(7237232), new Color(0xFDFDFD), new Color(0xACACAE), new Color(0xB2B2B4), new Color(0xFDFDFD), new Color(0xFDFDFD)};
                GAUGE_BACKGROUND_GRADIENT = new ConicalGradientPaint(false, CENTER, -0.45f, STAINLESS_FRACTIONS, STAINLESS_COLORS);
            } else if (BACKGROUND_COLOR == BackgroundColor.STAINLESS_GRINDED) {
                GAUGE_BACKGROUND_GRADIENT = new TexturePaint(this.STAINLESS_GRINDED_TEXTURE, new Rectangle(0, 0, 100, 100));
            } else if (BACKGROUND_COLOR == BackgroundColor.CARBON) {
                GAUGE_BACKGROUND_GRADIENT = new TexturePaint(this.CARBON_FIBRE_TEXTURE, new Rectangle(0, 0, 12, 12));
                fadeInOut = true;
            } else if (BACKGROUND_COLOR == BackgroundColor.PUNCHED_SHEET) {
                GAUGE_BACKGROUND_GRADIENT = new TexturePaint(this.punchedSheetTexture, new Rectangle(0, 0, 12, 12));
                fadeInOut = true;
            } else if (BACKGROUND_COLOR == BackgroundColor.LINEN) {
                GAUGE_BACKGROUND_GRADIENT = new TexturePaint(this.UTIL.createLinenTexture(TEXTURE_COLOR, GAUGE_BACKGROUND.getBounds().width, GAUGE_BACKGROUND.getBounds().height), GAUGE_BACKGROUND.getBounds());
            } else if (BACKGROUND_COLOR == BackgroundColor.NOISY_PLASTIC) {
                ((Point2D)GAUGE_BACKGROUND_START).setLocation(0.0, GAUGE_BACKGROUND.getMinY());
                ((Point2D)GAUGE_BACKGROUND_STOP).setLocation(0.0, GAUGE_BACKGROUND.getMaxY());
                if (GAUGE_BACKGROUND_START.equals(GAUGE_BACKGROUND_STOP)) {
                    ((Point2D)GAUGE_BACKGROUND_STOP).setLocation(0.0, ((Point2D)GAUGE_BACKGROUND_START).getY() + 1.0);
                }
                float[] FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] COLORS = new Color[]{this.UTIL.lighter(TEXTURE_COLOR, 0.15f), this.UTIL.darker(TEXTURE_COLOR, 0.15f)};
                GAUGE_BACKGROUND_GRADIENT = new LinearGradientPaint(GAUGE_BACKGROUND_START, GAUGE_BACKGROUND_STOP, FRACTIONS, COLORS);
            } else {
                GAUGE_BACKGROUND_GRADIENT = new LinearGradientPaint(GAUGE_BACKGROUND_START, GAUGE_BACKGROUND_STOP, GAUGE_BACKGROUND_FRACTIONS, GAUGE_BACKGROUND_COLORS);
            }
            G2.setPaint(GAUGE_BACKGROUND_GRADIENT);
        }
        G2.fill(GAUGE_BACKGROUND);
        if (BACKGROUND_COLOR == BackgroundColor.NOISY_PLASTIC) {
            Random BW_RND = new Random();
            Random ALPHA_RND = new Random();
            Shape OLD_CLIP = G2.getClip();
            G2.setClip(GAUGE_BACKGROUND);
            int y = 0;
            while ((double)y < ((RectangularShape)GAUGE_BACKGROUND).getHeight()) {
                int x = 0;
                while ((double)x < ((RectangularShape)GAUGE_BACKGROUND).getWidth()) {
                    Color noiseColor = BW_RND.nextBoolean() ? this.BRIGHT_NOISE : this.DARK_NOISE;
                    int noiseAlpha = 10 + ALPHA_RND.nextInt(10) - 5;
                    G2.setColor(new Color(noiseColor.getRed(), noiseColor.getGreen(), noiseColor.getBlue(), noiseAlpha));
                    G2.drawLine((int)((double)x + GAUGE_BACKGROUND.getMinX()), (int)((double)y + GAUGE_BACKGROUND.getMinY()), (int)((double)x + GAUGE_BACKGROUND.getMinX()), (int)((double)y + GAUGE_BACKGROUND.getMinY()));
                    ++x;
                }
                ++y;
            }
            G2.setClip(OLD_CLIP);
        }
        if (fadeInOut) {
            float[] SHADOW_OVERLAY_FRACTIONS = new float[]{0.0f, 0.4f, 0.6f, 1.0f};
            Color[] SHADOW_OVERLAY_COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.6f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.6f)};
            LinearGradientPaint SHADOW_OVERLAY_GRADIENT = new LinearGradientPaint(new Point2D.Double(GAUGE_BACKGROUND.getMinX(), 0.0), new Point2D.Double(GAUGE_BACKGROUND.getMaxX(), 0.0), SHADOW_OVERLAY_FRACTIONS, SHADOW_OVERLAY_COLORS);
            G2.setPaint(SHADOW_OVERLAY_GRADIENT);
            G2.fill(GAUGE_BACKGROUND);
        }
        Ellipse2D.Double GAUGE_INNERSHADOW = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.08411215245723724, (double)IMAGE_HEIGHT * 0.08411215245723724, (double)IMAGE_WIDTH * 0.8317756652832031, (double)IMAGE_HEIGHT * 0.8317756652832031);
        Point2D.Double GAUGE_INNERSHADOW_CENTER = new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
        float[] GAUGE_INNERSHADOW_FRACTIONS = new float[]{0.0f, 0.7f, 0.71f, 0.86f, 0.92f, 0.97f, 1.0f};
        Color[] GAUGE_INNERSHADOW_COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.03f), new Color(0.0f, 0.0f, 0.0f, 0.07f), new Color(0.0f, 0.0f, 0.0f, 0.15f), new Color(0.0f, 0.0f, 0.0f, 0.3f)};
        RadialGradientPaint GAUGE_INNERSHADOW_GRADIENT = new RadialGradientPaint(GAUGE_INNERSHADOW_CENTER, (float)(0.4158878504672897 * (double)IMAGE_WIDTH), GAUGE_INNERSHADOW_FRACTIONS, GAUGE_INNERSHADOW_COLORS);
        G2.setPaint(GAUGE_INNERSHADOW_GRADIENT);
        G2.fill(GAUGE_INNERSHADOW);
        if (BACKGROUND_COLOR != BackgroundColor.TRANSPARENT) {
            G2.fill(GAUGE_INNERSHADOW);
        }
        G2.dispose();
        if (BACKGROUND_IMAGE != null) {
            Graphics2D G = BACKGROUND_IMAGE.createGraphics();
            G.drawImage((Image)this.radBackgroundImage, 0, 0, null);
            G.dispose();
        }
        this.radWidth = WIDTH;
        this.radBackgroundColor = BACKGROUND_COLOR;
        this.radCustomBackground = CUSTOM_BACKGROUND;
        this.radTextureColor = TEXTURE_COLOR;
        return this.radBackgroundImage;
    }

    public BufferedImage createLinearBackground(int WIDTH, int HEIGHT, BackgroundColor BACKGROUND_COLOR) {
        return this.createLinearBackground(WIDTH, HEIGHT, BACKGROUND_COLOR, null);
    }

    public BufferedImage createLinearBackground(int WIDTH, int HEIGHT, BackgroundColor BACKGROUND_COLOR, Paint CUSTOM_BACKGROUND) {
        return this.createLinearBackground(WIDTH, HEIGHT, BACKGROUND_COLOR, CUSTOM_BACKGROUND, null, null);
    }

    public BufferedImage createLinearBackground(int WIDTH, int HEIGHT, BackgroundColor BACKGROUND_COLOR, Paint CUSTOM_BACKGROUND, Color TEXTURE_COLOR, BufferedImage BACKGROUND_IMAGE) {
        if (WIDTH <= 32 || HEIGHT <= 32) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.linWidth == WIDTH && this.linHeight == HEIGHT && this.linBackgroundColor == BACKGROUND_COLOR && this.linCustomBackground.equals(CUSTOM_BACKGROUND) && this.linTextureColor.equals(TEXTURE_COLOR)) {
            if (BACKGROUND_IMAGE != null) {
                Graphics2D G2 = BACKGROUND_IMAGE.createGraphics();
                G2.drawImage((Image)this.linBackgroundImage, 0, 0, null);
                G2.dispose();
            }
            return this.linBackgroundImage;
        }
        this.linBackgroundImage.flush();
        this.linBackgroundImage = this.UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = this.linBackgroundImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = WIDTH;
        int IMAGE_HEIGHT = HEIGHT;
        boolean fadeInOut = false;
        double OUTER_FRAME_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? (double)IMAGE_HEIGHT * 0.05 : (double)IMAGE_WIDTH * 0.05;
        RoundRectangle2D.Double OUTER_FRAME = new RoundRectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT, OUTER_FRAME_CORNER_RADIUS, OUTER_FRAME_CORNER_RADIUS);
        double FRAME_MAIN_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? OUTER_FRAME_CORNER_RADIUS - (((RectangularShape)OUTER_FRAME).getHeight() - (double)IMAGE_HEIGHT - 2.0) / 2.0 : OUTER_FRAME_CORNER_RADIUS - (((RectangularShape)OUTER_FRAME).getWidth() - (double)IMAGE_WIDTH - 2.0) / 2.0;
        RoundRectangle2D.Double FRAME_MAIN = new RoundRectangle2D.Double(1.0, 1.0, IMAGE_WIDTH - 2, IMAGE_HEIGHT - 2, FRAME_MAIN_CORNER_RADIUS, FRAME_MAIN_CORNER_RADIUS);
        double INNER_FRAME_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? (double)IMAGE_HEIGHT * 0.02857143 : (double)IMAGE_WIDTH * 0.02857143;
        RoundRectangle2D.Double INNER_FRAME = new RoundRectangle2D.Double(((RectangularShape)FRAME_MAIN).getX() + 16.0, ((RectangularShape)FRAME_MAIN).getY() + 16.0, ((RectangularShape)FRAME_MAIN).getWidth() - 32.0, ((RectangularShape)FRAME_MAIN).getHeight() - 32.0, INNER_FRAME_CORNER_RADIUS, INNER_FRAME_CORNER_RADIUS);
        double BACKGROUND_CORNER_RADIUS = INNER_FRAME_CORNER_RADIUS - 1.0;
        RoundRectangle2D.Double GAUGE_BACKGROUND = new RoundRectangle2D.Double(((RectangularShape)INNER_FRAME).getX() + 1.0, ((RectangularShape)INNER_FRAME).getY() + 1.0, ((RectangularShape)INNER_FRAME).getWidth() - 2.0, ((RectangularShape)INNER_FRAME).getHeight() - 2.0, BACKGROUND_CORNER_RADIUS, BACKGROUND_CORNER_RADIUS);
        Point2D.Double BACKGROUND_START = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMinY());
        Point2D.Double BACKGROUND_STOP = new Point2D.Double(0.0, GAUGE_BACKGROUND.getBounds2D().getMaxY());
        if (BACKGROUND_START.equals(BACKGROUND_STOP)) {
            ((Point2D)BACKGROUND_STOP).setLocation(0.0, ((Point2D)BACKGROUND_START).getY() + 1.0);
        }
        float[] BACKGROUND_FRACTIONS = new float[]{0.0f, 0.4f, 1.0f};
        Paint gaugeBackgroundGradient = null;
        if (CUSTOM_BACKGROUND != null && BACKGROUND_COLOR == BackgroundColor.CUSTOM) {
            G2.setPaint(CUSTOM_BACKGROUND);
        } else {
            Color[] BACKGROUND_COLORS = new Color[]{BACKGROUND_COLOR.GRADIENT_START_COLOR, BACKGROUND_COLOR.GRADIENT_FRACTION_COLOR, BACKGROUND_COLOR.GRADIENT_STOP_COLOR};
            if (BACKGROUND_COLOR == BackgroundColor.BRUSHED_METAL) {
                gaugeBackgroundGradient = new TexturePaint(this.UTIL.createBrushMetalTexture(TEXTURE_COLOR, GAUGE_BACKGROUND.getBounds().width, GAUGE_BACKGROUND.getBounds().height), GAUGE_BACKGROUND.getBounds());
            } else if (BACKGROUND_COLOR == BackgroundColor.STAINLESS) {
                gaugeBackgroundGradient = new TexturePaint(this.UTIL.createBrushMetalTexture(new Color(7237232), GAUGE_BACKGROUND.getBounds().width, GAUGE_BACKGROUND.getBounds().height, 5, 0.03f, true, 0.5f), GAUGE_BACKGROUND.getBounds());
            } else if (BACKGROUND_COLOR == BackgroundColor.STAINLESS_GRINDED) {
                gaugeBackgroundGradient = new TexturePaint(this.STAINLESS_GRINDED_TEXTURE, new Rectangle(0, 0, 100, 100));
            } else if (BACKGROUND_COLOR == BackgroundColor.CARBON) {
                gaugeBackgroundGradient = new TexturePaint(this.CARBON_FIBRE_TEXTURE, new Rectangle(0, 0, 12, 12));
                fadeInOut = true;
            } else if (BACKGROUND_COLOR == BackgroundColor.PUNCHED_SHEET) {
                gaugeBackgroundGradient = new TexturePaint(this.punchedSheetTexture, new Rectangle(0, 0, 12, 12));
                fadeInOut = true;
            } else if (BACKGROUND_COLOR == BackgroundColor.LINEN) {
                gaugeBackgroundGradient = new TexturePaint(this.UTIL.createLinenTexture(TEXTURE_COLOR, GAUGE_BACKGROUND.getBounds().width, GAUGE_BACKGROUND.getBounds().height), GAUGE_BACKGROUND.getBounds());
            } else if (BACKGROUND_COLOR == BackgroundColor.NOISY_PLASTIC) {
                ((Point2D)BACKGROUND_START).setLocation(0.0, GAUGE_BACKGROUND.getMinY());
                ((Point2D)BACKGROUND_STOP).setLocation(0.0, GAUGE_BACKGROUND.getMaxY());
                if (BACKGROUND_START.equals(BACKGROUND_STOP)) {
                    ((Point2D)BACKGROUND_STOP).setLocation(0.0, ((Point2D)BACKGROUND_START).getY() + 1.0);
                }
                float[] FRACTIONS = new float[]{0.0f, 1.0f};
                Color[] COLORS = new Color[]{this.UTIL.lighter(TEXTURE_COLOR, 0.15f), this.UTIL.darker(TEXTURE_COLOR, 0.15f)};
                gaugeBackgroundGradient = new LinearGradientPaint(BACKGROUND_START, BACKGROUND_STOP, FRACTIONS, COLORS);
            } else {
                gaugeBackgroundGradient = new LinearGradientPaint(BACKGROUND_START, BACKGROUND_STOP, BACKGROUND_FRACTIONS, BACKGROUND_COLORS);
            }
            G2.setPaint(gaugeBackgroundGradient);
        }
        G2.fill(GAUGE_BACKGROUND);
        BufferedImage CLP = CUSTOM_BACKGROUND != null && BACKGROUND_COLOR == BackgroundColor.CUSTOM ? Shadow.INSTANCE.createInnerShadow(GAUGE_BACKGROUND, CUSTOM_BACKGROUND, 0, 0.65f, Color.BLACK, 20, 315) : Shadow.INSTANCE.createInnerShadow(GAUGE_BACKGROUND, gaugeBackgroundGradient, 0, 0.65f, Color.BLACK, 20, 315);
        G2.drawImage((Image)CLP, GAUGE_BACKGROUND.getBounds().x, GAUGE_BACKGROUND.getBounds().y, null);
        if (BACKGROUND_COLOR == BackgroundColor.NOISY_PLASTIC) {
            Random BW_RND = new Random();
            Random ALPHA_RND = new Random();
            Shape OLD_CLIP = G2.getClip();
            G2.setClip(GAUGE_BACKGROUND);
            int y = 0;
            while ((double)y < ((RectangularShape)GAUGE_BACKGROUND).getHeight()) {
                int x = 0;
                while ((double)x < ((RectangularShape)GAUGE_BACKGROUND).getWidth()) {
                    Color noiseColor = BW_RND.nextBoolean() ? this.BRIGHT_NOISE : this.DARK_NOISE;
                    int noiseAlpha = 10 + ALPHA_RND.nextInt(10) - 5;
                    G2.setColor(new Color(noiseColor.getRed(), noiseColor.getGreen(), noiseColor.getBlue(), noiseAlpha));
                    G2.drawLine((int)((double)x + GAUGE_BACKGROUND.getMinX()), (int)((double)y + GAUGE_BACKGROUND.getMinY()), (int)((double)x + GAUGE_BACKGROUND.getMinX()), (int)((double)y + GAUGE_BACKGROUND.getMinY()));
                    ++x;
                }
                ++y;
            }
            G2.setClip(OLD_CLIP);
        }
        if (fadeInOut) {
            float[] SHADOW_OVERLAY_FRACTIONS = new float[]{0.0f, 0.4f, 0.6f, 1.0f};
            Color[] SHADOW_OVERLAY_COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.5f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.5f)};
            LinearGradientPaint SHADOW_OVERLAY_GRADIENT = new LinearGradientPaint(new Point2D.Double(GAUGE_BACKGROUND.getMinX(), 0.0), new Point2D.Double(GAUGE_BACKGROUND.getMaxX(), 0.0), SHADOW_OVERLAY_FRACTIONS, SHADOW_OVERLAY_COLORS);
            G2.setPaint(SHADOW_OVERLAY_GRADIENT);
            G2.fill(GAUGE_BACKGROUND);
        }
        G2.dispose();
        if (BACKGROUND_IMAGE != null) {
            Graphics2D G = BACKGROUND_IMAGE.createGraphics();
            G.drawImage((Image)this.linBackgroundImage, 0, 0, null);
            G.dispose();
        }
        this.linWidth = WIDTH;
        this.linHeight = HEIGHT;
        this.linBackgroundColor = BACKGROUND_COLOR;
        this.linCustomBackground = CUSTOM_BACKGROUND;
        this.linTextureColor = TEXTURE_COLOR;
        return this.linBackgroundImage;
    }

    public BufferedImage getPunchedSheetTexture() {
        return this.punchedSheetTexture;
    }

    public void recreatePunchedSheetTexture(Color TEXTURE_COLOR) {
        if (this.punchedSheetTexture != null) {
            this.punchedSheetTexture.flush();
        }
        this.punchedSheetTexture = this.UTIL.create_PUNCHED_SHEET_Image(12, TEXTURE_COLOR);
    }

    public String toString() {
        return "BackgroundImageFactory";
    }
}

