/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.FieldIterator;
import com.rusefi.output.FieldsStrategy;
import com.rusefi.parse.TypesHelper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public abstract class JavaFieldsConsumer
implements ConfigurationConsumer {
    protected final Set<String> existingJavaEnums = new HashSet<String>();
    private final StringBuilder content = new StringBuilder();
    protected final StringBuffer allFields = new StringBuffer();
    protected final ReaderState state;
    private final int structureStartingTsPosition;

    public JavaFieldsConsumer(ReaderState state, int structureStartingTsPosition) {
        this.state = state;
        this.structureStartingTsPosition = structureStartingTsPosition;
    }

    public String getContent() {
        return this.content.toString();
    }

    private void writeJavaFieldName(String nameWithPrefix, int tsPosition) {
        this.allFields.append("\t" + nameWithPrefix.toUpperCase() + "," + "\n");
        this.content.append("\tpublic static final Field ");
        this.content.append(nameWithPrefix.toUpperCase());
        this.content.append(" = Field.create(\"" + nameWithPrefix.toUpperCase() + "\", " + tsPosition + ", ");
    }

    public static String getJavaType(int elementSize) {
        if (elementSize == 1) {
            return "FieldType.INT8";
        }
        if (elementSize == 2) {
            return "FieldType.INT16";
        }
        return "FieldType.INT";
    }

    private boolean isStringField(ConfigField configField) {
        String custom = this.state.getTsCustomLine().get(configField.getTypeName());
        return custom != null && custom.toLowerCase().startsWith("string");
    }

    @Override
    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
        FieldsStrategy fieldsStrategy = new FieldsStrategy(){

            @Override
            protected int writeOneField(FieldIterator iterator, String prefix, int tsPosition) {
                ConfigField prev = iterator.getPrev();
                ConfigField configField = iterator.cf;
                ConfigField next = iterator.next;
                int bitIndex = iterator.bitState.get();
                if (configField.isDirective()) {
                    return tsPosition;
                }
                if (configField.getName().equals(prev.getName())) {
                    return tsPosition;
                }
                ConfigStructure cs = configField.getStructureType();
                if (cs != null) {
                    String extraPrefix = cs.isWithPrefix() ? configField.getName() + "_" : "";
                    return this.writeFields(cs.getTsFields(), prefix + extraPrefix, tsPosition);
                }
                String nameWithPrefix = prefix + configField.getName();
                if (configField.isBit()) {
                    if (JavaFieldsConsumer.isUsefulField(configField)) {
                        JavaFieldsConsumer.this.writeJavaFieldName(nameWithPrefix, tsPosition);
                        JavaFieldsConsumer.this.content.append("FieldType.BIT, " + bitIndex + ")" + JavaFieldsConsumer.this.terminateField());
                    }
                    return iterator.adjustSize(tsPosition);
                }
                if (TypesHelper.isFloat(configField.getTypeName())) {
                    JavaFieldsConsumer.this.writeJavaFieldName(nameWithPrefix, tsPosition);
                    JavaFieldsConsumer.this.content.append("FieldType.FLOAT)" + JavaFieldsConsumer.this.terminateField());
                } else {
                    String enumOptions = JavaFieldsConsumer.this.state.getVariableRegistry().get(configField.getTypeName() + "_fullenum");
                    if (enumOptions == null) {
                        enumOptions = JavaFieldsConsumer.this.state.getVariableRegistry().get(configField.getTypeName() + "_enum");
                    }
                    if (enumOptions != null && !JavaFieldsConsumer.this.existingJavaEnums.contains(configField.getTypeName())) {
                        JavaFieldsConsumer.this.existingJavaEnums.add(configField.getTypeName());
                        JavaFieldsConsumer.this.content.append("\tpublic static final String[] " + configField.getTypeName() + " = {" + enumOptions + "};" + "\n");
                    }
                    if (JavaFieldsConsumer.isUsefulField(configField)) {
                        JavaFieldsConsumer.this.writeJavaFieldName(nameWithPrefix, tsPosition);
                        if (JavaFieldsConsumer.this.isStringField(configField)) {
                            String custom = JavaFieldsConsumer.this.state.getTsCustomLine().get(configField.getTypeName());
                            String[] tokens = custom.split(",");
                            String stringSize = tokens[3].trim();
                            JavaFieldsConsumer.this.content.append(stringSize + ", FieldType.STRING");
                        } else {
                            JavaFieldsConsumer.this.content.append(JavaFieldsConsumer.getJavaType(configField.getElementSize()));
                        }
                        if (enumOptions != null) {
                            JavaFieldsConsumer.this.content.append(", " + configField.getTypeName());
                        }
                        JavaFieldsConsumer.this.content.append(").setScale(" + configField.autoscaleSpecNumber() + ")" + JavaFieldsConsumer.this.terminateField());
                    }
                }
                return iterator.adjustSize(tsPosition);
            }
        };
        fieldsStrategy.run(this.state, structure, 0);
    }

    private static boolean isUsefulField(ConfigField configField) {
        return !configField.getName().startsWith("unused");
    }

    private String terminateField() {
        return ".setBaseOffset(" + this.structureStartingTsPosition + ");" + "\n";
    }
}

