/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ldmp;

import com.rusefi.config.Field;
import com.rusefi.enums.StateDictionaryFactory;
import com.rusefi.enums.live_data_e;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum StateDictionary {
    INSTANCE;

    private final Map<live_data_e, Field[]> map = new HashMap<live_data_e, Field[]>();
    private final Map<live_data_e, String> fileNames = new HashMap<live_data_e, String>();

    private StateDictionary() {
        StateDictionaryFactory.initialize(this);
    }

    static int getSize(Field[] values) {
        Field last = values[values.length - 1];
        return last.getOffset() + last.getType().getStorageSize();
    }

    public int getOffset(live_data_e live_data_e2) {
        int result = 0;
        for (live_data_e index : live_data_e2.values()) {
            if (index.ordinal() >= live_data_e2.ordinal()) continue;
            result += StateDictionary.getSize(this.getFields(index));
        }
        return result;
    }

    public void register(live_data_e ldsIndex, String fileName) {
        this.fileNames.put(ldsIndex, fileName);
    }

    @NotNull
    public String getFileName(live_data_e ldsIndex) {
        String result = this.fileNames.get((Object)ldsIndex);
        if (result == null) {
            throw new IllegalStateException("Nothing for " + (Object)((Object)ldsIndex));
        }
        return result;
    }

    @NotNull
    public Field[] getFields(live_data_e ldsIndex) {
        Field[] result = this.map.get((Object)ldsIndex);
        if (result == null) {
            throw new IllegalStateException("Nothing for " + (Object)((Object)ldsIndex));
        }
        return result;
    }
}

