/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.opensr5.ConfigurationImageMetaVersion0_0;
import com.opensr5.ConfigurationImageWithMeta;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.IniField;
import com.rusefi.SerialPortScanner;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.BinaryProtocolExecutor;
import com.rusefi.maintenance.CalibrationsInfo;
import com.rusefi.maintenance.CalibrationsUpdater;
import com.rusefi.maintenance.migration.ComposedTuneMigrator;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.tune.xml.Constant;
import com.rusefi.tune.xml.Msq;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class CalibrationsHelper {
    private static final Logging log = Logging.getLogging(CalibrationsHelper.class);
    private static final String PREVIOUS_CALIBRATIONS_FILE_NAME_COMPONENT = "prev_calibrations";
    private static final String UPDATED_CALIBRATIONS_FILE_NAME_COMPONENT = "updated_calibrations";
    private static final String MERGED_CALIBRATIONS_FILE_NAME_COMPONENT = "merged_calibrations";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-mm-dd-hh.mm.ss");

    public static boolean updateFirmwareAndRestorePreviousCalibrations(JComponent parent, SerialPortScanner.PortResult ecuPort, UpdateOperationCallbacks callbacks, Supplier<Boolean> updateFirmware) {
        AutoupdateUtil.assertNotAwtThread();
        String timestampFoleNameComponent = DATE_FORMAT.format(new Date());
        Optional<CalibrationsInfo> prevCalibrations = CalibrationsHelper.readAndBackupCurrentCalibrations(ecuPort, callbacks, CalibrationsHelper.getFileNameWithoutExtension(timestampFoleNameComponent, PREVIOUS_CALIBRATIONS_FILE_NAME_COMPONENT));
        if (!prevCalibrations.isPresent()) {
            callbacks.logLine("Failed to back up current calibrations...");
            return false;
        }
        if (!updateFirmware.get().booleanValue()) {
            return false;
        }
        Optional<CalibrationsInfo> updatedCalibrations = CalibrationsHelper.readAndBackupCurrentCalibrations(ecuPort, callbacks, CalibrationsHelper.getFileNameWithoutExtension(timestampFoleNameComponent, UPDATED_CALIBRATIONS_FILE_NAME_COMPONENT));
        if (!updatedCalibrations.isPresent()) {
            callbacks.logLine("Failed to back up updated calibrations...");
            return false;
        }
        Optional<CalibrationsInfo> mergedCalibrations = CalibrationsHelper.mergeCalibrations(prevCalibrations.get(), updatedCalibrations.get(), callbacks);
        if (mergedCalibrations.isPresent() && JOptionPane.showConfirmDialog(parent, "Some calibrations fields were overwritten with default values.\nWould you like to restore previous calibrations?", "Restore previous calibrations", 0) == 0) {
            if (!CalibrationsHelper.backUpCalibrationsInfo(mergedCalibrations.get(), CalibrationsHelper.getFileNameWithoutExtension(timestampFoleNameComponent, MERGED_CALIBRATIONS_FILE_NAME_COMPONENT), callbacks)) {
                callbacks.logLine("Failed to back up merged calibrations...");
                return false;
            }
            return CalibrationsUpdater.INSTANCE.updateCalibrations(ecuPort.port, mergedCalibrations.get().getImage().getConfigurationImage(), callbacks, false);
        }
        return true;
    }

    private static String getFileNameWithoutExtension(String timestampNameComponent, String fileNameComponent) {
        return String.format("%s%s_%s", "state/", timestampNameComponent, fileNameComponent);
    }

    private static Optional<CalibrationsInfo> readCalibrationsInfo(BinaryProtocol binaryProtocol, UpdateOperationCallbacks callbacks) {
        try {
            String signature = BinaryProtocol.getSignature(binaryProtocol.getStream());
            callbacks.logLine(String.format("Received a signature %s", signature));
            IniFileModel iniFile = BinaryProtocol.iniFileProvider.provide(signature);
            int pageSize = iniFile.getMetaInfo().getTotalSize();
            callbacks.logLine(String.format("Page size is %d", pageSize));
            ConfigurationImageMetaVersion0_0 meta = new ConfigurationImageMetaVersion0_0(pageSize, signature);
            callbacks.logLine("Reading current calibrations...");
            ConfigurationImageWithMeta image = binaryProtocol.readFullImageFromController(meta);
            return Optional.of(new CalibrationsInfo(iniFile, image));
        }
        catch (IOException e) {
            log.error("Failed to read meta:", e);
            callbacks.logLine("Failed to read meta");
            return Optional.empty();
        }
    }

    private static boolean backUpCalibrationsInfo(CalibrationsInfo calibrationsInfo, String fileName, UpdateOperationCallbacks callbacks) {
        try {
            String iniFileName = String.format("%s.ini", fileName);
            IniFileModel ini = calibrationsInfo.getIniFile();
            Path iniFilePath = Paths.get(ini.getIniFilePath(), new String[0]);
            callbacks.logLine(String.format("Backing up current ini-file `%s`...", iniFilePath));
            Files.copy(iniFilePath, Paths.get(iniFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            callbacks.logLine(String.format("`%s` ini-file is backed up as `%s`", iniFilePath.getFileName(), iniFileName));
            String zipFileName = String.format("%s.zip", fileName);
            String msqFileName = String.format("%s.msq", fileName);
            callbacks.logLine(String.format("Backing up calibrations to files `%s` and `%s`...", zipFileName, msqFileName));
            BinaryProtocol.saveConfigurationImageToFiles(calibrationsInfo.getImage(), ini, zipFileName, msqFileName);
            callbacks.logLine(String.format("Calibrations are backed up to files `%s` and `%s`", zipFileName, msqFileName));
            return true;
        }
        catch (Exception e) {
            log.error("Backing up calibrations failed:", e);
            callbacks.logLine("Backing up current calibrations failed: " + e);
            return false;
        }
    }

    public static Optional<CalibrationsInfo> readAndBackupCurrentCalibrations(SerialPortScanner.PortResult ecuPort, UpdateOperationCallbacks callbacks, String backupFileName) {
        return BinaryProtocolExecutor.executeWithSuspendedPortScanner(ecuPort.port, callbacks, binaryProtocol -> {
            try {
                CalibrationsInfo receivedCalibrations;
                Optional<CalibrationsInfo> calibrationsInfo = CalibrationsHelper.readCalibrationsInfo(binaryProtocol, callbacks);
                if (calibrationsInfo.isPresent() && CalibrationsHelper.backUpCalibrationsInfo(receivedCalibrations = calibrationsInfo.get(), backupFileName, callbacks)) {
                    return calibrationsInfo;
                }
                return Optional.empty();
            }
            catch (Exception e) {
                log.error("Back up current calibrations failed:", e);
                callbacks.logLine("Back up current calibrations failed");
                return Optional.empty();
            }
        }, Optional.empty(), false);
    }

    public static Optional<CalibrationsInfo> mergeCalibrations(CalibrationsInfo prevCalibrations, CalibrationsInfo newCalibrations, UpdateOperationCallbacks callbacks) {
        Optional<CalibrationsInfo> result = Optional.empty();
        IniFileModel prevIniFile = prevCalibrations.getIniFile();
        Msq prevMsq = prevCalibrations.generateMsq();
        IniFileModel newIniFile = newCalibrations.getIniFile();
        Msq newMsq = newCalibrations.generateMsq();
        TuneMigrationContext context = new TuneMigrationContext(prevIniFile, prevMsq, newIniFile, newMsq, callbacks);
        ComposedTuneMigrator.INSTANCE.migrateTune(context);
        Set<Map.Entry<String, Constant>> valuesToUpdate = context.getMigratedConstants().entrySet();
        if (!valuesToUpdate.isEmpty()) {
            ConfigurationImage mergedImage = newCalibrations.getImage().getConfigurationImage().clone();
            for (Map.Entry<String, Constant> valueToUpdate : valuesToUpdate) {
                IniField fieldToUpdate = newIniFile.getIniField(valueToUpdate.getKey());
                Constant value = valueToUpdate.getValue();
                fieldToUpdate.setValue(mergedImage, value);
                callbacks.logLine(String.format("To restore previous calibrations we are going to update the field `%s` with a value `%s`", fieldToUpdate.getName(), value.getValue()));
            }
            result = Optional.of(new CalibrationsInfo(newIniFile, new ConfigurationImageWithMeta(newCalibrations.getImage().getMeta(), mergedImage.getContent())));
        } else {
            callbacks.logLine("It looks like we do not need to update any fields to restore previous calibrations.");
        }
        return result;
    }
}

