/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration;

import com.opensr5.ini.field.EnumIniField;
import com.rusefi.io.UpdateOperationCallbacks;
import java.util.Objects;
import java.util.Optional;
import javax.management.ObjectName;

public enum DefaultEnumIniFieldMigrator {
    INSTANCE;


    public Optional<String> tryMigrateValue(EnumIniField prevField, EnumIniField newField, String prevValue, UpdateOperationCallbacks callbacks) {
        Optional<String> result = Optional.empty();
        if (!Objects.equals((Object)prevField.getType(), (Object)newField.getType())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because type is updated: `%s` -> `%s`", new Object[]{prevField.getName(), prevField.getType(), newField.getType()}));
        } else if (!Objects.equals(prevField.getBitSize0(), newField.getBitSize0())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because bit size 0 is updated: `%s` -> `%s`", prevField.getName(), prevField.getBitSize0(), newField.getBitSize0()));
        } else {
            EnumIniField.EnumKeyValueMap newFieldKeyValues = newField.getEnums();
            if (newFieldKeyValues.indexOf(prevValue) == -1) {
                if (newFieldKeyValues.isBitField()) {
                    int prevValueOrdinal = prevField.getEnums().indexOf(prevValue);
                    String migratedValue = newFieldKeyValues.get(prevValueOrdinal);
                    if (migratedValue != null) {
                        result = Optional.of(ObjectName.quote(migratedValue));
                    } else {
                        callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because of internal error: new enum doesn't value with ordinal %d", prevField.getName(), prevValueOrdinal));
                    }
                } else {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because value `%s` has disappeared", prevField.getName(), prevValue));
                }
            } else {
                result = Optional.of(prevValue);
            }
        }
        return result;
    }
}

