/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.BitState;
import com.rusefi.ConfigField;
import com.rusefi.output.FieldsStrategy;
import java.util.List;

public class FieldIterator {
    private final List<ConfigField> fields;
    final BitState bitState = new BitState();
    private ConfigField prev = ConfigField.VOID;
    ConfigField next;
    ConfigField cf;

    public FieldIterator(List<ConfigField> fields) {
        this.fields = fields;
    }

    public ConfigField getPrev() {
        return this.prev;
    }

    public void start(int index) {
        int nextIndex;
        for (nextIndex = index + 1; nextIndex < this.fields.size() && this.fields.get(nextIndex).isDirective(); ++nextIndex) {
        }
        this.next = nextIndex >= this.fields.size() ? ConfigField.VOID : this.fields.get(nextIndex);
        this.cf = this.fields.get(index);
    }

    public int loop(int tsPosition) {
        return FieldsStrategy.VOID.loopIterator(this.fields, "", tsPosition, this);
    }

    public void end(int currentPosition) {
        if (!this.cf.isDirective()) {
            this.prev = this.cf;
        }
        this.bitState.incrementBitIndex(this.cf, this.next);
    }

    public int adjustSize(int tsPosition) {
        return tsPosition + this.cf.getSize(this.next);
    }
}

