/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.FieldIterator;
import com.rusefi.output.FieldsStrategy;
import com.rusefi.output.JavaSensorsConsumer;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FragmentDialogConsumer
implements ConfigurationConsumer {
    private final StringBuilder graphList = new StringBuilder();
    private final StringBuilder indicatorPanel = new StringBuilder();
    private final String fragmentName;
    private final String variableNameSuffix;
    private final String variableNamePrefix;
    private boolean hasIndicators;
    private int graphLinesCounter;
    private int linesInCurrentGraph;
    private int currentGraphIndex;

    public FragmentDialogConsumer(String fragmentName, String variableNamePrefix, String variableNameSuffix) {
        this.fragmentName = fragmentName;
        this.variableNamePrefix = variableNamePrefix;
        this.variableNameSuffix = variableNameSuffix;
    }

    @Override
    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
        FieldsStrategy fieldsStrategy = new FieldsStrategy(){

            @Override
            int writeOneField(FieldIterator iterator, String prefix, int tsPosition) {
                ConfigField configField = iterator.cf;
                if (configField.isUnusedField()) {
                    return 0;
                }
                ConfigStructure cs = configField.getStructureType();
                if (cs != null) {
                    String extraPrefix = cs.isWithPrefix() ? configField.getName() + "_" : "";
                    return this.writeFields(cs.getTsFields(), prefix + extraPrefix, tsPosition);
                }
                if (configField.isBit()) {
                    if (!FragmentDialogConsumer.this.hasIndicators) {
                        FragmentDialogConsumer.this.hasIndicators = true;
                        FragmentDialogConsumer.this.indicatorPanel.append("indicatorPanel = " + FragmentDialogConsumer.this.getPanelName() + ", 2\n");
                    }
                    FragmentDialogConsumer.this.indicatorPanel.append("\tindicator = {" + prefix + FragmentDialogConsumer.this.variableNamePrefix + configField.getName() + "}, \"" + configField.getName() + " No\", \"" + configField.getName() + " Yes\"\n");
                    return 0;
                }
                if (FragmentDialogConsumer.this.graphLinesCounter == 0) {
                    FragmentDialogConsumer.this.startNewGraph();
                }
                FragmentDialogConsumer.this.graphLinesCounter++;
                if (FragmentDialogConsumer.this.linesInCurrentGraph == 4) {
                    FragmentDialogConsumer.this.linesInCurrentGraph = 0;
                    FragmentDialogConsumer.this.startNewGraph();
                }
                FragmentDialogConsumer.this.graphList.append("\t\tgraphLine = " + prefix + FragmentDialogConsumer.this.variableNamePrefix + configField.getName() + "\n");
                FragmentDialogConsumer.this.linesInCurrentGraph++;
                return 0;
            }
        };
        fieldsStrategy.run(readerState, structure, 0);
    }

    private void startNewGraph() {
        ++this.currentGraphIndex;
        this.graphList.append("\tliveGraph = " + this.getGraphControlName() + ", " + JavaSensorsConsumer.quote("Graph") + ", South\n");
    }

    @NotNull
    private String getPanelName() {
        return this.getFragmentNameWithSuffix() + "IndicatorPanel";
    }

    public String menuLine() {
        if (this.getContent().isEmpty()) {
            return "";
        }
        return "\t\t\tsubMenu = " + this.getDialogName() + ", " + JavaSensorsConsumer.quote(this.getFragmentNameWithSuffix()) + "\n";
    }

    public String getContent() {
        if (this.graphLinesCounter > 40) {
            return "";
        }
        String dialogDeclaration = "dialog = " + this.getDialogName() + ", " + JavaSensorsConsumer.quote(this.getFragmentNameWithSuffix()) + "\n";
        String indicatorPanelUsageLine = this.indicatorPanel.length() > 0 ? "\tpanel = " + this.getPanelName() + "\n" : "";
        return this.indicatorPanel + "\n" + dialogDeclaration + indicatorPanelUsageLine + this.graphList + "\n";
    }

    @NotNull
    private String getDialogName() {
        return this.getFragmentNameWithSuffix() + "Dialog";
    }

    @NotNull
    private String getGraphControlName() {
        return this.getFragmentNameWithSuffix() + "_" + this.currentGraphIndex + "_Graph";
    }

    @NotNull
    private String getFragmentNameWithSuffix() {
        return this.fragmentName + this.variableNameSuffix;
    }
}

