/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.rusefi.config.Field;
import com.rusefi.config.FieldType;
import com.rusefi.config.generated.FuelComputer;
import com.rusefi.config.generated.TsOutputs;
import com.rusefi.core.SensorCategory;
import com.rusefi.sensor_logs.BinaryLogEntry;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public enum Sensor implements BinaryLogEntry
{
    RPMValue("RPM", SensorCategory.SENSOR_INPUTS, FieldType.UINT16, TsOutputs.RPMVALUE, 1.0, 0.0, 8000.0, "RPM"),
    vehicleSpeedKph("Vehicle Speed", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.VEHICLESPEEDKPH, 0.01, 0.0, 0.0, "kph"),
    INT_TEMP("CPU Temperature", SensorCategory.OPERATIONS, FieldType.INT8, TsOutputs.INTERNALMCUTEMPERATURE, 1.0, 0.0, 5.0, "C"),
    CLT("CLT", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.COOLANT, 0.01, -40.0, 150.0, "deg C"),
    IAT("IAT", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.INTAKE, 0.01, -40.0, 150.0, "deg C"),
    FUEL_TEMP("Fuel Temperature", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.FUELTEMP, 0.01, -40.0, 150.0, "deg C"),
    AuxFreq1("AuxFreq1", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.AUXSPEED1, 1.0, -40.0, 150.0, "Hz"),
    AuxFreq2("AuxFreq2", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.AUXSPEED2, 1.0, -40.0, 150.0, "Hz"),
    TPS("TPS", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.TPSVALUE, 0.01, 0.0, 100.0, "%"),
    PPS("Throttle pedal position", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.THROTTLEPEDALPOSITION, 0.01, 0.0, 100.0, "%"),
    MAF_RAE("MAF raw", SensorCategory.SENSOR_INPUTS, FieldType.UINT16, TsOutputs.RAWMAF, 0.001, 0.0, 5.0, "Volts"),
    MAF("MAF", SensorCategory.SENSOR_INPUTS, FieldType.UINT16, TsOutputs.MAFMEASURED, 0.1, 0.0, 5.0, "Volts"),
    MAP("MAP", SensorCategory.SENSOR_INPUTS, FieldType.UINT16, TsOutputs.MAPVALUE, 0.03333333333333333, 20.0, 300.0, "kPa"),
    BARO("Barometric pressure", SensorCategory.SENSOR_INPUTS, FieldType.UINT16, TsOutputs.BAROPRESSURE, 0.03333333333333333, 20.0, 300.0, "kPa"),
    Lambda1("Lambda", SensorCategory.SENSOR_INPUTS, FieldType.UINT16, TsOutputs.LAMBDAVALUE, 1.0E-4, 0.65, 1.2, "lambda"),
    VBATT("VBatt", SensorCategory.SENSOR_INPUTS, FieldType.UINT16, TsOutputs.VBATT, 0.001, 4.0, 18.0, "Volts"),
    veValue("Fuel: VE", SensorCategory.FUEL, FieldType.UINT8, TsOutputs.VEVALUE, 0.5, 0.0, 100.0, "%"),
    tpsAccelFuel("Fuel: TPS AE add fuel ms", SensorCategory.FUEL, FieldType.INT16, TsOutputs.TPSACCELFUEL, 0.0033333333333333335, 0.0, 200.0, "ms"),
    etb1DutyCycle("ETB: Duty", SensorCategory.OTHERS, FieldType.INT16, TsOutputs.ETB1DUTYCYCLE, 0.01, 0.0, 100.0, "%"),
    boostDcPidOutput("Boost PID output", SensorCategory.FUEL, FieldType.INT16, TsOutputs.BOOSTSTATUS_OUTPUT, 0.01, 0.0, 20.0, ""),
    boostDcPidPTerm("Boost PID pTerm", SensorCategory.FUEL, FieldType.FLOAT, TsOutputs.BOOSTSTATUS_PTERM, 0.01, 0.0, 20.0, ""),
    boostDcPidITerm("Boost PID iTerm", SensorCategory.FUEL, FieldType.INT16, TsOutputs.BOOSTSTATUS_ITERM, 0.01, 0.0, 20.0, ""),
    afrTarget("Fuel: target AFR", SensorCategory.FUEL, FieldType.INT16, FuelComputer.TARGETAFR, 0.001, 0.0, 20.0, ""),
    sdAirMassInOneCylinder("sdAirMassInOneCylinder", SensorCategory.FUEL, FieldType.FLOAT, FuelComputer.SDAIRMASSINONECYLINDER, 1.0, 0.0, 15.0, "g"),
    TIME_SECONDS("Time", SensorCategory.OPERATIONS, FieldType.INT, TsOutputs.SECONDS, 1.0, 0.0, 5.0, ""),
    FIRMWARE_VERSION("firmware", SensorCategory.OPERATIONS, FieldType.INT, TsOutputs.FIRMWAREVERSION, 1.0, 0.0, 100.0, "version_f"),
    totalTriggerErrorCounter("Trigger Error Counter", SensorCategory.STATUS, FieldType.INT, TsOutputs.TOTALTRIGGERERRORCOUNTER, 0.0, 5.0),
    lastErrorCode("Warning: last", SensorCategory.STATUS, FieldType.INT, TsOutputs.LASTERRORCODE, 0.0, 5.0),
    debugFloatField1("debug f1", SensorCategory.DEBUG, FieldType.FLOAT, TsOutputs.DEBUGFLOATFIELD1, 0.0, 5.0),
    debugFloatField2("debug f2: iTerm", SensorCategory.DEBUG, FieldType.FLOAT, TsOutputs.DEBUGFLOATFIELD2, 0.0, 5.0),
    debugFloatField3("debug f3: prevError", SensorCategory.DEBUG, FieldType.FLOAT, TsOutputs.DEBUGFLOATFIELD3, 0.0, 5.0),
    debugFloatField4("debug f4: iParam", SensorCategory.DEBUG, FieldType.FLOAT, TsOutputs.DEBUGFLOATFIELD4, 0.0, 5.0),
    debugFloatField5("debug f5: dParam", SensorCategory.DEBUG, FieldType.FLOAT, TsOutputs.DEBUGFLOATFIELD5, 0.0, 5.0),
    debugFloatField6("debug f6: dTerm", SensorCategory.DEBUG, FieldType.FLOAT, TsOutputs.DEBUGFLOATFIELD6, 0.0, 5.0),
    debugFloatField7("debug f7", SensorCategory.DEBUG, FieldType.FLOAT, TsOutputs.DEBUGFLOATFIELD7, 0.0, 5.0),
    debugIntField1("debug i1: pParam", SensorCategory.DEBUG, FieldType.INT, TsOutputs.DEBUGINTFIELD1, 0.0, 5.0),
    debugIntField2("debug i2: offset", SensorCategory.DEBUG, FieldType.INT, TsOutputs.DEBUGINTFIELD2, 0.0, 5.0),
    debugIntField3("debug i3", SensorCategory.DEBUG, FieldType.INT, TsOutputs.DEBUGINTFIELD3, 0.0, 5.0),
    debugIntField4("debug i4", SensorCategory.DEBUG, FieldType.INT16, TsOutputs.DEBUGINTFIELD4, 0.0, 5.0),
    debugIntField5("debug i5", SensorCategory.DEBUG, FieldType.INT16, TsOutputs.DEBUGINTFIELD5, 0.0, 5.0),
    tuneCrc16("tune crc16", SensorCategory.STATUS, FieldType.UINT16, TsOutputs.TUNECRC16, 0.0, 5.0),
    rawClt("raw CLT", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.RAWCLT, 0.001, 0.0, 5.0, "volts"),
    rawIat("raw IAT", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.RAWIAT, 0.001, 0.0, 5.0, "volts"),
    flexPercent("Flex Ethanol %", SensorCategory.SENSOR_INPUTS, FieldType.INT8, TsOutputs.FLEXPERCENT, 0.5, 0.0, 100.0, "%"),
    wastegatePosition("Wastegate position sensor", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.WASTEGATEPOSITIONSENSOR, 0.01, 0.0, 100.0, "%"),
    idlePositionSensor("Idle: Position sensor", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.IDLEPOSITIONSENSOR, 0.01, 0.0, 100.0, "%"),
    lowFuelPressure("Fuel pressure (low)", SensorCategory.OPERATIONS, FieldType.INT16, TsOutputs.RAWLOWFUELPRESSURE, 0.03333333333333333, 10.0, 20.0, "afr"),
    highFuelPressure("Fuel pressure (high)", SensorCategory.OPERATIONS, FieldType.INT16, TsOutputs.HIGHFUELPRESSURE, 0.1, 10.0, 20.0, "afr"),
    vvtPositionB1I("VVT: bank 1 intake", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.VVTPOSITIONB1I, 0.02, 0.0, 5.0, "deg"),
    vvtPositionB1E("VVT: bank 1 exhaust", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.VVTPOSITIONB1E, 0.02, 0.0, 5.0, "deg"),
    vvtPositionB2I("VVT: bank 2 intake", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.VVTPOSITIONB2I, 0.02, 0.0, 5.0, "deg"),
    vvtPositionB2E("VVT: bank 2 exhaust", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.VVTPOSITIONB2E, 0.02, 0.0, 5.0, "deg"),
    vvtTargetB1I("VVT: bank 1 intake target", SensorCategory.SENSOR_INPUTS, FieldType.INT8, TsOutputs.VVTTARGETS1, 1.0, -50.0, 50.0, "deg"),
    vvtTargetB1E("VVT: bank 1 exhaust target", SensorCategory.SENSOR_INPUTS, FieldType.INT8, TsOutputs.VVTTARGETS2, 1.0, -50.0, 50.0, "deg"),
    vvtTargetB2I("VVT: bank 2 intake target", SensorCategory.SENSOR_INPUTS, FieldType.INT8, TsOutputs.VVTTARGETS3, 1.0, -50.0, 50.0, "deg"),
    vvtTargetB2E("VVT: bank 2 exhaust target", SensorCategory.SENSOR_INPUTS, FieldType.INT8, TsOutputs.VVTTARGETS4, 1.0, -50.0, 50.0, "deg"),
    turboSpeed("Turbocharger Speed", SensorCategory.SENSOR_INPUTS, FieldType.INT16, TsOutputs.TURBOSPEED, 1.0, -50.0, 50.0, "hz"),
    instantMAP("Instant MAP", SensorCategory.SENSOR_INPUTS, FieldType.UINT16, TsOutputs.INSTANTMAPVALUE, 0.03333333333333333, 20.0, 300.0, "kPa"),
    LUAGAUGE1("Lua gauge 1", SensorCategory.SENSOR_INPUTS, FieldType.FLOAT, TsOutputs.LUAGAUGES1, 1.0, 4.0, 18000.0, "value"),
    LUAGAUGE2("Lua gauge 2", SensorCategory.SENSOR_INPUTS, FieldType.FLOAT, TsOutputs.LUAGAUGES2, 1.0, 4.0, 18000.0, "value"),
    MCUSERIAL(SensorCategory.OPERATIONS, TsOutputs.MCUSERIAL),
    ETB_CONTROL_QUALITY("ETB metric", SensorCategory.SNIFFING, "", 100.0);

    private final String name;
    private final SensorCategory category;
    private final String units;
    private final double minValue;
    private final double maxValue;
    @Nullable
    private final FieldType type;
    private final int offset;
    private final double scale;

    private Sensor(String name, SensorCategory category, FieldType type, Field field, double scale, double minValue, double maxValue, String units) {
        this.name = name == null ? this.name() : name;
        this.type = type;
        this.offset = field.getTotalOffset();
        this.scale = scale;
        this.category = category;
        this.units = units;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    private Sensor(String name, SensorCategory category, FieldType type, Field field, double minValue, double maxValue) {
        this(name, category, type, field, 1.0, minValue, maxValue, "n/a");
    }

    private Sensor(SensorCategory category, Field field) {
        this(field.getName(), category, field.getType(), field, 0.0, 100.0);
    }

    private Sensor(String name, SensorCategory category, String units, double maxValue) {
        this(name, category, units, 0.0, maxValue);
    }

    private Sensor(String name, SensorCategory category, String units, double minValue, double maxValue) {
        this.name = name;
        this.category = category;
        this.units = units;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.scale = 1.0;
        this.type = null;
        this.offset = -1;
    }

    public static Collection<Sensor> getSensorsForCategory(String category) {
        TreeSet<Sensor> sensors = new TreeSet<Sensor>(Comparator.comparing(o -> o.getName().toLowerCase()));
        for (Sensor sensor : Sensor.values()) {
            if (!sensor.category.getName().equals(category)) continue;
            sensors.add(sensor);
        }
        return sensors;
    }

    public static double processAdvance(double advance) {
        return advance > 360.0 ? advance - 720.0 : advance;
    }

    public static Sensor lookup(String gaugeName, Sensor defaultValue) {
        Sensor sensor;
        try {
            sensor = Sensor.valueOf(Sensor.class, gaugeName);
        }
        catch (IllegalArgumentException e) {
            sensor = defaultValue;
        }
        return sensor;
    }

    public static Sensor find(String value) {
        for (Sensor s : Sensor.values()) {
            if (!s.name.equals(value) && !s.name().equals(value)) continue;
            return s;
        }
        throw new IllegalStateException("Sensor not found: " + value);
    }

    public double getValueForChannel(ByteBuffer bb) {
        switch (this.getType()) {
            case FLOAT: {
                return bb.getFloat();
            }
            case INT: {
                return bb.getInt();
            }
            case UINT16: {
                return bb.getInt() & 0xFFFF;
            }
            case INT16: {
                return (short)(bb.getInt() & 0xFFFF);
            }
            case UINT8: {
                return bb.getInt() & 0xFF;
            }
            case INT8: {
                return (byte)(bb.getInt() & 0xFF);
            }
        }
        throw new UnsupportedOperationException("type " + (Object)((Object)this.getType()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.units;
    }

    @Override
    public int getByteSize() {
        switch (this.getType()) {
            case UINT8: {
                return 0;
            }
            case INT8: {
                return 1;
            }
            case UINT16: {
                return 2;
            }
            case INT16: {
                return 3;
            }
            case INT: {
                return 4;
            }
            case FLOAT: {
                return 7;
            }
        }
        throw new UnsupportedOperationException("" + (Object)((Object)this.getType()));
    }

    @Override
    public SensorCategory getCategory() {
        return this.category;
    }

    public String getUnits() {
        return this.units;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    @Deprecated
    public int getOffset() {
        return this.offset;
    }

    public double getScale() {
        return this.scale;
    }

    public FieldType getType() {
        return this.type;
    }

    public double translateValue(double value) {
        return value;
    }

    @Override
    public void writeToLog(DataOutputStream dos, double value) throws IOException {
        switch (this.type) {
            case UINT8: 
            case INT8: {
                dos.write((int)value);
                return;
            }
            case FLOAT: {
                dos.writeFloat((float)value);
                return;
            }
            case UINT16: 
            case INT16: {
                dos.writeShort((int)value);
                return;
            }
            case INT: {
                dos.writeInt((int)value);
                return;
            }
        }
        throw new UnsupportedOperationException("Type " + (Object)((Object)this.type));
    }

    public String getLogValue(double value) {
        if (this.scale == 1.0 && this.type != null) {
            switch (this.type) {
                case UINT16: {
                    int v = (int)value & 0xFFFF;
                    return Integer.toString(v);
                }
            }
        }
        return Double.toString(value);
    }

    static {
        TreeSet<String> NAMES = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Sensor s : Sensor.values()) {
            if (NAMES.add(s.name)) continue;
            throw new IllegalArgumentException("Unique name expected " + s.name);
        }
    }
}

