/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.config.FieldType;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.migration.IniFieldMigrator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public enum VeTableExtensionMigrator implements IniFieldMigrator
{
    INSTANCE;

    private static String VE_TABLE_FIELD_NAME;
    private static String VE_RPM_BINS_FIELD_NAME;
    private static final FieldType VE_TABLE_TYPE;
    private static final FieldType VE_RPM_BINS_TYPE;
    private static final int VE_TABLE_ROWS = 16;
    private static final int OLD_VE_TABLE_COLS = 16;
    private static final int NEW_VE_TABLE_COLS = 24;
    private static final int VE_RPM_BINS_COLS = 1;
    private static final double VE_RPM_BINS_MULTIPLIER = 1.0;
    private static final String VE_RPM_BINS_DIGITS = "0";

    @Override
    public Optional<String> tryMigrateValue(IniField prevField, IniField newField, String prevValue, UpdateOperationCallbacks callbacks) {
        Optional<String> result = Optional.empty();
        String prevFieldName = prevField.getName();
        String newFieldName = newField.getName();
        if (VE_TABLE_FIELD_NAME.equals(prevFieldName) && VE_TABLE_FIELD_NAME.equals(newFieldName)) {
            result = this.tryMigrateVeTable(prevField, newField, prevValue, callbacks);
        } else if (VE_RPM_BINS_FIELD_NAME.equals(prevFieldName) && VE_RPM_BINS_FIELD_NAME.equals(newFieldName)) {
            result = this.tryMigrateVeRpmBins(prevField, newField, prevValue, callbacks);
        }
        return result;
    }

    private Optional<String> tryMigrateVeTable(IniField prevField, IniField newField, String prevValue, UpdateOperationCallbacks callbacks) {
        Optional<String> result = Optional.empty();
        Optional<ArrayIniField> prevVeTableValidatedField = VeTableExtensionMigrator.getValidatedVeTableArrayIniField(prevField, callbacks);
        Optional<ArrayIniField> newVeTableValidatedField = VeTableExtensionMigrator.getValidatedVeTableArrayIniField(newField, callbacks);
        if (prevVeTableValidatedField.isPresent() && newVeTableValidatedField.isPresent()) {
            ArrayIniField prevVeTableField = prevVeTableValidatedField.get();
            ArrayIniField newVeTableField = newVeTableValidatedField.get();
            int prevVeTableFieldCols = prevVeTableField.getCols();
            int newVeTableFieldCols = newVeTableField.getCols();
            if (prevVeTableFieldCols == 16 && newVeTableFieldCols == 24) {
                String[][] prevValues = prevVeTableField.getValues(prevValue);
                String[][] newValues = new String[16][24];
                for (int rowIdx = 0; rowIdx < 16; ++rowIdx) {
                    int colIdx;
                    for (colIdx = 0; colIdx < 16; ++colIdx) {
                        newValues[rowIdx][colIdx] = prevValues[rowIdx][colIdx];
                    }
                    for (colIdx = 16; colIdx < 24; ++colIdx) {
                        newValues[rowIdx][colIdx] = prevValues[rowIdx][15];
                    }
                }
                result = Optional.of(newVeTableField.formatValue(newValues));
            }
        }
        return result;
    }

    private static Optional<ArrayIniField> getValidatedVeTableArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `veTable` ini-field is expected to be `ArrayIniField` instead of %s", field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != VE_TABLE_TYPE) {
            callbacks.logLine(String.format("WARNING! `veTable` ini-field is expected to be `ArrayIniField` instead of %s", field.getClass().getName()));
            return Optional.empty();
        }
        int arrayFieldRows = arrayField.getRows();
        if (arrayFieldRows != 16) {
            callbacks.logLine(String.format("WARNING! `veTable` ini-field is expected to contain %d rows instead of %d", 16, arrayFieldRows));
            return Optional.empty();
        }
        int arrayFieldCols = arrayField.getCols();
        switch (arrayFieldCols) {
            case 16: 
            case 24: {
                return Optional.of(arrayField);
            }
        }
        callbacks.logLine(String.format("WARNING! `veTable` ini-field is expected to contain %d or %d columns instead of %d", 16, 24, arrayFieldRows));
        return Optional.empty();
    }

    private static long chooseStep(List<Long> bins, long maxPossibleStep) {
        Long lastBin = null;
        Long lastStep = null;
        Long maxStep = null;
        for (long bin : bins) {
            if (lastBin != null && (lastStep = Long.valueOf(bin - lastBin)) <= maxPossibleStep && (maxStep == null || maxStep < lastStep)) {
                maxStep = lastStep;
            }
            lastBin = bin;
        }
        if (lastStep != null) {
            if (lastStep <= maxPossibleStep) {
                return lastStep;
            }
            if (maxStep != null) {
                return maxStep;
            }
        }
        return maxPossibleStep;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Optional<String> tryMigrateVeRpmBins(IniField prevField, IniField newField, String prevValue, UpdateOperationCallbacks callbacks) {
        Optional<String> result = Optional.empty();
        Optional<ArrayIniField> prevVeRpmBinsValidatedField = VeTableExtensionMigrator.getValidatedVeRpmBinsArrayIniField(prevField, callbacks);
        Optional<ArrayIniField> newVeRpmBinsValidatedField = VeTableExtensionMigrator.getValidatedVeRpmBinsArrayIniField(newField, callbacks);
        if (!prevVeRpmBinsValidatedField.isPresent()) return result;
        if (!newVeRpmBinsValidatedField.isPresent()) return result;
        ArrayIniField prevVeRpmBinsField = prevVeRpmBinsValidatedField.get();
        ArrayIniField newVeRpmBinsField = newVeRpmBinsValidatedField.get();
        int prevVeRpmBinsFieldRows = prevVeRpmBinsField.getRows();
        int newVeRpmBinsFieldRows = newVeRpmBinsField.getRows();
        if (prevVeRpmBinsFieldRows == 16 && newVeRpmBinsFieldRows == 24) {
            List prevValues = Arrays.stream(prevVeRpmBinsField.getValues(prevValue)).map(e -> e[0]).collect(Collectors.toList());
            List<Long> prevLongValues = prevValues.stream().map(Double::parseDouble).map(Math::round).collect(Collectors.toList());
            long lastValue = (Long)prevLongValues.get(prevLongValues.size() - 1);
            String max = newVeRpmBinsField.getMax();
            Optional<Object> recommendedStep = Optional.empty();
            if (max != null) {
                long maxPossibleStep = (long)((Double.parseDouble(max) - (double)lastValue) / 8.0);
                if (1L > maxPossibleStep) {
                    callbacks.logLine(String.format("WARNING! `veRpmBins` ini-field cannot be propagated with increasing values, because max value is %s", max));
                    return Optional.empty();
                }
                recommendedStep = Optional.of(VeTableExtensionMigrator.chooseStep(prevLongValues, maxPossibleStep));
            } else {
                long valueBeforeLast = (Long)prevLongValues.get(prevLongValues.size() - 2);
                recommendedStep = Optional.of(lastValue - valueBeforeLast);
            }
            if (!recommendedStep.isPresent()) return result;
            String[][] newValues = new String[24][1];
            for (int i = 0; i < 16; ++i) {
                newValues[i] = new String[]{(String)prevValues.get(i)};
            }
            long lastBin = lastValue;
            int i = 16;
            while (true) {
                if (i >= 24) {
                    return Optional.of(newVeRpmBinsField.formatValue(newValues));
                }
                newValues[i] = new String[]{String.format("%.1f", lastBin += ((Long)recommendedStep.get()).longValue())};
                ++i;
            }
        }
        callbacks.logLine("WARNING! We failed to extend `veRpmBins` ini-field");
        return result;
    }

    private static Optional<ArrayIniField> getValidatedVeRpmBinsArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `veRpmBins` ini-field is expected to be `ArrayIniField` instead of %s", field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != VE_RPM_BINS_TYPE) {
            callbacks.logLine(String.format("WARNING! Type of `veRpmBins` ini-field is expected to be `%s` instead of `%s`", new Object[]{VE_TABLE_TYPE, arrayFieldType}));
            return Optional.empty();
        }
        int arrayFieldCols = arrayField.getCols();
        if (arrayFieldCols != 1) {
            callbacks.logLine(String.format("WARNING! `veRpmBins` ini-field is expected to contain %d columns instead of %d", 16, arrayFieldCols));
            return Optional.empty();
        }
        double arrayFieldMultiplier = arrayField.getMultiplier();
        if (arrayFieldMultiplier != 1.0) {
            callbacks.logLine(String.format("WARNING! Multiplier of `veRpmBins` ini-field is expected to be %f instead of %f", 1.0, arrayFieldMultiplier));
            return Optional.empty();
        }
        String arrayFieldDigits = arrayField.getDigits();
        if (!VE_RPM_BINS_DIGITS.equals(arrayFieldDigits)) {
            callbacks.logLine(String.format("WARNING! Digits of `veRpmBins` ini-field is expected to be `%s` instead of `%s`", VE_RPM_BINS_DIGITS, arrayFieldDigits));
            return Optional.empty();
        }
        int arrayFieldRows = arrayField.getRows();
        switch (arrayFieldRows) {
            case 16: 
            case 24: {
                return Optional.of(arrayField);
            }
        }
        callbacks.logLine(String.format("WARNING! `veRpmBins` ini-field is expected to contain %d or %d rows instead of %d", 16, 24, arrayFieldRows));
        return Optional.empty();
    }

    static {
        VE_TABLE_FIELD_NAME = "veTable";
        VE_RPM_BINS_FIELD_NAME = "veRpmBins";
        VE_TABLE_TYPE = FieldType.UINT16;
        VE_RPM_BINS_TYPE = FieldType.UINT16;
    }
}

