/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public abstract class AbstractRadialBargraph
extends AbstractRadial {
    private final float[] LED_FRACTIONS = new float[]{0.0f, 1.0f};

    public AbstractRadialBargraph() {
        this.setLedPosition(0.453271028, 0.65);
        this.setUserLedPosition(0.453271028, 0.59);
    }

    public ColorDef getBarGraphColor() {
        return this.getModel().getValueColor();
    }

    public void setBarGraphColor(ColorDef BARGRAPH_COLOR) {
        this.getModel().setValueColor(BARGRAPH_COLOR);
        this.init(this.getInnerBounds().width, this.getInnerBounds().width);
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomBargraphColor() {
        return this.getModel().getCustomValueColor();
    }

    public void setCustomBarGraphColor(Color COLOR) {
        this.getModel().setCustomValueColorObject(new CustomColorDef(COLOR));
        this.init(this.getInnerBounds().width, this.getInnerBounds().width);
        this.repaint(this.getInnerBounds());
    }

    public CustomColorDef getCustomBarGraphColorObject() {
        return this.getModel().getCustomValueColorObject();
    }

    public boolean isPeakValueEnabled() {
        return this.getModel().isPeakValueVisible();
    }

    public void setPeakValueEnabled(boolean PEAK_VALUE_ENABLED) {
        this.getModel().setPeakValueVisible(PEAK_VALUE_ENABLED);
    }

    protected BufferedImage create_BARGRAPH_TRACK_Image(int WIDTH, double START_ANGLE, double ANGLE_EXTEND, double APEX_ANGLE, double BARGRAPH_OFFSET) {
        return this.create_BARGRAPH_TRACK_Image(WIDTH, START_ANGLE, ANGLE_EXTEND, APEX_ANGLE, BARGRAPH_OFFSET, null);
    }

    protected BufferedImage create_BARGRAPH_TRACK_Image(int WIDTH, double START_ANGLE, double ANGLE_EXTEND, double APEX_ANGLE, double BARGRAPH_OFFSET, BufferedImage image) {
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        Arc2D.Double BACK = new Arc2D.Double(2);
        BACK.setFrame((double)IMAGE_WIDTH * 0.1074766355, (double)IMAGE_HEIGHT * 0.1074766355, (double)IMAGE_WIDTH * 0.785046729, (double)IMAGE_HEIGHT * 0.785046729);
        ((Arc2D)BACK).setAngleStart(START_ANGLE + 2.0);
        ((Arc2D)BACK).setAngleExtent(ANGLE_EXTEND - 5.0);
        Ellipse2D.Double BACK_SUB = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.1822429907, (double)IMAGE_HEIGHT * 0.1822429907, (double)IMAGE_WIDTH * 0.6355140187, (double)IMAGE_HEIGHT * 0.6355140187);
        Area LED_TRACK_FRAME = new Area(BACK);
        LED_TRACK_FRAME.subtract(new Area(BACK_SUB));
        Point2D.Double LED_TRACK_FRAME_START = new Point2D.Double(0.0, LED_TRACK_FRAME.getBounds2D().getMinY());
        Point2D.Double LED_TRACK_FRAME_STOP = new Point2D.Double(0.0, LED_TRACK_FRAME.getBounds2D().getMaxY());
        float[] LED_TRACK_FRAME_FRACTIONS = new float[]{0.0f, 0.22f, 0.76f, 1.0f};
        Color[] LED_TRACK_FRAME_COLORS = new Color[]{new Color(0, 0, 0, 255), new Color(51, 51, 51, 255), new Color(51, 51, 51, 255), new Color(100, 100, 100, 255)};
        LinearGradientPaint LED_TRACK_FRAME_GRADIENT = new LinearGradientPaint(LED_TRACK_FRAME_START, LED_TRACK_FRAME_STOP, LED_TRACK_FRAME_FRACTIONS, LED_TRACK_FRAME_COLORS);
        G2.setPaint(LED_TRACK_FRAME_GRADIENT);
        G2.fill(LED_TRACK_FRAME);
        Arc2D.Double FRONT = new Arc2D.Double(2);
        FRONT.setFrame((double)IMAGE_WIDTH * 0.1121495327, (double)IMAGE_HEIGHT * 0.1121495327, (double)IMAGE_WIDTH * 0.7803738318, (double)IMAGE_HEIGHT * 0.7803738318);
        ((Arc2D)FRONT).setAngleStart(START_ANGLE);
        ((Arc2D)FRONT).setAngleExtent(ANGLE_EXTEND);
        Ellipse2D.Double FRONT_SUB = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.1822429907, (double)IMAGE_HEIGHT * 0.1822429907, (double)IMAGE_WIDTH * 0.6448598131, (double)IMAGE_HEIGHT * 0.6448598131);
        Area LED_TRACK_MAIN = new Area(BACK);
        LED_TRACK_MAIN.subtract(new Area(FRONT_SUB));
        Point2D.Double LED_TRACK_MAIN_START = new Point2D.Double(0.0, LED_TRACK_MAIN.getBounds2D().getMinY());
        Point2D.Double LED_TRACK_MAIN_STOP = new Point2D.Double(0.0, LED_TRACK_MAIN.getBounds2D().getMaxY());
        float[] LED_TRACK_MAIN_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] LED_TRACK_MAIN_COLORS = new Color[]{new Color(17, 17, 17, 255), new Color(51, 51, 51, 255)};
        LinearGradientPaint LED_TRACK_MAIN_GRADIENT = new LinearGradientPaint(LED_TRACK_MAIN_START, LED_TRACK_MAIN_STOP, LED_TRACK_MAIN_FRACTIONS, LED_TRACK_MAIN_COLORS);
        G2.setPaint(LED_TRACK_MAIN_GRADIENT);
        G2.fill(LED_TRACK_MAIN);
        Point2D.Double CENTER = new Point2D.Double((double)WIDTH / 2.0, (double)WIDTH / 2.0);
        Rectangle2D.Double LED = new Rectangle2D.Double((double)WIDTH * 0.1168224299, (double)WIDTH * 0.4859813084, (double)WIDTH * 0.06074766355140187, (double)WIDTH * 0.023364486);
        Point2D.Double LED_CENTER = new Point2D.Double(LED.getCenterX(), LED.getCenterY());
        Color[] LED_COLORS = new Color[]{new Color(60, 60, 60, 255), new Color(50, 50, 50, 255)};
        RadialGradientPaint LED_GRADIENT = new RadialGradientPaint(LED_CENTER, (float)(0.030373831775700934 * (double)IMAGE_WIDTH), this.LED_FRACTIONS, LED_COLORS);
        G2.setPaint(LED_GRADIENT);
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        for (double angle = 0.0; angle <= APEX_ANGLE; angle += 5.0) {
            G2.rotate(Math.toRadians(angle + BARGRAPH_OFFSET), ((Point2D)CENTER).getX(), ((Point2D)CENTER).getY());
            G2.fill(LED);
            G2.setTransform(OLD_TRANSFORM);
        }
        G2.dispose();
        return image;
    }
}

