/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.rusefi.core.preferences.storage.PersistentConfiguration;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class InstanceNameEditor {
    private static final String INSTANCE_NAME = "INSTANCE_NAME";
    public static final InstanceNameEditor INSTANCE = new InstanceNameEditor();

    private InstanceNameEditor() {
    }

    public void editInstanceName(Component parentComponent) {
        InstanceNameTextField instanceNameField = new InstanceNameTextField(this.loadInstanceName());
        instanceNameField.addAncestorListener(new RequestFocusListener());
        int response = JOptionPane.showOptionDialog(parentComponent, new Object[]{"Instance name:", instanceNameField, "up to 64 latin letters, digits, spaces and tabs are allowed"}, "Edit instance name", 2, -1, null, null, null);
        if (response == 0) {
            InstanceNameEditor.saveInstanceName(instanceNameField.getText());
        }
    }

    private String loadInstanceName() {
        return PersistentConfiguration.getConfig().getRoot().getProperty(INSTANCE_NAME, "");
    }

    private static void saveInstanceName(String newInstanceName) {
        PersistentConfiguration.getConfig().getRoot().setProperty(INSTANCE_NAME, newInstanceName);
        PersistentConfiguration.getConfig().save();
    }

    private static class RequestFocusListener
    implements AncestorListener {
        private boolean removeListener;

        public RequestFocusListener() {
            this(true);
        }

        public RequestFocusListener(boolean removeListener) {
            this.removeListener = removeListener;
        }

        @Override
        public void ancestorAdded(AncestorEvent e) {
            JComponent component = e.getComponent();
            component.requestFocusInWindow();
            if (this.removeListener) {
                component.removeAncestorListener(this);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent e) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent e) {
        }
    }

    private static class InstanceNameTextField
    extends JTextField {
        InstanceNameTextField(String initialTextToDisplay) {
            super(new InstanceNameDocument(), initialTextToDisplay, 0);
        }

        private static class InstanceNameDocument
        extends PlainDocument {
            private static final int MAX_LENGTH = 64;

            private InstanceNameDocument() {
            }

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                super.insertString(offs, this.getAllowedStringToInsert(str), a);
            }

            private String getAllowedStringToInsert(String originalString) {
                int allowedLengthToInsert;
                String filteredString = originalString.replaceAll("[^0-9a-zA-Z \t]+", "");
                String result = filteredString.substring(0, Math.min(allowedLengthToInsert = 64 - this.getLength(), filteredString.length()));
                if (!result.equals(originalString)) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return result;
            }
        }
    }
}

