/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ColorDef;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Timer;
import javax.swing.border.Border;

public class StopWatch
extends AbstractRadial
implements ActionListener {
    private static final double ANGLE_STEP = 6.0;
    private final Timer CLOCK_TIMER;
    private double minutePointerAngle = 0.0;
    private double secondPointerAngle = 0.0;
    private final Rectangle INNER_BOUNDS;
    private final Point2D MAIN_CENTER = new Point2D.Double();
    private final Point2D SMALL_CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage smallTickmarkImage;
    private BufferedImage mainPointerImage;
    private BufferedImage mainPointerShadowImage;
    private BufferedImage smallPointerImage;
    private BufferedImage smallPointerShadowImage;
    private BufferedImage disabledImage;
    private long start = 0L;
    private long currentMilliSeconds = 0L;
    private long minutes = 0L;
    private long seconds = 0L;
    private long milliSeconds = 0L;
    private boolean running = false;
    private boolean flatNeedle = false;
    private final Color SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.65f);
    private int horizontalAlignment;
    private int verticalAlignment;

    public StopWatch() {
        this.CLOCK_TIMER = new Timer(100, this);
        this.INNER_BOUNDS = new Rectangle(200, 200);
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.setPointerColor(ColorDef.BLACK);
        this.setBackgroundColor(BackgroundColor.LIGHT_GRAY);
        this.horizontalAlignment = 0;
        this.verticalAlignment = 0;
    }

    @Override
    public AbstractGauge init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getInnerBounds().width) * 0.0841121495, (double)(-this.getInnerBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getInnerBounds().x, this.getInnerBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(WIDTH, WIDTH, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(WIDTH, WIDTH, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(WIDTH, WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    BACKGROUND_FACTORY.createLinearBackground(WIDTH, WIDTH, this.getBackgroundColor(), this.getCustomBackground(), this.getModel().getTextureColor(), this.bImage);
                    break;
                }
                default: {
                    BACKGROUND_FACTORY.createRadialBackground(WIDTH, this.getBackgroundColor(), this.getCustomBackground(), this.getModel().getTextureColor(), this.bImage);
                }
            }
        }
        this.create_TICKMARKS_Image(WIDTH, 60.0f, 0.075, 0.14, this.bImage);
        if (this.smallTickmarkImage != null) {
            this.smallTickmarkImage.flush();
        }
        this.smallTickmarkImage = this.create_TICKMARKS_Image((int)(0.285 * (double)WIDTH), 30.0f, 0.095, 0.17, null);
        if (this.mainPointerImage != null) {
            this.mainPointerImage.flush();
        }
        this.mainPointerImage = this.create_MAIN_POINTER_Image(WIDTH);
        if (this.mainPointerShadowImage != null) {
            this.mainPointerShadowImage.flush();
        }
        this.mainPointerShadowImage = this.create_MAIN_POINTER_SHADOW_Image(WIDTH);
        if (this.smallPointerImage != null) {
            this.smallPointerImage.flush();
        }
        this.smallPointerImage = this.create_SMALL_POINTER_Image(WIDTH);
        if (this.smallPointerShadowImage != null) {
            this.smallPointerShadowImage.flush();
        }
        this.smallPointerShadowImage = this.create_SMALL_POINTER_SHADOW_Image(WIDTH);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(WIDTH, WIDTH, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(WIDTH, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = DISABLED_FACTORY.createRadialDisabled(WIDTH);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        this.MAIN_CENTER.setLocation(this.INNER_BOUNDS.getCenterX(), this.INNER_BOUNDS.getCenterX());
        this.SMALL_CENTER.setLocation(this.INNER_BOUNDS.getCenterX(), (double)this.INNER_BOUNDS.width * 0.3130841121);
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        G2.drawImage((Image)this.bImage, 0, 0, null);
        G2.drawImage((Image)this.smallTickmarkImage, (this.INNER_BOUNDS.width - this.smallTickmarkImage.getWidth()) / 2, (int)(this.SMALL_CENTER.getY() - (double)this.smallTickmarkImage.getHeight() / 2.0), null);
        G2.rotate(Math.toRadians(this.minutePointerAngle + 2.0 * Math.sin(Math.toRadians(this.minutePointerAngle))), this.SMALL_CENTER.getX(), this.SMALL_CENTER.getY());
        G2.drawImage((Image)this.smallPointerShadowImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate(Math.toRadians(this.minutePointerAngle), this.SMALL_CENTER.getX(), this.SMALL_CENTER.getY());
        G2.drawImage((Image)this.smallPointerImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate(Math.toRadians(this.secondPointerAngle + 2.0 * Math.sin(Math.toRadians(this.secondPointerAngle))), this.MAIN_CENTER.getX(), this.MAIN_CENTER.getY());
        G2.drawImage((Image)this.mainPointerShadowImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate(Math.toRadians(this.secondPointerAngle), this.MAIN_CENTER.getX(), this.MAIN_CENTER.getY());
        G2.drawImage((Image)this.mainPointerImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        G2.dispose();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean RUNNING) {
        this.running = RUNNING;
        if (RUNNING) {
            if (!this.CLOCK_TIMER.isRunning()) {
                this.CLOCK_TIMER.start();
                this.start = System.currentTimeMillis();
                this.repaint(this.INNER_BOUNDS);
            }
        } else if (this.CLOCK_TIMER.isRunning()) {
            this.CLOCK_TIMER.stop();
        }
    }

    public void start() {
        this.setRunning(true);
    }

    public void stop() {
        this.setRunning(false);
    }

    public void reset() {
        this.setRunning(false);
        this.start = 0L;
        this.repaint(this.INNER_BOUNDS);
    }

    public String getMeasuredTime() {
        return this.minutes + ":" + this.seconds + ":" + this.milliSeconds;
    }

    public boolean isFlatNeedle() {
        return this.flatNeedle;
    }

    public void setFlatNeedle(boolean FLAT_NEEDLE) {
        this.flatNeedle = FLAT_NEEDLE;
        this.init(this.getWidth(), this.getWidth());
        this.repaint(this.INNER_BOUNDS);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_TICKMARKS_Image(int WIDTH, float RANGE, double TEXT_SCALE, double TEXT_DISTANCE_FACTOR, BufferedImage image) {
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        Font STD_FONT = new Font("Verdana", 0, (int)(TEXT_SCALE * (double)WIDTH));
        BasicStroke THIN_STROKE = new BasicStroke(0.5f, 1, 2);
        BasicStroke MEDIUM_STROKE = new BasicStroke(1.0f, 1, 2);
        BasicStroke THICK_STROKE = new BasicStroke(1.5f, 1, 2);
        int TEXT_DISTANCE = (int)(TEXT_DISTANCE_FACTOR * (double)WIDTH);
        int MIN_LENGTH = (int)(0.025 * (double)WIDTH);
        int MED_LENGTH = (int)(0.035 * (double)WIDTH);
        int MAX_LENGTH = (int)(0.045 * (double)WIDTH);
        Color TEXT_COLOR = this.getBackgroundColor().LABEL_COLOR;
        Color TICK_COLOR = this.getBackgroundColor().LABEL_COLOR;
        float RADIUS = (float)IMAGE_WIDTH * 0.4f;
        Point2D.Double IMAGE_CENTER = new Point2D.Double((float)IMAGE_WIDTH / 2.0f, (float)IMAGE_HEIGHT / 2.0f);
        Point2D.Double textPoint = null;
        int counter = 0;
        int numberCounter = 0;
        int tickCounter = 0;
        G2.setFont(STD_FONT);
        double sinValue = 0.0;
        double cosValue = 0.0;
        double ALPHA_START = -Math.PI;
        double ANGLE_STEPSIZE = Math.PI * 2 / (double)RANGE;
        double alpha = -Math.PI;
        float valueCounter = 0.0f;
        while (Float.compare(valueCounter, RANGE + 1.0f) <= 0) {
            Line2D.Double tick;
            Point2D.Double outerPoint;
            Point2D.Double innerPoint;
            G2.setStroke(THIN_STROKE);
            sinValue = Math.sin(alpha);
            cosValue = Math.cos(alpha);
            if (counter % 2 == 0) {
                G2.setStroke(THIN_STROKE);
                innerPoint = new Point2D.Double(((Point2D)IMAGE_CENTER).getX() + (double)(RADIUS - (float)MIN_LENGTH) * sinValue, ((Point2D)IMAGE_CENTER).getY() + (double)(RADIUS - (float)MIN_LENGTH) * cosValue);
                outerPoint = new Point2D.Double(((Point2D)IMAGE_CENTER).getX() + (double)RADIUS * sinValue, ((Point2D)IMAGE_CENTER).getY() + (double)RADIUS * cosValue);
                G2.setColor(TICK_COLOR);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
            }
            if (counter == 10 || counter == 0) {
                G2.setColor(TEXT_COLOR);
                G2.setStroke(MEDIUM_STROKE);
                outerPoint = new Point2D.Double(((Point2D)IMAGE_CENTER).getX() + (double)RADIUS * sinValue, ((Point2D)IMAGE_CENTER).getY() + (double)RADIUS * cosValue);
                textPoint = new Point2D.Double(((Point2D)IMAGE_CENTER).getX() + (double)(RADIUS - (float)TEXT_DISTANCE + (float)STD_FONT.getSize() / 2.0f) * sinValue, ((Point2D)IMAGE_CENTER).getY() + (double)(RADIUS - (float)TEXT_DISTANCE + (float)STD_FONT.getSize() / 2.0f) * cosValue + (double)((float)TEXT_DISTANCE / 2.5f));
                if (numberCounter == 5) {
                    TextLayout TEXT_LAYOUT = new TextLayout(String.valueOf(Math.round(valueCounter)), G2.getFont(), RENDER_CONTEXT);
                    Rectangle2D TEXT_BOUNDARY = TEXT_LAYOUT.getBounds();
                    if (Float.compare(valueCounter, RANGE) != 0 && Math.ceil(valueCounter) != 60.0) {
                        G2.drawString(String.valueOf(Math.round(valueCounter)), (int)(((Point2D)textPoint).getX() - TEXT_BOUNDARY.getWidth() / 2.0), (int)(((Point2D)textPoint).getY() - TEXT_BOUNDARY.getHeight() / 2.0));
                    }
                    G2.setStroke(THICK_STROKE);
                    innerPoint = new Point2D.Double(((Point2D)IMAGE_CENTER).getX() + (double)(RADIUS - (float)MAX_LENGTH) * sinValue, ((Point2D)IMAGE_CENTER).getY() + (double)(RADIUS - (float)MAX_LENGTH) * cosValue);
                    numberCounter = 0;
                } else {
                    G2.setStroke(MEDIUM_STROKE);
                    innerPoint = new Point2D.Double(((Point2D)IMAGE_CENTER).getX() + (double)(RADIUS - (float)MED_LENGTH) * sinValue, ((Point2D)IMAGE_CENTER).getY() + (double)(RADIUS - (float)MED_LENGTH) * cosValue);
                }
                G2.setColor(TICK_COLOR);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
                counter = 0;
                ++tickCounter;
                ++numberCounter;
            }
            ++counter;
            alpha -= ANGLE_STEPSIZE * 0.1;
            valueCounter += 0.1f;
        }
        G2.dispose();
        return image;
    }

    private BufferedImage create_MAIN_POINTER_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath STOPWATCHPOINTER = new GeneralPath();
        STOPWATCHPOINTER.setWindingRule(0);
        STOPWATCHPOINTER.moveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.45794392523364486);
        STOPWATCHPOINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.102803738317757);
        STOPWATCHPOINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.45794392523364486);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.45794392523364486);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.5);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5420560747663551);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5420560747663551);
        STOPWATCHPOINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.6214953271028038);
        STOPWATCHPOINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.6214953271028038);
        STOPWATCHPOINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5420560747663551);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5420560747663551);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.5);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.45794392523364486);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.45794392523364486);
        STOPWATCHPOINTER.closePath();
        if (this.flatNeedle) {
            G2.setColor(this.getPointerColor().MEDIUM);
            G2.fill(STOPWATCHPOINTER);
        } else {
            Point2D.Double POINTER_START = new Point2D.Double(STOPWATCHPOINTER.getBounds2D().getMinX(), 0.0);
            Point2D.Double POINTER_STOP = new Point2D.Double(STOPWATCHPOINTER.getBounds2D().getMaxX(), 0.0);
            float[] POINTER_FRACTIONS = new float[]{0.0f, 0.3888889f, 0.5f, 0.6111111f, 1.0f};
            Color[] POINTER_COLORS = new Color[]{this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
            LinearGradientPaint GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
            G2.setPaint(GRADIENT);
            G2.fill(STOPWATCHPOINTER);
            G2.setPaint(this.getPointerColor().DARK);
            G2.draw(STOPWATCHPOINTER);
        }
        Ellipse2D.Double SWBRASSRING = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4672897160053253, (double)IMAGE_HEIGHT * 0.4672897160053253, (double)IMAGE_WIDTH * 0.06542053818702698, (double)IMAGE_HEIGHT * 0.06542053818702698);
        Point2D.Double SWBRASSRING_START = new Point2D.Double(0.0, SWBRASSRING.getBounds2D().getMaxY());
        Point2D.Double SWBRASSRING_STOP = new Point2D.Double(0.0, SWBRASSRING.getBounds2D().getMinY());
        float[] SWBRASSRING_FRACTIONS = new float[]{0.0f, 0.01f, 0.99f, 1.0f};
        Color[] SWBRASSRING_COLORS = new Color[]{new Color(230, 179, 92, 255), new Color(230, 179, 92, 255), new Color(196, 130, 0, 255), new Color(196, 130, 0, 255)};
        LinearGradientPaint SWBRASSRING_GRADIENT = new LinearGradientPaint(SWBRASSRING_START, SWBRASSRING_STOP, SWBRASSRING_FRACTIONS, SWBRASSRING_COLORS);
        G2.setPaint(SWBRASSRING_GRADIENT);
        G2.fill(SWBRASSRING);
        Ellipse2D.Double SWRING1 = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.47663551568984985, (double)IMAGE_HEIGHT * 0.47663551568984985, (double)IMAGE_WIDTH * 0.04672896862030029, (double)IMAGE_HEIGHT * 0.04672896862030029);
        Point2D.Double SWRING1_CENTER = new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
        float[] SWRING1_FRACTIONS = new float[]{0.0f, 0.19f, 0.22f, 0.8f, 0.99f, 1.0f};
        Color[] SWRING1_COLORS = new Color[]{new Color(197, 197, 197, 255), new Color(197, 197, 197, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(112, 112, 112, 255), new Color(112, 112, 112, 255)};
        RadialGradientPaint SWRING1_GRADIENT = new RadialGradientPaint(SWRING1_CENTER, (float)(0.02336448598130841 * (double)IMAGE_WIDTH), SWRING1_FRACTIONS, SWRING1_COLORS);
        G2.setPaint(SWRING1_GRADIENT);
        G2.fill(SWRING1);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_MAIN_POINTER_SHADOW_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath STOPWATCHPOINTER = new GeneralPath();
        STOPWATCHPOINTER.setWindingRule(0);
        STOPWATCHPOINTER.moveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.45794392523364486);
        STOPWATCHPOINTER.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.102803738317757);
        STOPWATCHPOINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.45794392523364486);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.45794392523364486);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.5);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.45794392523364486, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5420560747663551);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5420560747663551);
        STOPWATCHPOINTER.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.6214953271028038);
        STOPWATCHPOINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.6214953271028038);
        STOPWATCHPOINTER.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5420560747663551);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5420560747663551);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.5);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.5420560747663551, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.45794392523364486);
        STOPWATCHPOINTER.curveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.45794392523364486);
        STOPWATCHPOINTER.closePath();
        G2.setPaint(this.SHADOW_COLOR);
        G2.fill(STOPWATCHPOINTER);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_SMALL_POINTER_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath STOPWATCHPOINTERSMALL = new GeneralPath();
        STOPWATCHPOINTERSMALL.setWindingRule(0);
        STOPWATCHPOINTERSMALL.moveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.3130841121495327);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.3364485981308411);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.35046728971962615);
        STOPWATCHPOINTERSMALL.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.35046728971962615);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.3364485981308411);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.3130841121495327);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.3037383177570093, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.29439252336448596, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2897196261682243);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.20093457943925233, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.20093457943925233);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.20093457943925233, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2897196261682243);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.29439252336448596, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.3037383177570093, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.3130841121495327);
        STOPWATCHPOINTERSMALL.closePath();
        if (this.flatNeedle) {
            G2.setColor(this.getPointerColor().MEDIUM);
            G2.fill(STOPWATCHPOINTERSMALL);
        } else {
            Point2D.Double POINTER_START = new Point2D.Double(STOPWATCHPOINTERSMALL.getBounds2D().getMinX(), 0.0);
            Point2D.Double POINTER_STOP = new Point2D.Double(STOPWATCHPOINTERSMALL.getBounds2D().getMaxX(), 0.0);
            float[] POINTER_FRACTIONS = new float[]{0.0f, 0.3888889f, 0.5f, 0.6111111f, 1.0f};
            Color[] POINTER_COLORS = new Color[]{this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
            LinearGradientPaint GRADIENT = new LinearGradientPaint(POINTER_START, POINTER_STOP, POINTER_FRACTIONS, POINTER_COLORS);
            G2.setPaint(GRADIENT);
            G2.fill(STOPWATCHPOINTERSMALL);
            G2.setPaint(this.getPointerColor().DARK);
            G2.draw(STOPWATCHPOINTERSMALL);
        }
        Ellipse2D.Double SWBRASSRINGSMALL = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4813084006309509, (double)IMAGE_HEIGHT * 0.29439252614974976, (double)IMAGE_WIDTH * (double)0.0373832f, (double)IMAGE_HEIGHT * 0.03738316893577576);
        G2.setColor(new Color(12878336));
        G2.fill(SWBRASSRINGSMALL);
        Ellipse2D.Double SWRING1SMALL = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.4859813153743744, (double)IMAGE_HEIGHT * (double)0.2990654f, (double)IMAGE_WIDTH * 0.02803739905357361, (double)IMAGE_HEIGHT * 0.02803739905357361);
        G2.setColor(new Color(0x999999));
        G2.fill(SWRING1SMALL);
        Ellipse2D.Double SWRING1SMALL0 = new Ellipse2D.Double((double)IMAGE_WIDTH * (double)0.4906542f, (double)IMAGE_HEIGHT * 0.3037383258342743, (double)IMAGE_WIDTH * (double)0.01869157f, (double)IMAGE_HEIGHT * (double)0.01869157f);
        G2.setColor(Color.BLACK);
        G2.fill(SWRING1SMALL0);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_SMALL_POINTER_SHADOW_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath STOPWATCHPOINTERSMALL = new GeneralPath();
        STOPWATCHPOINTERSMALL.setWindingRule(0);
        STOPWATCHPOINTERSMALL.moveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.3130841121495327);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.3364485981308411);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.35046728971962615);
        STOPWATCHPOINTERSMALL.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.35046728971962615);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.35046728971962615, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.3364485981308411, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.3364485981308411);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.3317757009345794, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.32242990654205606, (double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.3130841121495327);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.3037383177570093, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.29439252336448596, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2897196261682243);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.20093457943925233, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.20093457943925233);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.20093457943925233, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2897196261682243, (double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.2897196261682243);
        STOPWATCHPOINTERSMALL.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.29439252336448596, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.3037383177570093, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.3130841121495327);
        STOPWATCHPOINTERSMALL.closePath();
        G2.setPaint(this.SHADOW_COLOR);
        G2.fill(STOPWATCHPOINTERSMALL);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (dim.width < 50 || dim.height < 50) {
            dim = new Dimension(50, 50);
        }
        return dim;
    }

    @Override
    public void setMinimumSize(Dimension DIM) {
        int width = DIM.width < 50 ? 50 : DIM.width;
        int height = DIM.height < 50 ? 50 : DIM.height;
        int SIZE = width <= height ? width : height;
        super.setMinimumSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        if (dim.width > 1080 || dim.height > 1080) {
            dim = new Dimension(1080, 1080);
        }
        return dim;
    }

    @Override
    public void setMaximumSize(Dimension DIM) {
        int width = DIM.width > 1080 ? 1080 : DIM.width;
        int height = DIM.height > 1080 ? 1080 : DIM.height;
        int SIZE = width <= height ? width : height;
        super.setMaximumSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        int SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        super.setPreferredSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        int SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        super.setSize(SIZE, SIZE);
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setSize(Dimension DIM) {
        int SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        super.setSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        if (BOUNDS.width <= BOUNDS.height) {
            int yNew;
            switch (this.verticalAlignment) {
                case 1: {
                    yNew = BOUNDS.y;
                    break;
                }
                case 3: {
                    yNew = BOUNDS.y + (BOUNDS.height - BOUNDS.width);
                    break;
                }
                default: {
                    yNew = BOUNDS.y + (BOUNDS.height - BOUNDS.width) / 2;
                }
            }
            super.setBounds(BOUNDS.x, yNew, BOUNDS.width, BOUNDS.width);
        } else {
            int xNew;
            switch (this.horizontalAlignment) {
                case 2: {
                    xNew = BOUNDS.x;
                    break;
                }
                case 4: {
                    xNew = BOUNDS.x + (BOUNDS.width - BOUNDS.height);
                    break;
                }
                default: {
                    xNew = BOUNDS.x + (BOUNDS.width - BOUNDS.height) / 2;
                }
            }
            super.setBounds(xNew, BOUNDS.y, BOUNDS.height, BOUNDS.height);
        }
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        if (WIDTH <= HEIGHT) {
            int yNew;
            switch (this.verticalAlignment) {
                case 1: {
                    yNew = Y;
                    break;
                }
                case 3: {
                    yNew = Y + (HEIGHT - WIDTH);
                    break;
                }
                default: {
                    yNew = Y + (HEIGHT - WIDTH) / 2;
                }
            }
            super.setBounds(X, yNew, WIDTH, WIDTH);
        } else {
            int xNew;
            switch (this.horizontalAlignment) {
                case 2: {
                    xNew = X;
                    break;
                }
                case 4: {
                    xNew = X + (WIDTH - HEIGHT);
                    break;
                }
                default: {
                    xNew = X + (WIDTH - HEIGHT) / 2;
                }
            }
            super.setBounds(xNew, Y, HEIGHT, HEIGHT);
        }
        this.calcInnerBounds();
        this.init(this.getGaugeBounds().width, this.getGaugeBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBorder(Border BORDER) {
        super.setBorder(BORDER);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setHorizontalAlignment(int HORIZONTAL_ALIGNMENT) {
        this.horizontalAlignment = HORIZONTAL_ALIGNMENT;
    }

    @Override
    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public void setVerticalAlignment(int VERTICAL_ALIGNMENT) {
        this.verticalAlignment = VERTICAL_ALIGNMENT;
    }

    @Override
    public void dispose() {
        this.CLOCK_TIMER.removeActionListener(this);
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent EVENT) {
        if (EVENT.getSource().equals(this.CLOCK_TIMER)) {
            this.currentMilliSeconds = System.currentTimeMillis() - this.start;
            this.secondPointerAngle = (double)this.currentMilliSeconds * 6.0 / 1000.0;
            this.minutePointerAngle = this.secondPointerAngle % 1000.0 / 30.0;
            this.minutes = this.currentMilliSeconds % 60000L;
            this.seconds = this.currentMilliSeconds % 60L;
            this.milliSeconds = this.currentMilliSeconds % 1000L;
            this.repaint(this.INNER_BOUNDS);
        }
    }

    @Override
    public void componentResized(ComponentEvent event) {
        int SIZE = this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight();
        this.setPreferredSize(new Dimension(SIZE, SIZE));
        if (SIZE < this.getMinimumSize().width || SIZE < this.getMinimumSize().height) {
            this.setPreferredSize(this.getMinimumSize());
        }
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public String toString() {
        return "StopWatch";
    }
}

