/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.devexperts.logging.Logging;
import com.opensr5.ini.DialogModel;
import com.opensr5.ini.IniFileMetaInfo;
import com.opensr5.ini.IniFileMetaInfoImpl;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.IniFileReader;
import com.opensr5.ini.RawIniFile;
import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.EnumIniField;
import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.ScalarIniField;
import com.opensr5.ini.field.StringIniField;
import com.rusefi.core.FindFileHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IniFileModelImpl
implements IniFileModel {
    private static final Logging log = Logging.getLogging(IniFileModelImpl.class);
    public static final String RUSEFI_INI_PREFIX = "rusefi";
    public static final String RUSEFI_INI_SUFFIX = ".ini";
    public static final String INI_FILE_PATH = System.getProperty("ini_file_path", "..");
    private static final String SECTION_PAGE = "page";
    private static final String FIELD_TYPE_SCALAR = "scalar";
    public static final String FIELD_TYPE_STRING = "string";
    private static final String FIELD_TYPE_ARRAY = "array";
    private static final String FIELD_TYPE_BITS = "bits";
    private final Map<String, List<String>> defines = new TreeMap<String, List<String>>();
    private static IniFileModelImpl INSTANCE;
    private String dialogId;
    private String dialogUiName;
    private final Map<String, DialogModel> dialogs = new TreeMap<String, DialogModel>();
    private final List<DialogModel.Field> fieldsOfCurrentDialog = new ArrayList<DialogModel.Field>();
    public Map<String, IniField> allIniFields = new LinkedHashMap<String, IniField>();
    public final Map<String, DialogModel.Field> fieldsInUiOrder = new LinkedHashMap<String, DialogModel.Field>();
    public Map<String, String> tooltips = new TreeMap<String, String>();
    public Map<String, String> protocolMeta = new TreeMap<String, String>();
    private boolean isConstantsSection;
    private String currentYBins;
    private String currentXBins;
    private final Map<String, String> xBinsByZBins = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> yBinsByZBins = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final IniFileMetaInfo metaInfo;
    private final String iniFilePath;
    private boolean isInSettingContextHelp = false;
    private boolean isInsidePageDefinition;

    public static IniFileModelImpl findAndReadIniFile(String iniFilePath) {
        String fileName = IniFileModelImpl.findMetaInfoFile(iniFilePath);
        return IniFileModelImpl.readIniFile(fileName);
    }

    private IniFileModelImpl(@Nullable IniFileMetaInfoImpl metaInfo, String iniFilePath) {
        this.metaInfo = metaInfo;
        this.iniFilePath = iniFilePath;
    }

    @Override
    public Map<String, List<String>> getDefines() {
        return this.defines;
    }

    @Override
    public Map<String, IniField> getAllIniFields() {
        return this.allIniFields;
    }

    @Override
    public IniField getIniField(String key) {
        IniField result = this.allIniFields.get(key);
        return Objects.requireNonNull(result, () -> key + " field not found");
    }

    @Override
    public Map<String, String> getProtocolMeta() {
        return this.protocolMeta;
    }

    @Override
    public IniFileMetaInfo getMetaInfo() {
        return Objects.requireNonNull(this.metaInfo, "metaInfo");
    }

    @Override
    public String getIniFilePath() {
        return Objects.requireNonNull(this.iniFilePath, "iniFilePath");
    }

    @Override
    public Map<String, String> getTooltips() {
        return this.tooltips;
    }

    @Override
    public Map<String, DialogModel.Field> getFieldsInUiOrder() {
        return this.fieldsInUiOrder;
    }

    public static IniFileModelImpl readIniFile(String fileName) {
        Objects.requireNonNull(fileName, "fileName");
        log.info("Reading " + fileName);
        File input = new File(fileName);
        RawIniFile content = IniFileReader.read(input);
        return IniFileModelImpl.readIniFile(content, true, fileName);
    }

    @NotNull
    public static IniFileModelImpl readIniFile(RawIniFile content, boolean initMeta, String iniFilePath) {
        IniFileModelImpl result = new IniFileModelImpl(initMeta ? new IniFileMetaInfoImpl(content) : null, iniFilePath);
        for (RawIniFile.Line line : content.getLines()) {
            result.handleLine(line);
        }
        result.finishDialog();
        return result;
    }

    private static String findMetaInfoFile(String iniFilePath) {
        String iniFileName = IniFileModelImpl.findIniFile(iniFilePath);
        if (iniFileName == null) {
            throw new IllegalStateException("Not found rusefi*.ini in " + iniFilePath);
        }
        return iniFileName;
    }

    @Nullable
    public static String findIniFile(String iniFilePath) {
        return FindFileHelper.findFile(iniFilePath, RUSEFI_INI_PREFIX, RUSEFI_INI_SUFFIX);
    }

    private void finishDialog() {
        if (this.fieldsOfCurrentDialog.isEmpty()) {
            return;
        }
        if (this.dialogUiName == null) {
            this.dialogUiName = this.dialogId;
        }
        this.dialogs.put(this.dialogUiName, new DialogModel(this.dialogId, this.dialogUiName, this.fieldsOfCurrentDialog));
        this.dialogId = null;
        this.fieldsOfCurrentDialog.clear();
    }

    private void handleLine(RawIniFile.Line line) {
        String rawText = line.getRawText();
        try {
            LinkedList<String> list = new LinkedList<String>(Arrays.asList(line.getTokens()));
            if (!list.isEmpty() && list.get(0).equals("#define")) {
                this.defines.put(list.get(1), list.subList(2, list.size()));
                return;
            }
            if (!list.isEmpty() && list.get(0).equals(SECTION_PAGE)) {
                this.isInsidePageDefinition = true;
                return;
            }
            if (this.isInSettingContextHelp) {
                if (rawText.contains("SettingContextHelpEnd")) {
                    this.isInSettingContextHelp = false;
                }
                if (list.size() == 2) {
                    this.tooltips.put(list.get(0), list.get(1));
                }
                return;
            }
            if (rawText.contains("SettingContextHelp")) {
                this.isInsidePageDefinition = false;
                this.isInSettingContextHelp = true;
                return;
            }
            if (RawIniFile.Line.isCommentLine(rawText)) {
                return;
            }
            if (RawIniFile.Line.isPreprocessorDirective(rawText)) {
                return;
            }
            this.trim(list);
            if (list.isEmpty()) {
                return;
            }
            String first = list.getFirst();
            if (first.startsWith("[") && first.endsWith("]")) {
                log.info("Section " + first);
                this.isConstantsSection = first.equals("[Constants]");
            }
            if (this.isConstantsSection) {
                if (this.isInsidePageDefinition) {
                    if (list.size() > 1) {
                        this.handleFieldDefinition(list, line);
                    }
                    return;
                }
                if (list.size() > 1) {
                    this.protocolMeta.put(list.get(0), list.get(1));
                }
            }
            switch (first) {
                case "field": {
                    this.handleField(list);
                    break;
                }
                case "slider": {
                    this.handleSlider(list);
                    break;
                }
                case "dialog": {
                    this.handleDialog(list);
                    break;
                }
                case "table": {
                    this.handleTable(list);
                    break;
                }
                case "xBins": {
                    this.handleXBins(list);
                    break;
                }
                case "yBins": {
                    this.handleYBins(list);
                    break;
                }
                case "zBins": {
                    this.handleZBins(list);
                }
            }
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Failed to handle [" + rawText + "]: " + e, e);
        }
    }

    private void handleZBins(LinkedList<String> list) {
        list.removeFirst();
        String zBins = list.removeFirst();
        this.addField(zBins);
        if (this.currentXBins == null || this.currentYBins == null) {
            throw new IllegalStateException("X or Y missing for " + zBins);
        }
        this.xBinsByZBins.put(zBins, this.currentXBins);
        this.yBinsByZBins.put(zBins, this.currentYBins);
    }

    @Override
    public String getXBin(String tableName) {
        return this.xBinsByZBins.get(tableName);
    }

    @Override
    public Set<String> getTables() {
        return this.xBinsByZBins.keySet();
    }

    @Override
    public String getYBin(String tableName) {
        return this.yBinsByZBins.get(tableName);
    }

    private void handleYBins(LinkedList<String> list) {
        list.removeFirst();
        this.currentYBins = list.removeFirst();
        this.addField(this.currentYBins);
    }

    private void handleXBins(LinkedList<String> list) {
        list.removeFirst();
        this.currentXBins = list.removeFirst();
        this.addField(this.currentXBins);
    }

    private void addField(String key) {
        DialogModel.Field field = new DialogModel.Field(key, key);
        this.fieldsInUiOrder.put(key, field);
    }

    private void handleTable(LinkedList<String> list) {
        list.removeFirst();
        String tableName = list.removeFirst();
    }

    private void handleFieldDefinition(LinkedList<String> list, RawIniFile.Line line) {
        switch (list.get(1)) {
            case "scalar": {
                this.registerField(ScalarIniField.parse(list));
                break;
            }
            case "string": {
                this.registerField(StringIniField.parse(list));
                break;
            }
            case "array": {
                this.registerField(ArrayIniField.parse(list));
                break;
            }
            case "bits": {
                this.registerField(EnumIniField.parse(list, line, this));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected " + list);
            }
        }
    }

    private void registerField(IniField field) {
        if (this.allIniFields.containsKey(field.getName())) {
            return;
        }
        this.allIniFields.put(field.getName(), field);
    }

    private void handleSlider(LinkedList<String> list) {
        list.removeFirst();
        String uiFieldName = list.isEmpty() ? "" : list.removeFirst();
        String key = list.isEmpty() ? null : list.removeFirst();
        this.registerUiField(key, uiFieldName);
        log.debug("IniFileModel: Slider label=[" + uiFieldName + "] : key=[" + key + "]");
    }

    private void handleField(LinkedList<String> list) {
        list.removeFirst();
        String uiFieldName = list.isEmpty() ? "" : list.removeFirst();
        String key = list.isEmpty() ? null : list.removeFirst();
        this.registerUiField(key, uiFieldName);
        log.debug("IniFileModel: Field label=[" + uiFieldName + "] : key=[" + key + "]");
    }

    private void registerUiField(String key, String uiFieldName) {
        DialogModel.Field field = new DialogModel.Field(key, uiFieldName);
        if (key != null) {
            this.fieldsOfCurrentDialog.add(field);
            this.fieldsInUiOrder.put(key, field);
        }
    }

    private void handleDialog(LinkedList<String> list) {
        this.finishDialog();
        list.removeFirst();
        String keyword = list.removeFirst();
        String name = list.isEmpty() ? null : list.removeFirst();
        this.dialogId = keyword;
        this.dialogUiName = name;
        log.debug("IniFileModel: Dialog key=" + keyword + ": name=[" + name + "]");
    }

    private void trim(LinkedList<String> list) {
        while (!list.isEmpty() && list.getFirst().isEmpty()) {
            list.removeFirst();
        }
    }

    public IniField findByOffset(int i) {
        for (IniField field : this.allIniFields.values()) {
            if (i < field.getOffset() || i >= field.getOffset() + field.getSize()) continue;
            return field;
        }
        return null;
    }

    public static synchronized IniFileModelImpl getInstance() {
        if (INSTANCE == null) {
            INSTANCE = IniFileModelImpl.findAndReadIniFile(INI_FILE_PATH);
        }
        return INSTANCE;
    }

    @Override
    public Map<String, DialogModel> getDialogs() {
        return this.dialogs;
    }
}

