/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.util.Objects;

public class IsotpFlowControlOptions {
    public static final IsotpFlowControlOptions DEFAULT = new IsotpFlowControlOptions(0, 0, 0);
    private final byte blockSize;
    private final byte minimumSeparationTime;
    private final byte maximumWaitFrameTransmission;

    public IsotpFlowControlOptions(byte blockSize, byte minimumSeparationTime, byte maximumWaitFrameTransmission) {
        this.blockSize = blockSize;
        this.minimumSeparationTime = minimumSeparationTime;
        this.maximumWaitFrameTransmission = maximumWaitFrameTransmission;
    }

    public byte getBlockSize() {
        return this.blockSize;
    }

    public IsotpFlowControlOptions withBlockSize(byte blockSize) {
        return new IsotpFlowControlOptions(blockSize, this.minimumSeparationTime, this.maximumWaitFrameTransmission);
    }

    public IsotpFlowControlOptions withBlockSize(int blockSize) {
        return this.withBlockSize((byte)blockSize);
    }

    public byte getMinimumSeparationTime() {
        return this.minimumSeparationTime;
    }

    public IsotpFlowControlOptions withMinimumSeparationTime(byte minimumSeparationTime) {
        return new IsotpFlowControlOptions(this.blockSize, minimumSeparationTime, this.maximumWaitFrameTransmission);
    }

    public IsotpFlowControlOptions withMinimumSeparationTime(int minimumSeparationTime) {
        return this.withMinimumSeparationTime((byte)minimumSeparationTime);
    }

    public byte getMaximumWaitFrameTransmission() {
        return this.maximumWaitFrameTransmission;
    }

    public IsotpFlowControlOptions withMaximumWaitFrameTransmission(byte maximumWaitFrameTransmission) {
        return new IsotpFlowControlOptions(this.blockSize, this.minimumSeparationTime, maximumWaitFrameTransmission);
    }

    public IsotpFlowControlOptions withMaximumWaitFrameTransmission(int maximumWaitFrameTransmission) {
        return this.withMaximumWaitFrameTransmission((byte)maximumWaitFrameTransmission);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsotpFlowControlOptions that = (IsotpFlowControlOptions)o;
        return this.blockSize == that.blockSize && this.minimumSeparationTime == that.minimumSeparationTime && this.maximumWaitFrameTransmission == that.maximumWaitFrameTransmission;
    }

    public int hashCode() {
        return Objects.hash(this.blockSize, this.minimumSeparationTime, this.maximumWaitFrameTransmission);
    }

    public String toString() {
        return "IsotpFlowControlOptions(blockSize=" + this.blockSize + ", minimumSeparationTime=" + this.minimumSeparationTime + ", maximumWaitFrameTransmission=" + this.maximumWaitFrameTransmission + ')';
    }
}

