/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.widgets;

import com.devexperts.logging.Logging;
import com.rusefi.FileLog;
import com.rusefi.core.io.BundleUtil;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.ui.StatusWindow;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class StatusPanel
extends JPanel
implements UpdateOperationCallbacks {
    private static final Logging log = Logging.getLogging(StatusWindow.class);
    private static final Color LIGHT_RED = new Color(255, 102, 102);
    private static final Color LIGHT_GREEN = new Color(102, 255, 102);
    private final JTextArea logTextArea = new JTextArea();
    private final JLabel bottomStatusLabel = new JLabel();

    public StatusPanel() {
        super(new BorderLayout());
        this.logTextArea.setLineWrap(true);
        JScrollPane messagesScroll = new JScrollPane(this.logTextArea, 22, 30){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(400, 400);
            }
        };
        super.add((Component)messagesScroll, "Center");
        super.add((Component)this.bottomStatusLabel, "South");
        this.clear();
    }

    public void setErrorState() {
        this.logTextArea.setBackground(LIGHT_RED);
        this.copyContentToClipboard();
    }

    @Override
    public void done() {
        this.setSuccessState();
    }

    @Override
    public void error() {
        this.setErrorState();
    }

    public void setSuccessState() {
        this.logTextArea.setBackground(LIGHT_GREEN);
    }

    public void copyContentToClipboard() {
        SwingUtilities.invokeLater(() -> Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.logTextArea.getText()), null));
        this.logLine("hint: error state is already in your clipboard, please use PASTE or Ctrl-V while reporting issues");
    }

    @Override
    public void clear() {
        this.logTextArea.setText("");
        this.logTextArea.setBackground(Color.WHITE);
        this.logLine("Console version 20250126");
        this.logLine(FileLog.getOsName() + " " + System.getProperty("os.version"));
        this.logLine("Bundle " + BundleUtil.readBundleFullNameNotNull());
    }

    @Override
    public void log(String string, boolean breakLineOnTextArea, boolean sendToLogger) {
        SwingUtilities.invokeLater(() -> {
            String s = string.replaceAll(Character.toString('\u00db'), "");
            if (sendToLogger) {
                log.info(s);
            }
            String stringForTestArea = s;
            if (breakLineOnTextArea) {
                stringForTestArea = stringForTestArea + "\r\n";
            }
            this.logTextArea.append(stringForTestArea);
            UiUtils.trueLayout(this.logTextArea);
        });
    }

    public void setStatus(String status) {
        this.bottomStatusLabel.setText(status);
    }
}

