/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class GradientWrapper
implements Paint {
    private final LinearGradientPaint GRADIENT;
    private float[] fractions;
    private Color[] colors;

    public GradientWrapper(float startX, float startY, float endX, float endY, float[] fractions, Color[] colors) {
        this.GRADIENT = new LinearGradientPaint(new Point2D.Float(startX, startY), new Point2D.Float(endX, endY), fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        this.copyArrays(fractions, colors);
    }

    public GradientWrapper(float startX, float startY, float endX, float endY, float[] fractions, Color[] colors, MultipleGradientPaint.CycleMethod cycleMethod) {
        this.GRADIENT = new LinearGradientPaint(new Point2D.Float(startX, startY), new Point2D.Float(endX, endY), fractions, colors, cycleMethod);
        this.copyArrays(fractions, colors);
    }

    public GradientWrapper(Point2D start, Point2D end, float[] fractions, Color[] colors) {
        this.GRADIENT = new LinearGradientPaint(start, end, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        this.copyArrays(fractions, colors);
    }

    public GradientWrapper(Point2D start, Point2D end, float[] fractions, Color[] colors, MultipleGradientPaint.CycleMethod cycleMethod) {
        this.GRADIENT = new LinearGradientPaint(start, end, fractions, colors, cycleMethod, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform());
        this.copyArrays(fractions, colors);
    }

    public GradientWrapper(Point2D start, Point2D end, float[] fractions, Color[] colors, MultipleGradientPaint.CycleMethod cycleMethod, MultipleGradientPaint.ColorSpaceType colorSpace, AffineTransform gradientTransform) {
        this.GRADIENT = new LinearGradientPaint(start, end, fractions, colors, cycleMethod, colorSpace, gradientTransform);
        this.copyArrays(fractions, colors);
    }

    public Point2D getStartPoint() {
        return this.GRADIENT.getStartPoint();
    }

    public Point2D getEndPoint() {
        return this.GRADIENT.getEndPoint();
    }

    public Color getColorAt(float FRACTION) {
        float fraction = FRACTION < 0.0f ? 0.0f : (FRACTION > 1.0f ? 1.0f : FRACTION);
        float lowerLimit = 0.0f;
        int lowerIndex = 0;
        float upperLimit = 1.0f;
        int upperIndex = 1;
        int index = 0;
        for (float currentFraction : this.fractions) {
            if (Float.compare(currentFraction, fraction) < 0) {
                lowerLimit = currentFraction;
                lowerIndex = index;
            }
            if (Float.compare(currentFraction, fraction) == 0) {
                return this.colors[index];
            }
            if (Float.compare(currentFraction, fraction) > 0) {
                upperLimit = currentFraction;
                upperIndex = index;
                break;
            }
            ++index;
        }
        float interpolationFraction = (fraction - lowerLimit) / (upperLimit - lowerLimit);
        return this.interpolateColor(this.colors[lowerIndex], this.colors[upperIndex], interpolationFraction);
    }

    public LinearGradientPaint getGradient() {
        return this.GRADIENT;
    }

    @Override
    public PaintContext createContext(ColorModel COLOR_MODEL, Rectangle DEVICE_BOUNDS, Rectangle2D USER_BOUNDS, AffineTransform X_FORM, RenderingHints HINTS) {
        return this.GRADIENT.createContext(COLOR_MODEL, DEVICE_BOUNDS, USER_BOUNDS, X_FORM, HINTS);
    }

    @Override
    public int getTransparency() {
        return this.GRADIENT.getTransparency();
    }

    private void copyArrays(float[] FRACTIONS, Color[] colors) {
        this.fractions = new float[FRACTIONS.length];
        System.arraycopy(FRACTIONS, 0, this.fractions, 0, FRACTIONS.length);
        this.colors = (Color[])colors.clone();
    }

    private Color interpolateColor(Color COLOR1, Color COLOR2, float FRACTION) {
        assert (Float.compare(FRACTION, 0.0f) >= 0 && Float.compare(FRACTION, 1.0f) <= 0);
        float INT_TO_FLOAT_CONST = 0.003921569f;
        float RED1 = (float)COLOR1.getRed() * 0.003921569f;
        float GREEN1 = (float)COLOR1.getGreen() * 0.003921569f;
        float BLUE1 = (float)COLOR1.getBlue() * 0.003921569f;
        float ALPHA1 = (float)COLOR1.getAlpha() * 0.003921569f;
        float RED2 = (float)COLOR2.getRed() * 0.003921569f;
        float GREEN2 = (float)COLOR2.getGreen() * 0.003921569f;
        float BLUE2 = (float)COLOR2.getBlue() * 0.003921569f;
        float ALPHA2 = (float)COLOR2.getAlpha() * 0.003921569f;
        float DELTA_RED = RED2 - RED1;
        float DELTA_GREEN = GREEN2 - GREEN1;
        float DELTA_BLUE = BLUE2 - BLUE1;
        float DELTA_ALPHA = ALPHA2 - ALPHA1;
        float red = RED1 + DELTA_RED * FRACTION;
        float green = GREEN1 + DELTA_GREEN * FRACTION;
        float blue = BLUE1 + DELTA_BLUE * FRACTION;
        float alpha = ALPHA1 + DELTA_ALPHA * FRACTION;
        float f = red < 0.0f ? 0.0f : (red = red > 1.0f ? 1.0f : red);
        float f2 = green < 0.0f ? 0.0f : (green = green > 1.0f ? 1.0f : green);
        float f3 = blue < 0.0f ? 0.0f : (blue = blue > 1.0f ? 1.0f : blue);
        alpha = alpha < 0.0f ? 0.0f : (alpha > 1.0f ? 1.0f : alpha);
        return new Color(red, green, blue, alpha);
    }
}

