/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.PostPosition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;

public final class Compass
extends AbstractRadial {
    private static final double MIN_VALUE = 0.0;
    private static final double MAX_VALUE = 360.0;
    private double value = 0.0;
    private double angleStep = Math.PI / 180;
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage compassRoseImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage pointerImage;
    private BufferedImage disabledImage;
    private Timeline timeline = new Timeline(this);
    private final Spline EASE = new Spline(0.5f);

    public Compass() {
        this.setPointerColor(ColorDef.RED);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public AbstractGauge init(int WIDTH, int HEIGHT) {
        int GAUGE_HEIGHT;
        int GAUGE_WIDTH = this.isFrameVisible() ? WIDTH : this.getGaugeBounds().width;
        int n = GAUGE_HEIGHT = this.isFrameVisible() ? HEIGHT : this.getGaugeBounds().height;
        if (GAUGE_WIDTH <= 1 || GAUGE_HEIGHT <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(GAUGE_WIDTH, GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(GAUGE_WIDTH, "", "", this.bImage);
        }
        if (this.compassRoseImage != null) {
            this.compassRoseImage.flush();
        }
        this.compassRoseImage = this.create_COMPASS_ROSE_Image(GAUGE_WIDTH);
        if (this.pointerShadowImage != null) {
            this.pointerShadowImage.flush();
        }
        this.pointerShadowImage = this.create_POINTER_SHADOW_Image(GAUGE_WIDTH);
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(GAUGE_WIDTH);
        this.createPostsImage(GAUGE_WIDTH, this.fImage, PostPosition.CENTER);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(GAUGE_WIDTH, GAUGE_WIDTH, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(GAUGE_WIDTH, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(GAUGE_WIDTH);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterX());
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        G2.drawImage((Image)this.bImage, 0, 0, null);
        G2.drawImage((Image)this.compassRoseImage, 0, 0, null);
        G2.rotate((this.value - 0.0) * this.angleStep, this.CENTER.getX(), this.CENTER.getY() + 2.0);
        G2.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate((this.value - 0.0) * this.angleStep, this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.pointerImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        G2.dispose();
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double VALUE) {
        if (this.isEnabled()) {
            double oldValue = this.value;
            this.value = VALUE % 360.0;
            this.fireStateChanged();
            this.firePropertyChange("value", oldValue, this.value);
            this.repaint();
        }
    }

    @Override
    public void setValueAnimated(double newValue) {
        if (this.isEnabled()) {
            if (360.0 - newValue + this.value < newValue - this.value) {
                newValue = 360.0 - newValue;
            }
            if (this.timeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
                this.timeline.abort();
            }
            this.timeline = new Timeline(this);
            this.timeline.addPropertyToInterpolate("value", this.value, newValue);
            this.timeline.setEase(this.EASE);
            this.timeline.setDuration(250L);
            this.timeline.play();
        }
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public double getMaxValue() {
        return 360.0;
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_BIG_ROSE_POINTER_Image(int WIDTH) {
        BufferedImage IMAGE = UTIL.createImage((int)((float)WIDTH * 0.0546875f), (int)((float)WIDTH * 0.2f), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        G2.setStroke(new BasicStroke(0.75f));
        GeneralPath POINTER_WHITE_LEFT = new GeneralPath();
        GeneralPath POINTER_WHITE_RIGHT = new GeneralPath();
        POINTER_WHITE_LEFT.moveTo((float)IMAGE_WIDTH - (float)IMAGE_WIDTH * 0.95f, IMAGE_HEIGHT);
        POINTER_WHITE_LEFT.lineTo((float)IMAGE_WIDTH / 2.0f, 0.0f);
        POINTER_WHITE_LEFT.lineTo((float)IMAGE_WIDTH / 2.0f, IMAGE_HEIGHT);
        POINTER_WHITE_LEFT.closePath();
        POINTER_WHITE_RIGHT.moveTo((float)IMAGE_WIDTH * 0.95f, IMAGE_HEIGHT);
        POINTER_WHITE_RIGHT.lineTo((float)IMAGE_WIDTH / 2.0f, 0.0f);
        POINTER_WHITE_RIGHT.lineTo((float)IMAGE_WIDTH / 2.0f, IMAGE_HEIGHT);
        POINTER_WHITE_RIGHT.closePath();
        Area POINTER_FRAME_WHITE = new Area(POINTER_WHITE_LEFT);
        POINTER_FRAME_WHITE.add(new Area(POINTER_WHITE_RIGHT));
        Color STROKE_COLOR = this.getBackgroundColor().SYMBOL_COLOR.darker();
        Color FILL_COLOR = this.getBackgroundColor().SYMBOL_COLOR;
        G2.setColor(STROKE_COLOR);
        G2.fill(POINTER_WHITE_RIGHT);
        G2.setColor(FILL_COLOR);
        G2.fill(POINTER_WHITE_LEFT);
        G2.setColor(STROKE_COLOR);
        G2.draw(POINTER_FRAME_WHITE);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_SMALL_ROSE_POINTER_Image(int WIDTH) {
        BufferedImage IMAGE = UTIL.createImage((int)((float)WIDTH * 0.0546875f), (int)((float)WIDTH * 0.2f), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        G2.setStroke(new BasicStroke(0.75f));
        GeneralPath POINTER_WHITE_LEFT = new GeneralPath();
        GeneralPath POINTER_WHITE_RIGHT = new GeneralPath();
        POINTER_WHITE_LEFT.moveTo((float)IMAGE_WIDTH - (float)IMAGE_WIDTH * 0.75f, IMAGE_HEIGHT);
        POINTER_WHITE_LEFT.lineTo((float)IMAGE_WIDTH / 2.0f, (float)IMAGE_HEIGHT / 2.0f);
        POINTER_WHITE_LEFT.lineTo((float)IMAGE_WIDTH / 2.0f, IMAGE_HEIGHT);
        POINTER_WHITE_LEFT.closePath();
        POINTER_WHITE_RIGHT.moveTo((float)IMAGE_WIDTH * 0.75f, IMAGE_HEIGHT);
        POINTER_WHITE_RIGHT.lineTo((float)IMAGE_WIDTH / 2.0f, (float)IMAGE_HEIGHT / 2.0f);
        POINTER_WHITE_RIGHT.lineTo((float)IMAGE_WIDTH / 2.0f, IMAGE_HEIGHT);
        POINTER_WHITE_RIGHT.closePath();
        Area POINTER_FRAME_WHITE = new Area(POINTER_WHITE_LEFT);
        POINTER_FRAME_WHITE.add(new Area(POINTER_WHITE_RIGHT));
        Color STROKE_COLOR = this.getBackgroundColor().SYMBOL_COLOR.darker();
        Color FILL_COLOR = this.getBackgroundColor().SYMBOL_COLOR;
        G2.setColor(FILL_COLOR);
        G2.fill(POINTER_FRAME_WHITE);
        G2.setColor(STROKE_COLOR);
        G2.draw(POINTER_FRAME_WHITE);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_COMPASS_ROSE_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        Point2D.Double COMPASS_CENTER = new Point2D.Double((float)IMAGE_WIDTH / 2.0f, (float)IMAGE_WIDTH / 2.0f);
        AffineTransform transform = G2.getTransform();
        G2.setStroke(new BasicStroke((float)IMAGE_WIDTH * 0.01953125f, 0, 2));
        G2.setColor(this.getBackgroundColor().SYMBOL_COLOR);
        for (int i = 0; i <= 360; i += 30) {
            G2.draw(new Arc2D.Double(((Point2D)COMPASS_CENTER).getX() - (double)((float)IMAGE_WIDTH * 0.26367188f), ((Point2D)COMPASS_CENTER).getY() - (double)((float)IMAGE_WIDTH * 0.26367188f), (float)IMAGE_WIDTH * 0.52734375f, (float)IMAGE_WIDTH * 0.52734375f, i, 15.0, 0));
        }
        G2.setColor(this.getBackgroundColor().SYMBOL_COLOR);
        G2.setStroke(new BasicStroke(0.5f));
        Ellipse2D.Double outerCircle = new Ellipse2D.Double(((Point2D)COMPASS_CENTER).getX() - (double)((float)IMAGE_WIDTH * 0.2734375f), ((Point2D)COMPASS_CENTER).getY() - (double)((float)IMAGE_WIDTH * 0.2734375f), (float)IMAGE_WIDTH * 0.546875f, (float)IMAGE_WIDTH * 0.546875f);
        G2.draw(outerCircle);
        Ellipse2D.Double innerCircle = new Ellipse2D.Double(((Point2D)COMPASS_CENTER).getX() - (double)((float)IMAGE_WIDTH * 0.25390625f), ((Point2D)COMPASS_CENTER).getY() - (double)((float)IMAGE_WIDTH * 0.25390625f), (float)IMAGE_WIDTH * 0.5078125f, (float)IMAGE_WIDTH * 0.5078125f);
        G2.draw(innerCircle);
        Line2D.Double LINE = new Line2D.Double(((Point2D)COMPASS_CENTER).getX(), (double)IMAGE_WIDTH * 0.4018691589, ((Point2D)COMPASS_CENTER).getX(), (double)IMAGE_WIDTH * 0.1495327103);
        G2.setColor(this.getBackgroundColor().SYMBOL_COLOR);
        G2.setStroke(new BasicStroke(1.0f));
        G2.draw(LINE);
        G2.rotate(0.2617993877991494, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.5235987755982988, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.5235987755982988, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.2617993877991494, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.2617993877991494, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.5235987755982988, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.5235987755982988, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.2617993877991494, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.2617993877991494, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.5235987755982988, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.5235987755982988, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.2617993877991494, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.2617993877991494, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.5235987755982988, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.5235987755982988, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.rotate(0.2617993877991494, ((Point2D)COMPASS_CENTER).getX(), ((Point2D)COMPASS_CENTER).getY());
        G2.draw(LINE);
        G2.setTransform(transform);
        BufferedImage BIG_ROSE_POINTER = this.create_BIG_ROSE_POINTER_Image(IMAGE_WIDTH);
        BufferedImage SMALL_ROSE_POINTER = this.create_SMALL_ROSE_POINTER_Image(IMAGE_WIDTH);
        Point2D.Double OFFSET = new Point2D.Double((float)IMAGE_WIDTH * 0.475f, (float)IMAGE_WIDTH * 0.2f);
        G2.translate(((Point2D)OFFSET).getX(), ((Point2D)OFFSET).getY());
        G2.drawImage((Image)BIG_ROSE_POINTER, 0, 0, this);
        G2.rotate(0.7853981633974483, ((Point2D)COMPASS_CENTER).getX() - ((Point2D)OFFSET).getX(), ((Point2D)COMPASS_CENTER).getY() - ((Point2D)OFFSET).getY());
        G2.drawImage((Image)SMALL_ROSE_POINTER, 0, 0, this);
        G2.rotate(0.7853981633974483, ((Point2D)COMPASS_CENTER).getX() - ((Point2D)OFFSET).getX(), ((Point2D)COMPASS_CENTER).getY() - ((Point2D)OFFSET).getY());
        G2.drawImage((Image)BIG_ROSE_POINTER, 0, 0, this);
        G2.rotate(0.7853981633974483, ((Point2D)COMPASS_CENTER).getX() - ((Point2D)OFFSET).getX(), ((Point2D)COMPASS_CENTER).getY() - ((Point2D)OFFSET).getY());
        G2.drawImage((Image)SMALL_ROSE_POINTER, 0, 0, this);
        G2.rotate(0.7853981633974483, ((Point2D)COMPASS_CENTER).getX() - ((Point2D)OFFSET).getX(), ((Point2D)COMPASS_CENTER).getY() - ((Point2D)OFFSET).getY());
        G2.drawImage((Image)BIG_ROSE_POINTER, 0, 0, this);
        G2.rotate(0.7853981633974483, ((Point2D)COMPASS_CENTER).getX() - ((Point2D)OFFSET).getX(), ((Point2D)COMPASS_CENTER).getY() - ((Point2D)OFFSET).getY());
        G2.drawImage((Image)SMALL_ROSE_POINTER, 0, 0, this);
        G2.rotate(0.7853981633974483, ((Point2D)COMPASS_CENTER).getX() - ((Point2D)OFFSET).getX(), ((Point2D)COMPASS_CENTER).getY() - ((Point2D)OFFSET).getY());
        G2.drawImage((Image)BIG_ROSE_POINTER, 0, 0, this);
        G2.rotate(0.7853981633974483, ((Point2D)COMPASS_CENTER).getX() - ((Point2D)OFFSET).getX(), ((Point2D)COMPASS_CENTER).getY() - ((Point2D)OFFSET).getY());
        G2.drawImage((Image)SMALL_ROSE_POINTER, 0, 0, this);
        G2.setTransform(transform);
        G2.setColor(this.getBackgroundColor().SYMBOL_COLOR);
        G2.setStroke(new BasicStroke((float)IMAGE_WIDTH * 0.00953125f, 0, 2));
        G2.draw(new Ellipse2D.Double(((Point2D)COMPASS_CENTER).getX() - (double)((float)IMAGE_WIDTH * 0.1025f), ((Point2D)COMPASS_CENTER).getY() - (double)((float)IMAGE_WIDTH * 0.1025f), (float)IMAGE_WIDTH * 0.205f, (float)IMAGE_WIDTH * 0.205f));
        G2.setStroke(new BasicStroke(0.5f));
        G2.setColor(this.getBackgroundColor().SYMBOL_COLOR.darker());
        Ellipse2D.Double OUTER_ROSE_ELLIPSE = new Ellipse2D.Double(((Point2D)COMPASS_CENTER).getX() - (double)((float)IMAGE_WIDTH * 0.11f), ((Point2D)COMPASS_CENTER).getY() - (double)((float)IMAGE_WIDTH * 0.11f), (float)IMAGE_WIDTH * 0.22f, (float)IMAGE_WIDTH * 0.22f);
        G2.draw(OUTER_ROSE_ELLIPSE);
        Ellipse2D.Double INNER_ROSE_ELLIPSE = new Ellipse2D.Double(((Point2D)COMPASS_CENTER).getX() - (double)((float)IMAGE_WIDTH * 0.095f), ((Point2D)COMPASS_CENTER).getY() - (double)((float)IMAGE_WIDTH * 0.095f), (float)IMAGE_WIDTH * 0.19f, (float)IMAGE_WIDTH * 0.19f);
        G2.draw(INNER_ROSE_ELLIPSE);
        this.create_TICKMARKS(G2, IMAGE_WIDTH);
        G2.dispose();
        return IMAGE;
    }

    private void create_TICKMARKS(Graphics2D G2, int IMAGE_WIDTH) {
        AffineTransform FORMER_TRANSFORM = G2.getTransform();
        BasicStroke MEDIUM_STROKE = new BasicStroke(0.005859375f * (float)IMAGE_WIDTH, 1, 2);
        BasicStroke THIN_STROKE = new BasicStroke(0.00390625f * (float)IMAGE_WIDTH, 1, 2);
        Font BIG_FONT = new Font("Serif", 0, (int)(0.12f * (float)IMAGE_WIDTH));
        Font SMALL_FONT = new Font("Serif", 0, (int)(0.06f * (float)IMAGE_WIDTH));
        float TEXT_DISTANCE = 0.075f * (float)IMAGE_WIDTH;
        float MIN_LENGTH = 0.015625f * (float)IMAGE_WIDTH;
        float MED_LENGTH = 0.0234375f * (float)IMAGE_WIDTH;
        float MAX_LENGTH = 0.03125f * (float)IMAGE_WIDTH;
        Color TEXT_COLOR = this.getBackgroundColor().LABEL_COLOR;
        Color TICK_COLOR = this.getBackgroundColor().LABEL_COLOR;
        float RADIUS = (float)IMAGE_WIDTH * 0.38f;
        Point2D.Double COMPASS_CENTER = new Point2D.Double((float)IMAGE_WIDTH / 2.0f, (float)IMAGE_WIDTH / 2.0f);
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Point2D.Double textPoint = null;
        int tickCounter90 = 0;
        int tickCounter15 = 0;
        int tickCounter5 = 0;
        int counter = 0;
        double sinValue = 0.0;
        double cosValue = 0.0;
        double STEP = Math.PI / 180;
        for (double alpha = Math.PI * 2; alpha >= 0.0; alpha -= Math.PI / 180) {
            Line2D.Double tick;
            Point2D.Double outerPoint;
            Point2D.Double innerPoint;
            G2.setStroke(THIN_STROKE);
            sinValue = Math.sin(alpha);
            cosValue = Math.cos(alpha);
            G2.setColor(TICK_COLOR);
            if (tickCounter5 == 5) {
                G2.setStroke(THIN_STROKE);
                innerPoint = new Point2D.Double(((Point2D)COMPASS_CENTER).getX() + (double)(RADIUS - MIN_LENGTH) * sinValue, ((Point2D)COMPASS_CENTER).getY() + (double)(RADIUS - MIN_LENGTH) * cosValue);
                outerPoint = new Point2D.Double(((Point2D)COMPASS_CENTER).getX() + (double)RADIUS * sinValue, ((Point2D)COMPASS_CENTER).getY() + (double)RADIUS * cosValue);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
                tickCounter5 = 0;
            }
            if (tickCounter15 == 15) {
                G2.setStroke(THIN_STROKE);
                innerPoint = new Point2D.Double(((Point2D)COMPASS_CENTER).getX() + (double)(RADIUS - MED_LENGTH) * sinValue, ((Point2D)COMPASS_CENTER).getY() + (double)(RADIUS - MED_LENGTH) * cosValue);
                outerPoint = new Point2D.Double(((Point2D)COMPASS_CENTER).getX() + (double)RADIUS * sinValue, ((Point2D)COMPASS_CENTER).getY() + (double)RADIUS * cosValue);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
                tickCounter15 = 0;
                tickCounter90 += 15;
            }
            if (tickCounter90 == 90) {
                G2.setStroke(MEDIUM_STROKE);
                innerPoint = new Point2D.Double(((Point2D)COMPASS_CENTER).getX() + (double)(RADIUS - MAX_LENGTH) * sinValue, ((Point2D)COMPASS_CENTER).getY() + (double)(RADIUS - MAX_LENGTH) * cosValue);
                outerPoint = new Point2D.Double(((Point2D)COMPASS_CENTER).getX() + (double)RADIUS * sinValue, ((Point2D)COMPASS_CENTER).getY() + (double)RADIUS * cosValue);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
                tickCounter90 = 0;
            }
            G2.setFont(BIG_FONT);
            G2.setColor(TEXT_COLOR);
            textPoint = new Point2D.Double(((Point2D)COMPASS_CENTER).getX() + (double)(RADIUS - TEXT_DISTANCE) * sinValue, ((Point2D)COMPASS_CENTER).getY() + (double)(RADIUS - TEXT_DISTANCE) * cosValue);
            switch (counter) {
                case 360: {
                    G2.setFont(BIG_FONT);
                    G2.fill(UTIL.rotateTextAroundCenter(G2, "S", (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI - alpha));
                    break;
                }
                case 45: {
                    G2.setFont(SMALL_FONT);
                    G2.fill(UTIL.rotateTextAroundCenter(G2, "SW", (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI - alpha));
                    break;
                }
                case 90: {
                    G2.setFont(BIG_FONT);
                    G2.fill(UTIL.rotateTextAroundCenter(G2, "W", (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI - alpha));
                    break;
                }
                case 135: {
                    G2.setFont(SMALL_FONT);
                    G2.fill(UTIL.rotateTextAroundCenter(G2, "NW", (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI - alpha));
                    break;
                }
                case 180: {
                    G2.setFont(BIG_FONT);
                    G2.fill(UTIL.rotateTextAroundCenter(G2, "N", (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI - alpha));
                    break;
                }
                case 225: {
                    G2.setFont(SMALL_FONT);
                    G2.fill(UTIL.rotateTextAroundCenter(G2, "NE", (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI - alpha));
                    break;
                }
                case 270: {
                    G2.setFont(BIG_FONT);
                    G2.fill(UTIL.rotateTextAroundCenter(G2, "E", (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI - alpha));
                    break;
                }
                case 315: {
                    G2.setFont(SMALL_FONT);
                    G2.fill(UTIL.rotateTextAroundCenter(G2, "SE", (int)((Point2D)textPoint).getX(), (int)((Point2D)textPoint).getY(), Math.PI - alpha));
                }
            }
            G2.setTransform(FORMER_TRANSFORM);
            ++tickCounter5;
            ++tickCounter15;
            ++counter;
        }
        G2.setTransform(FORMER_TRANSFORM);
    }

    @Override
    protected BufferedImage create_POINTER_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        switch (this.getPointerType()) {
            case TYPE2: {
                GeneralPath NORTHPOINTER2 = new GeneralPath();
                NORTHPOINTER2.setWindingRule(0);
                NORTHPOINTER2.moveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4532710280373832);
                NORTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                NORTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.4532710280373832);
                NORTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5);
                NORTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5);
                NORTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4532710280373832);
                NORTHPOINTER2.closePath();
                Point2D.Double NORTHPOINTER2_START = new Point2D.Double(NORTHPOINTER2.getBounds2D().getMinX(), 0.0);
                Point2D.Double NORTHPOINTER2_STOP = new Point2D.Double(NORTHPOINTER2.getBounds2D().getMaxX(), 0.0);
                float[] NORTHPOINTER2_FRACTIONS = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] NORTHPOINTER2_COLORS = new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
                LinearGradientPaint NORTHPOINTER2_GRADIENT = new LinearGradientPaint(NORTHPOINTER2_START, NORTHPOINTER2_STOP, NORTHPOINTER2_FRACTIONS, NORTHPOINTER2_COLORS);
                G2.setPaint(NORTHPOINTER2_GRADIENT);
                G2.fill(NORTHPOINTER2);
                G2.setColor(this.getPointerColor().DARK);
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(NORTHPOINTER2);
                GeneralPath SOUTHPOINTER2 = new GeneralPath();
                SOUTHPOINTER2.setWindingRule(0);
                SOUTHPOINTER2.moveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SOUTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8504672897196262, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8504672897196262);
                SOUTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8504672897196262, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SOUTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5);
                SOUTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5);
                SOUTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SOUTHPOINTER2.closePath();
                Point2D.Double SOUTHPOINTER2_START = new Point2D.Double(SOUTHPOINTER2.getBounds2D().getMinX(), 0.0);
                Point2D.Double SOUTHPOINTER2_STOP = new Point2D.Double(SOUTHPOINTER2.getBounds2D().getMaxX(), 0.0);
                float[] SOUTHPOINTER2_FRACTIONS = new float[]{0.0f, 0.48f, 0.48009998f, 1.0f};
                Color[] SOUTHPOINTER2_COLORS = new Color[]{new Color(227, 229, 232, 255), new Color(227, 229, 232, 255), new Color(171, 177, 184, 255), new Color(171, 177, 184, 255)};
                LinearGradientPaint SOUTHPOINTER2_GRADIENT = new LinearGradientPaint(SOUTHPOINTER2_START, SOUTHPOINTER2_STOP, SOUTHPOINTER2_FRACTIONS, SOUTHPOINTER2_COLORS);
                G2.setPaint(SOUTHPOINTER2_GRADIENT);
                G2.fill(SOUTHPOINTER2);
                G2.setColor(new Color(11252152));
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(SOUTHPOINTER2);
                break;
            }
            case TYPE3: {
                GeneralPath NORTHPOINTER3 = new GeneralPath();
                NORTHPOINTER3.setWindingRule(0);
                NORTHPOINTER3.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                NORTHPOINTER3.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5);
                NORTHPOINTER3.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5560747663551402);
                NORTHPOINTER3.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5);
                NORTHPOINTER3.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                NORTHPOINTER3.closePath();
                Point2D.Double NORTHPOINTER3_START = new Point2D.Double(NORTHPOINTER3.getBounds2D().getMinX(), 0.0);
                Point2D.Double NORTHPOINTER3_STOP = new Point2D.Double(NORTHPOINTER3.getBounds2D().getMaxX(), 0.0);
                float[] NORTHPOINTER3_FRACTIONS = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] NORTHPOINTER3_COLORS = new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
                LinearGradientPaint NORTHPOINTER3_GRADIENT = new LinearGradientPaint(NORTHPOINTER3_START, NORTHPOINTER3_STOP, NORTHPOINTER3_FRACTIONS, NORTHPOINTER3_COLORS);
                G2.setPaint(NORTHPOINTER3_GRADIENT);
                G2.fill(NORTHPOINTER3);
                break;
            }
            default: {
                GeneralPath NORTHPOINTER1 = new GeneralPath();
                NORTHPOINTER1.setWindingRule(0);
                NORTHPOINTER1.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4953271028037383);
                NORTHPOINTER1.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.4953271028037383);
                NORTHPOINTER1.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                NORTHPOINTER1.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.4953271028037383);
                NORTHPOINTER1.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4953271028037383);
                NORTHPOINTER1.closePath();
                Point2D.Double NORTHPOINTER1_START = new Point2D.Double(NORTHPOINTER1.getBounds2D().getMinX(), 0.0);
                Point2D.Double NORTHPOINTER1_STOP = new Point2D.Double(NORTHPOINTER1.getBounds2D().getMaxX(), 0.0);
                float[] NORTHPOINTER1_FRACTIONS = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] NORTHPOINTER1_COLORS = new Color[]{this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().MEDIUM, this.getPointerColor().MEDIUM};
                LinearGradientPaint NORTHPOINTER1_GRADIENT = new LinearGradientPaint(NORTHPOINTER1_START, NORTHPOINTER1_STOP, NORTHPOINTER1_FRACTIONS, NORTHPOINTER1_COLORS);
                G2.setPaint(NORTHPOINTER1_GRADIENT);
                G2.fill(NORTHPOINTER1);
                G2.setColor(this.getPointerColor().DARK);
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(NORTHPOINTER1);
                GeneralPath SOUTHPOINTER1 = new GeneralPath();
                SOUTHPOINTER1.setWindingRule(0);
                SOUTHPOINTER1.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SOUTHPOINTER1.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SOUTHPOINTER1.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8504672897196262);
                SOUTHPOINTER1.lineTo((double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SOUTHPOINTER1.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5046728971962616);
                SOUTHPOINTER1.closePath();
                Point2D.Double SOUTHPOINTER1_START = new Point2D.Double(SOUTHPOINTER1.getBounds2D().getMinX(), 0.0);
                Point2D.Double SOUTHPOINTER1_STOP = new Point2D.Double(SOUTHPOINTER1.getBounds2D().getMaxX(), 0.0);
                float[] SOUTHPOINTER1_FRACTIONS = new float[]{0.0f, 0.4999f, 0.5f, 1.0f};
                Color[] SOUTHPOINTER1_COLORS = new Color[]{new Color(227, 229, 232, 255), new Color(227, 229, 232, 255), new Color(171, 177, 184, 255), new Color(171, 177, 184, 255)};
                LinearGradientPaint SOUTHPOINTER1_GRADIENT = new LinearGradientPaint(SOUTHPOINTER1_START, SOUTHPOINTER1_STOP, SOUTHPOINTER1_FRACTIONS, SOUTHPOINTER1_COLORS);
                G2.setPaint(SOUTHPOINTER1_GRADIENT);
                G2.fill(SOUTHPOINTER1);
                Color STROKE_COLOR_SOUTHPOINTER1 = new Color(11252152);
                G2.setColor(STROKE_COLOR_SOUTHPOINTER1);
                G2.setStroke(new BasicStroke(1.0f, 0, 0));
                G2.draw(SOUTHPOINTER1);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    @Override
    protected BufferedImage create_POINTER_SHADOW_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, (int)(1.0 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Color SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.65f);
        switch (this.getPointerType()) {
            case TYPE2: {
                GeneralPath NORTHPOINTER2 = new GeneralPath();
                NORTHPOINTER2.setWindingRule(0);
                NORTHPOINTER2.moveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4532710280373832);
                NORTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                NORTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.4532710280373832, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.4532710280373832);
                NORTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5);
                NORTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5);
                NORTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.4532710280373832);
                NORTHPOINTER2.closePath();
                GeneralPath SOUTHPOINTER2 = new GeneralPath();
                SOUTHPOINTER2.setWindingRule(0);
                SOUTHPOINTER2.moveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SOUTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8504672897196262, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8504672897196262);
                SOUTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8504672897196262, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5467289719626168, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SOUTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.5467289719626168, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5);
                SOUTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5);
                SOUTHPOINTER2.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.4532710280373832, (double)IMAGE_HEIGHT * 0.5373831775700935, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5467289719626168);
                SOUTHPOINTER2.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(NORTHPOINTER2);
                G2.fill(SOUTHPOINTER2);
                break;
            }
            case TYPE3: {
                GeneralPath NORTHPOINTER3 = new GeneralPath();
                NORTHPOINTER3.setWindingRule(0);
                NORTHPOINTER3.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                NORTHPOINTER3.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5);
                NORTHPOINTER3.curveTo((double)IMAGE_WIDTH * 0.4439252336448598, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5560747663551402);
                NORTHPOINTER3.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5560747663551402, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.5);
                NORTHPOINTER3.curveTo((double)IMAGE_WIDTH * 0.5560747663551402, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.14953271028037382);
                NORTHPOINTER3.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(NORTHPOINTER3);
                break;
            }
            default: {
                GeneralPath NORTHPOINTER1 = new GeneralPath();
                NORTHPOINTER1.setWindingRule(0);
                NORTHPOINTER1.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
                NORTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.40186915887850466);
                NORTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1308411214953271, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1308411214953271);
                NORTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.1308411214953271, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.38317757009345793, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.397196261682243);
                NORTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.4158878504672897, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.45794392523364486, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299);
                NORTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
                NORTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5327102803738317);
                NORTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
                NORTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
                NORTHPOINTER1.closePath();
                GeneralPath SOUTHPOINTER1 = new GeneralPath();
                SOUTHPOINTER1.setWindingRule(0);
                SOUTHPOINTER1.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5280373831775701);
                SOUTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5841121495327103, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.602803738317757);
                SOUTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8691588785046729, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8691588785046729);
                SOUTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8691588785046729, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.602803738317757);
                SOUTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5841121495327103, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5420560747663551, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5280373831775701);
                SOUTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
                SOUTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.4672897196261682);
                SOUTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
                SOUTHPOINTER1.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5093457943925234, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5280373831775701);
                SOUTHPOINTER1.closePath();
                G2.setColor(SHADOW_COLOR);
                G2.fill(NORTHPOINTER1);
                G2.fill(SOUTHPOINTER1);
            }
        }
        G2.dispose();
        return IMAGE;
    }

    @Override
    public String toString() {
        return "Compass";
    }
}

