/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractLinearBargraph;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Section;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class LinearBargraph
extends AbstractLinearBargraph {
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage glowImageOff;
    private BufferedImage glowImageOn;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private BufferedImage lcdThresholdImage;
    private BufferedImage disabledImage;
    private ColorDef barGraphColor;
    private Rectangle2D led;
    private Point2D ledCenter;
    private Color[] ledColors;
    private final float[] LED_FRACTIONS;
    private RadialGradientPaint ledGradient;
    private RadialGradientPaint ledInactiveGradient;
    private final Color[] LED_INACTIVE_COLORS;
    private HashMap<Section, RadialGradientPaint> sectionGradients;
    private HashMap<Section, Point2D> sectionOffsets;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();
    private static final int BASE = 10;
    private final Rectangle2D VALUE_BACKGROUND_TRACK;
    private final Point2D VALUE_BACKGROUND_VERTICAL_START;
    private final Point2D VALUE_BACKGROUND_VERTICAL_STOP;
    private final float[] VALUE_BACKGROUND_TRACK_FRACTIONS;
    private final Rectangle2D VALUE_LEFT_BORDER;
    private final Rectangle2D VALUE_RIGHT_BORDER;
    private final Point2D VALUE_BORDER_START;
    private final Point2D VALUE_BORDER_STOP;
    private final float[] VALUE_BORDER_FRACTIONS;

    public LinearBargraph() {
        this.barGraphColor = this.getModel().getValueColor();
        this.LED_FRACTIONS = new float[]{0.0f, 1.0f};
        this.LED_INACTIVE_COLORS = new Color[]{new Color(60, 60, 60, 255), new Color(50, 50, 50, 255)};
        this.sectionGradients = new HashMap(4);
        this.sectionOffsets = new HashMap(4);
        this.VALUE_BACKGROUND_TRACK = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_BACKGROUND_VERTICAL_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_BACKGROUND_VERTICAL_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_BACKGROUND_TRACK_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        this.VALUE_LEFT_BORDER = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_RIGHT_BORDER = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_BORDER_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_BORDER_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_BORDER_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        this.prepareBargraph(this.getInnerBounds().width, this.getInnerBounds().height);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    public LinearBargraph(Model MODEL) {
        this.setModel(MODEL);
        this.barGraphColor = MODEL.getValueColor();
        this.LED_FRACTIONS = new float[]{0.0f, 1.0f};
        this.LED_INACTIVE_COLORS = new Color[]{new Color(60, 60, 60, 255), new Color(50, 50, 50, 255)};
        this.sectionGradients = new HashMap(4);
        this.sectionOffsets = new HashMap(4);
        this.VALUE_BACKGROUND_TRACK = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_BACKGROUND_VERTICAL_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_BACKGROUND_VERTICAL_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_BACKGROUND_TRACK_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        this.VALUE_LEFT_BORDER = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_RIGHT_BORDER = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.VALUE_BORDER_START = new Point2D.Double(0.0, 0.0);
        this.VALUE_BORDER_STOP = new Point2D.Double(0.0, 0.0);
        this.VALUE_BORDER_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        this.prepareBargraph(this.getInnerBounds().width, this.getInnerBounds().height);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return this;
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(WIDTH, HEIGHT, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(WIDTH, HEIGHT, 3);
        this.prepareBargraph(WIDTH, HEIGHT);
        if (this.isLcdVisible()) {
            float LCD_TEXT_HEIGHT_BASE = this.getOrientation() == Orientation.HORIZONTAL ? (float)HEIGHT * 0.15f : (float)HEIGHT * 0.055f;
            if (this.isDigitalFont()) {
                this.setLcdValueFont(LCD_DIGITAL_FONT.deriveFont(0.7f * LCD_TEXT_HEIGHT_BASE));
            } else {
                this.setLcdValueFont(LCD_STANDARD_FONT.deriveFont(0.625f * LCD_TEXT_HEIGHT_BASE));
            }
            if (this.isCustomLcdUnitFontEnabled()) {
                this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * LCD_TEXT_HEIGHT_BASE));
            } else {
                this.setLcdUnitFont(LCD_STANDARD_FONT.deriveFont(0.25f * LCD_TEXT_HEIGHT_BASE));
            }
            this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * LCD_TEXT_HEIGHT_BASE));
        }
        if (this.isFrameVisible()) {
            this.create_FRAME_Image(WIDTH, HEIGHT, this.bImage);
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(WIDTH, HEIGHT, this.bImage);
        }
        if (this.isGlowVisible()) {
            if (this.glowImageOff != null) {
                this.glowImageOff.flush();
            }
            this.glowImageOff = this.create_GLOW_Image(WIDTH, HEIGHT, this.getGlowColor(), false);
            if (this.glowImageOn != null) {
                this.glowImageOn.flush();
            }
            this.glowImageOn = this.create_GLOW_Image(WIDTH, HEIGHT, this.getGlowColor(), true);
        } else {
            this.setGlowPulsating(false);
        }
        if (this.isTrackVisible()) {
            this.create_TRACK_Image(WIDTH, HEIGHT, this.getMinValue(), this.getMaxValue(), this.getTrackStart(), this.getTrackSection(), this.getTrackStop(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), this.bImage);
        }
        TICKMARK_FACTORY.create_LINEAR_TICKMARKS_Image(WIDTH, HEIGHT, this.getModel().getNiceMinValue(), this.getModel().getNiceMaxValue(), this.getModel().getMaxNoOfMinorTicks(), this.getModel().getMaxNoOfMajorTicks(), this.getModel().getMinorTickSpacing(), this.getModel().getMajorTickSpacing(), this.getMinorTickmarkType(), this.getMajorTickmarkType(), this.isTickmarksVisible(), this.isTicklabelsVisible(), this.getModel().isMinorTickmarksVisible(), this.getModel().isMajorTickmarksVisible(), this.getLabelNumberFormat(), this.isTickmarkSectionsVisible(), this.getBackgroundColor(), this.getTickmarkColor(), this.isTickmarkColorFromThemeEnabled(), this.getTickmarkSections(), new Point2D.Double(0.0, 0.0), this.getOrientation(), this.getModel().isNiceScale(), this.getModel().isLogScale(), this.bImage);
        if (this.isTitleVisible()) {
            this.create_TITLE_Image(WIDTH, HEIGHT, this.getModel().isUnitVisible(), this.bImage);
        }
        if (this.isLcdVisible()) {
            switch (this.getOrientation()) {
                case HORIZONTAL: {
                    if (this.isLcdBackgroundVisible()) {
                        this.create_LCD_Image(new Rectangle2D.Double((double)WIDTH * 0.695, (double)HEIGHT * 0.22, (double)WIDTH * 0.18, (double)HEIGHT * 0.15), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
                    }
                    this.LCD.setRect((double)WIDTH * 0.695, (double)HEIGHT * 0.22, (double)WIDTH * 0.18, (double)HEIGHT * 0.15);
                    break;
                }
                case VERTICAL: {
                    if (this.isLcdBackgroundVisible()) {
                        this.create_LCD_Image(new Rectangle2D.Double(((double)WIDTH - (double)WIDTH * 0.5714285714) / 2.0, (double)HEIGHT * 0.875, (double)WIDTH * 0.5714285714, (double)HEIGHT * 0.055), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
                    }
                    this.LCD.setRect(((double)WIDTH - (double)WIDTH * 0.5714285714) / 2.0, (double)HEIGHT * 0.875, (double)WIDTH * 0.5714285714, (double)HEIGHT * 0.055);
                }
            }
            if (this.lcdThresholdImage != null) {
                this.lcdThresholdImage.flush();
            }
            this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)(this.LCD.getHeight() * 0.2045454545), (int)(this.LCD.getHeight() * 0.2045454545), this.getLcdColor().TEXT_COLOR);
        }
        if (this.thresholdImage != null) {
            this.thresholdImage.flush();
        }
        this.thresholdImage = this.create_THRESHOLD_Image(WIDTH, HEIGHT);
        if (this.minMeasuredImage != null) {
            this.minMeasuredImage.flush();
        }
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(WIDTH, HEIGHT, new Color(0, 23, 252, 255));
        if (this.maxMeasuredImage != null) {
            this.maxMeasuredImage.flush();
        }
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(WIDTH, HEIGHT, new Color(252, 29, 0, 255));
        if (this.isForegroundVisible()) {
            FOREGROUND_FACTORY.createLinearForeground(WIDTH, HEIGHT, false, this.fImage);
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(WIDTH, HEIGHT);
        this.setCurrentLedImage(this.getLedImageOff());
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        double VALUE_POS;
        AffineTransform OLD_TRANSFORM;
        double PIXEL_SCALE;
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (!this.isFrameVisible()) {
            G2.translate(this.getInnerBounds().x - 17, this.getInnerBounds().y - 17);
        } else {
            G2.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        }
        G2.drawImage((Image)this.bImage, 0, 0, null);
        if (this.getInnerBounds().width < this.getInnerBounds().height) {
            double PIXEL_RANGE = (double)this.getInnerBounds().height * 0.8567961165048543 - (double)this.getInnerBounds().height * 0.12864077669902912;
            double RANGE = this.getMaxValue() - this.getMinValue();
            PIXEL_SCALE = PIXEL_RANGE / RANGE;
        } else {
            double PIXEL_RANGE = (double)this.getInnerBounds().width * 0.8567961165048543 - (double)this.getInnerBounds().width * 0.12864077669902912;
            double RANGE = this.getMaxValue() - this.getMinValue();
            PIXEL_SCALE = PIXEL_RANGE / RANGE;
        }
        if (this.isThresholdVisible()) {
            OLD_TRANSFORM = G2.getTransform();
            if (this.getInnerBounds().width < this.getInnerBounds().height) {
                VALUE_POS = this.getMinValue() < 0.0 ? (double)this.getInnerBounds().height * 0.8567961165048543 + this.getMinValue() * PIXEL_SCALE - this.getThreshold() * PIXEL_SCALE : (double)this.getInnerBounds().height * 0.8567961165048543 - this.getMinValue() * PIXEL_SCALE - this.getThreshold() * PIXEL_SCALE;
                G2.translate((double)this.getInnerBounds().width * 0.4357142857142857 - (double)this.thresholdImage.getWidth() - 2.0 + (double)this.getInnerBounds().x, VALUE_POS - (double)this.thresholdImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
            } else {
                VALUE_POS = this.getThreshold() * PIXEL_SCALE - this.getMinValue() * PIXEL_SCALE;
                G2.translate((double)this.getInnerBounds().width * 0.14285714285714285 - (double)this.thresholdImage.getWidth() / 2.0 + VALUE_POS + (double)this.getInnerBounds().x, (double)this.getInnerBounds().height * 0.5714285714 + 2.0 + (double)this.getInnerBounds().y);
            }
            G2.drawImage((Image)this.thresholdImage, 0, 0, null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isMinMeasuredValueVisible()) {
            OLD_TRANSFORM = G2.getTransform();
            if (this.getInnerBounds().width < this.getInnerBounds().height) {
                VALUE_POS = this.getMinValue() < 0.0 ? (double)this.getInnerBounds().height * 0.8567961165048543 + this.getMinValue() * PIXEL_SCALE - this.getMinMeasuredValue() * PIXEL_SCALE : (double)this.getInnerBounds().height * 0.8567961165048543 - this.getMinValue() * PIXEL_SCALE - this.getMinMeasuredValue() * PIXEL_SCALE;
                G2.translate((double)this.getInnerBounds().width * 0.37 - (double)this.minMeasuredImage.getWidth() - 2.0 + (double)this.getInnerBounds().x, VALUE_POS - (double)this.minMeasuredImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
            } else {
                VALUE_POS = this.getMinMeasuredValue() * PIXEL_SCALE - this.getMinValue() * PIXEL_SCALE;
                G2.translate((double)this.getInnerBounds().width * 0.14285714285714285 - (double)this.minMeasuredImage.getWidth() / 2.0 + VALUE_POS + (double)this.getInnerBounds().x, (double)this.getInnerBounds().height * 0.63 + 2.0 + (double)this.getInnerBounds().y);
            }
            G2.drawImage((Image)this.minMeasuredImage, 0, 0, null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isMaxMeasuredValueVisible()) {
            OLD_TRANSFORM = G2.getTransform();
            if (this.getInnerBounds().width < this.getInnerBounds().height) {
                VALUE_POS = this.getMinValue() < 0.0 ? (double)this.getInnerBounds().height * 0.8567961165048543 + this.getMinValue() * PIXEL_SCALE - this.getMaxMeasuredValue() * PIXEL_SCALE : (double)this.getInnerBounds().height * 0.8567961165048543 - this.getMinValue() * PIXEL_SCALE - this.getMaxMeasuredValue() * PIXEL_SCALE;
                G2.translate((double)this.getInnerBounds().width * 0.37 - (double)this.maxMeasuredImage.getWidth() - 2.0 + (double)this.getInnerBounds().x, VALUE_POS - (double)this.maxMeasuredImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
            } else {
                VALUE_POS = this.getMaxMeasuredValue() * PIXEL_SCALE - this.getMinValue() * PIXEL_SCALE;
                G2.translate((double)this.getInnerBounds().width * 0.14285714285714285 - (double)this.maxMeasuredImage.getWidth() / 2.0 + VALUE_POS + (double)this.getInnerBounds().x, (double)this.getInnerBounds().height * 0.63 + 2.0 + (double)this.getInnerBounds().y);
            }
            G2.drawImage((Image)this.maxMeasuredImage, 0, 0, null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isLedVisible()) {
            G2.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.getInnerBounds().width * this.getLedPosition().getX()), (int)((double)this.getInnerBounds().height * this.getLedPosition().getY()), null);
        }
        if (this.isUserLedVisible()) {
            G2.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getInnerBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getInnerBounds().height * this.getUserLedPosition().getY()), null);
        }
        if (this.isLcdVisible()) {
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                G2.setColor(this.getCustomLcdForeground());
            } else {
                G2.setColor(this.getLcdColor().TEXT_COLOR);
            }
            G2.setFont(this.getLcdUnitFont());
            if (this.isLcdTextVisible()) {
                double UNIT_STRING_WIDTH;
                if (this.isLcdUnitStringVisible()) {
                    this.unitLayout = new TextLayout(this.getLcdUnitString(), G2.getFont(), this.RENDER_CONTEXT);
                    this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                    G2.drawString(this.getLcdUnitString(), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (int)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    UNIT_STRING_WIDTH = this.UNIT_BOUNDARY.getWidth();
                } else {
                    UNIT_STRING_WIDTH = 0.0;
                }
                G2.setFont(this.getLcdValueFont());
                switch (this.getModel().getNumberSystem()) {
                    case HEX: {
                        this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), G2.getFont(), this.RENDER_CONTEXT);
                        this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                        G2.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (int)(this.LCD.getX() + (this.LCD.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                        break;
                    }
                    case OCT: {
                        this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                        this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                        G2.drawString(Integer.toOctalString((int)this.getLcdValue()), (int)(this.LCD.getX() + (this.LCD.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                        break;
                    }
                    default: {
                        this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                        this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                        G2.drawString(this.formatLcdValue(this.getLcdValue()), (int)(this.LCD.getX() + (this.LCD.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    }
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                G2.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), G2.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                G2.drawString(this.getLcdInfoString(), this.LCD.getBounds().x + 5, this.LCD.getBounds().y + (int)this.INFO_BOUNDARY.getHeight() + 5);
            }
            if (this.getLcdNumberSystem() == NumberSystem.DEC && this.isLcdThresholdVisible() && this.getLcdValue() >= this.getLcdThreshold()) {
                G2.drawImage((Image)this.lcdThresholdImage, (int)(this.LCD.getX() + this.LCD.getHeight() * 0.0568181818), (int)(this.LCD.getY() + this.LCD.getHeight() - (double)this.lcdThresholdImage.getHeight() - this.LCD.getHeight() * 0.0568181818), null);
            }
        }
        this.drawValue(G2, this.getInnerBounds().width, this.getInnerBounds().height);
        if (this.isForegroundVisible()) {
            G2.drawImage((Image)this.fImage, 0, 0, null);
        }
        if (this.isGlowVisible()) {
            if (this.isGlowing()) {
                G2.setComposite(AlphaComposite.getInstance(3, this.getGlowAlpha()));
                G2.drawImage((Image)this.glowImageOn, 0, 0, null);
                G2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                G2.drawImage((Image)this.glowImageOff, 0, 0, null);
            }
        }
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.dispose();
    }

    private void drawValue(Graphics2D G2, int WIDTH, int HEIGHT) {
        double FULL_SIZE;
        double BOTTOM;
        double TOP;
        boolean VERTICAL;
        boolean bl = VERTICAL = WIDTH < HEIGHT;
        if (VERTICAL) {
            TOP = (double)HEIGHT * 0.12864077669902912;
            BOTTOM = (double)HEIGHT * 0.8567961165048543;
            FULL_SIZE = BOTTOM - TOP;
            this.VALUE_BACKGROUND_TRACK.setRect((double)WIDTH * 0.4357142857142857, TOP, (double)WIDTH * 0.14285714285714285, FULL_SIZE);
            this.VALUE_BACKGROUND_VERTICAL_START.setLocation(0.0, this.VALUE_BACKGROUND_TRACK.getBounds2D().getMinY());
            this.VALUE_BACKGROUND_VERTICAL_STOP.setLocation(0.0, this.VALUE_BACKGROUND_TRACK.getBounds2D().getMaxY());
        } else {
            TOP = (double)WIDTH * 0.8567961165048543;
            BOTTOM = (double)WIDTH * 0.12864077669902912;
            FULL_SIZE = TOP - BOTTOM;
            this.VALUE_BACKGROUND_TRACK.setRect((double)WIDTH * 0.14285714285714285, (double)HEIGHT * 0.4357142857142857, FULL_SIZE, (double)HEIGHT * 0.14285714285714285);
            this.VALUE_BACKGROUND_VERTICAL_START.setLocation(TOP, 0.0);
            this.VALUE_BACKGROUND_VERTICAL_STOP.setLocation(BOTTOM, 0.0);
        }
        Color[] VALUE_BACKGROUND_TRACK_COLORS = new Color[]{UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.047058824f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.14509805f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.14901961f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.047058824f)};
        LinearGradientPaint VALUE_BACKGROUND_TRACK_GRADIENT = new LinearGradientPaint(this.VALUE_BACKGROUND_VERTICAL_START, this.VALUE_BACKGROUND_VERTICAL_STOP, this.VALUE_BACKGROUND_TRACK_FRACTIONS, VALUE_BACKGROUND_TRACK_COLORS);
        G2.setPaint(VALUE_BACKGROUND_TRACK_GRADIENT);
        G2.fill(this.VALUE_BACKGROUND_TRACK);
        if (VERTICAL) {
            this.VALUE_LEFT_BORDER.setRect((double)WIDTH * 0.4357142857142857, TOP - this.led.getHeight() / 2.0, (double)WIDTH * 0.007142857142857143, FULL_SIZE + this.led.getHeight());
            this.VALUE_RIGHT_BORDER.setRect((double)WIDTH * 0.5714285714285714, TOP - this.led.getHeight() / 2.0, (double)WIDTH * 0.007142857142857143, FULL_SIZE + this.led.getHeight());
            this.VALUE_BORDER_START.setLocation(0.0, this.VALUE_LEFT_BORDER.getBounds2D().getMinY());
            this.VALUE_BORDER_STOP.setLocation(0.0, this.VALUE_LEFT_BORDER.getBounds2D().getMaxY());
        } else {
            this.VALUE_LEFT_BORDER.setRect((double)WIDTH * 0.14285714285714285 - this.led.getWidth() / 2.0, (double)HEIGHT * 0.4357142857, FULL_SIZE + this.led.getWidth(), (double)HEIGHT * 0.007142857142857143);
            this.VALUE_RIGHT_BORDER.setRect((double)WIDTH * 0.14285714285714285 - this.led.getWidth() / 2.0, (double)HEIGHT * 0.5714285714, FULL_SIZE + this.led.getWidth(), (double)HEIGHT * 0.007142857142857143);
            this.VALUE_BORDER_START.setLocation(this.VALUE_LEFT_BORDER.getBounds2D().getMaxX(), 0.0);
            this.VALUE_BORDER_STOP.setLocation(this.VALUE_LEFT_BORDER.getBounds2D().getMinX(), 0.0);
        }
        Color[] VALUE_BORDER_COLORS = new Color[]{UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.29803923f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.6862745f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.69803923f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.4f)};
        LinearGradientPaint VALUE_BORDER_GRADIENT = new LinearGradientPaint(this.VALUE_BORDER_START, this.VALUE_BORDER_STOP, this.VALUE_BORDER_FRACTIONS, VALUE_BORDER_COLORS);
        G2.setPaint(VALUE_BORDER_GRADIENT);
        G2.fill(this.VALUE_LEFT_BORDER);
        G2.fill(this.VALUE_RIGHT_BORDER);
        if (VERTICAL) {
            double ACTIVE_LEDS;
            AffineTransform OLD_TRANSFORM = G2.getTransform();
            G2.setPaint(this.ledInactiveGradient);
            double INACTIVE_LEDS = this.getCoordForValue(this.getMaxValue(), FULL_SIZE);
            double translateY = 0.0;
            while (Double.compare(translateY, INACTIVE_LEDS) <= 0) {
                G2.translate(0.0, -translateY);
                G2.fill(this.led);
                G2.setTransform(OLD_TRANSFORM);
                translateY += this.led.getHeight() + 1.0;
            }
            if (!this.isSectionsVisible()) {
                G2.setPaint(this.ledGradient);
            }
            if (!this.isLogScale()) {
                ACTIVE_LEDS = this.getCoordForValue(this.getValue(), FULL_SIZE);
            } else {
                double SIZE_FACTOR = Math.abs(TOP - BOTTOM) / UTIL.logOfBase(10.0, this.getMaxValue());
                ACTIVE_LEDS = SIZE_FACTOR * UTIL.logOfBase(10.0, this.getValue());
            }
            if (!this.getModel().isSingleLedBargraphEnabled()) {
                double translateY2 = 0.0;
                while (Double.compare(translateY2, ACTIVE_LEDS) <= 0) {
                    G2.setPaint(this.ledGradient);
                    if (this.isSectionsVisible()) {
                        for (Section section : this.getSections()) {
                            if (!(translateY2 >= this.sectionOffsets.get(section).getX()) || !(translateY2 < this.sectionOffsets.get(section).getY())) continue;
                            G2.setPaint(this.sectionGradients.get(section));
                            break;
                        }
                    }
                    G2.translate(0.0, -translateY2);
                    G2.fill(this.led);
                    G2.setTransform(OLD_TRANSFORM);
                    translateY2 += this.led.getHeight() + 1.0;
                }
            } else {
                double TRANSLATE_Y = -this.getCoordForValue(this.getValue(), FULL_SIZE);
                if (this.isSectionsVisible()) {
                    for (Section section : this.getSections()) {
                        if (!(TRANSLATE_Y >= this.sectionOffsets.get(section).getX()) || !(TRANSLATE_Y < this.sectionOffsets.get(section).getY())) continue;
                        G2.setPaint(this.sectionGradients.get(section));
                    }
                }
                G2.translate(0.0, -TRANSLATE_Y);
                G2.fill(this.led);
                G2.setTransform(OLD_TRANSFORM);
            }
            if (this.isPeakValueEnabled() && this.isPeakValueVisible()) {
                G2.translate(0.0, -this.getCoordForValue(this.getPeakValue(), FULL_SIZE));
                G2.fill(this.led);
                G2.setTransform(OLD_TRANSFORM);
            }
        } else {
            double ACTIVE_LEDS;
            AffineTransform OLD_TRANSFORM = G2.getTransform();
            G2.setPaint(this.ledInactiveGradient);
            double INACTIVE_LEDS = this.getCoordForValue(this.getMaxValue(), FULL_SIZE);
            double translateX = -(this.led.getWidth() / 2.0);
            while (Double.compare(translateX, INACTIVE_LEDS) <= 0) {
                G2.translate(translateX, 0.0);
                G2.fill(this.led);
                G2.setTransform(OLD_TRANSFORM);
                translateX += this.led.getWidth() + 1.0;
            }
            if (!this.isSectionsVisible()) {
                G2.setPaint(this.ledGradient);
            }
            if (!this.isLogScale()) {
                ACTIVE_LEDS = this.getCoordForValue(this.getValue(), FULL_SIZE);
            } else {
                double SIZE_FACTOR = FULL_SIZE / UTIL.logOfBase(10.0, this.getMaxValue());
                ACTIVE_LEDS = SIZE_FACTOR * UTIL.logOfBase(10.0, this.getValue());
            }
            if (!this.getModel().isSingleLedBargraphEnabled()) {
                double translateX2 = -(this.led.getWidth() / 2.0);
                while (Double.compare(translateX2, ACTIVE_LEDS) <= 0) {
                    G2.setPaint(this.ledGradient);
                    if (this.isSectionsVisible()) {
                        for (Section section : this.getSections()) {
                            if (!(translateX2 + this.led.getWidth() / 2.0 >= this.sectionOffsets.get(section).getX()) || !(translateX2 + this.led.getWidth() / 2.0 < this.sectionOffsets.get(section).getY())) continue;
                            G2.setPaint(this.sectionGradients.get(section));
                        }
                    }
                    G2.translate(translateX2, 0.0);
                    G2.fill(this.led);
                    G2.setTransform(OLD_TRANSFORM);
                    translateX2 += this.led.getWidth() + 1.0;
                }
            } else {
                double TRANSLATE_X = this.getCoordForValue(this.getValue(), FULL_SIZE);
                if (this.isSectionsVisible()) {
                    for (Section section : this.getSections()) {
                        if (!(TRANSLATE_X + this.led.getWidth() / 2.0 >= this.sectionOffsets.get(section).getX()) || !(TRANSLATE_X + this.led.getWidth() / 2.0 < this.sectionOffsets.get(section).getY())) continue;
                        G2.setPaint(this.sectionGradients.get(section));
                    }
                }
                G2.translate(TRANSLATE_X, 0.0);
                G2.fill(this.led);
                G2.setTransform(OLD_TRANSFORM);
            }
            if (this.isPeakValueEnabled() && this.isPeakValueVisible()) {
                G2.translate(this.getCoordForValue(this.getPeakValue(), FULL_SIZE), 0.0);
                G2.fill(this.led);
                G2.setTransform(OLD_TRANSFORM);
            }
        }
    }

    @Override
    public void setValue(double value) {
        if (this.isValueCoupled()) {
            this.setLcdValue(value);
        }
        super.setValue(value);
    }

    @Override
    public ColorDef getBarGraphColor() {
        return this.barGraphColor;
    }

    @Override
    public void setBarGraphColor(ColorDef BARGRAPH_COLOR) {
        this.barGraphColor = BARGRAPH_COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    private void prepareBargraph(int WIDTH, int HEIGHT) {
        this.ledColors = this.barGraphColor != ColorDef.CUSTOM ? new Color[]{this.barGraphColor.LIGHT, this.barGraphColor.DARK} : new Color[]{this.getCustomBarGraphColorObject().LIGHT, this.getCustomBarGraphColorObject().DARK};
        if (this.getOrientation() == Orientation.VERTICAL) {
            this.led = new Rectangle2D.Double((double)WIDTH * 0.45, (double)HEIGHT * 0.8519417476, (double)WIDTH * 0.1214285714, (double)HEIGHT * 0.0121359223);
            this.ledCenter = new Point2D.Double(this.led.getCenterX(), this.led.getCenterY());
            if (!this.getSections().isEmpty()) {
                this.sectionGradients.clear();
                this.sectionOffsets.clear();
                double TOP = (double)HEIGHT * 0.12864077669902912;
                double BOTTOM = (double)HEIGHT * 0.8567961165048543;
                double FULL_SIZE = BOTTOM - TOP;
                for (Section section : this.getSections()) {
                    this.sectionGradients.put(section, new RadialGradientPaint(this.ledCenter, (float)(0.030373831775700934 * (double)WIDTH), this.LED_FRACTIONS, new Color[]{section.getColor().brighter(), section.getColor().darker()}));
                    this.sectionOffsets.put(section, new Point2D.Double(this.getCoordForValue(section.getStart(), FULL_SIZE), this.getCoordForValue(section.getStop(), FULL_SIZE)));
                }
            }
            this.ledGradient = new RadialGradientPaint(this.ledCenter, (float)(0.030373831775700934 * (double)WIDTH), this.LED_FRACTIONS, this.ledColors);
            this.ledInactiveGradient = new RadialGradientPaint(this.ledCenter, (float)(0.030373831775700934 * (double)WIDTH), this.LED_FRACTIONS, this.LED_INACTIVE_COLORS);
        } else {
            this.led = new Rectangle2D.Double((double)WIDTH * 0.14285714285714285, (double)HEIGHT * 0.45, (double)WIDTH * 0.0121359223, (double)HEIGHT * 0.1214285714);
            this.ledCenter = new Point2D.Double(this.led.getCenterX(), this.led.getCenterY());
            if (!this.getSections().isEmpty()) {
                this.sectionGradients.clear();
                this.sectionOffsets.clear();
                double TOP = (double)WIDTH * 0.8567961165048543;
                double BOTTOM = (double)WIDTH * 0.12864077669902912;
                double FULL_SIZE = TOP - BOTTOM;
                for (Section section : this.getSections()) {
                    this.sectionGradients.put(section, new RadialGradientPaint(this.ledCenter, (float)(0.030373831775700934 * (double)WIDTH), this.LED_FRACTIONS, new Color[]{section.getColor().brighter(), section.getColor().darker()}));
                    this.sectionOffsets.put(section, new Point2D.Double(this.getCoordForValue(section.getStart(), FULL_SIZE), this.getCoordForValue(section.getStop(), FULL_SIZE)));
                }
            }
            this.ledGradient = new RadialGradientPaint(this.ledCenter, (float)(0.030373831775700934 * (double)HEIGHT), this.LED_FRACTIONS, this.ledColors);
            this.ledInactiveGradient = new RadialGradientPaint(this.ledCenter, (float)(0.030373831775700934 * (double)HEIGHT), this.LED_FRACTIONS, this.LED_INACTIVE_COLORS);
        }
    }

    public boolean isTitleVisible() {
        return this.getModel().isTitleVisible();
    }

    public void setTitleVisible(boolean TITLE_VISIBLE) {
        this.getModel().setTitleVisible(TITLE_VISIBLE);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isTickmarksVisible() {
        return this.getModel().isTickmarksVisible();
    }

    @Override
    public void setTickmarksVisible(boolean TICKMARKS_VISIBLE) {
        this.getModel().setTickmarksVisible(TICKMARKS_VISIBLE);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] LCD_COLORS) {
        Point2D.Double FOREGROUND_STOP;
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (FOREGROUND_START.equals(FOREGROUND_STOP = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{LCD_COLORS[0], LCD_COLORS[1], LCD_COLORS[2], LCD_COLORS[3], LCD_COLORS[4]};
        return new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
    }

    private double getCoordForValue(double value, double FULL_SIZE) {
        return (value - this.getMinValue()) / (this.getMaxValue() - this.getMinValue()) * FULL_SIZE;
    }

    @Override
    protected Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    protected Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    @Override
    public String toString() {
        return "LinearBargraph";
    }
}

