/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.AutotestLogging;
import com.rusefi.FileLog;
import com.rusefi.NamedThreadFactory;
import com.rusefi.SimulatorFunctionalTestLauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class SimulatorExecHelper {
    private static final Logging log = Logging.getLogging(SimulatorExecHelper.class);
    private static final NamedThreadFactory THREAD_FACTORY = new NamedThreadFactory("SimulatorExecHelper", true);
    private static final String SIMULATOR_BUILD_RUSEFI_SIMULATOR = "../simulator/build/rusefi_simulator";
    private static final String SIMULATOR_BINARY = SimulatorExecHelper.getSimulatorBinary();
    private static Process simulatorProcess;

    private static String getSimulatorBinary() {
        return FileLog.isWindows() ? "../simulator/build/rusefi_simulator.exe" : SIMULATOR_BUILD_RUSEFI_SIMULATOR;
    }

    private static void runSimulator(CountDownLatch simulatorStarted) {
        Thread.currentThread().setName("Main simulation");
        AutotestLogging.INSTANCE.logLine("runSimulator...");
        try {
            AutotestLogging.INSTANCE.logLine("Binary size: " + new File(SIMULATOR_BINARY).length());
            AutotestLogging.INSTANCE.logLine("Executing " + SIMULATOR_BINARY);
            simulatorProcess = Runtime.getRuntime().exec(SIMULATOR_BINARY);
            AutotestLogging.INSTANCE.logLine("simulatorProcess: " + simulatorProcess);
            SimulatorExecHelper.dumpProcessOutput(simulatorProcess, simulatorStarted);
        }
        catch (Exception err) {
            if (SimulatorFunctionalTestLauncher.isHappy) {
                System.out.println("Already happy " + err);
            }
            throw new IllegalStateException(err);
        }
        try {
            AutotestLogging.INSTANCE.logLine("exitValue: " + simulatorProcess.exitValue());
        }
        catch (Exception err) {
            log.warn("Error reading exit value", err);
        }
        System.out.println("end of console");
    }

    public static void dumpProcessOutput(Process process, CountDownLatch countDownLatch) throws IOException {
        BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Thread thread = THREAD_FACTORY.newThread(SimulatorExecHelper.createErrorStreamEcho(process));
        thread.start();
        AtomicInteger counter = new AtomicInteger();
        String prefix = "from console: ";
        Consumer<String> PRINT_AND_LOG = string -> {
            if (countDownLatch != null) {
                countDownLatch.countDown();
            }
            if (counter.incrementAndGet() < 1000) {
                System.out.println(prefix + string);
            }
        };
        SimulatorExecHelper.readAndPrint(PRINT_AND_LOG, input);
        input.close();
    }

    private static void readAndPrint(Consumer<String> consumer, BufferedReader input) throws IOException {
        String line;
        while ((line = input.readLine()) != null) {
            consumer.accept(line);
        }
    }

    private static Runnable createErrorStreamEcho(Process process) {
        return () -> {
            BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            try {
                String prefix = "ERROR from console: ";
                Consumer<String> PRINT_AND_LOG = string -> {
                    System.out.println(prefix + string);
                    log.info((String)string);
                };
                SimulatorExecHelper.readAndPrint(PRINT_AND_LOG, err);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        };
    }

    static void destroy() {
        if (simulatorProcess != null) {
            log.info("Destroying sub-process...");
            simulatorProcess.destroy();
        }
    }

    public static void startSimulator() throws InterruptedException {
        if (!new File(SIMULATOR_BINARY).exists()) {
            throw new IllegalStateException(SIMULATOR_BINARY + " not found");
        }
        AutotestLogging.INSTANCE.logLine("startSimulator...");
        CountDownLatch simulatorStarted = new CountDownLatch(1);
        new Thread(() -> SimulatorExecHelper.runSimulator(simulatorStarted), "simulator process").start();
        simulatorStarted.await(1L, TimeUnit.MINUTES);
        log.info("Let's give it some time to start...");
        Thread.sleep(5000L);
    }
}

