/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.ContourGradientPaint;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Shadow;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public enum GlowImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private int radWidth = 0;
    private Color radGlowColor = Color.RED;
    private boolean radOn = false;
    private GaugeType radGaugeType = GaugeType.TYPE4;
    private boolean radKnobs;
    private Orientation radOrientation;
    private BufferedImage radGlowImage = this.UTIL.createImage(1, 1, 3);
    private int linWidth = 0;
    private int linHeight = 0;
    private Color linGlowColor = Color.RED;
    private boolean linOn = false;
    private BufferedImage linGlowImage = this.UTIL.createImage(1, 1, 3);
    private int lcdWidth = 0;
    private int lcdHeight = 0;
    private Color lcdGlowColor = Color.RED;
    private boolean lcdOn = false;
    private BufferedImage lcdGlowImage = this.UTIL.createImage(1, 1, 3);

    public BufferedImage createRadialGlow(int WIDTH, Color GLOW_COLOR, boolean ON, GaugeType GAUGE_TYPE, boolean KNOBS, Orientation ORIENTATION) {
        if (WIDTH <= 0) {
            return null;
        }
        if (this.radWidth == WIDTH && this.radGlowColor.equals(GLOW_COLOR) && this.radOn == ON && this.radGaugeType == GAUGE_TYPE && this.radKnobs == KNOBS && this.radOrientation == ORIENTATION) {
            return this.radGlowImage;
        }
        this.radGlowImage.flush();
        this.radGlowImage = this.UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = this.radGlowImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = this.radGlowImage.getWidth();
        int IMAGE_HEIGHT = this.radGlowImage.getHeight();
        Area GLOWRING = new Area(new Ellipse2D.Double((double)IMAGE_WIDTH * 0.0841121495, (double)IMAGE_WIDTH * 0.0841121495, (double)IMAGE_WIDTH * 0.8317757009, (double)IMAGE_WIDTH * 0.8317757009));
        Area TMP_RING = new Area(new Ellipse2D.Double((double)IMAGE_WIDTH * 0.1074766355, (double)IMAGE_WIDTH * 0.1074766355, (double)IMAGE_WIDTH * 0.785046729, (double)IMAGE_WIDTH * 0.785046729));
        GLOWRING.subtract(TMP_RING);
        if (!ON) {
            Point2D.Double GLOWRING_OFF_START = new Point2D.Double(0.0, GLOWRING.getBounds2D().getMinY());
            Point2D.Double GLOWRING_OFF_STOP = new Point2D.Double(0.0, GLOWRING.getBounds2D().getMaxY());
            float[] GLOWRING_OFF_FRACTIONS = new float[]{0.0f, 0.17f, 0.33f, 0.34f, 0.63f, 0.64f, 0.83f, 1.0f};
            Color[] GLOWRING_OFF_COLORS = new Color[]{new Color(204, 204, 204, 102), new Color(153, 153, 153, 102), new Color(252, 252, 252, 102), new Color(255, 255, 255, 102), new Color(204, 204, 204, 102), new Color(203, 203, 203, 102), new Color(153, 153, 153, 102), new Color(255, 255, 255, 102)};
            LinearGradientPaint GLOWRING_OFF_GRADIENT = new LinearGradientPaint(GLOWRING_OFF_START, GLOWRING_OFF_STOP, GLOWRING_OFF_FRACTIONS, GLOWRING_OFF_COLORS);
            G2.setPaint(GLOWRING_OFF_GRADIENT);
            G2.fill(GLOWRING);
        } else {
            Point2D.Double GLOWRING_ON_CENTER = new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
            float[] GLOWRING_ON_FRACTIONS = new float[]{0.0f, 0.8999999f, 0.9f, 0.95f, 1.0f};
            Color[] GLOWRING_ON_COLORS = new Color[]{this.UTIL.setAlpha(GLOW_COLOR, 0.6f), this.UTIL.setAlpha(GLOW_COLOR, 0.6f), this.UTIL.setSaturation(GLOW_COLOR, 0.6f), GLOW_COLOR, this.UTIL.setSaturation(GLOW_COLOR, 0.6f)};
            RadialGradientPaint GLOWRING_ON_GRADIENT = new RadialGradientPaint(GLOWRING_ON_CENTER, (float)(0.4158878504672897 * (double)IMAGE_WIDTH), GLOWRING_ON_FRACTIONS, GLOWRING_ON_COLORS);
            G2.setPaint(GLOWRING_ON_GRADIENT);
            BufferedImage CLIP_IMAGE_GLOWRING_ON = Shadow.INSTANCE.createSoftClipImage(GLOWRING, GLOWRING_ON_GRADIENT);
            G2.translate(-16, -16);
            G2.drawImage((Image)Shadow.INSTANCE.createDropShadow(CLIP_IMAGE_GLOWRING_ON, 0, 1.0f, 15, 315, GLOW_COLOR), GLOWRING.getBounds().x + 1, GLOWRING.getBounds().y + 1, null);
            G2.translate(16, 16);
            if (KNOBS) {
                Ellipse2D.Double POST_GLOW = new Ellipse2D.Double();
                Point2D.Double POST_GLOW_START = new Point2D.Double();
                Point2D.Double POST_GLOW_STOP = new Point2D.Double();
                float[] POST_GLOW_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
                Color[] POST_GLOW_COLORS = new Color[]{new Color(0, 0, 0, 0), this.UTIL.setAlpha(GLOW_COLOR, 0.0f), this.UTIL.setAlpha(GLOW_COLOR, 0.3f)};
                Ellipse2D.Double CENTER_GLOW = new Ellipse2D.Double();
                Point2D.Double CENTER_GLOW_CENTER = new Point2D.Double();
                float[] CENTER_GLOW_FRACTIONS = new float[]{0.0f, 0.5f, 0.98f, 1.0f};
                Color[] CENTER_GLOW_COLORS = new Color[]{this.UTIL.setAlpha(GLOW_COLOR, 0.0f), this.UTIL.setAlpha(GLOW_COLOR, 0.1f), this.UTIL.setAlpha(GLOW_COLOR, 0.2f), this.UTIL.setAlpha(GLOW_COLOR, 0.1f)};
                block0 : switch (GAUGE_TYPE) {
                    case TYPE1: {
                        ((RectangularShape)POST_GLOW).setFrame((double)IMAGE_WIDTH * 0.13084112107753754, (double)IMAGE_HEIGHT * 0.514018714427948, (double)IMAGE_WIDTH * 0.0373831776, (double)IMAGE_WIDTH * 0.0373831776);
                        ((Point2D)POST_GLOW_START).setLocation(POST_GLOW.getMaxX(), POST_GLOW.getCenterY());
                        ((Point2D)POST_GLOW_STOP).setLocation(POST_GLOW.getMinX(), POST_GLOW.getCenterY());
                        LinearGradientPaint postGlowGradient = new LinearGradientPaint(POST_GLOW_START, POST_GLOW_STOP, POST_GLOW_FRACTIONS, POST_GLOW_COLORS);
                        G2.setPaint(postGlowGradient);
                        G2.fill(POST_GLOW);
                        ((RectangularShape)POST_GLOW).setFrame((double)IMAGE_WIDTH * 0.5233644843101501, (double)IMAGE_HEIGHT * 0.13084112107753754, (double)IMAGE_WIDTH * 0.0373831776, (double)IMAGE_WIDTH * 0.0373831776);
                        ((Point2D)POST_GLOW_START).setLocation(POST_GLOW.getCenterX(), POST_GLOW.getMaxY());
                        ((Point2D)POST_GLOW_STOP).setLocation(POST_GLOW.getCenterX(), POST_GLOW.getMinY());
                        postGlowGradient = new LinearGradientPaint(POST_GLOW_START, POST_GLOW_STOP, POST_GLOW_FRACTIONS, POST_GLOW_COLORS);
                        G2.setPaint(postGlowGradient);
                        G2.fill(POST_GLOW);
                        ((RectangularShape)CENTER_GLOW).setFrame((double)IMAGE_WIDTH * 0.4579439252, (double)IMAGE_WIDTH * 0.4579439252, (double)IMAGE_WIDTH * 0.0841121495, (double)IMAGE_WIDTH * 0.0841121495);
                        ((Point2D)CENTER_GLOW_CENTER).setLocation(CENTER_GLOW.getCenterX(), CENTER_GLOW.getCenterY());
                        RadialGradientPaint centerGlowGradient = new RadialGradientPaint(CENTER_GLOW_CENTER, (float)(((RectangularShape)CENTER_GLOW).getWidth() / 2.0), CENTER_GLOW_FRACTIONS, CENTER_GLOW_COLORS);
                        G2.setPaint(centerGlowGradient);
                        G2.fill(CENTER_GLOW);
                        break;
                    }
                    case TYPE2: {
                        ((RectangularShape)POST_GLOW).setFrame((double)IMAGE_WIDTH * 0.13084112107753754, (double)IMAGE_HEIGHT * 0.514018714427948, (double)IMAGE_WIDTH * 0.0373831776, (double)IMAGE_WIDTH * 0.0373831776);
                        ((Point2D)POST_GLOW_START).setLocation(POST_GLOW.getMaxX(), POST_GLOW.getCenterY());
                        ((Point2D)POST_GLOW_STOP).setLocation(POST_GLOW.getMinX(), POST_GLOW.getCenterY());
                        LinearGradientPaint postGlowGradient = new LinearGradientPaint(POST_GLOW_START, POST_GLOW_STOP, POST_GLOW_FRACTIONS, POST_GLOW_COLORS);
                        G2.setPaint(postGlowGradient);
                        G2.fill(POST_GLOW);
                        ((RectangularShape)POST_GLOW).setFrame((double)IMAGE_WIDTH * 0.8317757248878479, (double)IMAGE_HEIGHT * 0.514018714427948, (double)IMAGE_WIDTH * 0.0373831776, (double)IMAGE_WIDTH * 0.0373831776);
                        ((Point2D)POST_GLOW_START).setLocation(POST_GLOW.getMinX(), POST_GLOW.getCenterY());
                        ((Point2D)POST_GLOW_STOP).setLocation(POST_GLOW.getMaxX(), POST_GLOW.getCenterY());
                        postGlowGradient = new LinearGradientPaint(POST_GLOW_START, POST_GLOW_STOP, POST_GLOW_FRACTIONS, POST_GLOW_COLORS);
                        G2.setPaint(postGlowGradient);
                        G2.fill(POST_GLOW);
                        ((RectangularShape)CENTER_GLOW).setFrame((double)IMAGE_WIDTH * 0.4579439252, (double)IMAGE_WIDTH * 0.4579439252, (double)IMAGE_WIDTH * 0.0841121495, (double)IMAGE_WIDTH * 0.0841121495);
                        ((Point2D)CENTER_GLOW_CENTER).setLocation(CENTER_GLOW.getCenterX(), CENTER_GLOW.getCenterY());
                        RadialGradientPaint centerGlowGradient = new RadialGradientPaint(CENTER_GLOW_CENTER, (float)(((RectangularShape)CENTER_GLOW).getWidth() / 2.0), CENTER_GLOW_FRACTIONS, CENTER_GLOW_COLORS);
                        G2.setPaint(centerGlowGradient);
                        G2.fill(CENTER_GLOW);
                        break;
                    }
                    case TYPE3: {
                        ((RectangularShape)POST_GLOW).setFrame((double)IMAGE_WIDTH * 0.5233644843101501, (double)IMAGE_HEIGHT * 0.8317757248878479, (double)IMAGE_WIDTH * 0.0373831776, (double)IMAGE_WIDTH * 0.0373831776);
                        ((Point2D)POST_GLOW_START).setLocation(POST_GLOW.getCenterX(), POST_GLOW.getMinY());
                        ((Point2D)POST_GLOW_STOP).setLocation(POST_GLOW.getCenterX(), POST_GLOW.getMaxY());
                        LinearGradientPaint postGlowGradient = new LinearGradientPaint(POST_GLOW_START, POST_GLOW_STOP, POST_GLOW_FRACTIONS, POST_GLOW_COLORS);
                        G2.setPaint(postGlowGradient);
                        G2.fill(POST_GLOW);
                        ((RectangularShape)POST_GLOW).setFrame((double)IMAGE_WIDTH * 0.8317757248878479, (double)IMAGE_HEIGHT * 0.514018714427948, (double)IMAGE_WIDTH * 0.0373831776, (double)IMAGE_WIDTH * 0.0373831776);
                        ((Point2D)POST_GLOW_START).setLocation(POST_GLOW.getMinX(), POST_GLOW.getCenterY());
                        ((Point2D)POST_GLOW_STOP).setLocation(POST_GLOW.getMaxX(), POST_GLOW.getCenterY());
                        postGlowGradient = new LinearGradientPaint(POST_GLOW_START, POST_GLOW_STOP, POST_GLOW_FRACTIONS, POST_GLOW_COLORS);
                        G2.setPaint(postGlowGradient);
                        G2.fill(POST_GLOW);
                        ((RectangularShape)CENTER_GLOW).setFrame((double)IMAGE_WIDTH * 0.4579439252, (double)IMAGE_WIDTH * 0.4579439252, (double)IMAGE_WIDTH * 0.0841121495, (double)IMAGE_WIDTH * 0.0841121495);
                        ((Point2D)CENTER_GLOW_CENTER).setLocation(CENTER_GLOW.getCenterX(), CENTER_GLOW.getCenterY());
                        RadialGradientPaint centerGlowGradient = new RadialGradientPaint(CENTER_GLOW_CENTER, (float)(((RectangularShape)CENTER_GLOW).getWidth() / 2.0), CENTER_GLOW_FRACTIONS, CENTER_GLOW_COLORS);
                        G2.setPaint(centerGlowGradient);
                        G2.fill(CENTER_GLOW);
                        break;
                    }
                    case TYPE5: {
                        switch (ORIENTATION) {
                            case WEST: {
                                ((RectangularShape)POST_GLOW).setFrame((double)IMAGE_WIDTH * 0.4485981308, (double)IMAGE_HEIGHT * 0.7803738318, (double)IMAGE_WIDTH * 0.0373831776, (double)IMAGE_WIDTH * 0.0373831776);
                                ((Point2D)POST_GLOW_START).setLocation(POST_GLOW.getCenterX(), POST_GLOW.getMinY());
                                ((Point2D)POST_GLOW_STOP).setLocation(POST_GLOW.getCenterX(), POST_GLOW.getMaxY());
                                LinearGradientPaint postGlowGradient = new LinearGradientPaint(POST_GLOW_START, POST_GLOW_STOP, POST_GLOW_FRACTIONS, POST_GLOW_COLORS);
                                G2.setPaint(postGlowGradient);
                                G2.fill(POST_GLOW);
                                ((RectangularShape)POST_GLOW).setFrame((double)IMAGE_WIDTH * 0.4485981308, (double)IMAGE_HEIGHT * 0.1822429907, (double)IMAGE_WIDTH * 0.0373831776, (double)IMAGE_WIDTH * 0.0373831776);
                                ((Point2D)POST_GLOW_START).setLocation(POST_GLOW.getCenterX(), POST_GLOW.getMaxY());
                                ((Point2D)POST_GLOW_STOP).setLocation(POST_GLOW.getCenterX(), POST_GLOW.getMinY());
                                postGlowGradient = new LinearGradientPaint(POST_GLOW_START, POST_GLOW_STOP, POST_GLOW_FRACTIONS, POST_GLOW_COLORS);
                                G2.setPaint(postGlowGradient);
                                G2.fill(POST_GLOW);
                                ((RectangularShape)CENTER_GLOW).setFrame((double)IMAGE_WIDTH * 0.691588785, (double)IMAGE_WIDTH * 0.4579439252, (double)IMAGE_WIDTH * 0.0841121495, (double)IMAGE_WIDTH * 0.0841121495);
                                LinearGradientPaint centerGlowGradient = new LinearGradientPaint(new Point2D.Double(CENTER_GLOW.getMinX(), CENTER_GLOW.getCenterY()), new Point2D.Double(CENTER_GLOW.getMaxX(), CENTER_GLOW.getCenterY()), CENTER_GLOW_FRACTIONS, CENTER_GLOW_COLORS);
                                G2.setPaint(centerGlowGradient);
                                G2.fill(CENTER_GLOW);
                                break block0;
                            }
                        }
                        ((RectangularShape)POST_GLOW).setFrame((double)IMAGE_WIDTH * 0.1822429907, (double)IMAGE_HEIGHT * 0.4485981308, (double)IMAGE_WIDTH * 0.0373831776, (double)IMAGE_WIDTH * 0.0373831776);
                        ((Point2D)POST_GLOW_START).setLocation(POST_GLOW.getMaxX(), POST_GLOW.getCenterY());
                        ((Point2D)POST_GLOW_STOP).setLocation(POST_GLOW.getMinX(), POST_GLOW.getCenterY());
                        LinearGradientPaint postGlowGradient = new LinearGradientPaint(POST_GLOW_START, POST_GLOW_STOP, POST_GLOW_FRACTIONS, POST_GLOW_COLORS);
                        G2.setPaint(postGlowGradient);
                        G2.fill(POST_GLOW);
                        ((RectangularShape)POST_GLOW).setFrame((double)IMAGE_WIDTH * 0.7803738318, (double)IMAGE_HEIGHT * 0.4485981308, (double)IMAGE_WIDTH * 0.0373831776, (double)IMAGE_WIDTH * 0.0373831776);
                        ((Point2D)POST_GLOW_START).setLocation(POST_GLOW.getMinX(), POST_GLOW.getCenterY());
                        ((Point2D)POST_GLOW_STOP).setLocation(POST_GLOW.getMaxX(), POST_GLOW.getCenterY());
                        postGlowGradient = new LinearGradientPaint(POST_GLOW_START, POST_GLOW_STOP, POST_GLOW_FRACTIONS, POST_GLOW_COLORS);
                        G2.setPaint(postGlowGradient);
                        G2.fill(POST_GLOW);
                        ((RectangularShape)CENTER_GLOW).setFrame((double)IMAGE_WIDTH * 0.4579439252, (double)IMAGE_WIDTH * 0.691588785, (double)IMAGE_WIDTH * 0.0841121495, (double)IMAGE_WIDTH * 0.0841121495);
                        LinearGradientPaint centerGlowGradient = new LinearGradientPaint(new Point2D.Double(CENTER_GLOW.getCenterX(), CENTER_GLOW.getMinY()), new Point2D.Double(CENTER_GLOW.getCenterX(), CENTER_GLOW.getMaxY()), CENTER_GLOW_FRACTIONS, CENTER_GLOW_COLORS);
                        G2.setPaint(centerGlowGradient);
                        G2.fill(CENTER_GLOW);
                        break;
                    }
                    default: {
                        ((RectangularShape)POST_GLOW).setFrame((double)IMAGE_WIDTH * 0.336448609828949, (double)IMAGE_HEIGHT * 0.8037382960319519, (double)IMAGE_WIDTH * 0.0373831776, (double)IMAGE_WIDTH * 0.0373831776);
                        ((Point2D)POST_GLOW_START).setLocation(POST_GLOW.getMaxX(), POST_GLOW.getMinY());
                        ((Point2D)POST_GLOW_STOP).setLocation(POST_GLOW.getMinX(), POST_GLOW.getMaxY());
                        LinearGradientPaint postGlowGradient = new LinearGradientPaint(POST_GLOW_START, POST_GLOW_STOP, POST_GLOW_FRACTIONS, POST_GLOW_COLORS);
                        G2.setPaint(postGlowGradient);
                        G2.fill(POST_GLOW);
                        ((RectangularShape)POST_GLOW).setFrame((double)IMAGE_WIDTH * 0.6261682510375977, (double)IMAGE_HEIGHT * 0.8037382960319519, (double)IMAGE_WIDTH * 0.0373831776, (double)IMAGE_WIDTH * 0.0373831776);
                        ((Point2D)POST_GLOW_START).setLocation(POST_GLOW.getMinX(), POST_GLOW.getMinY());
                        ((Point2D)POST_GLOW_STOP).setLocation(POST_GLOW.getMaxX(), POST_GLOW.getMaxY());
                        postGlowGradient = new LinearGradientPaint(POST_GLOW_START, POST_GLOW_STOP, POST_GLOW_FRACTIONS, POST_GLOW_COLORS);
                        G2.setPaint(postGlowGradient);
                        G2.fill(POST_GLOW);
                        ((RectangularShape)CENTER_GLOW).setFrame((double)IMAGE_WIDTH * 0.4579439252, (double)IMAGE_WIDTH * 0.4579439252, (double)IMAGE_WIDTH * 0.0841121495, (double)IMAGE_WIDTH * 0.0841121495);
                        ((Point2D)CENTER_GLOW_CENTER).setLocation(CENTER_GLOW.getCenterX(), CENTER_GLOW.getCenterY());
                        RadialGradientPaint centerGlowGradient = new RadialGradientPaint(CENTER_GLOW_CENTER, (float)(((RectangularShape)CENTER_GLOW).getWidth() / 2.0), CENTER_GLOW_FRACTIONS, CENTER_GLOW_COLORS);
                        G2.setPaint(centerGlowGradient);
                        G2.fill(CENTER_GLOW);
                    }
                }
            }
        }
        Area GLOWRING_HL = new Area(new Arc2D.Double((double)IMAGE_WIDTH * 0.0841121495, (double)IMAGE_WIDTH * 0.0841121495, (double)IMAGE_WIDTH * 0.8317757009, (double)IMAGE_WIDTH * 0.8317757009, 270.0, 114.0, 2));
        GLOWRING_HL.subtract(TMP_RING);
        Point2D.Double GLOWRING_HL_LOWERRIGHT_CENTER = new Point2D.Double(0.7336448598130841 * (double)IMAGE_WIDTH, 0.8364485981308412 * (double)IMAGE_HEIGHT);
        float[] GLOWRING_HL_LOWERRIGHT_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] GLOWRING_HL_LOWERRIGHT_COLORS = new Color[]{new Color(255, 255, 255, 140), new Color(255, 255, 255, 0)};
        RadialGradientPaint GLOWRING_HL_LOWERRIGHT_GRADIENT = new RadialGradientPaint(GLOWRING_HL_LOWERRIGHT_CENTER, (float)(0.23598130841121495 * (double)IMAGE_WIDTH), GLOWRING_HL_LOWERRIGHT_FRACTIONS, GLOWRING_HL_LOWERRIGHT_COLORS);
        G2.setPaint(GLOWRING_HL_LOWERRIGHT_GRADIENT);
        G2.fill(GLOWRING_HL);
        G2.dispose();
        this.radWidth = WIDTH;
        this.radGlowColor = GLOW_COLOR;
        this.radOn = ON;
        this.radGaugeType = GAUGE_TYPE;
        this.radKnobs = KNOBS;
        this.radOrientation = ORIENTATION;
        return this.radGlowImage;
    }

    public BufferedImage createLinearGlow(int WIDTH, int HEIGHT, Color GLOW_COLOR, boolean ON) {
        if (WIDTH <= 32 || HEIGHT <= 32) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.linWidth == WIDTH && this.linHeight == HEIGHT && this.linGlowColor.equals(GLOW_COLOR) && this.linOn == ON) {
            return this.linGlowImage;
        }
        this.linGlowImage.flush();
        this.linGlowImage = this.UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = this.linGlowImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = WIDTH;
        int IMAGE_HEIGHT = HEIGHT;
        double OUTER_FRAME_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? (double)IMAGE_HEIGHT * 0.05 : (double)IMAGE_WIDTH * 0.05;
        RoundRectangle2D.Double OUTER_FRAME = new RoundRectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT, OUTER_FRAME_CORNER_RADIUS, OUTER_FRAME_CORNER_RADIUS);
        double FRAME_MAIN_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? OUTER_FRAME_CORNER_RADIUS - (((RectangularShape)OUTER_FRAME).getHeight() - (double)IMAGE_HEIGHT - 2.0) / 2.0 : OUTER_FRAME_CORNER_RADIUS - (((RectangularShape)OUTER_FRAME).getWidth() - (double)IMAGE_WIDTH - 2.0) / 2.0;
        RoundRectangle2D.Double FRAME_MAIN = new RoundRectangle2D.Double(1.0, 1.0, IMAGE_WIDTH - 2, IMAGE_HEIGHT - 2, FRAME_MAIN_CORNER_RADIUS, FRAME_MAIN_CORNER_RADIUS);
        double INNER_FRAME_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? (double)IMAGE_HEIGHT * 0.02857143 : (double)IMAGE_WIDTH * 0.02857143;
        RoundRectangle2D.Double INNER_FRAME = new RoundRectangle2D.Double(((RectangularShape)FRAME_MAIN).getX() + 16.0, ((RectangularShape)FRAME_MAIN).getY() + 16.0, ((RectangularShape)FRAME_MAIN).getWidth() - 32.0, ((RectangularShape)FRAME_MAIN).getHeight() - 32.0, INNER_FRAME_CORNER_RADIUS, INNER_FRAME_CORNER_RADIUS);
        double BACKGROUND_CORNER_RADIUS = INNER_FRAME_CORNER_RADIUS - 1.0;
        Area GLOWRING = new Area(new RoundRectangle2D.Double(((RectangularShape)INNER_FRAME).getX() + 1.0, ((RectangularShape)INNER_FRAME).getY() + 1.0, ((RectangularShape)INNER_FRAME).getWidth() - 2.0, ((RectangularShape)INNER_FRAME).getHeight() - 2.0, BACKGROUND_CORNER_RADIUS, BACKGROUND_CORNER_RADIUS));
        Area TMP_RING = new Area(new RoundRectangle2D.Double(((RectangularShape)INNER_FRAME).getX() + 6.0, ((RectangularShape)INNER_FRAME).getY() + 6.0, ((RectangularShape)INNER_FRAME).getWidth() - 12.0, ((RectangularShape)INNER_FRAME).getHeight() - 12.0, BACKGROUND_CORNER_RADIUS, BACKGROUND_CORNER_RADIUS));
        GLOWRING.subtract(TMP_RING);
        if (!ON) {
            Point2D.Double GLOWRING_OFF_START = new Point2D.Double(0.0, GLOWRING.getBounds2D().getMinY());
            Point2D.Double GLOWRING_OFF_STOP = new Point2D.Double(0.0, GLOWRING.getBounds2D().getMaxY());
            float[] GLOWRING_OFF_FRACTIONS = new float[]{0.0f, 0.17f, 0.33f, 0.34f, 0.63f, 0.64f, 0.83f, 1.0f};
            Color[] GLOWRING_OFF_COLORS = new Color[]{new Color(204, 204, 204, 102), new Color(153, 153, 153, 102), new Color(252, 252, 252, 102), new Color(255, 255, 255, 102), new Color(204, 204, 204, 102), new Color(203, 203, 203, 102), new Color(153, 153, 153, 102), new Color(255, 255, 255, 102)};
            LinearGradientPaint GLOWRING_OFF_GRADIENT = new LinearGradientPaint(GLOWRING_OFF_START, GLOWRING_OFF_STOP, GLOWRING_OFF_FRACTIONS, GLOWRING_OFF_COLORS);
            G2.setPaint(GLOWRING_OFF_GRADIENT);
            G2.fill(GLOWRING);
        } else {
            float relFrameSize = WIDTH >= HEIGHT ? 10.0f / (float)GLOWRING.getBounds().height : 10.0f / (float)GLOWRING.getBounds().width;
            float[] GLOWRING_ON_FRACTIONS = new float[]{0.0f, relFrameSize * 0.1f, relFrameSize * 0.5f, relFrameSize, 1.0f};
            Color[] GLOWRING_ON_COLORS = new Color[]{this.UTIL.setAlpha(GLOW_COLOR, 0.0f), this.UTIL.setSaturation(GLOW_COLOR, 0.6f), GLOW_COLOR, this.UTIL.setSaturation(GLOW_COLOR, 0.6f), this.UTIL.setAlpha(GLOW_COLOR, 0.0f)};
            ContourGradientPaint GLOWRING_ON_GRADIENT = new ContourGradientPaint(GLOWRING.getBounds2D(), GLOWRING_ON_FRACTIONS, GLOWRING_ON_COLORS);
            G2.setPaint(GLOWRING_ON_GRADIENT);
            G2.translate(-10, -10);
            G2.drawImage((Image)Shadow.INSTANCE.createDropShadow(GLOWRING, GLOWRING_ON_GRADIENT, GLOW_COLOR, true, null, null, 0, 1.0f, 10, 315, GLOW_COLOR), GLOWRING.getBounds().x, GLOWRING.getBounds().y, null);
            G2.translate(10, 10);
            Point2D.Double GLOWRING_HL_START = new Point2D.Double(GLOWRING.getBounds2D().getCenterX(), GLOWRING.getBounds2D().getMinY());
            Point2D.Double GLOWRING_HL_STOP = new Point2D.Double(GLOWRING.getBounds2D().getCenterX(), GLOWRING.getBounds2D().getMaxY());
            float[] GLOWRING_HL_FRACTIONS = new float[]{0.0f, 0.1f, 0.2f, 0.2001f, 0.27f, 0.41f, 0.42f, 0.48f, 0.48009998f, 0.55f, 0.5501f, 0.92f, 0.93f, 0.97f, 0.99f, 1.0f};
            Color[] GLOWRING_HL_COLORS = new Color[]{new Color(255, 255, 255, 140), new Color(255, 255, 255, 0), new Color(255, 255, 255, 50), new Color(255, 255, 255, 60), new Color(255, 255, 255, 45), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 80), new Color(255, 255, 255, 95), new Color(255, 255, 255, 24), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 124), new Color(255, 255, 255, 164)};
            LinearGradientPaint GLOWRING_HL_GRADIENT = new LinearGradientPaint(GLOWRING_HL_START, GLOWRING_HL_STOP, GLOWRING_HL_FRACTIONS, GLOWRING_HL_COLORS);
            G2.setPaint(GLOWRING_HL_GRADIENT);
            G2.fill(GLOWRING);
        }
        G2.dispose();
        this.linWidth = WIDTH;
        this.linHeight = HEIGHT;
        this.linGlowColor = GLOW_COLOR;
        this.linOn = ON;
        return this.linGlowImage;
    }

    public BufferedImage createLcdGlow(int WIDTH, int HEIGHT, Color GLOW_COLOR, boolean ON) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.lcdWidth == WIDTH && this.lcdHeight == HEIGHT && this.lcdGlowColor.equals(GLOW_COLOR) && this.lcdOn == ON) {
            return this.lcdGlowImage;
        }
        this.lcdGlowImage.flush();
        this.lcdGlowImage = this.UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = this.lcdGlowImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        double CORNER_RADIUS = WIDTH > HEIGHT ? (double)HEIGHT * 0.095 - 1.0 : (double)WIDTH * 0.095 - 1.0;
        RoundRectangle2D.Double GLOWRING = new RoundRectangle2D.Double(1.0, 1.0, WIDTH - 2, HEIGHT - 2 - 1, CORNER_RADIUS, CORNER_RADIUS);
        Color[] GLOW_COLORS = new Color[]{this.UTIL.setAlpha(GLOW_COLOR, 0.65f), this.UTIL.setAlpha(GLOW_COLOR, 0.32f), this.UTIL.setAlpha(GLOW_COLOR, 0.18f), this.UTIL.setAlpha(GLOW_COLOR, 0.07f), this.UTIL.setAlpha(GLOW_COLOR, 0.03f), this.UTIL.setAlpha(GLOW_COLOR, 0.01f)};
        for (int i = 0; i < 6; ++i) {
            G2.setColor(GLOW_COLORS[i]);
            ((RoundRectangle2D)GLOWRING).setRoundRect(i + 1, i + 1, WIDTH - 2 - i * 2, HEIGHT - 2 - i * 2, CORNER_RADIUS, CORNER_RADIUS);
            G2.draw(GLOWRING);
        }
        G2.dispose();
        this.lcdWidth = WIDTH;
        this.lcdHeight = HEIGHT;
        this.lcdGlowColor = GLOW_COLOR;
        this.lcdOn = ON;
        return this.lcdGlowImage;
    }
}

