/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.camick.RXTextUtilities;
import com.devexperts.logging.Logging;
import com.rusefi.CodeWalkthrough;
import com.rusefi.config.Field;
import com.rusefi.core.Sensor;
import com.rusefi.enums.live_data_e;
import com.rusefi.ldmp.StateDictionary;
import com.rusefi.livedata.LiveDataParserPanel;
import com.rusefi.livedata.ParseResult;
import com.rusefi.livedata.generated.CPP14Parser;
import com.rusefi.ui.InitOnFirstPaintPanel;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.IntGaugeLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.putgemin.VerticalFlowLayout;

public class LiveDataPane {
    private static final Logging log = Logging.getLogging(LiveDataPane.class);
    public static final String CPP_SUFFIX = ".cpp";
    private final JPanel content = new JPanel(new BorderLayout());
    private boolean isPaused;

    private LiveDataPane(UIContext uiContext) {
        long start = System.currentTimeMillis();
        JPanel vertical = new JPanel(new MigLayout("wrap 1", "[grow,fill]"));
        vertical.setBorder(BorderFactory.createLineBorder(Color.orange));
        final JScrollPane scroll = new JScrollPane(vertical, 22, 30);
        JPanel legend = this.populateLegend();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (live_data_e view : live_data_e.values()) {
            String fileName = StateDictionary.INSTANCE.getFileName(view) + CPP_SUFFIX;
            Field[] values = StateDictionary.INSTANCE.getFields(view);
            LiveDataParserPanel liveDataParserPanel = LiveDataParserPanel.createLiveDataParserPanel(uiContext, view, values, fileName);
            ParseResult parseResult = liveDataParserPanel.getParseResult();
            JPanel liveDataParserContent = liveDataParserPanel.getContent();
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(fileName);
            child.setUserObject(new PanelAndName(liveDataParserContent, fileName));
            for (CPP14Parser.UnqualifiedIdContext functionId : parseResult.getFunctions()) {
                DefaultMutableTreeNode methodNode = new DefaultMutableTreeNode();
                methodNode.setUserObject(new SpecificMethod(liveDataParserPanel, functionId));
                child.add(methodNode);
            }
            root.add(child);
            vertical.add((Component)liveDataParserContent, "grow, wrap");
        }
        final JTree tree = new JTree(new DefaultTreeModel(root));
        tree.setRootVisible(false);
        tree.getSelectionModel().setSelectionMode(1);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                Object payload = node.getUserObject();
                if (payload instanceof PanelAndName) {
                    PanelAndName panel = (PanelAndName)payload;
                    this.scrollToPanel(panel.panel, 0);
                } else if (payload instanceof SpecificMethod) {
                    Rectangle r;
                    SpecificMethod method = (SpecificMethod)payload;
                    JTextPane jTextPane = method.liveDataParserPanel.getText();
                    int position = RXTextUtilities.getStartOfLineOffset(jTextPane, method.method.getStart().getLine());
                    try {
                        r = jTextPane.modelToView(position);
                    }
                    catch (BadLocationException ex) {
                        return;
                    }
                    this.scrollToPanel(method.liveDataParserPanel.getContent(), r.y);
                }
            }

            private void scrollToPanel(JPanel panel, int yOffset) {
                scroll.getVerticalScrollBar().setValue(panel.getLocation().y + yOffset);
                scroll.requestFocus();
            }
        };
        tree.addMouseListener(ml);
        this.content.add((Component)tree, "West");
        this.content.add((Component)scroll, "Center");
        this.content.add((Component)legend, "East");
        final JButton pauseButton = UiUtils.createPauseButton();
        pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveDataPane.this.isPaused = !LiveDataPane.this.isPaused;
                UiUtils.setPauseButtonText(pauseButton, LiveDataPane.this.isPaused);
            }
        });
        JPanel topButtonsPanel = new JPanel(new FlowLayout());
        this.content.add((Component)topButtonsPanel, "North");
        JPanel bottomPanel = new JPanel(new FlowLayout());
        bottomPanel.add(new IntGaugeLabel("count", Sensor.totalTriggerErrorCounter));
        bottomPanel.add(new IntGaugeLabel("error", Sensor.lastErrorCode));
        this.content.add((Component)bottomPanel, "South");
        log.info("created in " + (System.currentTimeMillis() - start) + "ms");
    }

    public static InitOnFirstPaintPanel createLazy(final UIContext uiContext) {
        InitOnFirstPaintPanel panel = new InitOnFirstPaintPanel(){

            @Override
            protected JPanel createContent() {
                return new LiveDataPane(uiContext).getContent();
            }
        };
        return panel;
    }

    @NotNull
    private JPanel populateLegend() {
        JPanel legend = new JPanel(new VerticalFlowLayout());
        legend.add(new JLabel("Legend:"));
        legend.add(this.createLabel(CodeWalkthrough.TRUE_CONDITION, "'true' condition"));
        legend.add(this.createLabel(CodeWalkthrough.FALSE_CONDITION, "'false' condition"));
        legend.add(this.createLabel(CodeWalkthrough.PASSIVE_CODE, "inactive code"));
        legend.add(this.createLabel(CodeWalkthrough.ACTIVE_STATEMENT, "active branch"));
        legend.add(this.createLabel(CodeWalkthrough.BROKEN_CODE, "No live data"));
        return legend;
    }

    @NotNull
    private JLabel createLabel(Color background, String text) {
        JLabel label = new JLabel(text);
        label.setOpaque(true);
        label.setBackground(background);
        return label;
    }

    public JPanel getContent() {
        return this.content;
    }

    static class SpecificMethod {
        private final LiveDataParserPanel liveDataParserPanel;
        private final CPP14Parser.UnqualifiedIdContext method;

        public SpecificMethod(LiveDataParserPanel liveDataParserPanel, CPP14Parser.UnqualifiedIdContext method) {
            this.liveDataParserPanel = liveDataParserPanel;
            this.method = method;
        }

        public LiveDataParserPanel getLiveDataParserPanel() {
            return this.liveDataParserPanel;
        }

        public String toString() {
            return this.method.getText();
        }
    }

    static class PanelAndName {
        public final JPanel panel;
        public final String name;

        public PanelAndName(JPanel panel, String name) {
            this.panel = panel;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

