/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini.field;

import com.opensr5.ConfigurationImage;
import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.ScalarIniField;
import com.rusefi.config.Field;
import com.rusefi.config.FieldType;
import com.rusefi.tune.xml.Constant;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class ArrayIniField
extends IniField {
    private final FieldType type;
    private final int cols;
    private final int rows;
    private final double multiplier;
    private final String digits;

    public ArrayIniField(String name, int offset, FieldType type, int cols, int rows, String unit, double multiplier, String digits) {
        super(name, offset);
        this.type = type;
        this.cols = cols;
        this.rows = rows;
        this.multiplier = multiplier;
        this.digits = digits;
    }

    public FieldType getType() {
        return this.type;
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public String getDigits() {
        return this.digits;
    }

    @Override
    public int getSize() {
        return this.type.getStorageSize() * this.cols * this.rows;
    }

    @Override
    public String getValue(ConfigurationImage image) {
        StringBuilder sb = new StringBuilder();
        for (int rowIndex = 0; rowIndex < this.rows; ++rowIndex) {
            sb.append("\n        ");
            for (int colIndex = 0; colIndex < this.cols; ++colIndex) {
                Field f = new Field(this.getName() + "_" + colIndex, this.getOffset(rowIndex, colIndex), this.getType());
                sb.append(' ');
                sb.append(f.getAnyValue(image, this.multiplier));
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    private int getOffset(int rowIndex, int colIndex) {
        return this.getOffset() + (rowIndex * this.cols + colIndex) * this.getType().getStorageSize();
    }

    @Override
    public void setValue(ConfigurationImage image, Constant constant) {
        String[] values = constant.getValue().trim().split("\\s+");
        if (values.length != this.getRows() * this.getCols()) {
            throw new IllegalStateException(values.length + " values while expecting " + this.getRows() + " by " + this.getCols() + " total " + this.getRows() * this.getCols());
        }
        for (int rowIndex = 0; rowIndex < this.rows; ++rowIndex) {
            for (int colIndex = 0; colIndex < this.cols; ++colIndex) {
                String value = values[rowIndex * this.cols + colIndex];
                ByteBuffer wrapped = image.getByteBuffer(this.getOffset(rowIndex, colIndex), this.type.getStorageSize());
                ScalarIniField.setValue(wrapped, this.type, value, -1, this.multiplier);
            }
        }
    }

    public String toString() {
        return "ArrayIniField{name=" + this.getName() + ", offset=" + this.getOffset() + ", type=" + (Object)((Object)this.type) + ", cols=" + this.cols + ", rows=" + this.rows + '}';
    }

    public static IniField parse(LinkedList<String> list) {
        int rows;
        int cols;
        String name = list.get(0);
        FieldType type = FieldType.parseTs(list.get(2));
        int offset = Integer.parseInt(list.get(3));
        String size = list.get(4);
        String unit = list.size() > 5 ? list.get(5) : "error";
        String digits = list.size() > 10 ? list.get(10) : "0";
        double multiplier = IniField.parseDouble(list.size() > 6 ? list.get(6) : "1");
        String[] dimentions = (size = size.replaceAll("[\\]\\[x]", " ").trim()).split(" ");
        if (dimentions.length == 1) {
            cols = 1;
            rows = Integer.parseInt(dimentions[0]);
        } else if (dimentions.length == 2) {
            cols = Integer.parseInt(dimentions[0]);
            rows = Integer.parseInt(dimentions[1]);
        } else {
            throw new IllegalStateException("Unexpected " + size);
        }
        return new ArrayIniField(name, offset, type, cols, rows, unit, multiplier, digits);
    }
}

