/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.devexperts.logging.Logging;
import com.rusefi.FileLog;
import com.rusefi.core.io.BundleUtil;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.ui.StatusConsumer;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class StatusWindow
implements StatusConsumer,
UpdateOperationCallbacks {
    private static final Logging log = Logging.getLogging(StatusWindow.class);
    private static final Color LIGHT_RED = new Color(255, 102, 102);
    private static final Color LIGHT_GREEN = new Color(102, 255, 102);
    private final JTextArea logTextArea = new JTextArea();
    private final JPanel content = new JPanel(new BorderLayout());
    private final JLabel bottomStatusLabel = new JLabel();
    @NotNull
    protected final FrameHelper frameHelper = new FrameHelper();

    public StatusWindow() {
        this.logTextArea.setLineWrap(true);
        JScrollPane messagesScroll = new JScrollPane(this.logTextArea, 22, 30){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(400, 400);
            }
        };
        this.content.add((Component)messagesScroll, "Center");
        this.content.add((Component)this.bottomStatusLabel, "South");
        this.appendLine("Console version 20241002");
        this.appendLine(FileLog.getOsName() + " " + System.getProperty("os.version"));
        this.appendLine("Bundle " + BundleUtil.readBundleFullNameNotNull());
    }

    @NotNull
    public FrameHelper getFrameHelper() {
        return this.frameHelper;
    }

    public JPanel getContent() {
        return this.content;
    }

    public void setErrorState() {
        this.logTextArea.setBackground(LIGHT_RED);
        this.copyContentToClipboard();
    }

    @Override
    public void log(String message, boolean breakLineOnTextArea, boolean sendToLogger) {
        this.append(message, breakLineOnTextArea, sendToLogger);
    }

    @Override
    public void done() {
        this.setSuccessState();
    }

    @Override
    public void error() {
        this.setErrorState();
    }

    public void setSuccessState() {
        this.logTextArea.setBackground(LIGHT_GREEN);
    }

    public JFrame getFrame() {
        return this.frameHelper.getFrame();
    }

    public void showFrame(String title) {
        this.frameHelper.getFrame().setTitle(title);
        this.frameHelper.showFrame(this.content, false);
        UiUtils.centerWindow(this.frameHelper.getFrame());
        this.logTextArea.setText("");
    }

    @Override
    public void append(String string, boolean breakLineOnTextArea, boolean sendToLogger) {
        SwingUtilities.invokeLater(() -> {
            String s = string.replaceAll(Character.toString('\u00db'), "");
            if (sendToLogger) {
                log.info(s);
            }
            Object stringForTestArea = s;
            if (breakLineOnTextArea) {
                stringForTestArea = (String)stringForTestArea + "\r\n";
            }
            this.logTextArea.append((String)stringForTestArea);
            UiUtils.trueLayout(this.logTextArea);
        });
    }

    public void copyContentToClipboard() {
        SwingUtilities.invokeLater(() -> Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.logTextArea.getText()), null));
        this.appendLine("hint: error state is already in your clipboard, please use PASTE or Ctrl-V while reporting issues");
    }

    public void setStatus(String status) {
        this.bottomStatusLabel.setText(status);
    }
}

