/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.rusefi.io.LinkManager;
import com.rusefi.io.UpdateOperationCallbacks;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public enum CalibrationsUpdater {
    INSTANCE;

    private static final Logging log;

    public synchronized void updateCalibrations(String port, ConfigurationImage calibrationsImage, UpdateOperationCallbacks callbacks) {
        if (calibrationsImage != null) {
            int calibrationsImageSize = calibrationsImage.getSize();
            LinkManager linkManager = new LinkManager().setNeedPullText(false).setNeedPullLiveData(true);
            try {
                callbacks.logLine(String.format("Connecting to port %s...", port));
                try {
                    linkManager.connect(port).await(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    String errorMsg = String.format("Failed to connect to port %s", port);
                    log.error(errorMsg, e);
                    callbacks.logLine(errorMsg);
                    callbacks.error();
                    if (linkManager != null) {
                        linkManager.close();
                    }
                    return;
                }
                callbacks.logLine(String.format("Updating configuration image (%d bytes) to port %s...", calibrationsImageSize, port));
                CountDownLatch latch = new CountDownLatch(1);
                linkManager.execute(() -> {
                    linkManager.getBinaryProtocol().uploadChanges(calibrationsImage);
                    latch.countDown();
                });
                try {
                    if (!latch.await(1L, TimeUnit.MINUTES)) {
                        callbacks.logLine(String.format("Failed to update configuration image (%d bytes) to port %s in a minute", calibrationsImageSize, port));
                        callbacks.error();
                    }
                    callbacks.logLine(String.format("Configuration image (%d bytes) has been uploaded to port %s", calibrationsImageSize, port));
                    callbacks.done();
                }
                catch (InterruptedException e) {
                    String errorMsg = String.format("Updating calibrations to port %s was interrupted", port);
                    log.error(errorMsg, e);
                    callbacks.logLine(errorMsg);
                    callbacks.error();
                }
            }
            finally {
                if (linkManager != null) {
                    try {
                        linkManager.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        } else {
            callbacks.logLine("ERROR: Calibrations to update are undefined");
        }
    }

    static {
        log = Logging.getLogging(CalibrationsUpdater.class);
    }
}

