/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.tools.GradientWrapper;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class Battery
extends JComponent {
    private static final Util UTIL = Util.INSTANCE;
    private final Rectangle INNER_BOUNDS;
    private int value = 0;
    private boolean initialized = false;
    private BufferedImage batteryImage = UTIL.createImage(1, 1, 3);
    private final Color FULL_BORDER = new Color(7971403);
    private final Color HALF_BORDER = new Color(14395157);
    private final Color EMPTY_BORDER = new Color(11606274);
    private final Color FULL_DARK = new Color(10737766);
    private final Color FULL_LIGHT = new Color(14674262);
    private final Color HALF_DARK = new Color(14990624);
    private final Color HALF_LIGHT = new Color(16184477);
    private final Color EMPTY_DARK = new Color(12986117);
    private final Color EMPTY_LIGHT = new Color(16152880);
    private GradientWrapper borderGradient;
    private GradientWrapper liquidGradientDark;
    private GradientWrapper liquidGradientLight;
    private Orientation lightPosition;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            Container parent = Battery.this.getParent();
            if (parent != null && parent.getLayout() == null) {
                Battery.this.setSize(Battery.this.getWidth(), Battery.this.getHeight());
            } else {
                Battery.this.setPreferredSize(new Dimension(Battery.this.getWidth(), Battery.this.getHeight()));
            }
            Battery.this.calcInnerBounds();
            Battery.this.init(((Battery)Battery.this).INNER_BOUNDS.width, ((Battery)Battery.this).INNER_BOUNDS.height);
        }
    };

    public Battery() {
        this.lightPosition = Orientation.NORTH;
        this.INNER_BOUNDS = new Rectangle(40, 18);
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.addComponentListener(this.COMPONENT_LISTENER);
    }

    private void init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1) {
            return;
        }
        if (this.batteryImage != null) {
            this.batteryImage.flush();
        }
        this.batteryImage = this.create_BATTERY_Image(WIDTH, HEIGHT - this.getInsets().bottom, this.value);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.initialized) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.translate(this.INNER_BOUNDS.x, this.INNER_BOUNDS.y);
        G2.drawImage((Image)this.batteryImage, 0, 0, null);
        G2.translate(-this.INNER_BOUNDS.x, -this.INNER_BOUNDS.y);
        G2.dispose();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int VALUE) {
        this.value = VALUE < 0 ? 0 : (VALUE > 100 ? 100 : VALUE);
        this.init(this.getWidth(), this.getHeight());
        this.repaint(this.INNER_BOUNDS);
    }

    public Orientation getLightPosition() {
        return this.lightPosition;
    }

    public void setLightPosition(Orientation LIGHT_POSITION) {
        this.lightPosition = LIGHT_POSITION;
        this.init(this.getWidth(), this.getHeight());
        this.repaint(this.INNER_BOUNDS);
    }

    public BufferedImage getAsImage() {
        BufferedImage IMAGE = UTIL.createImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        this.paintAll(G2);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage create_BATTERY_Image(int WIDTH, int HEIGHT, int VALUE) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath BATTERY = new GeneralPath();
        BATTERY.setWindingRule(0);
        BATTERY.moveTo((double)IMAGE_WIDTH * 0.025, (double)IMAGE_HEIGHT * 0.05555555555555555);
        BATTERY.lineTo((double)IMAGE_WIDTH * 0.9, (double)IMAGE_HEIGHT * 0.05555555555555555);
        BATTERY.lineTo((double)IMAGE_WIDTH * 0.9, (double)IMAGE_HEIGHT * 0.9444444444444444);
        BATTERY.lineTo((double)IMAGE_WIDTH * 0.025, (double)IMAGE_HEIGHT * 0.9444444444444444);
        BATTERY.lineTo((double)IMAGE_WIDTH * 0.025, (double)IMAGE_HEIGHT * 0.05555555555555555);
        BATTERY.closePath();
        BATTERY.moveTo((double)IMAGE_WIDTH * 0.925, (double)IMAGE_HEIGHT * 0.0);
        BATTERY.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.0);
        BATTERY.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 1.0);
        BATTERY.lineTo((double)IMAGE_WIDTH * 0.925, (double)IMAGE_HEIGHT * 1.0);
        BATTERY.lineTo((double)IMAGE_WIDTH * 0.925, (double)IMAGE_HEIGHT * 0.7222222222222222);
        BATTERY.curveTo((double)IMAGE_WIDTH * 0.925, (double)IMAGE_HEIGHT * 0.7222222222222222, (double)IMAGE_WIDTH * 0.975, (double)IMAGE_HEIGHT * 0.7222222222222222, (double)IMAGE_WIDTH * 0.975, (double)IMAGE_HEIGHT * 0.7222222222222222);
        BATTERY.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.7222222222222222, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.6666666666666666, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.6666666666666666);
        BATTERY.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.6666666666666666, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.3333333333333333, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.3333333333333333);
        BATTERY.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.3333333333333333, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.2777777777777778, (double)IMAGE_WIDTH * 0.975, (double)IMAGE_HEIGHT * 0.2777777777777778);
        BATTERY.curveTo((double)IMAGE_WIDTH * 0.975, (double)IMAGE_HEIGHT * 0.2777777777777778, (double)IMAGE_WIDTH * 0.925, (double)IMAGE_HEIGHT * 0.2777777777777778, (double)IMAGE_WIDTH * 0.925, (double)IMAGE_HEIGHT * 0.2777777777777778);
        BATTERY.lineTo((double)IMAGE_WIDTH * 0.925, (double)IMAGE_HEIGHT * 0.0);
        BATTERY.closePath();
        Point2D.Double BATTERY_START = new Point2D.Double();
        Point2D.Double BATTERY_STOP = new Point2D.Double();
        switch (this.lightPosition) {
            case NORTH_EAST: {
                ((Point2D)BATTERY_START).setLocation(BATTERY.getBounds2D().getMaxX(), BATTERY.getBounds2D().getMinY());
                ((Point2D)BATTERY_STOP).setLocation(BATTERY.getBounds2D().getMinX(), BATTERY.getBounds2D().getMaxY());
                break;
            }
            case EAST: {
                ((Point2D)BATTERY_START).setLocation(BATTERY.getBounds2D().getMaxX(), 0.0);
                ((Point2D)BATTERY_STOP).setLocation(BATTERY.getBounds2D().getMinX(), 0.0);
                break;
            }
            case SOUTH_EAST: {
                ((Point2D)BATTERY_START).setLocation(BATTERY.getBounds2D().getMaxX(), BATTERY.getBounds2D().getMaxY());
                ((Point2D)BATTERY_STOP).setLocation(BATTERY.getBounds2D().getMinX(), BATTERY.getBounds2D().getMinY());
                break;
            }
            case SOUTH: {
                ((Point2D)BATTERY_START).setLocation(0.0, BATTERY.getBounds2D().getMaxY());
                ((Point2D)BATTERY_STOP).setLocation(0.0, BATTERY.getBounds2D().getMinY());
                break;
            }
            case SOUTH_WEST: {
                ((Point2D)BATTERY_START).setLocation(BATTERY.getBounds2D().getMinX(), BATTERY.getBounds2D().getMaxY());
                ((Point2D)BATTERY_STOP).setLocation(BATTERY.getBounds2D().getMaxX(), BATTERY.getBounds2D().getMinY());
                break;
            }
            case WEST: {
                ((Point2D)BATTERY_START).setLocation(BATTERY.getBounds2D().getMinX(), 0.0);
                ((Point2D)BATTERY_STOP).setLocation(BATTERY.getBounds2D().getMaxX(), 0.0);
                break;
            }
            case NORTH_WEST: {
                ((Point2D)BATTERY_START).setLocation(BATTERY.getBounds2D().getMinX(), BATTERY.getBounds2D().getMinY());
                ((Point2D)BATTERY_STOP).setLocation(BATTERY.getBounds2D().getMaxX(), BATTERY.getBounds2D().getMaxY());
                break;
            }
            default: {
                ((Point2D)BATTERY_START).setLocation(0.0, BATTERY.getBounds2D().getMinY());
                ((Point2D)BATTERY_STOP).setLocation(0.0, BATTERY.getBounds2D().getMaxY());
            }
        }
        float[] BATTERY_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] BATTERY_COLORS = new Color[]{new Color(255, 255, 255, 255), new Color(126, 126, 126, 255)};
        LinearGradientPaint BATTERY_GRADIENT = new LinearGradientPaint(BATTERY_START, BATTERY_STOP, BATTERY_FRACTIONS, BATTERY_COLORS);
        G2.setPaint(BATTERY_GRADIENT);
        G2.fill(BATTERY);
        Rectangle2D.Double BORDER = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.025, (double)IMAGE_WIDTH * 0.025, (double)IMAGE_WIDTH * 0.875 * ((double)VALUE / 100.0), (double)IMAGE_HEIGHT * 0.88888888888888);
        float[] BORDER_FRACTIONS = new float[]{0.0f, 0.4f, 1.0f};
        Color[] BORDER_COLORS = new Color[]{this.EMPTY_BORDER, this.HALF_BORDER, this.FULL_BORDER};
        this.borderGradient = new GradientWrapper(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 0.0), BORDER_FRACTIONS, BORDER_COLORS);
        G2.setPaint(this.borderGradient.getColorAt((float)VALUE / 100.0f));
        G2.fill(BORDER);
        Rectangle2D.Double LIQUID = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.05, (double)IMAGE_WIDTH * 0.05, (double)IMAGE_WIDTH * 0.85 * ((double)VALUE / 100.0), (double)IMAGE_HEIGHT * 0.77777777777777);
        Point2D.Double LIQUID_START = new Point2D.Double((double)IMAGE_WIDTH * 0.05, 0.0);
        Point2D.Double LIQUID_STOP = new Point2D.Double((double)IMAGE_WIDTH * 0.875, 0.0);
        float[] LIQUID_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
        Color[] LIQUID_COLORS_DARK = new Color[]{this.EMPTY_DARK, this.HALF_DARK, this.FULL_DARK};
        Color[] LIQUID_COLORS_LIGHT = new Color[]{this.EMPTY_LIGHT, this.HALF_LIGHT, this.FULL_LIGHT};
        float[] LIQUID_GRADIENT_FRACTIONS = new float[]{0.0f, 0.4f, 1.0f};
        this.liquidGradientDark = new GradientWrapper(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 0.0), LIQUID_GRADIENT_FRACTIONS, LIQUID_COLORS_DARK);
        this.liquidGradientLight = new GradientWrapper(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 0.0), LIQUID_GRADIENT_FRACTIONS, LIQUID_COLORS_LIGHT);
        Color[] LIQUID_COLORS = new Color[]{this.liquidGradientDark.getColorAt((float)VALUE / 100.0f), this.liquidGradientLight.getColorAt((float)VALUE / 100.0f), this.liquidGradientDark.getColorAt((float)VALUE / 100.0f)};
        LinearGradientPaint LIQUID_GRADIENT = new LinearGradientPaint(LIQUID_START, LIQUID_STOP, LIQUID_FRACTIONS, LIQUID_COLORS);
        G2.setPaint(LIQUID_GRADIENT);
        G2.fill(LIQUID);
        Rectangle2D.Double HIGHLIGHT = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.025, (double)IMAGE_WIDTH * 0.025, (double)IMAGE_WIDTH * 0.875, (double)IMAGE_HEIGHT * 0.44444444444444);
        Point2D.Double HIGHLIGHT_START = new Point2D.Double(0.0, ((Rectangle2D)HIGHLIGHT).getBounds2D().getMinY());
        Point2D.Double HIGHLIGHT_STOP = new Point2D.Double(0.0, ((Rectangle2D)HIGHLIGHT).getBounds2D().getMaxY());
        float[] HIGHLIGHT_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] HIGHLIGHT_COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f, 0.8f)};
        LinearGradientPaint HIGHLIGHT_GRADIENT = new LinearGradientPaint(HIGHLIGHT_START, HIGHLIGHT_STOP, HIGHLIGHT_FRACTIONS, HIGHLIGHT_COLORS);
        G2.setPaint(HIGHLIGHT_GRADIENT);
        G2.fill(HIGHLIGHT);
        G2.dispose();
        return IMAGE;
    }

    private void calcInnerBounds() {
        Insets INSETS = this.getInsets();
        this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, this.getWidth() - INSETS.left - INSETS.right, this.getHeight() - INSETS.top - INSETS.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (dim.width < 40 || dim.height < 18) {
            dim = new Dimension(40, 18);
        }
        return dim;
    }

    @Override
    public void setMinimumSize(Dimension DIM) {
        int width = DIM.width < 40 ? 40 : DIM.width;
        int height = DIM.height < 18 ? 18 : DIM.height;
        super.setMinimumSize(new Dimension(width, height));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        if (dim.width > 1920 || dim.height > 864) {
            dim = new Dimension(1920, 864);
        }
        return dim;
    }

    @Override
    public void setMaximumSize(Dimension DIM) {
        int width = DIM.width > 1920 ? 1920 : DIM.width;
        int height = DIM.height > 864 ? 864 : DIM.height;
        super.setMaximumSize(new Dimension(width, height));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        super.setPreferredSize(new Dimension(DIM.width, (int)(0.45 * (double)DIM.width)));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
        this.initialized = true;
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        super.setSize(WIDTH, (int)(0.45 * (double)WIDTH));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
        this.initialized = true;
    }

    @Override
    public void setSize(Dimension DIM) {
        super.setPreferredSize(new Dimension(DIM.width, (int)(0.45 * (double)DIM.width)));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
        this.initialized = true;
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        super.setBounds(new Rectangle(BOUNDS.x, BOUNDS.y, BOUNDS.width, (int)(0.45 * (double)BOUNDS.width)));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
        this.initialized = true;
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        super.setBounds(X, Y, WIDTH, (int)(0.45 * (double)WIDTH));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
        this.initialized = true;
    }

    @Override
    public void setBorder(Border BORDER) {
        super.setBorder(BORDER);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width, (int)(0.45 * (double)this.INNER_BOUNDS.width));
    }

    @Override
    public String toString() {
        return "Battery";
    }
}

