/*
 * Decompiled with CFR 0.152.
 */
package peak.can.basic;

import java.util.ArrayDeque;
import peak.can.basic.TPCANType;

public enum TPCANHandle {
    PCAN_NONEBUS(0),
    PCAN_ISABUS1(33),
    PCAN_ISABUS2(34),
    PCAN_ISABUS3(35),
    PCAN_ISABUS4(36),
    PCAN_ISABUS5(37),
    PCAN_ISABUS6(38),
    PCAN_ISABUS7(39),
    PCAN_ISABUS8(40),
    PCAN_DNGBUS1(49),
    PCAN_PCIBUS1(65),
    PCAN_PCIBUS2(66),
    PCAN_PCIBUS3(67),
    PCAN_PCIBUS4(68),
    PCAN_PCIBUS5(69),
    PCAN_PCIBUS6(70),
    PCAN_PCIBUS7(71),
    PCAN_PCIBUS8(72),
    PCAN_PCIBUS9(1033),
    PCAN_PCIBUS10(1034),
    PCAN_PCIBUS11(1035),
    PCAN_PCIBUS12(1036),
    PCAN_PCIBUS13(1037),
    PCAN_PCIBUS14(1038),
    PCAN_PCIBUS15(1039),
    PCAN_PCIBUS16(1040),
    PCAN_USBBUS1(81),
    PCAN_USBBUS2(82),
    PCAN_USBBUS3(83),
    PCAN_USBBUS4(84),
    PCAN_USBBUS5(85),
    PCAN_USBBUS6(86),
    PCAN_USBBUS7(87),
    PCAN_USBBUS8(88),
    PCAN_USBBUS9(1289),
    PCAN_USBBUS10(1290),
    PCAN_USBBUS11(1291),
    PCAN_USBBUS12(1292),
    PCAN_USBBUS13(1293),
    PCAN_USBBUS14(1294),
    PCAN_USBBUS15(1295),
    PCAN_USBBUS16(1296),
    PCAN_PCCBUS1(97),
    PCAN_PCCBUS2(98),
    PCAN_LANBUS1(2049),
    PCAN_LANBUS2(2050),
    PCAN_LANBUS3(2051),
    PCAN_LANBUS4(2052),
    PCAN_LANBUS5(2053),
    PCAN_LANBUS6(2054),
    PCAN_LANBUS7(2055),
    PCAN_LANBUS8(2056),
    PCAN_LANBUS9(2057),
    PCAN_LANBUS10(2058),
    PCAN_LANBUS11(2059),
    PCAN_LANBUS12(2060),
    PCAN_LANBUS13(2061),
    PCAN_LANBUS14(2062),
    PCAN_LANBUS15(2063),
    PCAN_LANBUS16(2064);

    private final short value;

    private TPCANHandle(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    public static Object[] initializableChannels() {
        TPCANHandle[] values = TPCANHandle.values();
        int size = values.length;
        ArrayDeque<TPCANHandle> result = new ArrayDeque<TPCANHandle>(size);
        for (int i = 1; i < size; ++i) {
            result.add(values[i]);
        }
        return result.toArray();
    }

    public static boolean isPCANUSBHardware(TPCANHandle handle) {
        switch (handle) {
            case PCAN_USBBUS1: 
            case PCAN_USBBUS2: 
            case PCAN_USBBUS3: 
            case PCAN_USBBUS4: 
            case PCAN_USBBUS5: 
            case PCAN_USBBUS6: 
            case PCAN_USBBUS7: 
            case PCAN_USBBUS8: 
            case PCAN_USBBUS9: 
            case PCAN_USBBUS10: 
            case PCAN_USBBUS11: 
            case PCAN_USBBUS12: 
            case PCAN_USBBUS13: 
            case PCAN_USBBUS14: 
            case PCAN_USBBUS15: 
            case PCAN_USBBUS16: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPCANPCCardHardware(TPCANHandle handle) {
        switch (handle) {
            case PCAN_PCCBUS1: 
            case PCAN_PCCBUS2: {
                return true;
            }
        }
        return false;
    }

    public static boolean containsSJA(TPCANHandle handle, TPCANType type) {
        switch (handle) {
            case PCAN_DNGBUS1: 
            case PCAN_ISABUS1: 
            case PCAN_ISABUS2: 
            case PCAN_ISABUS3: 
            case PCAN_ISABUS4: 
            case PCAN_ISABUS5: 
            case PCAN_ISABUS6: 
            case PCAN_ISABUS7: 
            case PCAN_ISABUS8: {
                switch (type) {
                    case PCAN_TYPE_DNG_SJA: 
                    case PCAN_TYPE_DNG_SJA_EPP: 
                    case PCAN_TYPE_ISA_SJA: {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

