/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.Lcd;
import eu.hansolo.steelseries.tools.GlowImageFactory;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Linear;
import org.pushingpixels.trident.ease.TimelineEase;

public final class DisplayMulti
extends JComponent
implements Lcd,
ActionListener {
    private final Util UTIL = Util.INSTANCE;
    private LcdColor lcdColor = LcdColor.WHITE_LCD;
    private Paint customLcdBackground = Color.BLACK;
    private Color customLcdForeground = Color.WHITE;
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 128, 64);
    private double lcdValue = 0.0;
    private double oldValue = 0.0;
    private static final String LCD_VALUE_PROPERTY = "lcdValue";
    private double lcdThreshold = 0.0;
    private boolean lcdThresholdVisible = false;
    private boolean lcdThresholdBehaviourInverted = false;
    private boolean lcdBackgroundVisible = true;
    private boolean lcdTextVisible = true;
    private boolean lcdBlinking = false;
    private final Timer LCD_BLINKING_TIMER;
    private BufferedImage lcdThresholdImage;
    private int lcdDecimals = 1;
    private String lcdUnitString = "unit";
    private boolean lcdUnitStringVisible = true;
    private boolean lcdScientificFormat = false;
    private boolean digitalFont = false;
    private boolean useCustomLcdUnitFont = false;
    private Font customLcdUnitFont;
    private Font lcdValueFont;
    private Font lcdFormerValueFont;
    private Font lcdUnitFont;
    private Font lcdInfoFont;
    private String lcdInfoString = "";
    private final Font LCD_STANDARD_FONT;
    private final Font LCD_DIGITAL_FONT;
    private BufferedImage lcdImage;
    private NumberSystem numberSystem;
    private Shape disabledShape;
    private final Color DISABLED_COLOR;
    private Timeline timeline;
    private final transient TimelineEase EASING;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout oldValueLayout;
    private final Rectangle2D OLD_VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();
    private boolean glowVisible = false;
    private Color glowColor;
    private boolean glowing = false;
    private BufferedImage glowImageOn;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            Container parent = DisplayMulti.this.getParent();
            if (DisplayMulti.this.getWidth() < DisplayMulti.this.getMinimumSize().width && DisplayMulti.this.getHeight() < DisplayMulti.this.getMinimumSize().height) {
                if (parent != null && DisplayMulti.this.getParent().getLayout() == null) {
                    DisplayMulti.this.setSize(DisplayMulti.this.getMinimumSize());
                } else {
                    DisplayMulti.this.setPreferredSize(DisplayMulti.this.getMinimumSize());
                }
            }
            if (parent != null && DisplayMulti.this.getParent().getLayout() == null) {
                DisplayMulti.this.setSize(DisplayMulti.this.getWidth(), DisplayMulti.this.getHeight());
            } else {
                DisplayMulti.this.setPreferredSize(new Dimension(DisplayMulti.this.getWidth(), DisplayMulti.this.getHeight()));
            }
            DisplayMulti.this.calcInnerBounds();
            DisplayMulti.this.init(((DisplayMulti)DisplayMulti.this).getInnerBounds().width, ((DisplayMulti)DisplayMulti.this).getInnerBounds().height);
        }
    };

    public DisplayMulti() {
        this.LCD_BLINKING_TIMER = new Timer(500, this);
        this.customLcdUnitFont = new Font("Verdana", 0, 24);
        this.LCD_STANDARD_FONT = new Font("Verdana", 0, 30);
        this.LCD_DIGITAL_FONT = Util.INSTANCE.getDigitalFont().deriveFont(24).deriveFont(0);
        this.lcdInfoFont = new Font("Verdana", 0, 24);
        this.numberSystem = NumberSystem.DEC;
        this.DISABLED_COLOR = new Color(102, 102, 102, 178);
        this.timeline = new Timeline(this);
        this.EASING = new Linear();
        this.glowColor = new Color(51, 255, 255);
        this.init(128, 64);
        this.addComponentListener(this.COMPONENT_LISTENER);
    }

    public final void init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return;
        }
        if (this.lcdImage != null) {
            this.lcdImage.flush();
        }
        this.lcdImage = this.create_LCD_Image(WIDTH, HEIGHT);
        if (this.glowImageOn != null) {
            this.glowImageOn.flush();
        }
        this.glowImageOn = GlowImageFactory.INSTANCE.createLcdGlow(WIDTH, HEIGHT, this.glowColor, true);
        double CORNER_RADIUS = WIDTH > HEIGHT ? (double)HEIGHT * 0.095 : (double)WIDTH * 0.095;
        this.disabledShape = new RoundRectangle2D.Double(0.0, 0.0, WIDTH, HEIGHT, CORNER_RADIUS, CORNER_RADIUS);
        if (this.isDigitalFont()) {
            this.lcdValueFont = this.LCD_DIGITAL_FONT.deriveFont(0.5f * (float)this.getInnerBounds().height);
            this.lcdFormerValueFont = this.LCD_DIGITAL_FONT.deriveFont(0.2f * (float)this.getInnerBounds().height);
            this.lcdUnitFont = this.useCustomLcdUnitFont ? this.customLcdUnitFont.deriveFont(0.1875f * (float)this.getInnerBounds().height) : this.LCD_STANDARD_FONT.deriveFont(0.1875f * (float)this.getInnerBounds().height);
        } else {
            this.lcdValueFont = this.LCD_STANDARD_FONT.deriveFont(0.46875f * (float)this.getInnerBounds().height);
            this.lcdFormerValueFont = this.LCD_STANDARD_FONT.deriveFont(0.1875f * (float)this.getInnerBounds().height);
            this.lcdUnitFont = this.useCustomLcdUnitFont ? this.customLcdUnitFont.deriveFont(0.1875f * (float)this.getInnerBounds().height) : this.LCD_STANDARD_FONT.deriveFont(0.1875f * (float)this.getInnerBounds().height);
        }
        this.lcdInfoFont = this.LCD_STANDARD_FONT.deriveFont(0.15f * (float)this.getInnerBounds().height);
        if (this.lcdThresholdImage != null) {
            this.lcdThresholdImage.flush();
        }
        this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)((double)HEIGHT * 0.2045454545), (int)((double)HEIGHT * 0.2045454545), this.lcdColor.TEXT_COLOR);
    }

    @Override
    protected void paintComponent(Graphics g) {
        double UNIT_STRING_WIDTH;
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        if (this.lcdBackgroundVisible) {
            G2.drawImage((Image)this.lcdImage, 0, 0, null);
        }
        if (this.lcdColor == LcdColor.CUSTOM) {
            G2.setColor(this.customLcdForeground);
        } else {
            G2.setColor(this.lcdColor.TEXT_COLOR);
        }
        G2.setFont(this.lcdUnitFont);
        if (this.lcdUnitStringVisible && !this.lcdUnitString.isEmpty()) {
            this.unitLayout = new TextLayout(this.lcdUnitString, G2.getFont(), this.RENDER_CONTEXT);
            this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
            if (this.lcdTextVisible) {
                G2.drawString(this.lcdUnitString, (float)((double)this.lcdImage.getWidth() - this.UNIT_BOUNDARY.getWidth() - (double)((float)this.lcdImage.getHeight() * 0.15f)), (float)this.lcdImage.getHeight() * 0.6f);
            }
            UNIT_STRING_WIDTH = this.UNIT_BOUNDARY.getWidth();
        } else {
            UNIT_STRING_WIDTH = 0.0;
        }
        switch (this.numberSystem) {
            default: {
                G2.setFont(this.lcdValueFont);
                this.valueLayout = new TextLayout(this.formatLcdValue(this.lcdValue), G2.getFont(), this.RENDER_CONTEXT);
                this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                if (this.lcdTextVisible) {
                    G2.drawString(this.formatLcdValue(this.lcdValue), (float)((double)this.lcdImage.getMinX() + ((double)this.lcdImage.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth()) - (double)this.lcdImage.getHeight() * 0.3), (float)this.lcdImage.getHeight() * 0.6f);
                }
                G2.setFont(this.lcdFormerValueFont);
                this.oldValueLayout = new TextLayout(this.formatLcdValue(this.oldValue), G2.getFont(), this.RENDER_CONTEXT);
                this.OLD_VALUE_BOUNDARY.setFrame(this.oldValueLayout.getBounds());
                if (!this.lcdTextVisible) break;
                G2.drawString(this.formatLcdValue(this.oldValue), (float)(((double)this.lcdImage.getWidth() - this.OLD_VALUE_BOUNDARY.getWidth()) / 2.0), (float)this.lcdImage.getHeight() * 0.9f);
                break;
            }
            case HEX: {
                G2.setFont(this.lcdValueFont);
                this.valueLayout = new TextLayout(Integer.toHexString((int)this.lcdValue).toUpperCase(), G2.getFont(), this.RENDER_CONTEXT);
                this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                if (this.lcdTextVisible) {
                    G2.drawString(Integer.toHexString((int)this.lcdValue).toUpperCase(), (float)((double)this.lcdImage.getMinX() + ((double)this.lcdImage.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth()) - (double)this.lcdImage.getHeight() * 0.3), (float)this.lcdImage.getHeight() * 0.6f);
                }
                G2.setFont(this.lcdFormerValueFont);
                this.oldValueLayout = new TextLayout(Integer.toHexString((int)this.oldValue).toUpperCase(), G2.getFont(), this.RENDER_CONTEXT);
                this.OLD_VALUE_BOUNDARY.setFrame(this.oldValueLayout.getBounds());
                if (!this.lcdTextVisible) break;
                G2.drawString(Integer.toHexString((int)this.oldValue).toUpperCase(), (float)(((double)this.lcdImage.getWidth() - this.OLD_VALUE_BOUNDARY.getWidth()) / 2.0), (float)this.lcdImage.getHeight() * 0.9f);
                break;
            }
            case OCT: {
                G2.setFont(this.lcdValueFont);
                this.valueLayout = new TextLayout(Integer.toOctalString((int)this.lcdValue), G2.getFont(), this.RENDER_CONTEXT);
                this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                if (this.lcdTextVisible) {
                    G2.drawString(Integer.toOctalString((int)this.lcdValue), (float)((double)this.lcdImage.getMinX() + ((double)this.lcdImage.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth()) - (double)this.lcdImage.getHeight() * 0.3), (float)this.lcdImage.getHeight() * 0.6f);
                }
                G2.setFont(this.lcdFormerValueFont);
                this.oldValueLayout = new TextLayout(Integer.toOctalString((int)this.oldValue), G2.getFont(), this.RENDER_CONTEXT);
                this.OLD_VALUE_BOUNDARY.setFrame(this.oldValueLayout.getBounds());
                if (!this.lcdTextVisible) break;
                G2.drawString(Integer.toOctalString((int)this.oldValue), (float)(((double)this.lcdImage.getWidth() - this.OLD_VALUE_BOUNDARY.getWidth()) / 2.0), (float)this.lcdImage.getHeight() * 0.9f);
            }
        }
        if (!this.lcdInfoString.isEmpty()) {
            G2.setFont(this.lcdInfoFont);
            this.infoLayout = new TextLayout(this.lcdInfoString, G2.getFont(), this.RENDER_CONTEXT);
            this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
            G2.drawString(this.lcdInfoString, 5.0f, (float)this.INFO_BOUNDARY.getHeight() + 5.0f);
        }
        if (this.numberSystem == NumberSystem.DEC && this.lcdThresholdVisible && this.lcdValue >= this.lcdThreshold) {
            if (!this.lcdThresholdBehaviourInverted) {
                if (this.lcdValue >= this.lcdThreshold) {
                    G2.drawImage((Image)this.lcdThresholdImage, 5, this.getHeight() - this.lcdThresholdImage.getHeight() - 5, null);
                }
            } else if (this.lcdValue <= this.lcdThreshold) {
                G2.drawImage((Image)this.lcdThresholdImage, 5, this.getHeight() - this.lcdThresholdImage.getHeight() - 5, null);
            }
        }
        if (this.glowVisible && this.glowing) {
            G2.drawImage((Image)this.glowImageOn, 0, 0, null);
        }
        if (!this.isEnabled()) {
            G2.setColor(this.DISABLED_COLOR);
            G2.fill(this.disabledShape);
        }
        G2.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        G2.dispose();
    }

    public BufferedImage getAsImage() {
        BufferedImage IMAGE = this.UTIL.createImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        this.paintAll(G2);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public double getLcdValue() {
        return this.lcdValue;
    }

    @Override
    public void setLcdValue(double VALUE) {
        this.oldValue = this.lcdValue;
        this.lcdValue = VALUE;
        if (this.numberSystem != NumberSystem.DEC && this.lcdValue < 0.0) {
            this.setLcdNumberSystem(NumberSystem.DEC);
        }
        this.firePropertyChange(LCD_VALUE_PROPERTY, this.oldValue, VALUE);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setLcdValueAnimated(double LCD_VALUE) {
        if (this.isEnabled()) {
            if (this.timeline.getState() != Timeline.TimelineState.IDLE) {
                this.timeline.abort();
            }
            this.timeline = new Timeline(this);
            this.timeline.addPropertyToInterpolate(LCD_VALUE_PROPERTY, this.lcdValue, LCD_VALUE);
            this.timeline.setEase(this.EASING);
            this.timeline.setDuration(2000L);
            this.timeline.play();
        }
    }

    @Override
    public double getLcdThreshold() {
        return this.lcdThreshold;
    }

    @Override
    public void setLcdThreshold(double LCD_THRESHOLD) {
        this.lcdThreshold = LCD_THRESHOLD;
        if (this.lcdThresholdVisible) {
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public boolean isLcdThresholdVisible() {
        return this.lcdThresholdVisible;
    }

    @Override
    public void setLcdThresholdVisible(boolean LCD_THRESHOLD_VISIBLE) {
        this.lcdThresholdVisible = LCD_THRESHOLD_VISIBLE;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdThresholdBehaviourInverted() {
        return this.lcdThresholdBehaviourInverted;
    }

    @Override
    public void setLcdThresholdBehaviourInverted(boolean LCD_THRESHOLD_BEHAVIOUR_INVERTED) {
        this.lcdThresholdBehaviourInverted = LCD_THRESHOLD_BEHAVIOUR_INVERTED;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdBlinking() {
        return this.lcdBlinking;
    }

    @Override
    public void setLcdBlinking(boolean LCD_BLINKING) {
        this.lcdBlinking = LCD_BLINKING;
        if (LCD_BLINKING) {
            this.LCD_BLINKING_TIMER.start();
        } else {
            this.LCD_BLINKING_TIMER.stop();
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public int getLcdDecimals() {
        return this.lcdDecimals;
    }

    @Override
    public void setLcdDecimals(int DECIMALS) {
        this.lcdDecimals = DECIMALS;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdUnitString() {
        return this.lcdUnitString;
    }

    @Override
    public void setLcdUnitString(String LCD_UNIT_STRING) {
        this.lcdUnitString = LCD_UNIT_STRING;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdUnitStringVisible() {
        return this.lcdUnitStringVisible;
    }

    @Override
    public void setLcdUnitStringVisible(boolean LCD_UNIT_STRING_VISIBLE) {
        this.lcdUnitStringVisible = LCD_UNIT_STRING_VISIBLE;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isCustomLcdUnitFontEnabled() {
        return this.useCustomLcdUnitFont;
    }

    @Override
    public void setCustomLcdUnitFontEnabled(boolean USE_CUSTOM_LCD_UNIT_FONT) {
        this.useCustomLcdUnitFont = USE_CUSTOM_LCD_UNIT_FONT;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getCustomLcdUnitFont() {
        return this.customLcdUnitFont;
    }

    @Override
    public void setCustomLcdUnitFont(Font CUSTOM_LCD_UNIT_FONT) {
        this.customLcdUnitFont = CUSTOM_LCD_UNIT_FONT;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setLcdScientificFormat(boolean LCD_SCIENTIFIC_FORMAT) {
        this.lcdScientificFormat = LCD_SCIENTIFIC_FORMAT;
    }

    @Override
    public boolean isLcdScientificFormat() {
        return this.lcdScientificFormat;
    }

    @Override
    public boolean isDigitalFont() {
        return this.digitalFont;
    }

    @Override
    public void setDigitalFont(boolean DIGITAL_FONT) {
        this.digitalFont = DIGITAL_FONT;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public LcdColor getLcdColor() {
        return this.lcdColor;
    }

    @Override
    public void setLcdColor(LcdColor COLOR) {
        this.lcdColor = COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint getCustomLcdBackground() {
        return this.customLcdBackground;
    }

    @Override
    public void setCustomLcdBackground(Paint CUSTOM_LCD_BACKGROUND) {
        this.customLcdBackground = CUSTOM_LCD_BACKGROUND;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Color getCustomLcdForeground() {
        return this.customLcdForeground;
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] LCD_COLORS) {
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, 1.0);
        Point2D.Double FOREGROUND_STOP = new Point2D.Double(0.0, this.getHeight() - 1);
        if (FOREGROUND_START.equals(FOREGROUND_STOP)) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{LCD_COLORS[0], LCD_COLORS[1], LCD_COLORS[2], LCD_COLORS[3], LCD_COLORS[4]};
        return new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
    }

    @Override
    public boolean isLcdBackgroundVisible() {
        return this.lcdBackgroundVisible;
    }

    @Override
    public void setLcdBackgroundVisible(boolean LCD_BACKGROUND_VISIBLE) {
        this.lcdBackgroundVisible = LCD_BACKGROUND_VISIBLE;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setCustomLcdForeground(Color CUSTOM_LCD_FOREGROUND) {
        this.customLcdForeground = CUSTOM_LCD_FOREGROUND;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String formatLcdValue(double VALUE) {
        StringBuilder DEC_BUFFER = new StringBuilder(16);
        DEC_BUFFER.append("0");
        if (this.lcdDecimals > 0) {
            DEC_BUFFER.append(".");
        }
        for (int i = 0; i < this.lcdDecimals; ++i) {
            DEC_BUFFER.append("0");
        }
        if (this.lcdScientificFormat) {
            DEC_BUFFER.append("E0");
        }
        DEC_BUFFER.trimToSize();
        DecimalFormat DEC_FORMAT = new DecimalFormat(DEC_BUFFER.toString(), new DecimalFormatSymbols(Locale.US));
        return DEC_FORMAT.format(VALUE);
    }

    @Override
    public boolean isValueCoupled() {
        return false;
    }

    @Override
    public void setValueCoupled(boolean VALUE_COUPLED) {
    }

    @Override
    public Font getLcdValueFont() {
        return this.lcdValueFont;
    }

    @Override
    public void setLcdValueFont(Font LCD_VALUE_FONT) {
        this.lcdValueFont = LCD_VALUE_FONT;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdUnitFont() {
        return this.lcdUnitFont;
    }

    @Override
    public void setLcdUnitFont(Font LCD_UNIT_FONT) {
        this.lcdUnitFont = LCD_UNIT_FONT;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdInfoString() {
        return this.lcdInfoString;
    }

    @Override
    public void setLcdInfoString(String LCD_INFO_STRING) {
        this.lcdInfoString = LCD_INFO_STRING;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdInfoFont() {
        return this.lcdInfoFont;
    }

    @Override
    public void setLcdInfoFont(Font LCD_INFO_FONT) {
        this.lcdInfoFont = LCD_INFO_FONT;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public NumberSystem getLcdNumberSystem() {
        return this.numberSystem;
    }

    @Override
    public void setLcdNumberSystem(NumberSystem NUMBER_SYSTEM) {
        this.numberSystem = NUMBER_SYSTEM;
        switch (NUMBER_SYSTEM) {
            case HEX: {
                this.lcdInfoString = "hex";
                break;
            }
            case OCT: {
                this.lcdInfoString = "oct";
                break;
            }
            default: {
                this.lcdInfoString = "";
            }
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.getInnerBounds();
    }

    public boolean isGlowVisible() {
        return this.glowVisible;
    }

    public void setGlowVisible(boolean GLOW_VISIBLE) {
        this.glowVisible = GLOW_VISIBLE;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public Color getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(Color GLOW_COLOR) {
        this.glowColor = GLOW_COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean GLOWING) {
        this.glowing = GLOWING;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint();
    }

    private BufferedImage create_LCD_Image(int WIDTH, int HEIGHT) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        BufferedImage IMAGE = this.UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Point2D.Double BACKGROUND_START = new Point2D.Double(0.0, 0.0);
        Point2D.Double BACKGROUND_STOP = new Point2D.Double(0.0, IMAGE_HEIGHT);
        if (BACKGROUND_START.equals(BACKGROUND_STOP)) {
            ((Point2D)BACKGROUND_STOP).setLocation(0.0, ((Point2D)BACKGROUND_START).getY() + 1.0);
        }
        float[] BACKGROUND_FRACTIONS = new float[]{0.0f, 0.08f, 0.92f, 1.0f};
        Color[] BACKGROUND_COLORS = new Color[]{new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 1.0f)};
        LinearGradientPaint BACKGROUND_GRADIENT = new LinearGradientPaint(BACKGROUND_START, BACKGROUND_STOP, BACKGROUND_FRACTIONS, BACKGROUND_COLORS);
        double BACKGROUND_CORNER_RADIUS = WIDTH > HEIGHT ? (double)HEIGHT * 0.095 : (double)WIDTH * 0.095;
        RoundRectangle2D.Double BACKGROUND = new RoundRectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT, BACKGROUND_CORNER_RADIUS, BACKGROUND_CORNER_RADIUS);
        G2.setPaint(BACKGROUND_GRADIENT);
        G2.fill(BACKGROUND);
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, 1.0);
        Point2D.Double FOREGROUND_STOP = new Point2D.Double(0.0, IMAGE_HEIGHT - 1);
        if (FOREGROUND_START.equals(FOREGROUND_STOP)) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{this.lcdColor.GRADIENT_START_COLOR, this.lcdColor.GRADIENT_FRACTION1_COLOR, this.lcdColor.GRADIENT_FRACTION2_COLOR, this.lcdColor.GRADIENT_FRACTION3_COLOR, this.lcdColor.GRADIENT_STOP_COLOR};
        if (this.lcdColor == LcdColor.CUSTOM) {
            G2.setPaint(this.customLcdBackground);
        } else {
            LinearGradientPaint FOREGROUND_GRADIENT = new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
            G2.setPaint(FOREGROUND_GRADIENT);
        }
        double FOREGROUND_CORNER_RADIUS = ((RoundRectangle2D)BACKGROUND).getArcWidth() - 1.0;
        RoundRectangle2D.Double FOREGROUND = new RoundRectangle2D.Double(1.0, 1.0, IMAGE_WIDTH - 2, IMAGE_HEIGHT - 2, FOREGROUND_CORNER_RADIUS, FOREGROUND_CORNER_RADIUS);
        G2.fill(FOREGROUND);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_LCD_THRESHOLD_Image(int WIDTH, int HEIGHT, Color COLOR) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        BufferedImage IMAGE = this.UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath LCD_THRESHOLD = new GeneralPath();
        LCD_THRESHOLD.setWindingRule(0);
        LCD_THRESHOLD.moveTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.7777777777777778);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5555555555555556, (double)IMAGE_HEIGHT * 0.7777777777777778);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5555555555555556, (double)IMAGE_HEIGHT * 0.8888888888888888);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.8888888888888888);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.7777777777777778);
        LCD_THRESHOLD.closePath();
        LCD_THRESHOLD.moveTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.3333333333333333);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5555555555555556, (double)IMAGE_HEIGHT * 0.3333333333333333);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5555555555555556, (double)IMAGE_HEIGHT * 0.7222222222222222);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.7222222222222222);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.4444444444444444, (double)IMAGE_HEIGHT * 0.3333333333333333);
        LCD_THRESHOLD.closePath();
        LCD_THRESHOLD.moveTo(0.0, (double)IMAGE_HEIGHT);
        LCD_THRESHOLD.lineTo(IMAGE_WIDTH, IMAGE_HEIGHT);
        LCD_THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5, 0.0);
        LCD_THRESHOLD.lineTo(0.0, (double)IMAGE_HEIGHT);
        LCD_THRESHOLD.closePath();
        G2.setColor(COLOR);
        G2.fill(LCD_THRESHOLD);
        G2.dispose();
        return IMAGE;
    }

    private void calcInnerBounds() {
        Insets INSETS = this.getInsets();
        this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, this.getWidth() - INSETS.left - INSETS.right, this.getHeight() - INSETS.top - INSETS.bottom);
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (dim.width < 64 || dim.height < 32) {
            dim = new Dimension(64, 32);
        }
        return dim;
    }

    @Override
    public void setMinimumSize(Dimension DIM) {
        int width = DIM.width < 64 ? 64 : DIM.width;
        int height = DIM.height < 32 ? 32 : DIM.height;
        super.setMinimumSize(new Dimension(width, height));
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        if (dim.width > 1920 || dim.height > 960) {
            dim = new Dimension(1920, 960);
        }
        return dim;
    }

    @Override
    public void setMaximumSize(Dimension DIM) {
        int width = DIM.width > 1920 ? 1920 : DIM.width;
        int height = DIM.height > 960 ? 960 : DIM.height;
        super.setMaximumSize(new Dimension(width, height));
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        super.setPreferredSize(DIM);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        super.setSize(WIDTH, HEIGHT);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(Dimension DIM) {
        super.setSize(DIM);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        super.setBounds(BOUNDS);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        super.setBounds(X, Y, WIDTH, HEIGHT);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBorder(Border BORDER) {
        super.setBorder(BORDER);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void actionPerformed(ActionEvent EVENT) {
        if (EVENT.getSource().equals(this.LCD_BLINKING_TIMER)) {
            this.lcdTextVisible ^= true;
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String toString() {
        return "DisplayMulti";
    }
}

