/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.rusefi.AvailableHardware;
import com.rusefi.FileLog;
import com.rusefi.SerialPortScanner;
import com.rusefi.UiProperties;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.DfuFlasher;
import com.rusefi.maintenance.OpenbltJni;
import com.rusefi.maintenance.UpdateMode;
import com.rusefi.maintenance.jobs.AsyncJob;
import com.rusefi.maintenance.jobs.AsyncJobExecutor;
import com.rusefi.maintenance.jobs.DfuAutoJob;
import com.rusefi.maintenance.jobs.DfuEraseJob;
import com.rusefi.maintenance.jobs.DfuManualJob;
import com.rusefi.maintenance.jobs.DfuSwitchJob;
import com.rusefi.maintenance.jobs.InstallOpenBltJob;
import com.rusefi.maintenance.jobs.OpenBltAutoJob;
import com.rusefi.maintenance.jobs.OpenBltCanJob;
import com.rusefi.maintenance.jobs.OpenBltManualJob;
import com.rusefi.maintenance.jobs.OpenBltSwitchJob;
import com.rusefi.maintenance.jobs.StLinkJob;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ProgramSelector {
    private static final Logging log = Logging.getLogging(ProgramSelector.class);
    private static final int ONE_DOT_DURATION_MS = 200;
    private static final int TOTAL_WAIT_SECONDS = 60;
    private final JPanel content = new JPanel(new BorderLayout());
    private final JLabel noHardware = new JLabel("Nothing detected");
    private final JPanel updateModeAndButton = new JPanel(new FlowLayout());
    private final JComboBox<UpdateMode> updateModeComboBox = new JComboBox();

    public ProgramSelector(final JComboBox<SerialPortScanner.PortResult> comboPorts) {
        this.content.add((Component)this.updateModeAndButton, "North");
        this.content.add((Component)this.noHardware, "South");
        String persistedMode = PersistentConfiguration.getConfig().getRoot().getProperty(this.getClass().getSimpleName());
        UpdateMode.parseDisplayText(persistedMode).ifPresent(this.updateModeComboBox::setSelectedItem);
        JButton updateFirmwareButton = ProgramSelector.createUpdateFirmwareButton();
        this.updateModeAndButton.setVisible(false);
        this.updateModeAndButton.add(this.updateModeComboBox);
        this.updateModeAndButton.add(updateFirmwareButton);
        updateFirmwareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateMode selectedMode = (UpdateMode)((Object)ProgramSelector.this.updateModeComboBox.getSelectedItem());
                SerialPortScanner.PortResult selectedPort = (SerialPortScanner.PortResult)comboPorts.getSelectedItem();
                String persistedValue = selectedMode != null ? selectedMode.displayText : null;
                PersistentConfiguration.getConfig().getRoot().setProperty(this.getClass().getSimpleName(), persistedValue);
                ProgramSelector.executeJob(comboPorts, selectedMode, selectedPort);
            }
        });
    }

    private static void executeJob(JComponent parent, UpdateMode selectedMode, SerialPortScanner.PortResult selectedPort) {
        AsyncJob job;
        log.info("ProgramSelector " + selectedMode + " " + selectedPort);
        Objects.requireNonNull(selectedMode);
        switch (selectedMode) {
            case DFU_AUTO: {
                job = new DfuAutoJob(selectedPort, parent);
                break;
            }
            case DFU_MANUAL: {
                job = new DfuManualJob();
                break;
            }
            case INSTALL_OPENBLT: {
                job = new InstallOpenBltJob();
                break;
            }
            case ST_LINK: {
                job = new StLinkJob(parent);
                break;
            }
            case DFU_SWITCH: {
                job = new DfuSwitchJob(selectedPort, parent);
                break;
            }
            case OPENBLT_SWITCH: {
                job = new OpenBltSwitchJob(selectedPort, parent);
                break;
            }
            case OPENBLT_CAN: {
                job = new OpenBltCanJob(parent);
                break;
            }
            case OPENBLT_MANUAL: {
                job = new OpenBltManualJob(selectedPort, parent);
                break;
            }
            case OPENBLT_AUTO: {
                job = new OpenBltAutoJob(selectedPort, parent);
                break;
            }
            case DFU_ERASE: {
                job = new DfuEraseJob();
                break;
            }
            default: {
                throw new IllegalArgumentException("How did you " + selectedMode);
            }
        }
        AsyncJobExecutor.INSTANCE.executeJob(job);
    }

    public static void rebootToDfu(JComponent parent, String selectedPort, UpdateOperationCallbacks callbacks) {
        String port = selectedPort == null ? "auto" : selectedPort;
        DfuFlasher.rebootToDfu(parent, port, callbacks, "reboot_dfu");
    }

    public static void rebootToOpenblt(JComponent parent, String selectedPort, UpdateOperationCallbacks callbacks) {
        String port = selectedPort == null ? "auto" : selectedPort;
        DfuFlasher.rebootToDfu(parent, port, callbacks, "reboot_openblt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flashOpenBltCan(JComponent parent, UpdateOperationCallbacks callbacks) {
        if (FileLog.is32bitJava()) {
            ProgramSelector.showError32bitJava(parent);
            return;
        }
        OpenbltJni.OpenbltCallbacks cb = ProgramSelector.makeOpenbltCallbacks(callbacks);
        try {
            OpenbltJni.flashCan(FindFileHelper.findSrecFile(), cb);
            callbacks.logLine("Update completed successfully!");
            callbacks.done();
        }
        catch (Throwable e) {
            callbacks.logLine("Error: " + e);
            callbacks.error();
        }
        finally {
            OpenbltJni.stop(cb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForPredicate(String waitingMessage, Supplier<Boolean> shouldFinish, UpdateOperationCallbacks callbacks) {
        callbacks.log(waitingMessage, false, true);
        try {
            for (int attemptsCount = 0; attemptsCount < 300; ++attemptsCount) {
                BinaryProtocol.sleep(200L);
                if (shouldFinish.get().booleanValue()) {
                    boolean bl = true;
                    return bl;
                }
                callbacks.log(".", false, false);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            callbacks.log("", true, false);
        }
    }

    private static boolean waitForEcuPortDisappeared(SerialPortScanner.PortResult ecuPort, UpdateOperationCallbacks callbacks) {
        return ProgramSelector.waitForPredicate(String.format("Waiting for ECU on port %s to reboot to OpenBlt for up to 60 seconds...", ecuPort), () -> {
            AvailableHardware availableHardware = SerialPortScanner.INSTANCE.getCurrentHardware();
            log.info(String.format("current ports: [%s]", availableHardware.getKnownPorts().stream().map(SerialPortScanner.PortResult::toString).collect(Collectors.joining(","))));
            return !availableHardware.isPortAvailable(ecuPort);
        }, callbacks);
    }

    private static List<SerialPortScanner.PortResult> waitForNewOpenBltPortAppeared(List<SerialPortScanner.PortResult> openBltPortsBefore, UpdateOperationCallbacks callbacks) {
        ArrayList<SerialPortScanner.PortResult> newPorts = new ArrayList<SerialPortScanner.PortResult>();
        ProgramSelector.waitForPredicate("Waiting for new OpenBlt port to appear...", () -> {
            AvailableHardware availableHardwareAfter = SerialPortScanner.INSTANCE.getCurrentHardware();
            log.info(String.format("ports after reboot to OpenBlt: [%s]", availableHardwareAfter.getKnownPorts().stream().map(SerialPortScanner.PortResult::toString).collect(Collectors.joining(","))));
            for (SerialPortScanner.PortResult p : availableHardwareAfter.getKnownPorts(SerialPortScanner.SerialPortType.OpenBlt)) {
                if (openBltPortsBefore.contains(p)) continue;
                newPorts.add(p);
            }
            return !newPorts.isEmpty();
        }, callbacks);
        return newPorts;
    }

    public static void flashOpenbltSerialAutomatic(JComponent parent, SerialPortScanner.PortResult ecuPort, UpdateOperationCallbacks callbacks) {
        AutoupdateUtil.assertNotAwtThread();
        List<SerialPortScanner.PortResult> openBltPortsBefore = SerialPortScanner.INSTANCE.getCurrentHardware().getKnownPorts(SerialPortScanner.SerialPortType.OpenBlt);
        ProgramSelector.rebootToOpenblt(parent, ecuPort.port, callbacks);
        boolean isEcuPortDisappeared = ProgramSelector.waitForEcuPortDisappeared(ecuPort, callbacks);
        if (!isEcuPortDisappeared) {
            callbacks.logLine("Looks like your ECU still haven't rebooted to OpenBLT");
            callbacks.logLine("");
            callbacks.logLine("Try closing and opening console again");
            callbacks.logLine("");
            callbacks.error();
            return;
        }
        List<SerialPortScanner.PortResult> newItems = ProgramSelector.waitForNewOpenBltPortAppeared(openBltPortsBefore, callbacks);
        if (newItems.isEmpty()) {
            callbacks.logLine("Looks like your ECU disappeared during the update process. Please try again.");
            callbacks.error();
            return;
        }
        if (newItems.size() > 1) {
            callbacks.logLine("Unable to find ECU after reboot as multiple serial ports appeared. Before: " + openBltPortsBefore.size());
            callbacks.error();
            return;
        }
        String openbltPort = newItems.get((int)0).port;
        callbacks.logLine("Serial port " + openbltPort + " appeared, programming firmware...");
        ProgramSelector.flashOpenbltSerialJni(parent, openbltPort, callbacks);
    }

    private static OpenbltJni.OpenbltCallbacks makeOpenbltCallbacks(final UpdateOperationCallbacks callbacks) {
        return new OpenbltJni.OpenbltCallbacks(){

            @Override
            public void log(String line) {
                callbacks.logLine(line);
            }

            @Override
            public void updateProgress(int percent) {
                callbacks.logLine("Progress: " + percent + "%");
            }

            @Override
            public void error(String line) {
                throw new RuntimeException(line);
            }

            @Override
            public void setPhase(String title, boolean hasProgress) {
                callbacks.logLine("Phase: " + title);
            }
        };
    }

    private static void showError32bitJava(JComponent parent) {
        JOptionPane.showMessageDialog(parent, "64 bit java required. 32 bit java not supported!", "Error", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flashOpenbltSerialJni(JComponent parent, String port, UpdateOperationCallbacks callbacks) {
        if (FileLog.is32bitJava()) {
            ProgramSelector.showError32bitJava(parent);
            return;
        }
        OpenbltJni.OpenbltCallbacks cb = ProgramSelector.makeOpenbltCallbacks(callbacks);
        String fileName = FindFileHelper.findSrecFile();
        if (fileName == null) {
            callbacks.logLine(".srec image file not found");
            callbacks.error();
            return;
        }
        try {
            callbacks.logLine("flashSerial " + fileName);
            OpenbltJni.flashSerial(fileName, port, cb);
            callbacks.logLine("Update completed successfully!");
            callbacks.done();
        }
        catch (Throwable e) {
            callbacks.logLine("Error: " + e);
            callbacks.error();
        }
        finally {
            OpenbltJni.stop(cb);
        }
    }

    @NotNull
    public static JComponent createHelpButton() {
        return new URLLabel("HOWTO Update Firmware", UiProperties.getUpdateHelpUrl());
    }

    public JPanel getControl() {
        return this.content;
    }

    public void apply(AvailableHardware currentHardware) {
        this.noHardware.setVisible(currentHardware.isEmpty());
        this.updateModeAndButton.setVisible(!currentHardware.isEmpty());
        boolean hasSerialPorts = !currentHardware.getKnownPorts().isEmpty();
        boolean hasDfuDevice = currentHardware.isDfuFound();
        this.updateModeComboBox.removeAllItems();
        if (FileLog.isWindows()) {
            boolean requireBlt = FindFileHelper.isObfuscated();
            if (!requireBlt) {
                if (hasSerialPorts) {
                    this.updateModeComboBox.addItem(UpdateMode.DFU_AUTO);
                }
                if (hasDfuDevice) {
                    this.updateModeComboBox.addItem(UpdateMode.DFU_MANUAL);
                    this.updateModeComboBox.addItem(UpdateMode.DFU_ERASE);
                    if (DfuFlasher.haveBootloaderBinFile()) {
                        this.updateModeComboBox.addItem(UpdateMode.INSTALL_OPENBLT);
                    }
                }
                this.updateModeComboBox.addItem(UpdateMode.DFU_SWITCH);
                if (currentHardware.isStLinkConnected()) {
                    this.updateModeComboBox.addItem(UpdateMode.ST_LINK);
                }
            }
            if (currentHardware.isPCANConnected()) {
                this.updateModeComboBox.addItem(UpdateMode.OPENBLT_CAN);
            }
        }
        if (hasSerialPorts) {
            this.updateModeComboBox.addItem(UpdateMode.OPENBLT_AUTO);
            this.updateModeComboBox.addItem(UpdateMode.OPENBLT_SWITCH);
            this.updateModeComboBox.addItem(UpdateMode.OPENBLT_MANUAL);
            List listOfBootloaders = currentHardware.getKnownPorts().stream().filter(portResult -> portResult.type == SerialPortScanner.SerialPortType.OpenBlt).collect(Collectors.toList());
            if (!listOfBootloaders.isEmpty()) {
                this.updateModeComboBox.setSelectedItem((Object)UpdateMode.OPENBLT_MANUAL);
            }
        }
        UiUtils.trueLayout(this.updateModeComboBox);
        UiUtils.trueLayout(this.content);
    }

    @NotNull
    public static JButton createUpdateFirmwareButton() {
        return new JButton("Update Firmware", AutoupdateUtil.loadIcon("upload48.png"));
    }
}

