/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autodetect;

import com.devexperts.logging.Logging;
import com.rusefi.NamedThreadFactory;
import com.rusefi.autodetect.SerialAutoChecker;
import com.rusefi.io.LinkManager;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class PortDetector {
    private static final Logging log = Logging.getLogging(PortDetector.class);
    private static final NamedThreadFactory AUTO_DETECT_PORT = new NamedThreadFactory("ECU AutoDetectPort", true);
    public static final String AUTO = "auto";

    @NotNull
    public static SerialAutoChecker.AutoDetectResult autoDetectSerial(Function<SerialAutoChecker.CallbackContext, Void> callback) {
        String rusEfiAddress = System.getProperty("rusefi.address");
        if (rusEfiAddress != null) {
            return PortDetector.getSignatureFromPorts(callback, Set.of(rusEfiAddress));
        }
        Set<String> serialPorts = LinkManager.getCommPorts();
        if (serialPorts.isEmpty()) {
            log.error("No serial ports detected");
            return new SerialAutoChecker.AutoDetectResult(null, null);
        }
        log.info("Trying [" + String.join((CharSequence)", ", serialPorts) + "]");
        return PortDetector.getSignatureFromPorts(callback, serialPorts);
    }

    @NotNull
    private static SerialAutoChecker.AutoDetectResult getSignatureFromPorts(final Function<SerialAutoChecker.CallbackContext, Void> callback, Set<String> serialPorts) {
        ArrayList<Thread> serialFinder = new ArrayList<Thread>();
        final CountDownLatch portFound = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        for (final String serialPort : serialPorts) {
            Thread thread = AUTO_DETECT_PORT.newThread(new Runnable(){

                @Override
                public void run() {
                    new SerialAutoChecker(serialPort, portFound).openAndCheckResponse(result, callback);
                }

                public String toString() {
                    return serialPort + " " + super.toString();
                }
            });
            serialFinder.add(thread);
            thread.start();
        }
        try {
            portFound.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        log.info("Now interrupting " + serialFinder);
        try {
            for (Thread thread : serialFinder) {
                log.info("Interrupting " + thread);
                thread.interrupt();
            }
        }
        catch (RuntimeException e) {
            log.error("Unexpected runtime", e);
        }
        log.info("Done interrupting!");
        SerialAutoChecker.AutoDetectResult autoDetectResult = (SerialAutoChecker.AutoDetectResult)result.get();
        if (autoDetectResult == null) {
            autoDetectResult = new SerialAutoChecker.AutoDetectResult(null, null);
        }
        log.debug("Found " + autoDetectResult + " now stopping threads");
        return autoDetectResult;
    }

    public static String autoDetectSerialIfNeeded(String port) {
        if (!PortDetector.isAutoPort(port)) {
            return port;
        }
        return PortDetector.autoDetectSerial(null).getSerialPort();
    }

    public static boolean isAutoPort(String port) {
        return port.toLowerCase().startsWith(AUTO);
    }
}

