/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import java.util.ArrayList;

public class TokenUtils {
    public static String[] tokenizeWithBraces(String stringToTokenize) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (stringToTokenize != null) {
            StringBuilder currentToken = new StringBuilder();
            int openedBracesCount = 0;
            block4: for (char ch : stringToTokenize.toCharArray()) {
                if (ch == ',' && openedBracesCount == 0) {
                    tokens.add(currentToken.toString());
                    currentToken.setLength(0);
                    continue;
                }
                currentToken.append(ch);
                switch (ch) {
                    case '{': {
                        ++openedBracesCount;
                        continue block4;
                    }
                    case '}': {
                        if (0 < openedBracesCount) {
                            --openedBracesCount;
                            continue block4;
                        }
                        throw new IllegalArgumentException(String.format("Unexpected closing brace: %s", stringToTokenize));
                    }
                }
            }
            if (openedBracesCount != 0) {
                throw new IllegalArgumentException(String.format("Unclosed opening brace: %s", stringToTokenize));
            }
            tokens.add(currentToken.toString());
        }
        return (String[])tokens.toArray(String[]::new);
    }
}

