/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.can;

public class HexUtil {
    private static final String HEX_STRING = "0123456789ABCDEF";
    public static final byte[] HEX_BYTE_ARRAY = "0123456789ABCDEF".getBytes();
    public static final char[] HEX_CHAR_ARRAY = "0123456789ABCDEF".toCharArray();

    public static byte[] asBytes(String hex) {
        if (hex.indexOf(32) >= 0) {
            hex = hex.replaceAll(" ", "");
        }
        if (hex.startsWith("0x")) {
            hex = hex.substring(2);
        }
        return HexUtil.hexToBytes(hex);
    }

    public static String asString(byte[] input) {
        StringBuilder sb = new StringBuilder();
        for (byte b : input) {
            int i = b & 0xFF;
            sb.append(HEX_STRING.charAt(i / 16));
            sb.append(HEX_STRING.charAt(i % 16));
        }
        return sb.toString();
    }

    public static byte[] hexToBytes(CharSequence s) {
        return HexUtil.hexToBytes(s, 0);
    }

    private static byte[] hexToBytes(CharSequence s, int off) {
        byte[] bs = new byte[off + (1 + s.length()) / 2];
        HexUtil.hexToBytes(s, bs, off);
        return bs;
    }

    public static void hexToBytes(CharSequence s, byte[] out, int off) throws NumberFormatException, IndexOutOfBoundsException {
        int slen = s.length();
        if (slen % 2 != 0) {
            byte nibble;
            out[off] = nibble = (byte)Character.digit(s.charAt(0), 16);
            HexUtil.hexToBytes(s.subSequence(1, s.length()), out, off + 1);
            return;
        }
        if (out.length < off + slen / 2) {
            throw new IndexOutOfBoundsException("Output buffer too small for input (" + out.length + "<" + off + slen / 2 + ")");
        }
        for (int i = 0; i < slen; i += 2) {
            byte firstNibble = (byte)Character.digit(s.charAt(i), 16);
            byte secondNibble = (byte)Character.digit(s.charAt(i + 1), 16);
            if (firstNibble < 0 || secondNibble < 0) {
                throw new NumberFormatException();
            }
            out[off + i / 2] = (byte)(firstNibble << 4 | secondNibble);
        }
    }
}

