/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.rusefi.CyclicBuffer;
import com.rusefi.DataBuffer;
import com.rusefi.SensorConversion;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;

public class SensorStats {
    public static void startRangeMeasurement(Sensor source, final Sensor widthDestination) {
        SensorCentral.getInstance().addListener(source, new SensorCentral.SensorListener(){
            int counter;
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;

            @Override
            public void onSensorUpdate(double value) {
                ++this.counter;
                this.min = Math.min(value, this.min);
                this.max = Math.max(value, this.max);
                if (this.counter == 10) {
                    this.counter = 0;
                    double width = this.max - this.min;
                    SensorCentral.getInstance().setValue(width, widthDestination);
                    this.min = Double.MAX_VALUE;
                    this.max = Double.MIN_VALUE;
                }
            }
        });
    }

    public static void startStandardDeviation(Sensor source, Sensor destination) {
        CyclicBuffer cb = new CyclicBuffer(30);
        SensorCentral.getInstance().addListener(source, value -> {
            cb.add(value);
            if (cb.getSize() == cb.getMaxSize()) {
                double stdDev = DataBuffer.getStandardDeviation(cb.getValues());
                SensorCentral.getInstance().setValue(stdDev, destination);
            }
        });
    }

    public static void startDelta(Sensor input1, Sensor input2, Sensor destination) {
        SensorCentral.getInstance().addListener(input1, value -> {
            double valueMs = (value - SensorCentral.getInstance().getValue(input2)) / 100.0;
            SensorCentral.getInstance().setValue(valueMs, destination);
        });
    }

    public static void startConversion(Sensor source, Sensor destination, SensorConversion conversion) {
        SensorCentral.getInstance().addListener(source, value -> {
            double converted = conversion.convertValue(value);
            SensorCentral.getInstance().setValue(converted, destination);
        });
    }
}

