/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.tools.CustomLedColor;
import eu.hansolo.steelseries.tools.LedColor;
import eu.hansolo.steelseries.tools.LedType;
import eu.hansolo.steelseries.tools.Shadow;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.border.Border;

public class Led
extends JComponent
implements ActionListener {
    private static final Util UTIL = Util.INSTANCE;
    private static final Map<String, BufferedImage> CACHE = new HashMap<String, BufferedImage>();
    private final Rectangle INNER_BOUNDS = new Rectangle(16, 16);
    private final Timer LED_BLINKING_TIMER;
    private final transient ComponentListener COMPONENT_LISTENER;
    private LedColor ledColor = LedColor.RED_LED;
    private CustomLedColor customLedColor = new CustomLedColor(Color.RED);
    private BufferedImage ledImageOff = this.create_LED_Image(16, 0, this.ledColor, LedType.ROUND);
    private BufferedImage ledImageOn = this.create_LED_Image(16, 1, this.ledColor, LedType.ROUND);
    private BufferedImage currentLedImage = this.ledImageOff;
    private boolean ledBlinking = false;
    private boolean ledOn = false;
    private LedType ledType;
    private boolean initialized = false;
    private int horizontalAlignment = 0;
    private int verticalAlignment = 0;

    public Led() {
        this.LED_BLINKING_TIMER = new Timer(500, this);
        this.ledType = LedType.ROUND;
        this.COMPONENT_LISTENER = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                int SIZE = Led.this.getWidth() <= Led.this.getHeight() ? Led.this.getWidth() : Led.this.getHeight();
                Container parent = Led.this.getParent();
                if (parent != null && parent.getLayout() == null) {
                    if (SIZE < Led.this.getMinimumSize().width || SIZE < Led.this.getMinimumSize().height) {
                        Led.this.setSize(Led.this.getMinimumSize().width, Led.this.getMinimumSize().height);
                    } else {
                        Led.this.setSize(SIZE, SIZE);
                    }
                } else if (SIZE < Led.this.getMinimumSize().width || SIZE < Led.this.getMinimumSize().height) {
                    Led.this.setPreferredSize(Led.this.getMinimumSize());
                } else {
                    Led.this.setPreferredSize(new Dimension(SIZE, SIZE));
                }
                Led.this.calcInnerBounds();
                Led.this.init(((Led)Led.this).INNER_BOUNDS.width);
            }
        };
        this.init(this.INNER_BOUNDS.width);
        this.addComponentListener(this.COMPONENT_LISTENER);
    }

    private void init(int WIDTH) {
        if (WIDTH <= 1) {
            return;
        }
        if (this.ledImageOff != null) {
            this.ledImageOff.flush();
        }
        this.ledImageOff = this.create_LED_Image(WIDTH, 0, this.ledColor, this.ledType);
        if (this.ledImageOn != null) {
            this.ledImageOn.flush();
        }
        this.ledImageOn = this.create_LED_Image(WIDTH, 1, this.ledColor, this.ledType);
        if (this.ledOn) {
            this.setCurrentLedImage(this.ledImageOn);
        } else {
            this.setCurrentLedImage(this.ledImageOff);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.initialized) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.translate(this.INNER_BOUNDS.x, this.INNER_BOUNDS.y);
        G2.drawImage((Image)this.getCurrentLedImage(), 0, 0, null);
        G2.translate(-this.INNER_BOUNDS.x, -this.INNER_BOUNDS.y);
        G2.dispose();
    }

    public LedType getLedType() {
        return this.ledType;
    }

    public void setLedType(LedType LED_TYPE) {
        if (this.ledType == LED_TYPE) {
            return;
        }
        this.ledType = LED_TYPE;
        boolean LED_WAS_ON = this.currentLedImage.equals(this.ledImageOn);
        this.flushImages();
        this.ledImageOff = this.create_LED_Image(this.getWidth(), 0, this.ledColor, this.ledType);
        this.ledImageOn = this.create_LED_Image(this.getWidth(), 1, this.ledColor, this.ledType);
        this.currentLedImage = LED_WAS_ON ? this.ledImageOn : this.ledImageOff;
        this.repaint();
    }

    public LedColor getLedColor() {
        return this.ledColor;
    }

    public void setLedColor(LedColor LED_COLOR) {
        if (this.ledColor == LED_COLOR) {
            return;
        }
        this.ledColor = LED_COLOR == null ? LedColor.RED_LED : LED_COLOR;
        boolean LED_WAS_ON = this.currentLedImage.equals(this.ledImageOn);
        this.flushImages();
        this.ledImageOff = this.create_LED_Image(this.getWidth(), 0, LED_COLOR, this.ledType);
        this.ledImageOn = this.create_LED_Image(this.getWidth(), 1, LED_COLOR, this.ledType);
        this.currentLedImage = LED_WAS_ON ? this.ledImageOn : this.ledImageOff;
        this.repaint();
    }

    public Color getCustomLedColor() {
        return this.customLedColor.COLOR;
    }

    public void setCustomLedColor(Color COLOR) {
        if (this.customLedColor.COLOR.equals(COLOR)) {
            return;
        }
        this.customLedColor = new CustomLedColor(COLOR);
        boolean LED_WAS_ON = this.currentLedImage.equals(this.ledImageOn);
        this.flushImages();
        this.ledImageOff = this.create_LED_Image(this.getWidth(), 0, this.ledColor, this.ledType);
        this.ledImageOn = this.create_LED_Image(this.getWidth(), 1, this.ledColor, this.ledType);
        this.currentLedImage = LED_WAS_ON ? this.ledImageOn : this.ledImageOff;
        this.repaint();
    }

    public CustomLedColor getCustomLedColorObject() {
        return this.customLedColor;
    }

    public boolean isLedOn() {
        return this.ledOn;
    }

    public void setLedOn(boolean LED_ON) {
        if (this.ledOn == LED_ON) {
            return;
        }
        this.ledOn = LED_ON;
        this.init(this.getWidth());
        this.repaint();
    }

    public boolean isLedBlinking() {
        return this.ledBlinking;
    }

    public void setLedBlinking(boolean LED_BLINKING) {
        if (this.ledBlinking == LED_BLINKING) {
            return;
        }
        this.ledBlinking = LED_BLINKING;
        if (LED_BLINKING) {
            this.LED_BLINKING_TIMER.start();
        } else {
            this.setCurrentLedImage(this.getLedImageOff());
            this.LED_BLINKING_TIMER.stop();
        }
    }

    public BufferedImage getAsImage() {
        BufferedImage IMAGE = UTIL.createImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        this.paintAll(G2);
        G2.dispose();
        return IMAGE;
    }

    private void flushImages() {
        this.ledImageOff.flush();
        this.ledImageOn.flush();
    }

    private BufferedImage getLedImageOn() {
        return this.ledImageOn;
    }

    private BufferedImage getLedImageOff() {
        return this.ledImageOff;
    }

    private BufferedImage getCurrentLedImage() {
        return this.currentLedImage;
    }

    private void setCurrentLedImage(BufferedImage CURRENT_LED_IMAGE) {
        this.currentLedImage = CURRENT_LED_IMAGE;
        this.repaint(this.INNER_BOUNDS);
    }

    public final BufferedImage create_LED_Image(int SIZE, int STATE, LedColor LED_COLOR, LedType LED_TYPE) {
        Point2D.Double LED_LIGHTREFLEX_STOP;
        Point2D.Double LED_LIGHTREFLEX_START;
        Shape LED_LIGHTREFLEX;
        Color[] LED_ON_CORONA_COLORS;
        Color[] LED_ON_COLORS;
        Color[] LED_OFF_COLORS;
        RectangularShape LED;
        if (SIZE <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        StringBuilder KEY = new StringBuilder(32);
        KEY.append(Integer.toString(SIZE));
        KEY.append("_");
        KEY.append(Integer.toString(STATE));
        KEY.append("_");
        KEY.append((Object)LED_COLOR);
        KEY.append("_");
        KEY.append((Object)LED_TYPE);
        if (LED_COLOR == LedColor.CUSTOM) {
            StringBuilder sb = new StringBuilder();
            sb.append("#");
            String RED_HEX = Integer.toHexString(this.customLedColor.COLOR.getRed());
            String BLUE_HEX = Integer.toHexString(this.customLedColor.COLOR.getBlue());
            String GREEN_HEX = Integer.toHexString(this.customLedColor.COLOR.getGreen());
            if (RED_HEX.length() == 1) {
                sb.append("0");
            }
            sb.append(RED_HEX);
            if (GREEN_HEX.length() == 1) {
                sb.append("0");
            }
            sb.append(GREEN_HEX);
            if (BLUE_HEX.length() == 1) {
                sb.append("0");
            }
            sb.append(BLUE_HEX);
            if (this.customLedColor.COLOR.getAlpha() != 255) {
                String ALPHA_HEX = Integer.toHexString(this.customLedColor.COLOR.getAlpha());
                if (ALPHA_HEX.length() == 1) {
                    sb.append("0");
                }
                sb.append(ALPHA_HEX);
            }
            KEY.append("_").append(sb.toString());
        }
        if (CACHE.containsKey(KEY.toString())) {
            return CACHE.get(KEY.toString());
        }
        BufferedImage IMAGE = UTIL.createImage(SIZE, SIZE, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        switch (LED_TYPE) {
            case RECT_VERTICAL: {
                LED = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.3421052632, (double)IMAGE_HEIGHT * 0.1052631579, (double)IMAGE_WIDTH * 0.3157894737, (double)IMAGE_HEIGHT * 0.7894736842);
                break;
            }
            case RECT_HORIZONTAL: {
                LED = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.1052631579, (double)IMAGE_HEIGHT * 0.3421052632, (double)IMAGE_WIDTH * 0.7894736842, (double)IMAGE_HEIGHT * 0.3157894737);
                break;
            }
            default: {
                LED = new Ellipse2D.Double(0.25 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
            }
        }
        Ellipse2D.Double LED_CORONA = new Ellipse2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT);
        Point2D.Double LED_CENTER = new Point2D.Double(LED.getBounds2D().getCenterX(), LED.getBounds2D().getCenterY());
        float[] LED_FRACTIONS = new float[]{0.0f, 0.2f, 1.0f};
        if (LED_COLOR != LedColor.CUSTOM) {
            LED_OFF_COLORS = new Color[]{LED_COLOR.INNER_COLOR1_OFF, LED_COLOR.INNER_COLOR2_OFF, LED_COLOR.OUTER_COLOR_OFF};
            LED_ON_COLORS = new Color[]{LED_COLOR.INNER_COLOR1_ON, LED_COLOR.INNER_COLOR2_ON, LED_COLOR.OUTER_COLOR_ON};
            LED_ON_CORONA_COLORS = new Color[]{UTIL.setAlpha(LED_COLOR.CORONA_COLOR, 0.4f), UTIL.setAlpha(LED_COLOR.CORONA_COLOR, 0.4f), UTIL.setAlpha(LED_COLOR.CORONA_COLOR, 0.25f), UTIL.setAlpha(LED_COLOR.CORONA_COLOR, 0.15f), UTIL.setAlpha(LED_COLOR.CORONA_COLOR, 0.05f), UTIL.setAlpha(LED_COLOR.CORONA_COLOR, 0.0f)};
        } else {
            LED_OFF_COLORS = new Color[]{this.customLedColor.INNER_COLOR1_OFF, this.customLedColor.INNER_COLOR2_OFF, this.customLedColor.OUTER_COLOR_OFF};
            LED_ON_COLORS = new Color[]{this.customLedColor.INNER_COLOR1_ON, this.customLedColor.INNER_COLOR2_ON, this.customLedColor.OUTER_COLOR_ON};
            LED_ON_CORONA_COLORS = new Color[]{UTIL.setAlpha(this.customLedColor.CORONA_COLOR, 0.4f), UTIL.setAlpha(this.customLedColor.CORONA_COLOR, 0.4f), UTIL.setAlpha(this.customLedColor.CORONA_COLOR, 0.25f), UTIL.setAlpha(this.customLedColor.CORONA_COLOR, 0.15f), UTIL.setAlpha(this.customLedColor.CORONA_COLOR, 0.05f), UTIL.setAlpha(this.customLedColor.CORONA_COLOR, 0.0f)};
        }
        float[] LED_INNER_SHADOW_FRACTIONS = new float[]{0.0f, 0.8f, 1.0f};
        Color[] LED_INNER_SHADOW_COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.4f)};
        float[] LED_ON_CORONA_FRACTIONS = new float[]{0.0f, 0.6f, 0.7f, 0.8f, 0.85f, 1.0f};
        RadialGradientPaint LED_OFF_GRADIENT = new RadialGradientPaint(LED_CENTER, 0.25f * (float)IMAGE_WIDTH, LED_FRACTIONS, LED_OFF_COLORS);
        RadialGradientPaint LED_ON_GRADIENT = new RadialGradientPaint(LED_CENTER, 0.25f * (float)IMAGE_WIDTH, LED_FRACTIONS, LED_ON_COLORS);
        RadialGradientPaint LED_INNER_SHADOW_GRADIENT = new RadialGradientPaint(LED_CENTER, 0.25f * (float)IMAGE_WIDTH, LED_INNER_SHADOW_FRACTIONS, LED_INNER_SHADOW_COLORS);
        RadialGradientPaint LED_ON_CORONA_GRADIENT = new RadialGradientPaint(LED_CENTER, 0.5f * (float)IMAGE_WIDTH, LED_ON_CORONA_FRACTIONS, LED_ON_CORONA_COLORS);
        switch (LED_TYPE) {
            case RECT_VERTICAL: {
                GeneralPath VERTICAL_HL = new GeneralPath();
                VERTICAL_HL.setWindingRule(0);
                VERTICAL_HL.moveTo((double)IMAGE_WIDTH * 0.34210526315789475, (double)IMAGE_HEIGHT * 0.10526315789473684);
                VERTICAL_HL.lineTo((double)IMAGE_WIDTH * 0.6578947368421053, (double)IMAGE_HEIGHT * 0.10526315789473684);
                VERTICAL_HL.lineTo((double)IMAGE_WIDTH * 0.6578947368421053, (double)IMAGE_HEIGHT * 0.3684210526315789);
                VERTICAL_HL.curveTo((double)IMAGE_WIDTH * 0.6578947368421053, (double)IMAGE_HEIGHT * 0.3684210526315789, (double)IMAGE_WIDTH * 0.631578947368421, (double)IMAGE_HEIGHT * 0.42105263157894735, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.42105263157894735);
                VERTICAL_HL.curveTo((double)IMAGE_WIDTH * 0.3684210526315789, (double)IMAGE_HEIGHT * 0.42105263157894735, (double)IMAGE_WIDTH * 0.34210526315789475, (double)IMAGE_HEIGHT * 0.3684210526315789, (double)IMAGE_WIDTH * 0.34210526315789475, (double)IMAGE_HEIGHT * 0.3684210526315789);
                VERTICAL_HL.lineTo((double)IMAGE_WIDTH * 0.34210526315789475, (double)IMAGE_HEIGHT * 0.10526315789473684);
                VERTICAL_HL.closePath();
                LED_LIGHTREFLEX = VERTICAL_HL;
                LED_LIGHTREFLEX_START = new Point2D.Double(0.0, VERTICAL_HL.getBounds2D().getMinY());
                LED_LIGHTREFLEX_STOP = new Point2D.Double(0.0, VERTICAL_HL.getBounds2D().getMaxY());
                break;
            }
            case RECT_HORIZONTAL: {
                GeneralPath HORIZONTAL_HL = new GeneralPath();
                HORIZONTAL_HL.setWindingRule(0);
                HORIZONTAL_HL.moveTo((double)IMAGE_WIDTH * 0.10526315789473684, (double)IMAGE_HEIGHT * 0.34210526315789475);
                HORIZONTAL_HL.lineTo((double)IMAGE_WIDTH * 0.8947368421052632, (double)IMAGE_HEIGHT * 0.34210526315789475);
                HORIZONTAL_HL.lineTo((double)IMAGE_WIDTH * 0.8947368421052632, (double)IMAGE_HEIGHT * 0.42105263157894735);
                HORIZONTAL_HL.curveTo((double)IMAGE_WIDTH * 0.8947368421052632, (double)IMAGE_HEIGHT * 0.42105263157894735, (double)IMAGE_WIDTH * 0.7894736842105263, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5);
                HORIZONTAL_HL.curveTo((double)IMAGE_WIDTH * 0.21052631578947367, (double)IMAGE_HEIGHT * 0.5, (double)IMAGE_WIDTH * 0.10526315789473684, (double)IMAGE_HEIGHT * 0.42105263157894735, (double)IMAGE_WIDTH * 0.10526315789473684, (double)IMAGE_HEIGHT * 0.42105263157894735);
                HORIZONTAL_HL.lineTo((double)IMAGE_WIDTH * 0.10526315789473684, (double)IMAGE_HEIGHT * 0.34210526315789475);
                HORIZONTAL_HL.closePath();
                LED_LIGHTREFLEX = HORIZONTAL_HL;
                LED_LIGHTREFLEX_START = new Point2D.Double(0.0, LED_LIGHTREFLEX.getBounds2D().getMinY());
                LED_LIGHTREFLEX_STOP = new Point2D.Double(0.0, LED_LIGHTREFLEX.getBounds2D().getMaxY());
                break;
            }
            default: {
                LED_LIGHTREFLEX = new Ellipse2D.Double(0.4 * (double)IMAGE_WIDTH, 0.35 * (double)IMAGE_WIDTH, 0.2 * (double)IMAGE_WIDTH, 0.15 * (double)IMAGE_WIDTH);
                LED_LIGHTREFLEX_START = new Point2D.Double(0.0, LED_LIGHTREFLEX.getBounds2D().getMinY());
                LED_LIGHTREFLEX_STOP = new Point2D.Double(0.0, LED_LIGHTREFLEX.getBounds2D().getMaxY());
            }
        }
        float[] LIGHT_REFLEX_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] LIGHTREFLEX_COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.4f), new Color(1.0f, 1.0f, 1.0f, 0.0f)};
        LinearGradientPaint LED_LIGHTREFLEX_GRADIENT = new LinearGradientPaint(LED_LIGHTREFLEX_START, LED_LIGHTREFLEX_STOP, LIGHT_REFLEX_FRACTIONS, LIGHTREFLEX_COLORS);
        switch (STATE) {
            case 1: {
                G2.setPaint(LED_ON_CORONA_GRADIENT);
                G2.fill(LED_CORONA);
                switch (LED_TYPE) {
                    case ROUND: {
                        G2.setPaint(LED_ON_GRADIENT);
                        G2.fill(LED);
                        G2.setPaint(LED_INNER_SHADOW_GRADIENT);
                        G2.fill(LED);
                        break;
                    }
                    case RECT_VERTICAL: {
                        G2.drawImage((Image)Shadow.INSTANCE.createInnerShadow(LED, LED_ON_GRADIENT, 0, 0.65f, Color.BLACK, 20, 315), (int)((double)IMAGE_WIDTH * 0.3421052632), (int)((double)IMAGE_HEIGHT * 0.1052631579), null);
                        break;
                    }
                    case RECT_HORIZONTAL: {
                        G2.drawImage((Image)Shadow.INSTANCE.createInnerShadow(LED, LED_ON_GRADIENT, 0, 0.65f, Color.BLACK, 20, 315), (int)((double)IMAGE_WIDTH * 0.1052631579), (int)((double)IMAGE_HEIGHT * 0.3421052632), null);
                    }
                }
                G2.setPaint(LED_LIGHTREFLEX_GRADIENT);
                G2.fill(LED_LIGHTREFLEX);
                break;
            }
            default: {
                switch (LED_TYPE) {
                    case ROUND: {
                        G2.setPaint(LED_OFF_GRADIENT);
                        G2.fill(LED);
                        G2.setPaint(LED_INNER_SHADOW_GRADIENT);
                        G2.fill(LED);
                        break;
                    }
                    case RECT_VERTICAL: {
                        G2.drawImage((Image)Shadow.INSTANCE.createInnerShadow(LED, LED_OFF_GRADIENT, 0, 0.65f, Color.BLACK, 20, 315), (int)((double)IMAGE_WIDTH * 0.3421052632), (int)((double)IMAGE_HEIGHT * 0.1052631579), null);
                        break;
                    }
                    case RECT_HORIZONTAL: {
                        G2.drawImage((Image)Shadow.INSTANCE.createInnerShadow(LED, LED_OFF_GRADIENT, 0, 0.65f, Color.BLACK, 20, 315), (int)((double)IMAGE_WIDTH * 0.1052631579), (int)((double)IMAGE_HEIGHT * 0.3421052632), null);
                    }
                }
                G2.setPaint(LED_LIGHTREFLEX_GRADIENT);
                G2.fill(LED_LIGHTREFLEX);
            }
        }
        G2.dispose();
        CACHE.put(KEY.toString(), IMAGE);
        return IMAGE;
    }

    private void calcInnerBounds() {
        Insets INSETS = this.getInsets();
        int SIZE = this.getWidth() - INSETS.left - INSETS.right <= this.getHeight() - INSETS.top - INSETS.bottom ? this.getWidth() - INSETS.left - INSETS.right : this.getHeight() - INSETS.top - INSETS.bottom;
        this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, SIZE, SIZE);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (dim.width < 16 || dim.height < 16) {
            dim = new Dimension(16, 16);
        }
        return dim;
    }

    @Override
    public void setMinimumSize(Dimension DIM) {
        int width = DIM.width < 16 ? 16 : DIM.width;
        int height = DIM.height < 16 ? 16 : DIM.height;
        int SIZE = width <= height ? width : height;
        super.setMinimumSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        if (dim.width > 1080 || dim.height > 1080) {
            dim = new Dimension(1080, 1080);
        }
        return dim;
    }

    @Override
    public void setMaximumSize(Dimension DIM) {
        int width = DIM.width > 1080 ? 1080 : DIM.width;
        int height = DIM.height > 1080 ? 1080 : DIM.height;
        int SIZE = width <= height ? width : height;
        super.setMaximumSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        int SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        super.setPreferredSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        int SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        super.setSize(SIZE, SIZE);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
    }

    @Override
    public void setSize(Dimension DIM) {
        int SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        super.setSize(new Dimension(SIZE, SIZE));
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        if (BOUNDS.width <= BOUNDS.height) {
            int yNew;
            switch (this.verticalAlignment) {
                case 1: {
                    yNew = BOUNDS.y;
                    break;
                }
                case 3: {
                    yNew = BOUNDS.y + (BOUNDS.height - BOUNDS.width);
                    break;
                }
                default: {
                    yNew = BOUNDS.y + (BOUNDS.height - BOUNDS.width) / 2;
                }
            }
            super.setBounds(BOUNDS.x, yNew, BOUNDS.width, BOUNDS.width);
        } else {
            int xNew;
            switch (this.horizontalAlignment) {
                case 2: {
                    xNew = BOUNDS.x;
                    break;
                }
                case 4: {
                    xNew = BOUNDS.x + (BOUNDS.width - BOUNDS.height);
                    break;
                }
                default: {
                    xNew = BOUNDS.x + (BOUNDS.width - BOUNDS.height) / 2;
                }
            }
            super.setBounds(xNew, BOUNDS.y, BOUNDS.height, BOUNDS.height);
        }
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        if (WIDTH <= HEIGHT) {
            int yNew;
            switch (this.verticalAlignment) {
                case 1: {
                    yNew = Y;
                    break;
                }
                case 3: {
                    yNew = Y + (HEIGHT - WIDTH);
                    break;
                }
                default: {
                    yNew = Y + (HEIGHT - WIDTH) / 2;
                }
            }
            super.setBounds(X, yNew, WIDTH, WIDTH);
        } else {
            int xNew;
            switch (this.horizontalAlignment) {
                case 2: {
                    xNew = X;
                    break;
                }
                case 4: {
                    xNew = X + (WIDTH - HEIGHT);
                    break;
                }
                default: {
                    xNew = X + (WIDTH - HEIGHT) / 2;
                }
            }
            super.setBounds(xNew, Y, HEIGHT, HEIGHT);
        }
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
        this.initialized = true;
    }

    @Override
    public void setBorder(Border BORDER) {
        super.setBorder(BORDER);
        this.calcInnerBounds();
        this.init(this.INNER_BOUNDS.width);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int HORIZONTAL_ALIGNMENT) {
        this.horizontalAlignment = HORIZONTAL_ALIGNMENT;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int VERTICAL_ALIGNMENT) {
        this.verticalAlignment = VERTICAL_ALIGNMENT;
    }

    public void dispose() {
        this.LED_BLINKING_TIMER.removeActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.LED_BLINKING_TIMER)) {
            this.currentLedImage = this.ledOn ? this.getLedImageOn() : this.getLedImageOff();
            this.ledOn ^= true;
            this.repaint();
        }
    }

    @Override
    public String toString() {
        return "LED";
    }
}

