/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.opensr5.io.DataListener;
import com.opensr5.io.WriteStream;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.io.serial.AbstractIoStream;
import com.rusefi.io.serial.StreamStatistics;
import com.rusefi.io.tcp.BinaryProtocolServer;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public interface IoStream
extends WriteStream,
Closeable,
StreamStatistics {
    @NotNull
    default public BinaryProtocolServer.Packet readPacket() throws IOException {
        short length = this.readShort();
        return BinaryProtocolServer.readPromisedBytes(this.getDataBuffer(), length);
    }

    default public void sendPacket(BinaryProtocolServer.Packet packet) throws IOException {
        this.writeShort(packet.getPacket().length);
        this.write(packet.getPacket());
        this.writeInt(packet.getCrc());
        this.flush();
        this.onActivity();
    }

    public long latestActivityTime();

    public void addCloseListener(Runnable var1);

    public Object getIoLock();

    public void onActivity();

    default public void sendPacket(byte[] plainPacket) throws IOException {
        if (plainPacket.length == 0) {
            throw new IllegalArgumentException("Empty packets are not valid.");
        }
        byte[] packet = IoHelper.makeCrc32Packet(plainPacket);
        this.write(packet);
        this.flush();
    }

    public void setInputListener(DataListener var1);

    public boolean isClosed();

    public AbstractIoStream.StreamStats getStreamStats();

    @Override
    public void close();

    public IncomingDataBuffer getDataBuffer();

    default public short readShort() throws EOFException {
        return this.getDataBuffer().readShort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public byte[] sendAndGetPacket(byte[] packet, String message) throws IOException {
        IoStream ioStream = this;
        synchronized (ioStream) {
            this.sendPacket(packet);
            return this.getDataBuffer().getPacket(message);
        }
    }
}

