/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging;

import com.devexperts.logging.DefaultLogging;
import com.devexperts.logging.TraceLogging;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class Logging {
    private static final boolean TRACE_LOGGING = Logging.class.desiredAssertionStatus();
    private static final int FINEST_INT = Level.FINEST.intValue();
    private static final int FINE_INT = Level.FINE.intValue();
    public static final String LOG_CLASS_NAME = "log.className";
    public static final String LOG_FILE_PROPERTY = "log.file";
    public static final String ERR_FILE_PROPERTY = "err.file";
    public static final String LOG_MAX_FILE_SIZE_PROPERTY = "log.maxFileSize";
    public static final String ERR_MAX_FILE_SIZE_PROPERTY = "err.maxFileSize";
    public static final String DEFAULT_MAX_FILE_SIZE = "900M";
    private static final ConcurrentMap<String, Logging> INSTANCES = new ConcurrentHashMap<String, Logging>();
    private static final DefaultLogging IMPL = Logging.configure(DefaultLogging.getProperty("log.className", "com.devexperts.logging.Log4j2Logging"));
    private final Object peer;

    public static Logging getLogging(Class<?> clazz) {
        return Logging.getLogging(clazz.getName());
    }

    private static Logging getLogging(String name) {
        Logging logging = (Logging)INSTANCES.get(name);
        if (logging != null) {
            return logging;
        }
        INSTANCES.putIfAbsent(name, new Logging(name));
        return (Logging)INSTANCES.get(name);
    }

    public static void configureLogFile(String log_file) {
        Logging.reportErrors(IMPL, IMPL.configureLogFileAndConsole(log_file));
    }

    protected Logging() {
        this.peer = IMPL.getPeer(this.getClass().getName());
    }

    protected Logging(String name) {
        this.peer = IMPL.getPeer(name);
    }

    public final String getName() {
        return IMPL.getName(this.peer);
    }

    public final void configureDebugEnabled(boolean defaultDebugEnabled) {
        IMPL.setDebugEnabled(this.peer, Boolean.valueOf(DefaultLogging.getProperty(this.getName() + ".debug", String.valueOf(defaultDebugEnabled))));
    }

    public final boolean debugEnabled() {
        return IMPL.debugEnabled(this.peer);
    }

    public final void trace(String message) {
        this.log(Level.FINEST, message, null);
    }

    public final void debug(String message) {
        this.log(Level.FINE, message, null);
    }

    public final void debug(String message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    public final void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public final void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public final void warn(String message) {
        this.log(Level.WARNING, message, null);
    }

    public final void warn(String message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    public final void error(String message) {
        this.log(Level.SEVERE, message, null);
    }

    public final void error(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    public final RuntimeException log(RuntimeException e) {
        this.log(Level.SEVERE, e.getMessage(), e);
        return e;
    }

    protected String decorateLogMessage(String msg) {
        return msg;
    }

    private void log(Level level, String msg, Throwable t) {
        int levelInt;
        if (TRACE_LOGGING) {
            TraceLogging.log(this.getName(), level, this.decorateLogMessage(msg), t);
        }
        if ((levelInt = level.intValue()) <= FINEST_INT) {
            return;
        }
        if (levelInt <= FINE_INT && !IMPL.debugEnabled(this.peer)) {
            return;
        }
        try {
            msg = this.decorateLogMessage(msg == null ? "" : msg);
        }
        catch (Throwable tt) {
            IMPL.log(this.peer, Level.SEVERE, "Failed to decorate log message", tt);
        }
        IMPL.log(this.peer, level, msg, t);
    }

    private static DefaultLogging configure(String className) {
        DefaultLogging impl = null;
        LinkedHashMap<String, Exception> errors = new LinkedHashMap<String, Exception>();
        if (!className.isEmpty()) {
            try {
                impl = (DefaultLogging)Class.forName(className).newInstance();
                errors.putAll(impl.configure());
            }
            catch (Throwable t) {
                impl = null;
                if (t instanceof LinkageError || !(t.getCause() instanceof LinkageError)) {
                    // empty if block
                }
            }
        }
        if (impl == null) {
            try {
                impl = (DefaultLogging)Class.forName("com.devexperts.logging.Log4j2Logging").newInstance();
                errors.putAll(impl.configure());
            }
            catch (Throwable t) {
                impl = null;
                if (t instanceof LinkageError || !(t.getCause() instanceof LinkageError)) {
                    // empty if block
                }
            }
        }
        if (impl == null) {
            impl = new DefaultLogging();
            errors.putAll(impl.configure());
        }
        Logging.reportErrors(impl, errors);
        return impl;
    }

    private static void reportErrors(DefaultLogging impl, Map<String, Exception> errors) {
        for (Map.Entry<String, Exception> entry : errors.entrySet()) {
            impl.log(impl.getPeer("config"), Level.SEVERE, entry.getKey(), entry.getValue());
        }
    }
}

