/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.SymbolImageFactory;
import eu.hansolo.steelseries.tools.SymbolType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class Indicator
extends AbstractRadial {
    private static final SymbolImageFactory SYMBOL_FACTORY = SymbolImageFactory.INSTANCE;
    private BufferedImage bImage;
    private BufferedImage symbolOnImage;
    private BufferedImage symbolOffImage;
    private BufferedImage fImage;
    private BufferedImage disabledImage;
    private SymbolType symbolType = SymbolType.HORN;
    private ColorDef onColor = ColorDef.RED;
    private CustomColorDef customOnColor = new CustomColorDef(Color.RED);
    private ColorDef offColor = ColorDef.GRAY;
    private CustomColorDef customOffColor = new CustomColorDef(Color.DARK_GRAY);
    private boolean on = false;
    private boolean glow = true;

    public Indicator() {
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        int GAUGE_HEIGHT;
        int GAUGE_WIDTH = this.isFrameVisible() ? WIDTH : this.getGaugeBounds().width;
        int n = GAUGE_HEIGHT = this.isFrameVisible() ? HEIGHT : this.getGaugeBounds().height;
        if (GAUGE_WIDTH <= 1 || GAUGE_HEIGHT <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.symbolOnImage != null) {
            this.symbolOnImage.flush();
        }
        this.symbolOnImage = SYMBOL_FACTORY.createSymbol(GAUGE_WIDTH, this.symbolType, this.onColor, this.customOnColor, this.glow);
        if (this.symbolOffImage != null) {
            this.symbolOffImage.flush();
        }
        this.symbolOffImage = SYMBOL_FACTORY.createSymbol(GAUGE_WIDTH, this.symbolType, this.offColor, this.customOffColor, false);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(GAUGE_WIDTH, GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(GAUGE_WIDTH, "", "", this.bImage);
        }
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(GAUGE_WIDTH, GAUGE_WIDTH, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(GAUGE_WIDTH, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(GAUGE_WIDTH);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        G2.drawImage((Image)this.bImage, 0, 0, null);
        if (this.on) {
            G2.drawImage((Image)this.symbolOnImage, 0, 0, null);
        } else {
            G2.drawImage((Image)this.symbolOffImage, 0, 0, null);
        }
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        G2.dispose();
    }

    public SymbolType getSymbolType() {
        return this.symbolType;
    }

    public void setSymbolType(SymbolType SYMBOL_TYPE) {
        this.symbolType = SYMBOL_TYPE;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean ON) {
        this.on = ON;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public ColorDef getOnColor() {
        return this.onColor;
    }

    public void setOnColor(ColorDef ON_COLOR) {
        this.onColor = ON_COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public CustomColorDef getCustomOnColor() {
        return this.customOnColor;
    }

    public void setCustomOnColor(CustomColorDef CUSTOM_ON_COLOR) {
        this.customOnColor = CUSTOM_ON_COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public ColorDef getOffColor() {
        return this.offColor;
    }

    public void setOffColor(ColorDef OFF_COLOR) {
        this.offColor = OFF_COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public CustomColorDef getCustomOffColor() {
        return this.customOffColor;
    }

    public void setCustomOffColor(CustomColorDef CUSTOM_OFF_COLOR) {
        this.customOffColor = CUSTOM_OFF_COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isGlow() {
        return this.glow;
    }

    public void setGlow(boolean GLOW) {
        this.glow = GLOW;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(50, 50);
    }

    @Override
    public String toString() {
        return "Indicator";
    }
}

