/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.opensr5.ini.PrimeTunerStudioCache;
import com.rusefi.AvailableHardware;
import com.rusefi.ConnectivityContext;
import com.rusefi.ConsoleUI;
import com.rusefi.FileLog;
import com.rusefi.HwCiF4Discovery;
import com.rusefi.Launcher;
import com.rusefi.NamedThreadFactory;
import com.rusefi.PortResult;
import com.rusefi.PortsComboBox;
import com.rusefi.SerialPortType;
import com.rusefi.SimulatorHelper;
import com.rusefi.UiProperties;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.io.serial.BaudRateHolder;
import com.rusefi.maintenance.DriverInstall;
import com.rusefi.maintenance.MaintenanceUtil;
import com.rusefi.maintenance.ProgramSelector;
import com.rusefi.maintenance.StatusAnimation;
import com.rusefi.maintenance.UpdateMode;
import com.rusefi.ui.BasicLogoHelper;
import com.rusefi.ui.LogoHelper;
import com.rusefi.ui.duplicates.ConsoleBundleUtil;
import com.rusefi.ui.util.HorizontalLine;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.ToolButtons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.putgemin.VerticalFlowLayout;

public class StartupFrame {
    private static final Logging log = Logging.getLogging(Launcher.class);
    public static final String ALWAYS_AUTO_PORT = "always_auto_port";
    private static final String NO_PORTS_FOUND = "<html>No ports found!<br>Confirm blue LED is blinking</html>";
    public static final String SCANNING_PORTS = "Scanning ports";
    private final JFrame frame;
    private final JPanel connectPanel = new JPanel(new FlowLayout());
    private final PortsComboBox portsComboBox = new PortsComboBox();
    private final JPanel leftPanel = new JPanel(new VerticalFlowLayout());
    private final JPanel realHardwarePanel = new JPanel(new MigLayout());
    private final JPanel miscPanel = new JPanel(new MigLayout()){

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(size.width, ((StartupFrame)StartupFrame.this).realHardwarePanel.getPreferredSize().width), size.height);
        }
    };
    private final ConnectivityContext connectivityContext;
    private boolean isProceeding;
    private final JLabel noPortsMessage = new JLabel();
    private final StatusAnimation status;
    private ProgramSelector selector;
    private boolean firstTimeHasEcuWithOpenBlt = true;

    public StartupFrame(ConnectivityContext connectivityContext) {
        this.connectivityContext = connectivityContext;
        String title = UiProperties.getWhiteLabel() + " console " + 20251017;
        log.info(title);
        this.noPortsMessage.setForeground(Color.red);
        this.status = new StatusAnimation(new StatusAnimation.StatusConsumer(){

            @Override
            public void onStatus(String niceStatus) {
                StartupFrame.this.noPortsMessage.setText(niceStatus);
            }
        }, SCANNING_PORTS);
        this.frame = FrameHelper.createFrame(title).getFrame();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent ev) {
                if (!StartupFrame.this.isProceeding) {
                    PersistentConfiguration.getConfig().save();
                    log.info("Configuration saved.");
                }
            }
        });
        new NamedThreadFactory("ecuDef primer").newThread(PrimeTunerStudioCache::primeWithLocalFile).start();
    }

    public void showUi() {
        JLabel logo;
        String panelTitle = UiProperties.useSimulator() ? "Real stm32" : "";
        this.realHardwarePanel.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.darkGray), panelTitle));
        this.miscPanel.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.darkGray), "Miscellaneous"));
        this.connectPanel.add(this.portsComboBox.getComboPorts());
        final JComboBox<String> comboSpeeds = StartupFrame.createSpeedCombo();
        comboSpeeds.setToolTipText("For 'STMicroelectronics Virtual COM Port' device any speed setting would work the same");
        this.connectPanel.add(comboSpeeds);
        final JButton connectButton = new JButton("Connect", new ImageIcon(this.getClass().getResource("/com/rusefi/connect48.png")));
        UiUtils.setToolTip(connectButton, "Connect to real hardware");
        final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("Always auto-connect port");
        menuItem.setState(PersistentConfiguration.getBoolProperty(ALWAYS_AUTO_PORT));
        menuItem.addActionListener(e -> PersistentConfiguration.setBoolProperty(ALWAYS_AUTO_PORT, menuItem.getState()));
        connectButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                JPopupMenu menu = new JPopupMenu();
                menu.add(menuItem);
                menu.show(connectButton, e.getX(), e.getY());
            }
        });
        this.connectPanel.add(connectButton);
        this.connectPanel.setVisible(false);
        this.frame.getRootPane().setDefaultButton(connectButton);
        connectButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    StartupFrame.this.connectButtonAction(comboSpeeds);
                }
            }
        });
        connectButton.addActionListener(e -> this.connectButtonAction(comboSpeeds));
        Optional<JPanel> newReleaseNotification = StartupFrame.newReleaseAnnounce("rusefi_autoupdate.exe", "left", () -> this.realHardwarePanel.getPreferredSize().width);
        if (newReleaseNotification.isPresent()) {
            this.leftPanel.add(newReleaseNotification.get());
        }
        this.leftPanel.add(this.realHardwarePanel);
        if (UiProperties.useSimulator()) {
            this.leftPanel.add(this.miscPanel);
        }
        if (FileLog.isWindows()) {
            JPanel topButtons = new JPanel(new FlowLayout(1, 5, 0));
            topButtons.add(ToolButtons.createShowDeviceManagerButton());
            if (DriverInstall.isFolderExist()) {
                topButtons.add(DriverInstall.createButton());
            }
            if (UiProperties.usePCAN()) {
                topButtons.add(ToolButtons.createPcanConnectorButton());
            }
            this.realHardwarePanel.add((Component)topButtons, "right, wrap");
        }
        this.realHardwarePanel.add((Component)this.connectPanel, "right, wrap");
        this.realHardwarePanel.add((Component)this.noPortsMessage, "right, wrap");
        this.noPortsMessage.setToolTipText("Check you cables. Check your drivers. Do you want to start simulator maybe?");
        this.selector = new ProgramSelector(this.connectivityContext, this.portsComboBox.getComboPorts());
        this.realHardwarePanel.add((Component)new HorizontalLine(), "right, wrap");
        this.realHardwarePanel.add((Component)this.selector.getControl(), "right, wrap");
        if (FileLog.isWindows()) {
            JComponent updateHelp = ProgramSelector.createHelpButton();
            JLabel comp = StartupFrame.binaryModificationControl();
            this.realHardwarePanel.add((Component)comp, "right, wrap");
            this.realHardwarePanel.add((Component)updateHelp, "right, wrap");
        }
        this.connectivityContext.getSerialPortScanner().addListener(currentHardware -> SwingUtilities.invokeLater(() -> {
            this.status.stop();
            this.selector.apply(currentHardware);
            this.applyKnownPorts(currentHardware);
            this.frame.pack();
        }));
        this.miscPanel.add(SimulatorHelper.createSimulatorComponent(this));
        JPanel rightPanel = new JPanel(new VerticalFlowLayout());
        if (ConsoleBundleUtil.readBundleFullNameNotNull().getTarget().contains("proteus_f7")) {
            final String text = "WARNING: Proteus F7";
            final URLLabel urlLabel = new URLLabel(text, "https://github.com/rusefi/rusefi/wiki/F7-requires-full-erase");
            new Timer(500, new ActionListener(){
                int counter;

                @Override
                public void actionPerformed(ActionEvent e) {
                    urlLabel.setText(text, this.counter++ % 2 == 0);
                }
            }).start();
            rightPanel.add(urlLabel);
        }
        if ((logo = LogoHelper.createLogoLabel()) != null) {
            rightPanel.add(logo);
        }
        if (ConnectionAndMeta.isDefaultWhitelabel(UiProperties.getWhiteLabel())) {
            rightPanel.add(LogoHelper.createUrlLabel());
        }
        rightPanel.add(new JLabel("Console 20251017"));
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this.leftPanel, "West");
        content.add((Component)rightPanel, "East");
        this.frame.add(content);
        this.frame.pack();
        StartupFrame.setFrameIcon(this.frame);
        log.info("setVisible");
        this.frame.setVisible(true);
        UiUtils.centerWindow(this.frame);
        KeyListener hwTestEasterEgg = this.functionalTestEasterEgg();
        for (Component component : UiUtils.getAllComponents(this.frame)) {
            component.addKeyListener(hwTestEasterEgg);
        }
    }

    @NotNull
    public static Optional<JPanel> newReleaseAnnounce(String upgradeExeFileName, String textAlign, final Supplier<Integer> minWidthSupplier) {
        String nextBranchName = ConsoleBundleUtil.readBundleFullNameNotNull().getNextBranchName();
        if (nextBranchName != null && !nextBranchName.isBlank()) {
            JLabel newReleaseAmmomceMessage = new JLabel(String.format("<html><p style=\"text-align: %s;font-weight: bold;color:red\">New release `%s` is available!<br/>To upgrade please restart `%s`.</p></html>", textAlign, nextBranchName, upgradeExeFileName));
            JPanel newReleaseAnnouncePanel = new JPanel((LayoutManager)new MigLayout()){

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    return new Dimension(Math.max(size.width, (Integer)minWidthSupplier.get()), size.height);
                }
            };
            newReleaseAnnouncePanel.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.darkGray), ""));
            newReleaseAnnouncePanel.add(newReleaseAmmomceMessage);
            return Optional.of(newReleaseAnnouncePanel);
        }
        return Optional.empty();
    }

    @NotNull
    public static JLabel binaryModificationControl() {
        JLabel jLabel;
        long binaryModificationTimestamp = MaintenanceUtil.getBinaryModificationTimestamp();
        if (binaryModificationTimestamp == 0L) {
            jLabel = new JLabel("firmware file not found");
            jLabel.setForeground(Color.red);
        } else {
            final Date binaryModificationDate = new Date(binaryModificationTimestamp);
            final String branchNameToDisplay = ConsoleBundleUtil.readBundleFullNameNotNull().getBranchName();
            jLabel = new JLabel(String.format("<html><center>%s files<br/>%s</center></html>", branchNameToDisplay, binaryModificationDate));
            jLabel.setToolTipText("Click to copy");
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(String.format("%s files\r%s", branchNameToDisplay, binaryModificationDate)), null);
                }
            });
        }
        return jLabel;
    }

    private void applyKnownPorts(AvailableHardware currentHardware) {
        boolean hasEcuWithOpenBlt;
        List<PortResult> ports = currentHardware.getKnownPorts();
        log.info("Rendering available ports: " + ports);
        this.connectPanel.setVisible(!ports.isEmpty());
        boolean hasEcuOrBootloader = StartupFrame.applyPortSelectionToUIcontrol(this.portsComboBox.getComboPorts(), ports);
        if (ports.isEmpty()) {
            this.noPortsMessage.setText(NO_PORTS_FOUND);
        } else {
            this.noPortsMessage.setText("Make sure you are disconnected from TunerStudio");
        }
        this.noPortsMessage.setVisible(ports.isEmpty() || !hasEcuOrBootloader);
        boolean bl = hasEcuWithOpenBlt = !currentHardware.getKnownPorts().stream().filter(portResult -> portResult.type == SerialPortType.EcuWithOpenblt).collect(Collectors.toList()).isEmpty();
        if (hasEcuWithOpenBlt && this.firstTimeHasEcuWithOpenBlt) {
            this.selector.setMode(UpdateMode.OPENBLT_AUTO);
            this.firstTimeHasEcuWithOpenBlt = false;
        }
        AutoupdateUtil.trueLayoutAndRepaint(this.connectPanel);
    }

    public static void setFrameIcon(Frame frame) {
        ImageIcon icon = LogoHelper.getBundleSpecificIcon();
        BasicLogoHelper.setFrameIcon(frame, icon);
    }

    private void connectButtonAction(JComboBox<String> comboSpeeds) {
        BaudRateHolder.INSTANCE.baudRate = Integer.parseInt((String)comboSpeeds.getSelectedItem());
        PortResult selectedPort = (PortResult)this.portsComboBox.getComboPorts().getSelectedItem();
        this.disposeFrameAndProceed();
        new ConsoleUI(selectedPort.port);
    }

    @NotNull
    private KeyListener functionalTestEasterEgg() {
        return new KeyAdapter(){
            private static final String TEST = "test";
            private String recentKeyStrokes = "";

            @Override
            public void keyTyped(KeyEvent e) {
                this.recentKeyStrokes = this.recentKeyStrokes + e.getKeyChar();
                if (this.recentKeyStrokes.toLowerCase().endsWith(TEST) && this.showTestConfirmation()) {
                    this.runFunctionalHardwareTest();
                }
            }

            private boolean showTestConfirmation() {
                return JOptionPane.showConfirmDialog(StartupFrame.this.frame, "Want to run functional test? This would freeze UI for the duration of the test", "Better do not run while connected to vehicle!!!", 0) == 0;
            }

            private void runFunctionalHardwareTest() {
                boolean isSuccess = HwCiF4Discovery.runHardwareTest();
                JOptionPane.showMessageDialog(null, "Function test passed: " + isSuccess + "\nSee log folder for details.");
            }
        };
    }

    public void disposeFrameAndProceed() {
        this.isProceeding = true;
        this.frame.dispose();
        this.status.stop();
        this.connectivityContext.getSerialPortScanner().stopTimer();
    }

    private static boolean applyPortSelectionToUIcontrol(JComboBox<PortResult> comboPorts, List<PortResult> ports) {
        comboPorts.removeAllItems();
        boolean hasEcuOrBootloader = false;
        for (PortResult port : ports) {
            comboPorts.addItem(port);
            if (port.type != SerialPortType.Ecu && port.type != SerialPortType.EcuWithOpenblt && port.type != SerialPortType.OpenBlt) continue;
            hasEcuOrBootloader = true;
        }
        String defaultPort = PersistentConfiguration.getConfig().getRoot().getProperty("port");
        if (!PersistentConfiguration.getBoolProperty(ALWAYS_AUTO_PORT)) {
            comboPorts.setSelectedItem(defaultPort);
        }
        AutoupdateUtil.trueLayoutAndRepaint(comboPorts);
        return hasEcuOrBootloader;
    }

    private static JComboBox<String> createSpeedCombo() {
        JComboBox<String> combo = new JComboBox<String>();
        String defaultSpeed = PersistentConfiguration.getConfig().getRoot().getProperty("speed", "115200");
        for (int speed : new int[]{9600, 14400, 19200, 38400, 57600, 115200, 460800, 921600}) {
            combo.addItem(Integer.toString(speed));
        }
        combo.setSelectedItem(defaultSpeed);
        return combo;
    }
}

