/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.LedColor;
import eu.hansolo.steelseries.tools.NumberSystem;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class DigitalRadial
extends AbstractRadial {
    private int noOfActiveLeds = 0;
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage lcdThresholdImage;
    private BufferedImage disabledImage;
    private BufferedImage ledGreenOff = UTIL.createImage(24, 24, 3);
    private BufferedImage ledYellowOff = UTIL.createImage(24, 24, 3);
    private BufferedImage ledRedOff = UTIL.createImage(24, 24, 3);
    private BufferedImage ledGreenOn = UTIL.createImage(24, 24, 3);
    private BufferedImage ledYellowOn = UTIL.createImage(24, 24, 3);
    private BufferedImage ledRedOn = UTIL.createImage(24, 24, 3);
    private Color valueColor = new Color(255, 0, 0, 255);
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private Point[] ledPosition;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();

    public DigitalRadial() {
        this.setUnitString("");
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return this;
        }
        if (this.isLcdVisible()) {
            if (this.isDigitalFont()) {
                this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.7f * (float)WIDTH * 0.15f));
            } else {
                this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.625f * (float)WIDTH * 0.15f));
            }
            if (this.isCustomLcdUnitFontEnabled()) {
                this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)WIDTH * 0.15f));
            } else {
                this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.25f * (float)WIDTH * 0.15f));
            }
            this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * (float)WIDTH * 0.15f));
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(WIDTH, WIDTH, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(WIDTH, WIDTH, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(WIDTH, WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(WIDTH, "", "", this.bImage);
        }
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(WIDTH, WIDTH, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(WIDTH, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.isLcdVisible()) {
            this.createLcdImage(new Rectangle2D.Double(((double)this.getGaugeBounds().width - (double)WIDTH * 0.48) / 2.0, (double)this.getGaugeBounds().height * 0.425, (double)WIDTH * 0.48, (double)WIDTH * 0.15), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
            this.LCD.setRect(((double)this.getGaugeBounds().width - (double)WIDTH * 0.4) / 2.0, (double)this.getGaugeBounds().height * 0.55, (double)WIDTH * 0.48, (double)WIDTH * 0.15);
            if (this.lcdThresholdImage != null) {
                this.lcdThresholdImage.flush();
            }
            this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)(this.LCD.getHeight() * 0.2045454545), (int)(this.LCD.getHeight() * 0.2045454545), this.getLcdColor().TEXT_COLOR);
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(WIDTH);
        this.ledPosition = new Point[]{new Point((int)((double)WIDTH * 0.186915887850467), (int)((double)WIDTH * 0.649532710280374)), new Point((int)((double)WIDTH * 0.116822429906542), (int)((double)WIDTH * 0.546728971962617)), new Point((int)((double)WIDTH * 0.088785046728972), (int)((double)WIDTH * 0.41588785046729)), new Point((int)((double)WIDTH * 0.116822429906542), (int)((double)WIDTH * 0.285046728971963)), new Point((int)((double)WIDTH * 0.177570093457944), (int)((double)WIDTH * 0.182242990654206)), new Point((int)((double)WIDTH * 0.280373831775701), (int)((double)WIDTH * 0.117222429906542)), new Point((int)((double)WIDTH * 0.411214953271028), (int)((double)WIDTH * 0.0794392523364486)), new Point((int)((double)WIDTH * 0.542056074766355), (int)((double)WIDTH * 0.117222429906542)), new Point((int)((double)WIDTH * 0.649532710280374), (int)((double)WIDTH * 0.182242990654206)), new Point((int)((double)WIDTH * 0.719626168224299), (int)((double)WIDTH * 0.285046728971963)), new Point((int)((double)WIDTH * 0.738317757009346), (int)((double)WIDTH * 0.41588785046729)), new Point((int)((double)WIDTH * 0.710280373831776), (int)((double)WIDTH * 0.546728971962617)), new Point((int)((double)WIDTH * 0.64018691588785), (int)((double)WIDTH * 0.649532710280374))};
        this.ledGreenOff.flush();
        this.ledGreenOff = this.create_LED_OFF_Image(WIDTH, LedColor.GREEN);
        this.ledYellowOff.flush();
        this.ledYellowOff = this.create_LED_OFF_Image(WIDTH, LedColor.YELLOW);
        this.ledRedOff.flush();
        this.ledRedOff = this.create_LED_OFF_Image(WIDTH, LedColor.RED);
        this.ledGreenOn.flush();
        this.ledGreenOn = this.create_LED_ON_Image(WIDTH, LedColor.GREEN);
        this.ledYellowOn.flush();
        this.ledYellowOn = this.create_LED_ON_Image(WIDTH, LedColor.YELLOW);
        this.ledRedOn.flush();
        this.ledRedOn = this.create_LED_ON_Image(WIDTH, LedColor.RED);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        super.paintComponent(g);
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        G2.drawImage((Image)this.bImage, 0, 0, null);
        for (int i = 0; i < 13; ++i) {
            if (i < 7) {
                if (i < this.noOfActiveLeds) {
                    G2.drawImage((Image)this.ledGreenOn, this.ledPosition[i].x, this.ledPosition[i].y, null);
                } else {
                    G2.drawImage((Image)this.ledGreenOff, this.ledPosition[i].x, this.ledPosition[i].y, null);
                }
            }
            if (i >= 7 && i < 12) {
                if (i < this.noOfActiveLeds) {
                    G2.drawImage((Image)this.ledYellowOn, this.ledPosition[i].x, this.ledPosition[i].y, null);
                } else {
                    G2.drawImage((Image)this.ledYellowOff, this.ledPosition[i].x, this.ledPosition[i].y, null);
                }
            }
            if (i != 12) continue;
            if (i < this.noOfActiveLeds) {
                G2.drawImage((Image)this.ledRedOn, this.ledPosition[i].x, this.ledPosition[i].y, null);
                continue;
            }
            G2.drawImage((Image)this.ledRedOff, this.ledPosition[i].x, this.ledPosition[i].y, null);
        }
        if (this.isLcdVisible()) {
            double UNIT_STRING_WIDTH;
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                G2.setColor(this.getCustomLcdForeground());
            } else {
                G2.setColor(this.getLcdColor().TEXT_COLOR);
            }
            G2.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), G2.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                G2.drawString(this.getLcdUnitString(), (int)(((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0 + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (int)((double)this.getGaugeBounds().height * 0.425 + this.LCD.getHeight() * 0.76));
                UNIT_STRING_WIDTH = this.UNIT_BOUNDARY.getWidth();
            } else {
                UNIT_STRING_WIDTH = 0.0;
            }
            G2.setFont(this.getLcdValueFont());
            switch (this.getModel().getNumberSystem()) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (int)(((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0 + (this.LCD.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)((double)this.getGaugeBounds().height * 0.425 + this.LCD.getHeight() * 0.76));
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(Integer.toOctalString((int)this.getLcdValue()), (int)(((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0 + (this.LCD.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)((double)this.getGaugeBounds().height * 0.425 + this.LCD.getHeight() * 0.76));
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(this.formatLcdValue(this.getLcdValue()), (int)(((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0 + (this.LCD.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (int)((double)this.getGaugeBounds().height * 0.425 + this.LCD.getHeight() * 0.76));
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                G2.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), G2.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                G2.drawString(this.getLcdInfoString(), this.LCD.getBounds().x + 5, this.LCD.getBounds().y + (int)this.INFO_BOUNDARY.getHeight() + 5);
            }
            if (this.getLcdNumberSystem() == NumberSystem.DEC && this.isLcdThresholdVisible() && this.getLcdValue() >= this.getLcdThreshold()) {
                G2.drawImage((Image)this.lcdThresholdImage, (int)(this.LCD.getX() + this.LCD.getHeight() * 0.0568181818), (int)(this.LCD.getY() + this.LCD.getHeight() - (double)this.lcdThresholdImage.getHeight() - this.LCD.getHeight() * 0.0568181818), null);
            }
        }
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        G2.dispose();
    }

    @Override
    public void setValue(double value) {
        super.setValue(value);
        this.calcNoOfActiveLed();
        if (this.isValueCoupled()) {
            this.setLcdValue(value);
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setMinValue(double MIN_VALUE) {
        super.setMinValue(MIN_VALUE);
        this.calcNoOfActiveLed();
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setMaxValue(double MAX_VALUE) {
        super.setMaxValue(MAX_VALUE);
        this.calcNoOfActiveLed();
        this.repaint(this.getInnerBounds());
    }

    private void calcNoOfActiveLed() {
        this.noOfActiveLeds = (int)(13.0 / (this.getMaxValue() - this.getMinValue()) * this.getValue());
    }

    public Color getValueColor() {
        return this.valueColor;
    }

    public void setValueColor(Color VALUE_COLOR) {
        this.valueColor = VALUE_COLOR;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] LCD_COLORS) {
        Point2D.Double FOREGROUND_STOP;
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (FOREGROUND_START.equals(FOREGROUND_STOP = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{LCD_COLORS[0], LCD_COLORS[1], LCD_COLORS[2], LCD_COLORS[3], LCD_COLORS[4]};
        return new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    private BufferedImage create_LED_OFF_Image(int WIDTH, LedColor LED_COLOR) {
        Color[] ledFgColors;
        BufferedImage IMAGE = UTIL.createImage((int)((double)WIDTH * 0.1775700935), (int)((double)WIDTH * 0.1775700935), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double E_LED1_BG = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.21052631735801697, (double)IMAGE_HEIGHT * 0.21052631735801697, (double)IMAGE_WIDTH * 0.5526316165924072, (double)IMAGE_HEIGHT * 0.5526316165924072);
        Point2D.Double E_LED1_BG_START = new Point2D.Double(0.0, E_LED1_BG.getBounds2D().getMinY());
        Point2D.Double E_LED1_BG_STOP = new Point2D.Double(0.0, E_LED1_BG.getBounds2D().getMaxY());
        float[] E_LED1_BG_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] E_LED1_BG_COLORS = new Color[]{new Color(0, 0, 0, 229), new Color(153, 153, 153, 255)};
        LinearGradientPaint E_LED1_BG_GRADIENT = new LinearGradientPaint(E_LED1_BG_START, E_LED1_BG_STOP, E_LED1_BG_FRACTIONS, E_LED1_BG_COLORS);
        G2.setPaint(E_LED1_BG_GRADIENT);
        G2.fill(E_LED1_BG);
        Ellipse2D.Double LED_FG = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.2368421107530594, (double)IMAGE_HEIGHT * 0.2368421107530594, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5);
        Point2D.Double LED_FG_CENTER = new Point2D.Double(LED_FG.getCenterX(), LED_FG.getCenterY());
        float[] LED_FG_FRACTIONS = new float[]{0.0f, 0.14f, 0.15f, 1.0f};
        switch (LED_COLOR) {
            case GREEN: {
                ledFgColors = new Color[]{new Color(28, 126, 0, 255), new Color(28, 126, 0, 255), new Color(28, 126, 0, 255), new Color(27, 100, 0, 255)};
                break;
            }
            case YELLOW: {
                ledFgColors = new Color[]{new Color(164, 128, 8, 255), new Color(158, 125, 10, 255), new Color(158, 125, 10, 255), new Color(130, 96, 25, 255)};
                break;
            }
            case RED: {
                ledFgColors = new Color[]{new Color(248, 0, 0, 255), new Color(248, 0, 0, 255), new Color(248, 0, 0, 255), new Color(63, 0, 0, 255)};
                break;
            }
            default: {
                ledFgColors = new Color[]{new Color(28, 126, 0, 255), new Color(28, 126, 0, 255), new Color(28, 126, 0, 255), new Color(27, 100, 0, 255)};
            }
        }
        RadialGradientPaint LED_FG_GRADIENT = new RadialGradientPaint(LED_FG_CENTER, 0.25f * (float)IMAGE_WIDTH, LED_FG_FRACTIONS, ledFgColors);
        G2.setPaint(LED_FG_GRADIENT);
        G2.fill(LED_FG);
        Ellipse2D.Double E_LED1_INNERSHADOW = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.2368421107530594, (double)IMAGE_HEIGHT * 0.2368421107530594, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5);
        Point2D.Double E_LED1_INNERSHADOW_CENTER = new Point2D.Double(0.47368421052631576 * (double)IMAGE_WIDTH, 0.47368421052631576 * (double)IMAGE_HEIGHT);
        float[] E_LED1_INNERSHADOW_FRACTIONS = new float[]{0.0f, 0.86f, 1.0f};
        Color[] E_LED1_INNERSHADOW_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 88), new Color(0, 0, 0, 102)};
        RadialGradientPaint E_LED1_INNERSHADOW_GRADIENT = new RadialGradientPaint(E_LED1_INNERSHADOW_CENTER, (float)(0.25 * (double)IMAGE_WIDTH), E_LED1_INNERSHADOW_FRACTIONS, E_LED1_INNERSHADOW_COLORS);
        G2.setPaint(E_LED1_INNERSHADOW_GRADIENT);
        G2.fill(E_LED1_INNERSHADOW);
        Ellipse2D.Double E_LED1_HL = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.3947368562221527, (double)IMAGE_HEIGHT * 0.31578946113586426, (double)IMAGE_WIDTH * 0.21052631735801697, (double)IMAGE_HEIGHT * 0.1315789520740509);
        Point2D.Double E_LED1_HL_START = new Point2D.Double(0.0, E_LED1_HL.getBounds2D().getMinY());
        Point2D.Double E_LED1_HL_STOP = new Point2D.Double(0.0, E_LED1_HL.getBounds2D().getMaxY());
        float[] E_LED1_HL_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] E_LED1_HL_COLORS = new Color[]{new Color(255, 255, 255, 102), new Color(255, 255, 255, 0)};
        LinearGradientPaint E_LED1_HL_GRADIENT = new LinearGradientPaint(E_LED1_HL_START, E_LED1_HL_STOP, E_LED1_HL_FRACTIONS, E_LED1_HL_COLORS);
        G2.setPaint(E_LED1_HL_GRADIENT);
        G2.fill(E_LED1_HL);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_LED_ON_Image(int WIDTH, LedColor LED_COLOR) {
        Color[] ledFgColors;
        Color[] ledGlowColors;
        BufferedImage IMAGE = UTIL.createImage((int)((double)WIDTH * 0.1775700935), (int)((double)WIDTH * 0.1775700935), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double E_LED1_BG = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.21052631735801697, (double)IMAGE_HEIGHT * 0.21052631735801697, (double)IMAGE_WIDTH * 0.5526316165924072, (double)IMAGE_HEIGHT * 0.5526316165924072);
        Point2D.Double E_LED1_BG_START = new Point2D.Double(0.0, E_LED1_BG.getBounds2D().getMinY());
        Point2D.Double E_LED1_BG_STOP = new Point2D.Double(0.0, E_LED1_BG.getBounds2D().getMaxY());
        float[] E_LED1_BG_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] E_LED1_BG_COLORS = new Color[]{new Color(0, 0, 0, 229), new Color(153, 153, 153, 255)};
        LinearGradientPaint E_LED1_BG_GRADIENT = new LinearGradientPaint(E_LED1_BG_START, E_LED1_BG_STOP, E_LED1_BG_FRACTIONS, E_LED1_BG_COLORS);
        G2.setPaint(E_LED1_BG_GRADIENT);
        G2.fill(E_LED1_BG);
        Ellipse2D.Double LED_GLOW = new Ellipse2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT);
        Point2D.Double LED_GLOW_CENTER = new Point2D.Double(LED_GLOW.getCenterX(), LED_GLOW.getCenterY());
        float[] LED_GLOW_FRACTIONS = new float[]{0.0f, 0.57f, 0.71f, 0.72f, 0.85f, 0.93f, 0.9301f, 0.99f};
        switch (LED_COLOR) {
            case GREEN: {
                ledGlowColors = new Color[]{new Color(165, 255, 0, 255), new Color(165, 255, 0, 101), new Color(165, 255, 0, 63), new Color(165, 255, 0, 62), new Color(165, 255, 0, 31), new Color(165, 255, 0, 13), new Color(165, 255, 0, 12), new Color(165, 255, 0, 0)};
                break;
            }
            case YELLOW: {
                ledGlowColors = new Color[]{new Color(255, 102, 0, 255), new Color(255, 102, 0, 101), new Color(255, 102, 0, 63), new Color(255, 102, 0, 62), new Color(255, 102, 0, 31), new Color(255, 102, 0, 13), new Color(255, 102, 0, 12), new Color(255, 102, 0, 0)};
                break;
            }
            case RED: {
                ledGlowColors = new Color[]{new Color(255, 0, 0, 255), new Color(255, 0, 0, 101), new Color(255, 0, 0, 63), new Color(255, 0, 0, 62), new Color(255, 0, 0, 31), new Color(255, 0, 0, 13), new Color(255, 0, 0, 12), new Color(255, 0, 0, 0)};
                break;
            }
            default: {
                ledGlowColors = new Color[]{new Color(165, 255, 0, 255), new Color(165, 255, 0, 101), new Color(165, 255, 0, 63), new Color(165, 255, 0, 62), new Color(165, 255, 0, 31), new Color(165, 255, 0, 13), new Color(165, 255, 0, 12), new Color(165, 255, 0, 0)};
            }
        }
        RadialGradientPaint LED_GLOW_GRADIENT = new RadialGradientPaint(LED_GLOW_CENTER, 0.5f * (float)IMAGE_WIDTH, LED_GLOW_FRACTIONS, ledGlowColors);
        G2.setPaint(LED_GLOW_GRADIENT);
        G2.fill(LED_GLOW);
        Ellipse2D.Double LED_FG = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.2368421107530594, (double)IMAGE_HEIGHT * 0.2368421107530594, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5);
        Point2D.Double LED_FG_CENTER = new Point2D.Double(LED_FG.getCenterX(), LED_FG.getCenterY());
        float[] LED_FG_FRACTIONS = new float[]{0.0f, 0.14f, 0.15f, 1.0f};
        switch (LED_COLOR) {
            case GREEN: {
                ledFgColors = new Color[]{new Color(154, 255, 137, 255), new Color(154, 255, 137, 255), new Color(154, 255, 137, 255), new Color(89, 255, 42, 255)};
                break;
            }
            case YELLOW: {
                ledFgColors = new Color[]{new Color(251, 255, 140, 255), new Color(251, 255, 140, 255), new Color(251, 255, 140, 255), new Color(250, 249, 60, 255)};
                break;
            }
            case RED: {
                ledFgColors = new Color[]{new Color(252, 53, 55, 255), new Color(252, 53, 55, 255), new Color(252, 53, 55, 255), new Color(255, 0, 0, 255)};
                break;
            }
            default: {
                ledFgColors = new Color[]{new Color(154, 255, 137, 255), new Color(154, 255, 137, 255), new Color(154, 255, 137, 255), new Color(89, 255, 42, 255)};
            }
        }
        RadialGradientPaint LED_FG_GRADIENT = new RadialGradientPaint(LED_FG_CENTER, 0.25f * (float)IMAGE_WIDTH, LED_FG_FRACTIONS, ledFgColors);
        G2.setPaint(LED_FG_GRADIENT);
        G2.fill(LED_FG);
        Ellipse2D.Double E_LED1_INNERSHADOW = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.2368421107530594, (double)IMAGE_HEIGHT * 0.2368421107530594, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5);
        Point2D.Double E_LED1_INNERSHADOW_CENTER = new Point2D.Double(0.47368421052631576 * (double)IMAGE_WIDTH, 0.47368421052631576 * (double)IMAGE_HEIGHT);
        float[] E_LED1_INNERSHADOW_FRACTIONS = new float[]{0.0f, 0.86f, 1.0f};
        Color[] E_LED1_INNERSHADOW_COLORS = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 88), new Color(0, 0, 0, 102)};
        RadialGradientPaint E_LED1_INNERSHADOW_GRADIENT = new RadialGradientPaint(E_LED1_INNERSHADOW_CENTER, (float)(0.25 * (double)IMAGE_WIDTH), E_LED1_INNERSHADOW_FRACTIONS, E_LED1_INNERSHADOW_COLORS);
        G2.setPaint(E_LED1_INNERSHADOW_GRADIENT);
        G2.fill(E_LED1_INNERSHADOW);
        Ellipse2D.Double E_LED1_HL = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.3947368562221527, (double)IMAGE_HEIGHT * 0.31578946113586426, (double)IMAGE_WIDTH * 0.21052631735801697, (double)IMAGE_HEIGHT * 0.1315789520740509);
        Point2D.Double E_LED1_HL_START = new Point2D.Double(0.0, E_LED1_HL.getBounds2D().getMinY());
        Point2D.Double E_LED1_HL_STOP = new Point2D.Double(0.0, E_LED1_HL.getBounds2D().getMaxY());
        float[] E_LED1_HL_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] E_LED1_HL_COLORS = new Color[]{new Color(255, 255, 255, 102), new Color(255, 255, 255, 0)};
        LinearGradientPaint E_LED1_HL_GRADIENT = new LinearGradientPaint(E_LED1_HL_START, E_LED1_HL_STOP, E_LED1_HL_FRACTIONS, E_LED1_HL_COLORS);
        G2.setPaint(E_LED1_HL_GRADIENT);
        G2.fill(E_LED1_HL);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public String toString() {
        return "DigitalRadial";
    }
}

