/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio.bootstrap;

import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.NamedElementChain;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import org.apache.hc.core5.http.impl.bootstrap.StandardFilter;
import org.apache.hc.core5.http.impl.nio.DefaultHttpRequestParserFactory;
import org.apache.hc.core5.http.impl.nio.DefaultHttpResponseWriterFactory;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.nio.AsyncFilterHandler;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.nio.support.AsyncServerExpectationFilter;
import org.apache.hc.core5.http.nio.support.AsyncServerFilterChainElement;
import org.apache.hc.core5.http.nio.support.AsyncServerFilterChainExchangeHandlerFactory;
import org.apache.hc.core5.http.nio.support.BasicAsyncServerExpectationDecorator;
import org.apache.hc.core5.http.nio.support.BasicServerExchangeHandler;
import org.apache.hc.core5.http.nio.support.DefaultAsyncResponseExchangeHandlerFactory;
import org.apache.hc.core5.http.nio.support.TerminalAsyncServerFilter;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.LookupRegistry;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http.protocol.UriPatternMatcher;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.H2Processors;
import org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ServerHttpProtocolNegotiationStarter;
import org.apache.hc.core5.http2.impl.nio.bootstrap.FilterEntry;
import org.apache.hc.core5.http2.ssl.H2ServerTlsStrategy;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

public class H2ServerBootstrap {
    private final List<RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>> routeEntries = new ArrayList<RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>>();
    private final List<FilterEntry<AsyncFilterHandler>> filters = new ArrayList<FilterEntry<AsyncFilterHandler>>();
    private String canonicalHostName;
    private LookupRegistry<Supplier<AsyncServerExchangeHandler>> lookupRegistry;
    private HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> requestRouter;
    private IOReactorConfig ioReactorConfig;
    private HttpProcessor httpProcessor;
    private CharCodingConfig charCodingConfig;
    private HttpVersionPolicy versionPolicy;
    private H2Config h2Config;
    private Http1Config http1Config;
    private TlsStrategy tlsStrategy;
    private Timeout handshakeTimeout;
    private Decorator<IOSession> ioSessionDecorator;
    private Callback<Exception> exceptionCallback;
    private IOSessionListener sessionListener;
    private H2StreamListener h2StreamListener;
    private Http1StreamListener http1StreamListener;

    private H2ServerBootstrap() {
    }

    public static H2ServerBootstrap bootstrap() {
        return new H2ServerBootstrap();
    }

    public final H2ServerBootstrap setCanonicalHostName(String canonicalHostName) {
        this.canonicalHostName = canonicalHostName;
        return this;
    }

    public final H2ServerBootstrap setIOReactorConfig(IOReactorConfig ioReactorConfig) {
        this.ioReactorConfig = ioReactorConfig;
        return this;
    }

    public final H2ServerBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final H2ServerBootstrap setVersionPolicy(HttpVersionPolicy versionPolicy) {
        this.versionPolicy = versionPolicy;
        return this;
    }

    public final H2ServerBootstrap setH2Config(H2Config h2Config) {
        this.h2Config = h2Config;
        return this;
    }

    public final H2ServerBootstrap setHttp1Config(Http1Config http1Config) {
        this.http1Config = http1Config;
        return this;
    }

    public final H2ServerBootstrap setCharset(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final H2ServerBootstrap setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final H2ServerBootstrap setHandshakeTimeout(Timeout handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
        return this;
    }

    public final H2ServerBootstrap setIOSessionDecorator(Decorator<IOSession> ioSessionDecorator) {
        this.ioSessionDecorator = ioSessionDecorator;
        return this;
    }

    public final H2ServerBootstrap setExceptionCallback(Callback<Exception> exceptionCallback) {
        this.exceptionCallback = exceptionCallback;
        return this;
    }

    public final H2ServerBootstrap setIOSessionListener(IOSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public final H2ServerBootstrap setStreamListener(H2StreamListener h2StreamListener) {
        this.h2StreamListener = h2StreamListener;
        return this;
    }

    public final H2ServerBootstrap setStreamListener(Http1StreamListener http1StreamListener) {
        this.http1StreamListener = http1StreamListener;
        return this;
    }

    @Deprecated
    public final H2ServerBootstrap setLookupRegistry(LookupRegistry<Supplier<AsyncServerExchangeHandler>> lookupRegistry) {
        this.lookupRegistry = lookupRegistry;
        return this;
    }

    public final H2ServerBootstrap setRequestRouter(HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> requestRouter) {
        this.requestRouter = requestRouter;
        return this;
    }

    public final H2ServerBootstrap register(String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Exchange handler supplier");
        this.routeEntries.add(new RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>(uriPattern, supplier));
        return this;
    }

    public final H2ServerBootstrap register(String hostname, String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notBlank(hostname, "Hostname");
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Exchange handler supplier");
        this.routeEntries.add(new RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>(hostname, uriPattern, supplier));
        return this;
    }

    @Deprecated
    public final H2ServerBootstrap registerVirtual(String hostname, String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        return this.register(hostname, uriPattern, supplier);
    }

    public final <T> H2ServerBootstrap register(String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        this.register(uriPattern, () -> new BasicServerExchangeHandler(requestHandler));
        return this;
    }

    public final <T> H2ServerBootstrap register(String hostname, String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        this.registerVirtual(hostname, uriPattern, () -> new BasicServerExchangeHandler(requestHandler));
        return this;
    }

    @Deprecated
    public final <T> H2ServerBootstrap registerVirtual(String hostname, String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        return this.register(hostname, uriPattern, requestHandler);
    }

    public final H2ServerBootstrap addFilterBefore(String existing, String name, AsyncFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notBlank(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.BEFORE, name, filterHandler, existing));
        return this;
    }

    public final H2ServerBootstrap addFilterAfter(String existing, String name, AsyncFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notBlank(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.AFTER, name, filterHandler, existing));
        return this;
    }

    public final H2ServerBootstrap replaceFilter(String existing, AsyncFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.REPLACE, existing, filterHandler, existing));
        return this;
    }

    public final H2ServerBootstrap addFilterFirst(String name, AsyncFilterHandler filterHandler) {
        Args.notNull(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.FIRST, name, filterHandler, null));
        return this;
    }

    public final H2ServerBootstrap addFilterLast(String name, AsyncFilterHandler filterHandler) {
        Args.notNull(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.LAST, name, filterHandler, null));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpAsyncServer create() {
        HandlerFactory<AsyncServerExchangeHandler> handlerFactory;
        HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> requestRouterCopy;
        String actualCanonicalHostName;
        String string = actualCanonicalHostName = this.canonicalHostName != null ? this.canonicalHostName : InetAddressUtils.getCanonicalLocalHostName();
        if (this.lookupRegistry != null && this.requestRouter == null) {
            RequestHandlerRegistry<Supplier<AsyncServerExchangeHandler>> handlerRegistry = new RequestHandlerRegistry<Supplier<AsyncServerExchangeHandler>>(actualCanonicalHostName, () -> this.lookupRegistry != null ? this.lookupRegistry : new UriPatternMatcher());
            for (RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>> entry : this.routeEntries) {
                handlerRegistry.register(entry.uriAuthority != null ? entry.uriAuthority.getHostName() : null, (String)entry.route.pattern, (Supplier<AsyncServerExchangeHandler>)entry.route.handler);
            }
            requestRouterCopy = handlerRegistry;
        } else {
            requestRouterCopy = this.routeEntries.isEmpty() ? this.requestRouter : RequestRouter.create(new URIAuthority(actualCanonicalHostName), UriPatternType.URI_PATTERN, this.routeEntries, RequestRouter.IGNORE_PORT_AUTHORITY_RESOLVER, this.requestRouter);
        }
        if (!this.filters.isEmpty()) {
            void var6_14;
            void var5_7;
            NamedElementChain<AsyncFilterHandler> filterChainDefinition = new NamedElementChain<AsyncFilterHandler>();
            filterChainDefinition.addLast(new TerminalAsyncServerFilter(new DefaultAsyncResponseExchangeHandlerFactory(requestRouterCopy)), StandardFilter.MAIN_HANDLER.name());
            filterChainDefinition.addFirst(new AsyncServerExpectationFilter(), StandardFilter.EXPECT_CONTINUE.name());
            for (FilterEntry<AsyncFilterHandler> filterEntry : this.filters) {
                switch (filterEntry.position) {
                    case AFTER: {
                        filterChainDefinition.addAfter(filterEntry.existing, (AsyncFilterHandler)filterEntry.filterHandler, filterEntry.name);
                        break;
                    }
                    case BEFORE: {
                        filterChainDefinition.addBefore(filterEntry.existing, (AsyncFilterHandler)filterEntry.filterHandler, filterEntry.name);
                        break;
                    }
                    case REPLACE: {
                        filterChainDefinition.replace(filterEntry.existing, (AsyncFilterHandler)filterEntry.filterHandler);
                        break;
                    }
                    case FIRST: {
                        filterChainDefinition.addFirst((AsyncFilterHandler)filterEntry.filterHandler, filterEntry.name);
                        break;
                    }
                    case LAST: {
                        filterChainDefinition.addBefore(StandardFilter.MAIN_HANDLER.name(), (AsyncFilterHandler)filterEntry.filterHandler, filterEntry.name);
                    }
                }
            }
            NamedElementChain.Node node = filterChainDefinition.getLast();
            Object var6_13 = null;
            while (var5_7 != null) {
                AsyncServerFilterChainElement asyncServerFilterChainElement = new AsyncServerFilterChainElement((AsyncFilterHandler)var5_7.getValue(), (AsyncServerFilterChainElement)var6_14);
                NamedElementChain.Node node2 = var5_7.getPrevious();
            }
            handlerFactory = new AsyncServerFilterChainExchangeHandlerFactory((AsyncServerFilterChainElement)var6_14, this.exceptionCallback);
        } else {
            handlerFactory = new DefaultAsyncResponseExchangeHandlerFactory(requestRouterCopy, handler -> new BasicAsyncServerExpectationDecorator((AsyncServerExchangeHandler)handler, this.exceptionCallback));
        }
        ServerH2StreamMultiplexerFactory http2StreamHandlerFactory = new ServerH2StreamMultiplexerFactory(this.httpProcessor != null ? this.httpProcessor : H2Processors.server(), handlerFactory, this.h2Config != null ? this.h2Config : H2Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, this.h2StreamListener);
        TlsStrategy tlsStrategy = this.tlsStrategy != null ? this.tlsStrategy : new H2ServerTlsStrategy();
        ServerHttp1StreamDuplexerFactory serverHttp1StreamDuplexerFactory = new ServerHttp1StreamDuplexerFactory(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.server(), handlerFactory, this.http1Config != null ? this.http1Config : Http1Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, DefaultConnectionReuseStrategy.INSTANCE, new DefaultHttpRequestParserFactory(this.http1Config), new DefaultHttpResponseWriterFactory(this.http1Config), DefaultContentLengthStrategy.INSTANCE, DefaultContentLengthStrategy.INSTANCE, this.http1StreamListener);
        ServerHttpProtocolNegotiationStarter ioEventHandlerFactory = new ServerHttpProtocolNegotiationStarter(serverHttp1StreamDuplexerFactory, http2StreamHandlerFactory, this.versionPolicy != null ? this.versionPolicy : HttpVersionPolicy.NEGOTIATE, tlsStrategy, this.handshakeTimeout);
        return new HttpAsyncServer((IOEventHandlerFactory)ioEventHandlerFactory, this.ioReactorConfig, this.ioSessionDecorator, this.exceptionCallback, this.sessionListener, actualCanonicalHostName);
    }
}

