/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.devexperts.logging.Logging;
import com.rusefi.core.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class FindFileHelper {
    private static final Logging log = Logging.getLogging(FindFileHelper.class);
    public static String INPUT_FILES_PATH = System.getProperty("input_files_path", "..");
    public static final String FIRMWARE_BIN_FILE = INPUT_FILES_PATH + "/rusefi.bin";
    private static final String PREFIX = "";
    private static final String SUFFIX = "srec";

    @Nullable
    public static String findFile(String fileDirectory, String prefix, String suffix, AdditionalFileHandler fileMoveOperation, boolean keepOneFile) {
        File dir = new File(fileDirectory);
        log.info("Scanning " + dir.getAbsolutePath() + " for " + prefix + "/" + suffix);
        if (!dir.isDirectory()) {
            throw new IllegalStateException("Not a directory: " + fileDirectory);
        }
        log.info("Searching for " + prefix + "*" + suffix + " in " + dir.getAbsolutePath());
        return FindFileHelper.findXNumberOfFile(fileDirectory, prefix, suffix, dir.list(), fileMoveOperation, keepOneFile);
    }

    @Nullable
    public static String findXNumberOfFile(String fileDirectory, String prefix, String suffix, String[] directoryListing, AdditionalFileHandler fileMoveOperation, boolean keepOneFile) {
        int index;
        Optional<String[]> fileList = Optional.ofNullable(directoryListing);
        Supplier<Stream> search_file = () -> Arrays.stream((String[])fileList.get()).filter(file -> !file.contains(" ")).filter(file -> file.startsWith(prefix) && file.endsWith(suffix));
        List files = search_file.get().collect(Collectors.toList());
        if (files.isEmpty()) {
            return null;
        }
        int n = index = keepOneFile ? 1 : 0;
        while (index < files.size()) {
            fileMoveOperation.onAdditionalFile(fileDirectory, (String)files.get(index));
            ++index;
        }
        if (!keepOneFile) {
            return null;
        }
        String file = (String)files.get(0);
        String result = fileDirectory + File.separator + file;
        log.info("Located " + result);
        return result;
    }

    @Nullable
    public static String findSrecFile() {
        return FindFileHelper.findSrecFile(true);
    }

    @Nullable
    public static String findSrecFile(boolean keepOneFile) {
        String fileAtFirstLocation = FindFileHelper.findFile(INPUT_FILES_PATH, PREFIX, SUFFIX, new AdditionalFileHandler(){

            @Override
            public void onAdditionalFile(String fileDirectory, String fileName) {
                FindFileHelper.moveFile(fileDirectory, fileName);
            }
        }, keepOneFile);
        if (fileAtFirstLocation == null) {
            log.info("Second choice: current folder");
            return FindFileHelper.findFile(".", PREFIX, SUFFIX, new AdditionalFileHandler(){

                @Override
                public void onAdditionalFile(String fileDirectory, String fileName) {
                    FindFileHelper.moveFile(fileDirectory, fileName);
                }
            }, keepOneFile);
        }
        return fileAtFirstLocation;
    }

    private static void moveFile(String fileDirectory, String fileName) {
        String destinationFolder = FileUtil.RUSEFI_SETTINGS_FOLDER + "older-fw" + File.separator;
        boolean wasCreated = new File(destinationFolder).mkdirs();
        log.info(destinationFolder + ": created: " + wasCreated);
        String fullSourceFileName = fileDirectory + File.separator + fileName;
        Path sourcePath = Paths.get(fullSourceFileName, new String[0]);
        Path destinationDirectory = Paths.get(destinationFolder + fileName, new String[0]);
        try {
            Files.move(sourcePath, destinationDirectory, new CopyOption[0]);
            log.info("Moved " + sourcePath + " to " + destinationFolder);
        }
        catch (IOException e) {
            log.warn(sourcePath + "Move failed, will try to remove: " + e);
            boolean deletedOk = new File(fullSourceFileName).delete();
            log.info(fullSourceFileName + ": deleted: " + deletedOk);
        }
    }

    public static String findFirmwareFile() {
        return FIRMWARE_BIN_FILE;
    }

    public static boolean isObfuscated() {
        String srecFile = FindFileHelper.findSrecFile();
        return srecFile != null && srecFile.contains("obfuscated");
    }

    public static interface AdditionalFileHandler {
        public void onAdditionalFile(String var1, String var2);
    }
}

