/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import tel.schich.javacan.BcmFlag;
import tel.schich.javacan.BcmOpcode;
import tel.schich.javacan.CanFrame;
import tel.schich.javacan.JavaCAN;
import tel.schich.javacan.util.BufferHelper;

public class BcmMessage {
    public static final int HEADER_LENGTH;
    public static final int OFFSET_OPCODE = 0;
    public static final int OFFSET_FLAGS;
    public static final int OFFSET_COUNT;
    public static final int OFFSET_IVAL1_TV_SEC;
    public static final int OFFSET_IVAL1_TV_USEC;
    public static final int OFFSET_IVAL2_TV_SEC;
    public static final int OFFSET_IVAL2_TV_USEC;
    public static final int OFFSET_CAN_ID;
    public static final int OFFSET_NFRAMES;
    public static final int OFFSET_FRAMES;
    private final ByteBuffer buffer;
    private final int base;
    private final int size;

    public BcmMessage(ByteBuffer buffer) {
        this.buffer = buffer;
        this.base = buffer.position();
        this.size = buffer.remaining();
        if (this.size < HEADER_LENGTH) {
            throw new IllegalArgumentException("the buffer is too small for a BCM message");
        }
        int expectedSize = HEADER_LENGTH + this.getFrameCount() * BcmMessage.frameLength(this.getFlags());
        if (expectedSize > this.size) {
            throw new IllegalArgumentException(String.format("the buffer capacity cannot hold all frames of this BCM message,required %d but was %d", expectedSize, this.size));
        }
    }

    public BcmMessage(BcmOpcode opcode, Set<BcmFlag> flags, int count, Duration interval1, Duration interval2, int canId, List<CanFrame> frames) {
        boolean fdFrames = frames.stream().anyMatch(CanFrame::isFDFrame);
        if (fdFrames && !flags.contains((Object)BcmFlag.CAN_FD_FRAME)) {
            flags = new HashSet<BcmFlag>(flags);
            flags.add(BcmFlag.CAN_FD_FRAME);
        }
        int frameLength = BcmMessage.frameLength(flags);
        this.base = 0;
        this.size = HEADER_LENGTH + frames.size() * frameLength;
        this.buffer = JavaCAN.allocateOrdered(this.size);
        this.buffer.putInt(0, opcode.nativeOpcode).putInt(OFFSET_FLAGS, BcmFlag.toNative(flags)).putInt(OFFSET_COUNT, count).putInt(OFFSET_CAN_ID, canId).putInt(OFFSET_NFRAMES, frames.size());
        if (interval1 != null) {
            BufferHelper.putPlatformLong(this.buffer, OFFSET_IVAL1_TV_SEC, interval1.getSeconds());
            BufferHelper.putPlatformLong(this.buffer, OFFSET_IVAL1_TV_USEC, TimeUnit.NANOSECONDS.toMicros(interval1.getNano()));
        }
        if (interval2 != null) {
            BufferHelper.putPlatformLong(this.buffer, OFFSET_IVAL2_TV_SEC, interval2.getSeconds());
            BufferHelper.putPlatformLong(this.buffer, OFFSET_IVAL2_TV_USEC, TimeUnit.NANOSECONDS.toMicros(interval2.getNano()));
        }
        for (int i = 0; i < frames.size(); ++i) {
            this.buffer.position(OFFSET_FRAMES + i * frameLength);
            this.buffer.put(frames.get(i).getBuffer());
        }
        this.buffer.clear();
    }

    public BcmOpcode getOpcode() {
        return BcmOpcode.fromNative(this.buffer.getInt(this.base + 0));
    }

    public Set<BcmFlag> getFlags() {
        return BcmFlag.fromNative(this.buffer.getInt(this.base + OFFSET_FLAGS));
    }

    public int getCount() {
        return this.buffer.getInt(this.base + OFFSET_COUNT);
    }

    public Duration getInterval1() {
        return this.getIntervalAt(OFFSET_IVAL1_TV_SEC, OFFSET_IVAL1_TV_USEC);
    }

    public Duration getInterval2() {
        return this.getIntervalAt(OFFSET_IVAL2_TV_SEC, OFFSET_IVAL2_TV_USEC);
    }

    private Duration getIntervalAt(int secOffset, int usecOffset) {
        long usec;
        long sec = BufferHelper.getPlatformLong(this.buffer, this.base + secOffset);
        if (sec + (usec = BufferHelper.getPlatformLong(this.buffer, this.base + usecOffset)) == 0L) {
            return Duration.ZERO;
        }
        return Duration.ofSeconds(sec).plusNanos(TimeUnit.MICROSECONDS.toNanos(usec));
    }

    public int getCanId() {
        return this.buffer.getInt(this.base + OFFSET_CAN_ID);
    }

    public int getFrameCount() {
        return this.buffer.getInt(this.base + OFFSET_NFRAMES);
    }

    public CanFrame getFrame(int index) {
        int frameLength = BcmMessage.frameLength(this.getFlags());
        return CanFrame.create(this.createFrameBuffer(index, frameLength));
    }

    public List<CanFrame> getFrames() {
        int nFrames = this.getFrameCount();
        if (nFrames == 0) {
            return Collections.emptyList();
        }
        int frameLength = BcmMessage.frameLength(this.getFlags());
        ArrayList<CanFrame> frames = new ArrayList<CanFrame>(nFrames);
        for (int i = 0; i < nFrames; ++i) {
            frames.add(CanFrame.create(this.createFrameBuffer(i, frameLength)));
        }
        return frames;
    }

    public ByteBuffer getBuffer() {
        this.buffer.clear().position(this.base).limit(this.base + this.size);
        return this.buffer;
    }

    private ByteBuffer createFrameBuffer(int frameIndex, int frameLength) {
        ByteBuffer frameBuffer = this.buffer.duplicate().order(this.buffer.order());
        frameBuffer.position(this.base + OFFSET_FRAMES + frameIndex * frameLength).limit(frameBuffer.position() + frameLength);
        return frameBuffer;
    }

    private static int frameLength(Set<BcmFlag> flags) {
        return flags.contains((Object)BcmFlag.CAN_FD_FRAME) ? 72 : 16;
    }

    public String toString() {
        return "BcmMessage(OP=" + (Object)((Object)this.getOpcode()) + ", FLAGS=" + this.getFlags() + ", COUNT=" + this.getCount() + ", IVAL1=" + this.getInterval1() + ", IVAL2=" + this.getInterval2() + ", CANID=" + this.getCanId() + ", FRAMES=" + this.getFrameCount() + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BcmMessage)) {
            return false;
        }
        BcmMessage b = (BcmMessage)o;
        return BufferHelper.equals(this.buffer, this.base, this.size, b.buffer, b.base, b.size);
    }

    public int hashCode() {
        return BufferHelper.hashCode(this.buffer, this.base, this.size);
    }

    private static native int getHeaderSize();

    private static native int getOffsetFlags();

    private static native int getOffsetCount();

    private static native int getOffsetIval1Sec();

    private static native int getOffsetIval1Usec();

    private static native int getOffsetIval2Sec();

    private static native int getOffsetIval2Usec();

    private static native int getOffsetCanID();

    private static native int getOffsetNFrames();

    private static native int getOffsetFrames();

    public static Builder builder(BcmOpcode opcode) {
        if (opcode == null) {
            throw new IllegalArgumentException("opcode must not be null");
        }
        return new Builder(opcode);
    }

    static {
        JavaCAN.initialize();
        HEADER_LENGTH = BcmMessage.getHeaderSize();
        OFFSET_FLAGS = BcmMessage.getOffsetFlags();
        OFFSET_COUNT = BcmMessage.getOffsetCount();
        OFFSET_IVAL1_TV_SEC = BcmMessage.getOffsetIval1Sec();
        OFFSET_IVAL1_TV_USEC = BcmMessage.getOffsetIval1Usec();
        OFFSET_IVAL2_TV_SEC = BcmMessage.getOffsetIval2Sec();
        OFFSET_IVAL2_TV_USEC = BcmMessage.getOffsetIval2Usec();
        OFFSET_CAN_ID = BcmMessage.getOffsetCanID();
        OFFSET_NFRAMES = BcmMessage.getOffsetNFrames();
        OFFSET_FRAMES = BcmMessage.getOffsetFrames();
    }

    public static class Builder {
        private final BcmOpcode opcode;
        private final Set<BcmFlag> flags = new HashSet<BcmFlag>();
        private int count;
        private Duration interval1;
        private Duration interval2;
        private int canId;
        private final List<CanFrame> frames = new ArrayList<CanFrame>();

        public Builder(BcmOpcode opcode) {
            this.opcode = opcode;
        }

        public Builder flag(BcmFlag flag) {
            this.flags.add(flag);
            return this;
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder frame(CanFrame frame) {
            this.frames.add(frame);
            return this;
        }

        public Builder interval1(Duration interval) {
            this.interval1 = interval;
            return this;
        }

        public Builder interval2(Duration interval) {
            this.interval2 = interval;
            return this;
        }

        public Builder canId(int canId) {
            this.canId = canId;
            return this;
        }

        public BcmMessage build() {
            return new BcmMessage(this.opcode, this.flags, this.count, this.interval1, this.interval2, this.canId, this.frames);
        }
    }
}

