/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autoupdate;

import com.devexperts.logging.FileLogger;
import com.devexperts.logging.Logging;
import com.rusefi.autoupdate.ConsoleExeFileLocator;
import com.rusefi.autoupdate.ObsoleteFilesArchiver;
import com.rusefi.autoupdate.ReportedIOException;
import com.rusefi.autoupdate.TsPluginInstaller;
import com.rusefi.core.FileUtil;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.io.BundleInfo;
import com.rusefi.core.io.BundleInfoStrategy;
import com.rusefi.core.io.BundleUtil;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.net.PropertiesHolder;
import com.rusefi.core.rusEFIVersion;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.core.ui.ErrorMessageHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;

public class Autoupdate {
    private static final Logging log = Logging.getLogging(Autoupdate.class);
    private static final int AUTOUPDATE_VERSION = 20251007;
    private static final String DO_NOT_UPDATE_PROPERTY_KEY = "Autoupdate.do_not_download";
    private static final boolean doNotDownloadPropertyValue;
    private static final String SUPPRESS_FILE_NAME;
    private static final boolean suppressDownloadViaFlagFile;
    private static final String TITLE;
    private static final String consoleJarZipEntry;
    private static final Predicate<ZipEntry> isConsoleJar;

    private static String getTitle() {
        try {
            return ConnectionAndMeta.getWhiteLabel(ConnectionAndMeta.getProperties()) + " Bundle Updater " + 20251007;
        }
        catch (Throwable e) {
            log.error("Error", e);
            return "Title error: " + e;
        }
    }

    public static void main(String[] args) {
        try {
            FileLogger.init();
            log.info("Version 20251007");
            log.info("Compiled " + new Date(rusEFIVersion.classBuildTimeMillis(Autoupdate.class)));
            log.info("Current folder " + new File(".").getCanonicalPath());
            log.info("Source " + new File(Autoupdate.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getCanonicalPath());
            Autoupdate.autoupdate(args);
        }
        catch (Throwable e) {
            log.error("Autoupdate Error", e);
            String stackTrace = Autoupdate.extracted(e);
            ErrorMessageHelper.showErrorDialog(stackTrace, "Autoupdate Error " + TITLE);
            System.exit(-1);
        }
    }

    private static String extracted(Throwable e) {
        StringBuilder sb = new StringBuilder(e.toString());
        for (StackTraceElement ste : e.getStackTrace()) {
            sb.append("\n\tat ");
            sb.append(ste);
        }
        return sb.toString();
    }

    private static void autoupdate(String[] args) {
        Optional<Object> downloadedAutoupdateFile;
        String firstArgument;
        BundleInfo bundleInfo = BundleUtil.readBundleFullNameNotNull();
        if (BundleInfo.isUndefined(bundleInfo)) {
            log.error("ERROR: Autoupdate: unable to perform without bundleFullName");
            System.exit(-1);
        }
        String string = firstArgument = args.length > 0 ? args[0] : "";
        if (doNotDownloadPropertyValue || suppressDownloadViaFlagFile) {
            downloadedAutoupdateFile = Optional.empty();
        } else {
            downloadedAutoupdateFile = Autoupdate.downloadFreshZipFile(firstArgument, bundleInfo);
            downloadedAutoupdateFile.ifPresent(downloadedFile -> ObsoleteFilesArchiver.INSTANCE.archiveObsoleteFiles());
        }
        String consoleExeFileName = new ConsoleExeFileLocator().getConsoleExeFileName();
        Autoupdate.safeUnzipMakingSureClassloaderIsHappy(downloadedAutoupdateFile);
        Autoupdate.startConsoleAsANewProcess(consoleExeFileName, args);
    }

    private static Optional<DownloadedAutoupdateFileInfo> downloadFreshZipFile(String firstArgument, BundleInfo bundleInfo) {
        Optional<DownloadedAutoupdateFileInfo> downloadedAutoupdateFile;
        if (firstArgument.equalsIgnoreCase("release")) {
            log.info("Release update requested");
            downloadedAutoupdateFile = Autoupdate.downloadAutoupdateZipFile(bundleInfo, "https://github.com/rusefi/rusefi/releases/latest/download/", FindFileHelper.isObfuscated());
        } else {
            downloadedAutoupdateFile = Autoupdate.doDownload(bundleInfo);
        }
        return downloadedAutoupdateFile;
    }

    private static void safeUnzipMakingSureClassloaderIsHappy(Optional<DownloadedAutoupdateFileInfo> downloadedAutoupdateFile) {
        downloadedAutoupdateFile.ifPresent(Autoupdate::unzipFreshConsole);
        downloadedAutoupdateFile.ifPresent(autoupdateFile -> {
            block2: {
                FindFileHelper.findSrecFile(false);
                try {
                    String pathname = "..";
                    log.info("unzipping everything else into " + pathname);
                    FileUtil.unzip(autoupdateFile.zipFileName, new File(pathname), isConsoleJar.negate());
                    String srecFile = FindFileHelper.findSrecFile();
                    String firmwareFile = FindFileHelper.findFirmwareFile();
                    new File(srecFile == null ? firmwareFile : srecFile).setLastModified(autoupdateFile.lastModified);
                    TsPluginInstaller.installTsPlugin();
                }
                catch (IOException e) {
                    log.error("Error unzipping autoupdate from bundle: " + e);
                    if (AutoupdateUtil.runHeadless) break block2;
                    ErrorMessageHelper.showErrorDialog("Error unzipping autoupdate from bundle: " + e, "Error");
                }
            }
        });
    }

    private static void unzipFreshConsole(DownloadedAutoupdateFileInfo autoupdateFile) {
        block2: {
            try {
                log.info("unzipFreshConsole " + autoupdateFile.zipFileName + " only " + consoleJarZipEntry);
                FileUtil.unzip(autoupdateFile.zipFileName, new File(".."), isConsoleJar);
            }
            catch (IOException e) {
                log.error("Error unzipping bundle without autoupdate: " + e);
                if (AutoupdateUtil.runHeadless) break block2;
                ErrorMessageHelper.showErrorDialog("Error unzipping bundle without autoupdate: " + e, "Error");
            }
        }
    }

    private static Optional<DownloadedAutoupdateFileInfo> doDownload(BundleInfo bundleInfo) {
        String branchUrl = BundleInfoStrategy.getDownloadUrl(bundleInfo, PropertiesHolder.getBaseUrl(), BundleInfoStrategy::selectBranchName);
        return Autoupdate.downloadAutoupdateZipFile(bundleInfo, branchUrl, FindFileHelper.isObfuscated());
    }

    private static void startConsoleAsANewProcess(String consoleExeFileName, String[] args) {
        block4: {
            if (!Files.exists(Paths.get(consoleExeFileName, new String[0]), new LinkOption[0])) {
                log.error(String.format("File `%s` to launch isn't found", consoleExeFileName));
                if (!AutoupdateUtil.runHeadless) {
                    ErrorMessageHelper.showErrorDialog(String.format("File `%s` to launch isn't found.", consoleExeFileName), "Error");
                }
                return;
            }
            log.info(String.format("File `%s` to launch is found", consoleExeFileName));
            CharSequence[] processBuilderArgs = new String[args.length + 1];
            processBuilderArgs[0] = consoleExeFileName;
            System.arraycopy(args, 0, processBuilderArgs, 1, args.length);
            try {
                log.info(String.format("We're starting `%s` process", consoleExeFileName));
                new ProcessBuilder((String[])processBuilderArgs).start();
                log.info(String.format("Process `%s` is started", consoleExeFileName));
            }
            catch (IOException e) {
                String command = String.join((CharSequence)" ", processBuilderArgs);
                log.error(String.format("Failed to run `$s` command", command), e);
                if (AutoupdateUtil.runHeadless) break block4;
                ErrorMessageHelper.showErrorDialog(String.format("Error running `%s` command.\nPlease try to run it manually again.", command), "Error");
            }
        }
    }

    public static Optional<DownloadedAutoupdateFileInfo> downloadAutoupdateZipFile(BundleInfo info, String baseUrl, boolean isObfuscated) {
        block4: {
            try {
                String suffix = isObfuscated ? "_obfuscated_public" : "";
                String folderName = info.getTarget() + "_" + info.getBranchName();
                String localFolder = FileUtil.RUSEFI_SETTINGS_FOLDER + "updates" + File.separator + folderName + File.separator;
                new File(localFolder).mkdirs();
                String fileName = ConnectionAndMeta.getWhiteLabel(ConnectionAndMeta.getProperties()) + "_bundle_" + info.getTarget() + suffix + "_autoupdate.zip";
                String localZipFileName = localFolder + fileName;
                ConnectionAndMeta connectionAndMeta = new ConnectionAndMeta(fileName).invoke(baseUrl);
                log.info("Local file " + localZipFileName);
                log.info("Remote file " + fileName);
                log.info("Server has " + connectionAndMeta.getCompleteFileSize() + " from " + new Date(connectionAndMeta.getLastModified()));
                if (AutoupdateUtil.hasExistingFile(localZipFileName, connectionAndMeta.getCompleteFileSize(), connectionAndMeta.getLastModified())) {
                    log.info("We already have latest update " + new Date(connectionAndMeta.getLastModified()));
                    return Optional.empty();
                }
                long completeFileSize = connectionAndMeta.getCompleteFileSize();
                long lastModified = connectionAndMeta.getLastModified();
                log.info(info + " " + completeFileSize + " bytes, last modified " + new Date(lastModified));
                AutoupdateUtil.downloadAutoupdateFile(localZipFileName, connectionAndMeta, TITLE);
                File file = new File(localZipFileName);
                file.setLastModified(lastModified);
                log.info("Downloaded " + file.length() + " bytes, lastModified=" + lastModified);
                return Optional.of(new DownloadedAutoupdateFileInfo(localZipFileName, lastModified));
            }
            catch (ReportedIOException e) {
                log.error("Error downloading bundle: " + e);
            }
            catch (IOException e) {
                log.error("Error downloading bundle: " + e);
                if (AutoupdateUtil.runHeadless) break block4;
                ErrorMessageHelper.showErrorDialog("Error downloading " + e, "Error");
            }
        }
        return Optional.empty();
    }

    static {
        SUPPRESS_FILE_NAME = FileUtil.RUSEFI_SETTINGS_FOLDER + "donotdownload";
        suppressDownloadViaFlagFile = new File(SUPPRESS_FILE_NAME).exists();
        doNotDownloadPropertyValue = Boolean.getBoolean(DO_NOT_UPDATE_PROPERTY_KEY);
        log.info("Autoupdate.do_not_download=" + doNotDownloadPropertyValue);
        log.info(SUPPRESS_FILE_NAME + " exists: " + suppressDownloadViaFlagFile);
        TITLE = Autoupdate.getTitle();
        consoleJarZipEntry = String.format("console/%s", ConnectionAndMeta.getRusEfiConsoleJarName());
        isConsoleJar = zipEntry -> consoleJarZipEntry.equals(zipEntry.getName());
    }

    public static class DownloadedAutoupdateFileInfo {
        final String zipFileName;
        final long lastModified;

        DownloadedAutoupdateFileInfo(String zipFileName, long lastModified) {
            this.zipFileName = zipFileName;
            this.lastModified = lastModified;
        }
    }
}

