/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.rusefi.AvailableHardware;
import com.rusefi.ConnectivityContext;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.maintenance.StatusAnimation;
import com.rusefi.tools.TunerStudioHelper;
import com.rusefi.ui.BasicLogoHelper;
import com.rusefi.ui.basic.BasicUpdaterPanel;
import com.rusefi.ui.util.DefaultExceptionHandler;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.StatusPanel;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BasicStartupFrame {
    private final String whiteLabel = ConnectionAndMeta.getWhiteLabel(ConnectionAndMeta.getProperties());
    private final StatusPanel statusPanel = new StatusPanel();
    private final BasicUpdaterPanel basicUpdaterPanel;
    private final FrameHelper frame = FrameHelper.createFrame(this.whiteLabel + " basic console " + 20250615);
    private final StatusAnimation status = new StatusAnimation(this::updateStatus, "Scanning ports");

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        BasicStartupFrame.runTool(null);
    }

    public static void runTool(String[] args) throws InterruptedException, InvocationTargetException {
        DefaultExceptionHandler.install();
        SwingUtilities.invokeAndWait(() -> new BasicStartupFrame(ConnectivityContext.INSTANCE));
    }

    public BasicStartupFrame(ConnectivityContext connectivityContext) {
        JPanel panel = new JPanel();
        this.basicUpdaterPanel = new BasicUpdaterPanel(connectivityContext, ConnectionAndMeta.isDefaultWhitelabel(this.whiteLabel), this.statusPanel);
        panel.add(this.basicUpdaterPanel.getContent());
        panel.add(this.statusPanel);
        TunerStudioHelper.maybeCloseTs();
        connectivityContext.getSerialPortScanner().addListener(currentHardware -> SwingUtilities.invokeLater(() -> this.onHardwareUpdated(currentHardware)));
        BasicLogoHelper.setGenericFrameIcon(this.frame.getFrame());
        this.frame.showFrame(panel, false);
        UiUtils.centerWindow(this.frame.getFrame());
        this.packFrame();
    }

    private void packFrame() {
        this.frame.getFrame().pack();
    }

    private void updateStatus(String niceStatus) {
        this.basicUpdaterPanel.updateStatus(niceStatus);
        this.packFrame();
    }

    public void onHardwareUpdated(AvailableHardware currentHardware) {
        this.status.stop();
        this.basicUpdaterPanel.onHardwareUpdated(currentHardware);
        this.packFrame();
    }
}

