/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.rusefi.ConnectivityContext;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.LinkManager;
import com.rusefi.io.UpdateOperationCallbacks;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class BinaryProtocolExecutor {
    public static <T> T execute(String port, UpdateOperationCallbacks callbacks, BinaryProtocolAction<T> bpAction, T failureResult, boolean isScanningForEcu) {
        AtomicReference executionResult;
        block12: {
            executionResult = new AtomicReference(failureResult);
            try (LinkManager linkManager = new LinkManager().setNeedPullText(false).setNeedPullLiveData(true);){
                callbacks.logLine(String.format("Connecting to port `%s`...", port));
                try {
                    if (linkManager.connect(port, isScanningForEcu).await(1L, TimeUnit.MINUTES)) {
                        CountDownLatch latch = new CountDownLatch(1);
                        callbacks.logLine(String.format("Performing action on port %s...", port));
                        linkManager.execute(() -> {
                            try {
                                executionResult.set(bpAction.doWithBinaryProtocol(linkManager.getBinaryProtocol()));
                            }
                            finally {
                                latch.countDown();
                            }
                        });
                        try {
                            if (!latch.await(1L, TimeUnit.MINUTES)) {
                                callbacks.logLine(String.format("Failed perform action on port %s in a minute", port));
                            }
                            break block12;
                        }
                        catch (InterruptedException e) {
                            callbacks.logLine(String.format("Action on port %s was interrupted", port));
                        }
                        break block12;
                    }
                    callbacks.logLine(String.format("Failed to connect to port %s in a minute", port));
                }
                catch (InterruptedException e) {
                    callbacks.logLine(String.format("Connection to port %s was interrupted", port));
                }
            }
        }
        return executionResult.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithSuspendedPortScanner(String port, UpdateOperationCallbacks callbacks, BinaryProtocolAction<T> bpAction, T failureResult, ConnectivityContext connectivityContext) {
        try {
            callbacks.logLine("Suspending port scanning...");
            try {
                connectivityContext.getSerialPortScanner().suspend().await(1L, TimeUnit.MINUTES);
                callbacks.logLine("Port scanning is suspended.");
            }
            catch (InterruptedException e) {
                callbacks.logLine("Failed to  suspend port scanning in a minute.");
                T t = failureResult;
                callbacks.logLine("Resuming port scanning...");
                connectivityContext.getSerialPortScanner().resume();
                callbacks.logLine("Port scanning is resumed.");
                return t;
            }
            T t = BinaryProtocolExecutor.execute(port, callbacks, bpAction, failureResult, false);
            return t;
        }
        finally {
            callbacks.logLine("Resuming port scanning...");
            connectivityContext.getSerialPortScanner().resume();
            callbacks.logLine("Port scanning is resumed.");
        }
    }

    @FunctionalInterface
    public static interface BinaryProtocolAction<T> {
        public T doWithBinaryProtocol(BinaryProtocol var1);
    }
}

