/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.devexperts.logging.Logging;
import com.opensr5.ini.IniFileModel;
import com.rusefi.AvailableHardware;
import com.rusefi.CompatibilityOptional;
import com.rusefi.CompatibilitySet;
import com.rusefi.ConnectivityContext;
import com.rusefi.FileLog;
import com.rusefi.PortResult;
import com.rusefi.SerialPortType;
import com.rusefi.StartupFrame;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.CalibrationsInfo;
import com.rusefi.maintenance.ProgramSelector;
import com.rusefi.maintenance.jobs.AsyncJob;
import com.rusefi.maintenance.jobs.AsyncJobWithContext;
import com.rusefi.maintenance.jobs.DfuAutoJob;
import com.rusefi.maintenance.jobs.DfuManualJob;
import com.rusefi.maintenance.jobs.OpenBltAutoJob;
import com.rusefi.maintenance.jobs.OpenBltManualJob;
import com.rusefi.maintenance.jobs.PrintUnitLabelJob;
import com.rusefi.maintenance.jobs.UploadTuneJob;
import com.rusefi.ui.LogoHelper;
import com.rusefi.ui.basic.BasicButtonCoordinator;
import com.rusefi.ui.basic.ImportTuneControl;
import com.rusefi.ui.basic.LogoLabelPopupMenu;
import com.rusefi.ui.basic.MigrateSettingsCheckboxState;
import com.rusefi.ui.basic.SingleAsyncJobExecutor;
import com.rusefi.ui.basic.UnitLabelPrinter;
import com.rusefi.ui.basic.Usability;
import com.rusefi.ui.util.HorizontalLine;
import com.rusefi.ui.widgets.ToolButtons;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.putgemin.VerticalFlowLayout;

public class BasicUpdaterPanel
implements BasicButtonCoordinator {
    private static final Logging log = Logging.getLogging(BasicUpdaterPanel.class);
    private final JPanel content = new JPanel(new VerticalFlowLayout());
    private final boolean isObfuscated = FindFileHelper.isObfuscated();
    private final String panamaUrl = ConnectionAndMeta.getProperties().getProperty("panama_url");
    private final JLabel statusMessage = new JLabel();
    private final JCheckBox migrateSettings = new JCheckBox("Migrate Settings");
    private final JCheckBox verboseMessages = new JCheckBox("Verbose Status");
    private final JButton updateFirmwareButton = ProgramSelector.createUpdateFirmwareButton();
    private final ImportTuneControl importTuneButton;
    private final JButton updateCalibrationsButton = new JButton("Update Calibrations", AutoupdateUtil.loadIcon("writeconfig48.png"));
    private LogoLabelPopupMenu logoLabelPopupMenu = null;
    private final ConnectivityContext connectivityContext;
    private final SingleAsyncJobExecutor singleAsyncJobExecutor;
    private final UpdateOperationCallbacks updateOperationCallbacks;
    private volatile Optional<AsyncJob> updateFirmwareJob = Optional.empty();
    private final AtomicReference<Optional<PortResult>> ecuPortToUse;
    private String latestReportedHash;

    BasicUpdaterPanel(ConnectivityContext connectivityContext, boolean showUrlLabel, UpdateOperationCallbacks updateOperationCallbacks, SingleAsyncJobExecutor singleAsyncJobExecutor, AtomicReference<Optional<PortResult>> ecuPortToUse) {
        this.connectivityContext = connectivityContext;
        this.ecuPortToUse = ecuPortToUse;
        this.singleAsyncJobExecutor = singleAsyncJobExecutor;
        this.updateOperationCallbacks = updateOperationCallbacks;
        singleAsyncJobExecutor.addOnJobInProgressFinishedListener(() -> SwingUtilities.invokeLater(this::refreshButtons));
        this.importTuneButton = new ImportTuneControl(singleAsyncJobExecutor, this, connectivityContext, this.ecuPortToUse);
        if (FileLog.isWindows()) {
            Optional<JPanel> newReleaseNotification = StartupFrame.newReleaseAnnounce("rusefi_updater.exe", "center", () -> 0);
            if (newReleaseNotification.isPresent()) {
                this.content.add(newReleaseNotification.get());
            }
            this.content.add(ToolButtons.createShowDeviceManagerButton());
            this.content.add(StartupFrame.binaryModificationControl());
            this.updateFirmwareButton.addActionListener(this::onUpdateFirmwareButtonClicked);
            this.updateFirmwareButton.setEnabled(false);
            this.statusMessage.setForeground(Color.red);
            this.content.add(this.statusMessage);
            this.content.add(this.updateFirmwareButton);
            this.importTuneButton.setEnabled(false);
        } else {
            this.content.add(new JLabel("Sorry only works on Windows"));
        }
        this.content.add(new HorizontalLine());
        JLabel logoLabel = LogoHelper.createLogoLabel();
        if (logoLabel != null) {
            this.logoLabelPopupMenu = new LogoLabelPopupMenu(this::uploadTune, this::printUnitLabel, this.panamaUrl != null);
            logoLabel.setComponentPopupMenu(this.logoLabelPopupMenu);
            this.content.add(logoLabel);
        }
        if (showUrlLabel) {
            this.content.add(LogoHelper.createUrlLabel());
        }
        this.migrateSettings.setSelected(true);
        this.migrateSettings.addActionListener(e -> this.updateMigrateSettingState());
        this.verboseMessages.setSelected(false);
        this.verboseMessages.addActionListener(e -> this.updateMigrateSettingState());
        this.updateMigrateSettingState();
        this.content.add(this.migrateSettings);
        this.content.add(this.verboseMessages);
    }

    public ImportTuneControl getImportTuneButton() {
        return this.importTuneButton;
    }

    private void updateMigrateSettingState() {
        MigrateSettingsCheckboxState.isMigrationNeeded = this.migrateSettings.isSelected();
        MigrateSettingsCheckboxState.isVerboseMessages = this.verboseMessages.isSelected();
    }

    private void hideStatusMessage() {
        this.statusMessage.setText(" ");
    }

    public void updateStatus(String niceStatus) {
        this.statusMessage.setText(niceStatus);
    }

    public void onHardwareUpdated() {
        this.hideStatusMessage();
        this.updateUpdateFirmwareJob();
        this.updateEcuPortToUse();
    }

    private void updateUpdateFirmwareJob() {
        AvailableHardware currentHardware = this.connectivityContext.getCurrentHardware();
        log.info("updateUpdateFirmwareJob " + currentHardware);
        List<PortResult> portsToUpdateFirmware = this.getPortResults(currentHardware);
        switch (portsToUpdateFirmware.size()) {
            case 1: {
                this.setUpdateFirmwareJob(this.getNonDfuUpdateFirmwareJobForPort(portsToUpdateFirmware.get(0)));
                break;
            }
            case 0: {
                this.setUpdateFirmwareJob(new DfuManualJob());
                break;
            }
            default: {
                this.resetUpdateFirmwareJob(String.format("Multiple ECUs found on: %s", portsToUpdateFirmware.stream().map(portResult -> portResult.port).collect(Collectors.joining(", "))));
            }
        }
    }

    private AsyncJob getNonDfuUpdateFirmwareJobForPort(PortResult portToUpdateFirmware) {
        AsyncJobWithContext job = null;
        SerialPortType portType = portToUpdateFirmware.type;
        switch (portType) {
            case Ecu: {
                job = new DfuAutoJob(portToUpdateFirmware, this.updateFirmwareButton, this.connectivityContext);
                break;
            }
            case EcuWithOpenblt: {
                job = new OpenBltAutoJob(portToUpdateFirmware, this.updateFirmwareButton, this.connectivityContext);
                break;
            }
            case OpenBlt: {
                job = new OpenBltManualJob(portToUpdateFirmware, this.updateFirmwareButton);
                break;
            }
            default: {
                log.error(String.format("Unexpected port type: %s", new Object[]{portType}));
            }
        }
        return job;
    }

    @NotNull
    private List<PortResult> getPortResults(AvailableHardware currentHardware) {
        Set<SerialPortType> portTypesToUpdateFirmware = this.isObfuscated ? CompatibilitySet.of(SerialPortType.EcuWithOpenblt, SerialPortType.OpenBlt) : CompatibilitySet.of(SerialPortType.Ecu, SerialPortType.EcuWithOpenblt);
        return currentHardware.getKnownPorts(portTypesToUpdateFirmware);
    }

    private void setUpdateFirmwareJob(AsyncJob updateFirmwareJob) {
        this.updateFirmwareJob = Optional.of(updateFirmwareJob);
        this.hideStatusMessage();
        this.refreshButtons();
    }

    private void resetUpdateFirmwareJob(String reason) {
        this.updateFirmwareJob = Optional.empty();
        this.updateFirmwareButton.setEnabled(false);
        this.statusMessage.setText(reason);
    }

    private void updateEcuPortToUse() {
        AvailableHardware currentHardware = this.connectivityContext.getCurrentHardware();
        List<PortResult> ecuPortsToUse = currentHardware.getKnownPorts(CompatibilitySet.of(SerialPortType.Ecu, SerialPortType.EcuWithOpenblt));
        switch (ecuPortsToUse.size()) {
            case 0: {
                this.resetEcuPortToUse();
                log.info("No ECU ports to use found");
                break;
            }
            case 1: {
                this.setEcuPortToUse(ecuPortsToUse.get(0));
                break;
            }
            default: {
                this.resetEcuPortToUse();
                log.info(String.format("Multiple ECU ports to use found on: %s", ecuPortsToUse.stream().map(portResult -> portResult.port).collect(Collectors.joining(", "))));
            }
        }
    }

    private void setEcuPortToUse(PortResult port) {
        this.ecuPortToUse.set(Optional.of(port));
        SwingUtilities.invokeLater(() -> {
            this.refreshButtons();
            if (port.getFirmwareHash().isPresent()) {
                String hash = port.getFirmwareHash().get();
                if (hash.equals(this.latestReportedHash)) {
                    return;
                }
                this.latestReportedHash = hash;
                this.updateOperationCallbacks.logLine("Detected " + hash);
                CalibrationsInfo calibrations = port.getCalibrations();
                if (calibrations != null) {
                    this.updateOperationCallbacks.logLine(calibrations.getIniFile().getSignature());
                    Usability.INSTANCE.onCalibrations(this.updateOperationCallbacks, calibrations);
                }
            }
        });
    }

    private void resetEcuPortToUse() {
        this.ecuPortToUse.set(Optional.empty());
        SwingUtilities.invokeLater(() -> {
            this.importTuneButton.setEnabled(false);
            if (this.logoLabelPopupMenu != null) {
                this.logoLabelPopupMenu.refreshUploadTuneAndPrintUnitLabelsMenuItems(false, false);
            }
        });
    }

    private void onUpdateFirmwareButtonClicked(ActionEvent actionEvent) {
        this.disableButtons();
        CompatibilityOptional.ifPresentOrElse(this.updateFirmwareJob, value -> this.singleAsyncJobExecutor.startJob((AsyncJob)value, this.updateFirmwareButton), () -> log.error("Update firmware job is is not defined."));
        this.refreshButtons();
    }

    @Override
    public void refreshButtons() {
        this.refreshUpdateFirmwareButton();
        Optional<PortResult> ecuPort = this.ecuPortToUse.get();
        boolean isEcuPortJobPossible = ecuPort.isPresent() && this.singleAsyncJobExecutor.isNotInProgress();
        this.importTuneButton.setEnabled(isEcuPortJobPossible);
        if (this.logoLabelPopupMenu != null) {
            this.logoLabelPopupMenu.refreshUploadTuneAndPrintUnitLabelsMenuItems(isEcuPortJobPossible, ecuPort.map(port -> this.existsAnyOfUnitIdentifierFields(port.getCalibrations().getIniFile())).orElse(false));
        }
    }

    private void refreshUpdateFirmwareButton() {
        boolean isFirmwareUpdatePossible;
        boolean bl = isFirmwareUpdatePossible = this.updateFirmwareJob.isPresent() && this.singleAsyncJobExecutor.isNotInProgress();
        if (isFirmwareUpdatePossible) {
            AsyncJob currentUpdateFirmwareJob = this.updateFirmwareJob.get();
            Optional<Object> updateFirmwareButtonText = Optional.empty();
            if (currentUpdateFirmwareJob instanceof OpenBltAutoJob) {
                updateFirmwareButtonText = Optional.of("Auto Update Firmware");
            } else if (currentUpdateFirmwareJob instanceof OpenBltManualJob) {
                updateFirmwareButtonText = Optional.of("Blt Update Firmware");
            } else if (currentUpdateFirmwareJob instanceof DfuAutoJob) {
                updateFirmwareButtonText = Optional.of("Update Firmware");
            } else if (currentUpdateFirmwareJob instanceof DfuManualJob) {
                updateFirmwareButtonText = Optional.of("Update Firmware via DFU");
            } else {
                log.error(String.format("Unexpected job type: %s", currentUpdateFirmwareJob.getClass().getSimpleName()));
            }
            updateFirmwareButtonText.ifPresent(this.updateFirmwareButton::setText);
        }
        this.updateFirmwareButton.setEnabled(isFirmwareUpdatePossible);
    }

    private boolean existsAnyOfUnitIdentifierFields(IniFileModel iniFile) {
        for (String fieldName : UnitLabelPrinter.UNIT_IDENTIFIER_FIELD_NAMES) {
            if (!iniFile.findIniField(fieldName).isPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void disableButtons() {
        this.updateFirmwareButton.setEnabled(false);
        this.importTuneButton.setEnabled(false);
        if (this.logoLabelPopupMenu != null) {
            this.logoLabelPopupMenu.refreshUploadTuneAndPrintUnitLabelsMenuItems(false, false);
        }
    }

    private void uploadTune() {
        this.disableButtons();
        CompatibilityOptional.ifPresentOrElse(this.ecuPortToUse.get(), port -> this.singleAsyncJobExecutor.startJob(new UploadTuneJob(this.connectivityContext, (PortResult)port, this.panamaUrl), this.logoLabelPopupMenu), () -> JOptionPane.showMessageDialog(this.content, "Device is not connected", "Error", 0));
        this.refreshButtons();
    }

    private void printUnitLabel() {
        this.disableButtons();
        CompatibilityOptional.ifPresentOrElse(this.ecuPortToUse.get(), port -> this.singleAsyncJobExecutor.startJob(new PrintUnitLabelJob(this.connectivityContext, (PortResult)port, this.logoLabelPopupMenu), this.logoLabelPopupMenu), () -> JOptionPane.showMessageDialog(this.updateCalibrationsButton, "Device is not connected", "Error", 0));
        this.refreshButtons();
    }

    public Component getContent() {
        return this.content;
    }
}

